/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import org.dflib.map.AnyToPrimitiveMappers;
import org.dflib.map.NumToPrimitiveMappers;
import org.dflib.map.StringToPrimitiveMappers;

@FunctionalInterface
public interface LongValueMapper<V> {
    public static LongValueMapper<Object> of() {
        return AnyToPrimitiveMappers::toLong;
    }

    public static LongValueMapper<Object> of(long forNull) {
        return o -> AnyToPrimitiveMappers.toLong(o, forNull);
    }

    public static LongValueMapper<String> ofStr() {
        return StringToPrimitiveMappers::toLong;
    }

    public static LongValueMapper<String> ofStr(long forNull) {
        return s -> StringToPrimitiveMappers.toLong(s, forNull);
    }

    public static LongValueMapper<Number> ofNum() {
        return NumToPrimitiveMappers::toLong;
    }

    public static LongValueMapper<Number> ofNum(long forNull) {
        return n -> NumToPrimitiveMappers.toLong(n, forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static LongValueMapper<Object> fromObject() {
        return o -> {
            String s;
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            String string = s = o != null ? o.toString() : null;
            if (s == null || s.length() == 0) {
                throw new IllegalArgumentException("Can't convert a null to a primitive long");
            }
            return Long.parseLong(s);
        };
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static LongValueMapper<Object> fromObject(long forNull) {
        return LongValueMapper.of(forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static LongValueMapper<String> fromString() {
        return LongValueMapper.ofStr();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static LongValueMapper<String> fromString(long forNull) {
        return LongValueMapper.ofStr(forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static LongValueMapper<? extends Number> fromNumber() {
        return n -> n != null ? n.longValue() : 0L;
    }

    public long map(V var1);
}

