/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Comparator;
import java.util.Random;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.builder.BoolBuilder;
import org.dflib.op.ReplaceOp;
import org.dflib.series.FalseSeries;
import org.dflib.series.LongArraySeries;
import org.dflib.series.LongIndexedSeries;
import org.dflib.series.TrueSeries;
import org.dflib.set.Diff;
import org.dflib.set.Intersect;

public interface LongSeries
extends Series<Long> {
    @Override
    default public Class<Long> getNominalType() {
        return Long.TYPE;
    }

    @Override
    default public Class<?> getInferredType() {
        return Long.TYPE;
    }

    @Override
    default public LongSeries castAsLong() {
        return this;
    }

    @Override
    default public LongSeries compactLong(long forNull) {
        return this;
    }

    @Override
    default public Long get(int index) {
        return this.getLong(index);
    }

    public long getLong(int var1);

    @Override
    default public Series<Long> replace(int index, Long with) {
        return with != null ? this.replaceLong(index, with) : ReplaceOp.replace(this, index, with);
    }

    default public LongSeries replaceLong(int index, long with) {
        if (this.getLong(index) == with) {
            return this;
        }
        int len = this.size();
        long[] longs = new long[len];
        this.copyToLong(longs, 0, 0, len);
        longs[index] = with;
        return Series.ofLong(longs);
    }

    public void copyToLong(long[] var1, int var2, int var3, int var4);

    public LongSeries materialize();

    @Override
    default public int position(Long value) {
        if (value == null) {
            return -1;
        }
        long pval = value;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (pval != this.getLong(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public Series<?> expand(Object ... values) {
        int len = values.length;
        if (len == 0) {
            return this;
        }
        long[] primitives = new long[len];
        for (int i = 0; i < len; ++i) {
            if (!(values[i] instanceof Long)) {
                return Series.super.expand(values);
            }
            primitives[i] = (Long)values[i];
        }
        return this.expandLong(primitives);
    }

    default public LongSeries expandLong(long ... values) {
        int rlen = values.length;
        if (rlen == 0) {
            return this;
        }
        int llen = this.size();
        long[] expanded = new long[llen + rlen];
        this.copyToLong(expanded, 0, 0, llen);
        System.arraycopy(values, 0, expanded, llen, rlen);
        return Series.ofLong(expanded);
    }

    @Override
    default public Series<?> insert(int pos, Object ... values) {
        int ilen = values.length;
        long[] longs = new long[ilen];
        for (int i = 0; i < ilen; ++i) {
            if (!(values[i] instanceof Long)) {
                return Series.super.insert(pos, values);
            }
            longs[i] = (Long)values[i];
        }
        return this.insertLong(pos, longs);
    }

    default public LongSeries insertLong(int pos, long ... values) {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative insert position: " + pos);
        }
        int slen = this.size();
        if (pos > slen) {
            throw new IllegalArgumentException("Insert position past the end of the Series: " + pos + ", len: " + slen);
        }
        int ilen = values.length;
        if (ilen == 0) {
            return this;
        }
        long[] expanded = new long[slen + ilen];
        if (pos > 0) {
            this.copyToLong(expanded, 0, 0, pos);
        }
        System.arraycopy(values, 0, expanded, pos, ilen);
        if (pos < slen) {
            this.copyToLong(expanded, pos, pos + ilen, slen - pos);
        }
        return Series.ofLong(expanded);
    }

    public LongSeries concatLong(LongSeries ... var1);

    default public LongSeries diff(Series<? extends Long> other) {
        return Diff.diffLong(this, other);
    }

    default public LongSeries intersect(Series<? extends Long> other) {
        return Intersect.intersectLong(this, other);
    }

    public LongSeries rangeLong(int var1, int var2);

    default public LongSeries head(int len) {
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.tail(this.size() + len) : this.rangeLong(0, len);
    }

    default public LongSeries tail(int len) {
        int size = this.size();
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.head(size + len) : this.rangeLong(size - len, size);
    }

    public LongSeries select(Predicate<Long> var1);

    public LongSeries select(Condition var1);

    public LongSeries select(BooleanSeries var1);

    @Override
    default public Series<Long> select(IntSeries positions) {
        return LongIndexedSeries.of(this, positions);
    }

    public LongSeries selectLong(LongPredicate var1);

    public LongSeries sort(Comparator<? super Long> var1);

    public LongSeries sort(Sorter ... var1);

    public LongSeries sortLong();

    public IntSeries indexLong(LongPredicate var1);

    public BooleanSeries locateLong(LongPredicate var1);

    @Override
    default public BooleanSeries isNull() {
        return new FalseSeries(this.size());
    }

    @Override
    default public BooleanSeries isNotNull() {
        return new TrueSeries(this.size());
    }

    public LongSeries unique();

    public LongSeries sample(int var1);

    public LongSeries sample(int var1, Random var2);

    default public long[] toLongArray() {
        int len = this.size();
        long[] copy = new long[len];
        this.copyToLong(copy, 0, 0, len);
        return copy;
    }

    public LongSeries cumSum();

    public long max();

    public long min();

    public long sum();

    public double avg();

    default public double median() {
        return this.quantile(0.5);
    }

    public double quantile(double var1);

    default public double stdDev(boolean usePopulationStdDev) {
        double variance = this.variance(usePopulationStdDev);
        return Math.sqrt(variance);
    }

    default public double stdDev() {
        return this.stdDev(true);
    }

    default public double variance(boolean usePopulationVariance) {
        int len = this.size();
        double avg = this.avg();
        double denominator = usePopulationVariance ? (double)len : (double)(len - 1);
        double acc = 0.0;
        for (int i = 0; i < len; ++i) {
            double x = this.getLong(i);
            acc += (x - avg) * (x - avg);
        }
        return acc / denominator;
    }

    default public double variance() {
        return this.variance(true);
    }

    @Override
    default public BooleanSeries eq(Series<?> s) {
        if (!(s instanceof LongSeries)) {
            return Series.super.eq(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongSeries anotherLong = (LongSeries)s;
        return BoolBuilder.buildSeries(i -> this.getLong(i) == anotherLong.getLong(i), len);
    }

    @Override
    default public BooleanSeries ne(Series<?> s) {
        if (!(s instanceof LongSeries)) {
            return Series.super.ne(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongSeries anotherLong = (LongSeries)s;
        return BoolBuilder.buildSeries(i -> this.getLong(i) != anotherLong.getLong(i), len);
    }

    default public LongSeries add(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i) + s.getLong(i);
        }
        return new LongArraySeries(data);
    }

    default public LongSeries add(long v) {
        int len = this.size();
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i) + v;
        }
        return new LongArraySeries(data);
    }

    default public LongSeries sub(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i) - s.getLong(i);
        }
        return new LongArraySeries(data);
    }

    default public LongSeries mul(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i) * s.getLong(i);
        }
        return new LongArraySeries(data);
    }

    default public LongSeries mul(long v) {
        int len = this.size();
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i) * v;
        }
        return new LongArraySeries(data);
    }

    default public LongSeries div(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i) / s.getLong(i);
        }
        return new LongArraySeries(data);
    }

    default public LongSeries mod(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i) % s.getLong(i);
        }
        return new LongArraySeries(data);
    }

    default public BooleanSeries lt(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getLong(i) < s.getLong(i), len);
    }

    default public BooleanSeries le(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getLong(i) <= s.getLong(i), len);
    }

    default public BooleanSeries gt(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getLong(i) > s.getLong(i), len);
    }

    default public BooleanSeries ge(LongSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getLong(i) >= s.getLong(i), len);
    }

    default public BooleanSeries between(LongSeries from, LongSeries to) {
        int len = this.size();
        if (len != from.size()) {
            throw new IllegalArgumentException("'from' Series size " + from.size() + " is not the same as this size " + len);
        }
        if (len != to.size()) {
            throw new IllegalArgumentException("'to' Series size " + to.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> {
            long v = this.getLong(i);
            return v >= from.getLong(i) && v <= to.getLong(i);
        }, len);
    }
}

