/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Comparator;
import java.util.Random;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.builder.BoolBuilder;
import org.dflib.op.ReplaceOp;
import org.dflib.series.FalseSeries;
import org.dflib.series.IntArraySeries;
import org.dflib.series.IntIndexedSeries;
import org.dflib.series.TrueSeries;
import org.dflib.set.Diff;
import org.dflib.set.Intersect;
import org.dflib.sort.IntComparator;

public interface IntSeries
extends Series<Integer> {
    @Override
    default public Class<Integer> getNominalType() {
        return Integer.TYPE;
    }

    @Override
    default public Class<?> getInferredType() {
        return Integer.TYPE;
    }

    @Override
    default public IntSeries castAsInt() {
        return this;
    }

    @Override
    default public IntSeries compactInt(int forNull) {
        return this;
    }

    @Override
    default public Integer get(int index) {
        return this.getInt(index);
    }

    public int getInt(int var1);

    @Override
    default public Series<Integer> replace(int index, Integer with) {
        return with != null ? this.replaceInt(index, with) : ReplaceOp.replace(this, index, with);
    }

    default public IntSeries replaceInt(int index, int with) {
        if (this.getInt(index) == with) {
            return this;
        }
        int len = this.size();
        int[] ints = new int[len];
        this.copyToInt(ints, 0, 0, len);
        ints[index] = with;
        return Series.ofInt(ints);
    }

    public void copyToInt(int[] var1, int var2, int var3, int var4);

    public IntSeries materialize();

    @Override
    default public int position(Integer value) {
        if (value == null) {
            return -1;
        }
        int ival = value;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (ival != this.getInt(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public Series<?> expand(Object ... values) {
        int len = values.length;
        if (len == 0) {
            return this;
        }
        int[] primitives = new int[len];
        for (int i = 0; i < len; ++i) {
            if (!(values[i] instanceof Integer)) {
                return Series.super.expand(values);
            }
            primitives[i] = (Integer)values[i];
        }
        return this.expandInt(primitives);
    }

    default public IntSeries expandInt(int ... values) {
        int rlen = values.length;
        if (rlen == 0) {
            return this;
        }
        int llen = this.size();
        int[] expanded = new int[llen + rlen];
        this.copyToInt(expanded, 0, 0, llen);
        System.arraycopy(values, 0, expanded, llen, rlen);
        return Series.ofInt(expanded);
    }

    @Override
    default public Series<?> insert(int pos, Object ... values) {
        int ilen = values.length;
        int[] ints = new int[ilen];
        for (int i = 0; i < ilen; ++i) {
            if (!(values[i] instanceof Integer)) {
                return Series.super.insert(pos, values);
            }
            ints[i] = (Integer)values[i];
        }
        return this.insertInt(pos, ints);
    }

    default public IntSeries insertInt(int pos, int ... values) {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative insert position: " + pos);
        }
        int slen = this.size();
        if (pos > slen) {
            throw new IllegalArgumentException("Insert position past the end of the Series: " + pos + ", len: " + slen);
        }
        int ilen = values.length;
        if (ilen == 0) {
            return this;
        }
        int[] expanded = new int[slen + ilen];
        if (pos > 0) {
            this.copyToInt(expanded, 0, 0, pos);
        }
        System.arraycopy(values, 0, expanded, pos, ilen);
        if (pos < slen) {
            this.copyToInt(expanded, pos, pos + ilen, slen - pos);
        }
        return Series.ofInt(expanded);
    }

    public IntSeries concatInt(IntSeries ... var1);

    default public IntSeries diff(Series<? extends Integer> other) {
        return Diff.diffInt(this, other);
    }

    default public IntSeries intersect(Series<? extends Integer> other) {
        return Intersect.intersectInt(this, other);
    }

    public IntSeries rangeInt(int var1, int var2);

    default public IntSeries head(int len) {
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.tail(this.size() + len) : this.rangeInt(0, len);
    }

    default public IntSeries tail(int len) {
        int size = this.size();
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.head(size + len) : this.rangeInt(size - len, size);
    }

    public IntSeries select(Predicate<Integer> var1);

    public IntSeries select(Condition var1);

    public IntSeries select(BooleanSeries var1);

    @Override
    default public Series<Integer> select(IntSeries positions) {
        return IntIndexedSeries.of(this, positions);
    }

    public IntSeries selectInt(IntPredicate var1);

    public IntSeries sort(Sorter ... var1);

    public IntSeries sort(Comparator<? super Integer> var1);

    public IntSeries sortInt();

    public IntSeries sortInt(IntComparator var1);

    public IntSeries sortIndexInt();

    public IntSeries sortIndexInt(IntComparator var1);

    public IntSeries indexInt(IntPredicate var1);

    public BooleanSeries locateInt(IntPredicate var1);

    @Override
    default public BooleanSeries isNull() {
        return new FalseSeries(this.size());
    }

    @Override
    default public BooleanSeries isNotNull() {
        return new TrueSeries(this.size());
    }

    public IntSeries unique();

    public IntSeries sample(int var1);

    public IntSeries sample(int var1, Random var2);

    default public int[] toIntArray() {
        int len = this.size();
        int[] copy = new int[len];
        this.copyToInt(copy, 0, 0, len);
        return copy;
    }

    public LongSeries cumSum();

    public int max();

    public int min();

    public long sum();

    public double avg();

    default public double median() {
        return this.quantile(0.5);
    }

    public double quantile(double var1);

    default public double stdDev(boolean usePopulationStdDev) {
        double variance = this.variance(usePopulationStdDev);
        return Math.sqrt(variance);
    }

    default public double stdDev() {
        return this.stdDev(true);
    }

    default public double variance(boolean usePopulationVariance) {
        int len = this.size();
        double avg = this.avg();
        double denominator = usePopulationVariance ? (double)len : (double)(len - 1);
        double acc = 0.0;
        for (int i = 0; i < len; ++i) {
            double x = this.getInt(i);
            acc += (x - avg) * (x - avg);
        }
        return acc / denominator;
    }

    default public double variance() {
        return this.variance(true);
    }

    @Override
    default public BooleanSeries eq(Series<?> s) {
        if (!(s instanceof IntSeries)) {
            return Series.super.eq(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntSeries anotherInt = (IntSeries)s;
        return BoolBuilder.buildSeries(i -> this.getInt(i) == anotherInt.getInt(i), len);
    }

    @Override
    default public BooleanSeries ne(Series<?> s) {
        if (!(s instanceof IntSeries)) {
            return Series.super.ne(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntSeries anotherInt = (IntSeries)s;
        return BoolBuilder.buildSeries(i -> this.getInt(i) != anotherInt.getInt(i), len);
    }

    default public IntSeries add(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i) + s.getInt(i);
        }
        return new IntArraySeries(data);
    }

    default public IntSeries add(int v) {
        int len = this.size();
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i) + v;
        }
        return new IntArraySeries(data);
    }

    default public IntSeries sub(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i) - s.getInt(i);
        }
        return new IntArraySeries(data);
    }

    default public IntSeries mul(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i) * s.getInt(i);
        }
        return new IntArraySeries(data);
    }

    default public IntSeries mul(int v) {
        int len = this.size();
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i) * v;
        }
        return new IntArraySeries(data);
    }

    default public IntSeries div(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i) / s.getInt(i);
        }
        return new IntArraySeries(data);
    }

    default public IntSeries mod(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i) % s.getInt(i);
        }
        return new IntArraySeries(data);
    }

    default public BooleanSeries lt(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getInt(i) < s.getInt(i), len);
    }

    default public BooleanSeries le(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getInt(i) <= s.getInt(i), len);
    }

    default public BooleanSeries gt(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getInt(i) > s.getInt(i), len);
    }

    default public BooleanSeries ge(IntSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getInt(i) >= s.getInt(i), len);
    }

    default public BooleanSeries between(IntSeries from, IntSeries to) {
        int len = this.size();
        if (len != from.size()) {
            throw new IllegalArgumentException("'from' Series size " + from.size() + " is not the same as this size " + len);
        }
        if (len != to.size()) {
            throw new IllegalArgumentException("'to' Series size " + to.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> {
            int v = this.getInt(i);
            return v >= from.getInt(i) && v <= to.getInt(i);
        }, len);
    }
}

