/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import org.dflib.map.AnyToPrimitiveMappers;
import org.dflib.map.NumToPrimitiveMappers;
import org.dflib.map.StringToPrimitiveMappers;

@FunctionalInterface
public interface FloatValueMapper<V> {
    public static FloatValueMapper<Object> of() {
        return AnyToPrimitiveMappers::toFloat;
    }

    public static FloatValueMapper<Object> of(float forNull) {
        return o -> AnyToPrimitiveMappers.toFloat(o, forNull);
    }

    public static FloatValueMapper<String> ofStr() {
        return StringToPrimitiveMappers::toFloat;
    }

    public static FloatValueMapper<String> ofStr(float forNull) {
        return s -> StringToPrimitiveMappers.toFloat(s, forNull);
    }

    public static FloatValueMapper<Number> ofNum() {
        return NumToPrimitiveMappers::toFloat;
    }

    public static FloatValueMapper<Number> ofNum(float forNull) {
        return n -> NumToPrimitiveMappers.toFloat(n, forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static FloatValueMapper<Object> fromObject() {
        return o -> {
            String s;
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            String string = s = o != null ? o.toString() : null;
            if (s == null || s.length() == 0) {
                throw new IllegalArgumentException("Can't convert a null to a primitive float");
            }
            return Float.parseFloat(s);
        };
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static FloatValueMapper<Object> fromObject(float forNull) {
        return FloatValueMapper.of(forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static FloatValueMapper<String> fromString() {
        return FloatValueMapper.ofStr();
    }

    public static FloatValueMapper<String> fromString(float forNull) {
        return FloatValueMapper.ofStr(forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static FloatValueMapper<? extends Number> fromNumber() {
        return n -> n != null ? n.floatValue() : 0.0f;
    }

    public float map(V var1);
}

