/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.DateExp;
import org.dflib.DateTimeExp;
import org.dflib.DecimalExp;
import org.dflib.NumExp;
import org.dflib.OffsetDateTimeExp;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.StrExp;
import org.dflib.TimeExp;
import org.dflib.exp.AsExp;
import org.dflib.exp.Column;
import org.dflib.exp.RowNumExp;
import org.dflib.exp.ScalarExp;
import org.dflib.exp.ShiftExp;
import org.dflib.exp.agg.CountExp;
import org.dflib.exp.agg.FirstExp;
import org.dflib.exp.agg.LastExp;
import org.dflib.exp.agg.ReduceExp1;
import org.dflib.exp.agg.ReduceExp2;
import org.dflib.exp.agg.ReduceExpN;
import org.dflib.exp.agg.StringAggregators;
import org.dflib.exp.bool.AndCondition;
import org.dflib.exp.bool.BoolColumn;
import org.dflib.exp.bool.BoolScalarExp;
import org.dflib.exp.bool.ConditionFactory;
import org.dflib.exp.bool.OrCondition;
import org.dflib.exp.datetime.DateColumn;
import org.dflib.exp.datetime.DateExp1;
import org.dflib.exp.datetime.DateScalarExp;
import org.dflib.exp.datetime.DateTimeColumn;
import org.dflib.exp.datetime.DateTimeExp1;
import org.dflib.exp.datetime.DateTimeScalarExp;
import org.dflib.exp.datetime.OffsetDateTimeColumn;
import org.dflib.exp.datetime.OffsetDateTimeExp1;
import org.dflib.exp.datetime.OffsetDateTimeScalarExp;
import org.dflib.exp.datetime.TimeColumn;
import org.dflib.exp.datetime.TimeExp1;
import org.dflib.exp.datetime.TimeScalarExp;
import org.dflib.exp.flow.IfExp;
import org.dflib.exp.flow.IfNullExp;
import org.dflib.exp.map.MapCondition1;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapExp1;
import org.dflib.exp.map.MapExp2;
import org.dflib.exp.num.BigintColumn;
import org.dflib.exp.num.BigintScalarExp;
import org.dflib.exp.num.DecimalColumn;
import org.dflib.exp.num.DecimalScalarExp;
import org.dflib.exp.num.DoubleColumn;
import org.dflib.exp.num.DoubleScalarExp;
import org.dflib.exp.num.FloatColumn;
import org.dflib.exp.num.FloatScalarExp;
import org.dflib.exp.num.IntColumn;
import org.dflib.exp.num.IntScalarExp;
import org.dflib.exp.num.LongColumn;
import org.dflib.exp.num.LongScalarExp;
import org.dflib.exp.sort.ExpSorter;
import org.dflib.exp.str.ConcatExp;
import org.dflib.exp.str.StrColumn;
import org.dflib.exp.str.StrExp1;
import org.dflib.exp.str.StrScalarExp;

public interface Exp<T> {
    public static <T> Exp<T> $val(T value) {
        Class type = value != null ? value.getClass() : Object.class;
        return Exp.$val(value, type);
    }

    public static NumExp<Integer> $intVal(int value) {
        return new IntScalarExp(value);
    }

    public static NumExp<Long> $longVal(long value) {
        return new LongScalarExp(value);
    }

    public static NumExp<Float> $floatVal(float value) {
        return new FloatScalarExp(value);
    }

    public static NumExp<Double> $doubleVal(double value) {
        return new DoubleScalarExp(value);
    }

    public static NumExp<BigInteger> $bigintVal(BigInteger value) {
        return new BigintScalarExp(value);
    }

    public static NumExp<BigDecimal> $decimalVal(BigDecimal value) {
        return new DecimalScalarExp(value);
    }

    public static Condition $boolVal(boolean value) {
        return value ? BoolScalarExp.getTrue() : BoolScalarExp.getFalse();
    }

    public static StrExp $strVal(String value) {
        return new StrScalarExp(value);
    }

    public static DateExp $dateVal(LocalDate value) {
        return new DateScalarExp(value);
    }

    public static TimeExp $timeVal(LocalTime value) {
        return new TimeScalarExp(value);
    }

    public static DateTimeExp $dateTimeVal(LocalDateTime value) {
        return new DateTimeScalarExp(value);
    }

    public static OffsetDateTimeExp $offsetDateTimeVal(OffsetDateTime value) {
        return new OffsetDateTimeScalarExp(value);
    }

    public static <T, V extends T> Exp<T> $val(V value, Class<T> type) {
        return new ScalarExp<V>(value, type);
    }

    public static <T> Exp<T> $col(String name) {
        return new Column<Object>(name, Object.class);
    }

    public static <T> Exp<T> $col(int position) {
        return new Column<Object>(position, Object.class);
    }

    public static <T> Exp<T> $col(String name, Class<T> type) {
        return new Column<T>(name, type);
    }

    public static <T> Exp<T> $col(int position, Class<T> type) {
        return new Column<T>(position, type);
    }

    public static StrExp $str(String name) {
        return new StrColumn(name);
    }

    public static StrExp $str(int position) {
        return new StrColumn(position);
    }

    public static NumExp<Integer> $int(String name) {
        return new IntColumn(name);
    }

    public static NumExp<Integer> $int(int position) {
        return new IntColumn(position);
    }

    public static NumExp<Long> $long(String name) {
        return new LongColumn(name);
    }

    public static NumExp<Long> $long(int position) {
        return new LongColumn(position);
    }

    public static NumExp<Float> $float(String name) {
        return new FloatColumn(name);
    }

    public static NumExp<Float> $float(int position) {
        return new FloatColumn(position);
    }

    public static NumExp<Double> $double(String name) {
        return new DoubleColumn(name);
    }

    public static NumExp<Double> $double(int position) {
        return new DoubleColumn(position);
    }

    public static NumExp<BigInteger> $bigint(String name) {
        return new BigintColumn(name);
    }

    public static NumExp<BigInteger> $bigint(int position) {
        return new BigintColumn(position);
    }

    public static DecimalExp $decimal(String name) {
        return new DecimalColumn(name);
    }

    public static DecimalExp $decimal(int position) {
        return new DecimalColumn(position);
    }

    public static Condition $bool(String name) {
        return new BoolColumn(name);
    }

    public static Condition $bool(int position) {
        return new BoolColumn(position);
    }

    public static DateExp $date(String name) {
        return new DateColumn(name);
    }

    public static DateExp $date(int position) {
        return new DateColumn(position);
    }

    public static TimeExp $time(String name) {
        return new TimeColumn(name);
    }

    public static TimeExp $time(int position) {
        return new TimeColumn(position);
    }

    public static DateTimeExp $dateTime(String name) {
        return new DateTimeColumn(name);
    }

    public static DateTimeExp $dateTime(int position) {
        return new DateTimeColumn(position);
    }

    public static OffsetDateTimeExp $offsetDateTime(String name) {
        return new OffsetDateTimeColumn(name);
    }

    public static OffsetDateTimeExp $offsetDateTime(int position) {
        return new OffsetDateTimeColumn(position);
    }

    public static Condition or(Condition ... conditions) {
        return conditions.length == 1 ? conditions[0] : new OrCondition(conditions);
    }

    public static Condition and(Condition ... conditions) {
        return conditions.length == 1 ? conditions[0] : new AndCondition(conditions);
    }

    public static Condition not(Condition condition) {
        return condition.not();
    }

    public static <T> Exp<T> ifExp(Condition condition, Exp<T> ifTrue, Exp<T> ifFalse) {
        return new IfExp<T>(condition, ifTrue, ifFalse);
    }

    public static <T> Exp<T> ifNull(Exp<T> exp, Exp<T> ifNullExp) {
        return new IfNullExp<T>(exp, ifNullExp);
    }

    public static <T> Exp<T> ifNull(Exp<T> exp, T ifNull) {
        return new IfNullExp<T>(exp, Exp.$val(ifNull));
    }

    public static StrExp concat(Object ... valuesOrExps) {
        return ConcatExp.of(valuesOrExps);
    }

    public static NumExp<Integer> count() {
        return CountExp.getInstance();
    }

    public static NumExp<Integer> count(Condition filter) {
        return new CountExp(filter);
    }

    public static NumExp<Integer> rowNum() {
        return RowNumExp.getInstance();
    }

    public Class<T> getType();

    default public String getColumnName() {
        return this.toQL();
    }

    default public String getColumnName(DataFrame df) {
        return this.toQL(df);
    }

    public String toQL();

    public String toQL(DataFrame var1);

    public Series<T> eval(DataFrame var1);

    public Series<T> eval(Series<?> var1);

    public T reduce(DataFrame var1);

    public T reduce(Series<?> var1);

    default public Sorter asc() {
        return new ExpSorter(this, true);
    }

    default public Sorter desc() {
        return new ExpSorter(this, false);
    }

    default public Exp<T> as(String name) {
        Objects.requireNonNull(name, "Null 'name'");
        return new AsExp(name, this);
    }

    default public <R> Exp<R> map(Function<Series<T>, Series<R>> op) {
        return MapExp1.map("map", Object.class, this, op);
    }

    default public <R> Exp<R> mapVal(Function<T, R> op) {
        return this.mapVal(op, true);
    }

    default public <R> Exp<R> mapVal(Function<T, R> op, boolean hideNulls) {
        return hideNulls ? MapExp1.mapVal("map", Object.class, this, op) : MapExp1.mapValWithNulls("map", Object.class, this, op);
    }

    default public <S, R> Exp<R> map(Exp<S> other, BiFunction<Series<T>, Series<S>, Series<R>> op) {
        return MapExp2.map("map", Object.class, this, other, op);
    }

    default public <S, R> Exp<R> mapVal(Exp<S> other, BiFunction<T, S, R> op) {
        return MapExp2.mapVal("map", Object.class, this, other, op);
    }

    default public Condition eq(Exp<?> exp) {
        return MapCondition2.map("=", this, exp, Series::eq);
    }

    default public Condition ne(Exp<?> exp) {
        return MapCondition2.map("!=", this, exp, Series::ne);
    }

    default public Condition eq(Object value) {
        return value != null ? this.eq(Exp.$val(value)) : this.isNull();
    }

    default public Condition ne(Object value) {
        return value != null ? this.ne(Exp.$val(value)) : this.isNotNull();
    }

    default public Condition in(Object ... values) {
        return MapCondition1.map("in", this, s -> s.in(values));
    }

    default public Condition notIn(Object ... values) {
        return MapCondition1.map("in", this, s -> s.notIn(values));
    }

    default public Condition isNull() {
        return ConditionFactory.isNull(this);
    }

    default public Condition isNotNull() {
        return ConditionFactory.isNotNull(this);
    }

    default public Exp<T> shift(int offset) {
        return this.shift(offset, null);
    }

    default public Exp<T> shift(int offset, T filler) {
        return new ShiftExp<T>(this, offset, filler);
    }

    default public <A> Exp<A> agg(Function<Series<T>, A> aggregator) {
        return new ReduceExp1<T, Object>("_custom", Object.class, this, aggregator, null);
    }

    default public <A> Exp<A> agg(Condition filter, Function<Series<T>, A> aggregator) {
        return new ReduceExp1<T, Object>("_custom", Object.class, this, aggregator, filter);
    }

    default public Exp<T> first() {
        return new FirstExp<T>(this.getType(), this, null);
    }

    default public Exp<T> last() {
        return new LastExp<T>(this.getType(), this, null);
    }

    default public Exp<T> first(Condition filter) {
        return new FirstExp<T>(this.getType(), this, filter);
    }

    default public Exp<String> vConcat(String delimiter) {
        Function f = StringAggregators.vConcat(delimiter);
        return new ReduceExp2("vConcat", String.class, this, Exp.$val(delimiter), (s, d) -> (String)f.apply(s), null);
    }

    default public Exp<String> vConcat(Condition filter, String delimiter) {
        Function f = StringAggregators.vConcat(delimiter);
        return new ReduceExp2("vConcat", String.class, this, Exp.$val(delimiter), (s, d) -> (String)f.apply(s), filter);
    }

    default public Exp<String> vConcat(String delimiter, String prefix, String suffix) {
        Function f = StringAggregators.vConcat(delimiter, prefix, suffix);
        return new ReduceExpN<String>("vConcat", String.class, new Exp[]{this, Exp.$val(delimiter), Exp.$val(prefix), Exp.$val(suffix)}, ss -> (String)f.apply(ss[0]), null);
    }

    default public Exp<String> vConcat(Condition filter, String delimiter, String prefix, String suffix) {
        Function f = StringAggregators.vConcat(delimiter, prefix, suffix);
        return new ReduceExpN<String>("vConcat", String.class, new Exp[]{this, Exp.$val(delimiter), Exp.$val(prefix), Exp.$val(suffix)}, ss -> (String)f.apply(ss[0]), filter);
    }

    default public Exp<Set<T>> set() {
        Class<Set> setClass = Set.class;
        return new ReduceExp1("set", setClass, this, Series::toSet, null);
    }

    default public Exp<List<T>> list() {
        Class<List> listClass = List.class;
        return new ReduceExp1("list", listClass, this, Series::toList, null);
    }

    default public Exp<T[]> array(T[] template) {
        Class<?> arrayClass = template.getClass();
        return new ReduceExp1("array", arrayClass, this, s -> s.toArray(template), null);
    }

    default public Condition castAsBool() {
        return ConditionFactory.castAsBool(this);
    }

    default public Condition mapBool(Function<Series<T>, BooleanSeries> op) {
        return MapCondition1.map("map", this, op);
    }

    default public Condition mapBoolVal(Predicate<T> op) {
        return this.mapBoolVal(op, true);
    }

    default public Condition mapBoolVal(Predicate<T> op, boolean hideNulls) {
        return hideNulls ? MapCondition1.mapVal("map", this, op) : MapCondition1.mapValWithNulls("map", this, op);
    }

    default public DateExp castAsDate() {
        return DateExp1.mapVal("castAsDate", this.castAsStr(), LocalDate::parse);
    }

    default public DateExp castAsDate(String format) {
        return this.castAsDate(DateTimeFormatter.ofPattern(format));
    }

    default public DateExp castAsDate(DateTimeFormatter formatter) {
        return DateExp1.mapVal("castAsDate", this.castAsStr(), s -> LocalDate.parse(s, formatter));
    }

    default public TimeExp castAsTime() {
        return TimeExp1.mapVal("castAsTime", this.castAsStr(), LocalTime::parse);
    }

    default public TimeExp castAsTime(String formatter) {
        return this.castAsTime(DateTimeFormatter.ofPattern(formatter));
    }

    default public TimeExp castAsTime(DateTimeFormatter formatter) {
        return TimeExp1.mapVal("castAsTime", this.castAsStr(), s -> LocalTime.parse(s, formatter));
    }

    default public DateTimeExp castAsDateTime() {
        return DateTimeExp1.mapVal("castAsDateTime", this.castAsStr(), LocalDateTime::parse);
    }

    default public DateTimeExp castAsDateTime(String format) {
        return this.castAsDateTime(DateTimeFormatter.ofPattern(format));
    }

    default public DateTimeExp castAsDateTime(DateTimeFormatter formatter) {
        return DateTimeExp1.mapVal("castAsDateTime", this.castAsStr(), s -> LocalDateTime.parse(s, formatter));
    }

    default public OffsetDateTimeExp castAsOffsetDateTime() {
        return OffsetDateTimeExp1.mapVal("castAsOffsetDateTime", this.castAsStr(), OffsetDateTime::parse);
    }

    default public OffsetDateTimeExp castAsOffsetDateTime(String format) {
        return this.castAsOffsetDateTime(DateTimeFormatter.ofPattern(format));
    }

    default public OffsetDateTimeExp castAsOffsetDateTime(DateTimeFormatter formatter) {
        return OffsetDateTimeExp1.mapVal("castAsOffsetDateTime", this.castAsStr(), s -> OffsetDateTime.parse(s, formatter));
    }

    default public StrExp castAsStr() {
        return StrExp1.mapVal("castAsStr", this, o -> o.toString());
    }

    default public NumExp<Integer> castAsInt() {
        return this.castAsStr().castAsDecimal().castAsInt();
    }

    default public NumExp<Long> castAsLong() {
        return this.castAsStr().castAsDecimal().castAsLong();
    }

    default public NumExp<Float> castAsFloat() {
        return this.castAsStr().castAsFloat();
    }

    default public NumExp<Double> castAsDouble() {
        return this.castAsStr().castAsDouble();
    }

    default public NumExp<BigInteger> castAsBigint() {
        return this.castAsStr().castAsBigint();
    }

    default public DecimalExp castAsDecimal() {
        return this.castAsStr().castAsDecimal();
    }
}

