/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.dflib.print.InlineClassExposingPrinter;
import org.dflib.print.Printer;

public class Environment {
    private static final AtomicReference<Environment> commonEnv;
    private final ExecutorService threadPool;
    private final int parallelExecThreshold;
    private final Printer printer;

    public static Environment commonEnv() {
        return commonEnv.get();
    }

    public static void setThreadPool(ExecutorService threadPool) {
        Objects.requireNonNull(threadPool);
        Environment.resetEnv(old -> new Environment(threadPool, old.parallelExecThreshold, old.printer));
    }

    public static void setParallelExecThreshold(int parallelExecThreshold) {
        Environment.resetEnv(old -> new Environment(old.threadPool, parallelExecThreshold, old.printer));
    }

    public static void setPrinter(Printer printer) {
        Environment.resetEnv(old -> new Environment(old.threadPool, old.parallelExecThreshold, printer));
    }

    static void resetEnv(UnaryOperator<Environment> envFactory) {
        Environment newEnv;
        Environment oldEnv;
        while (!commonEnv.compareAndSet(oldEnv = Environment.commonEnv(), newEnv = (Environment)envFactory.apply(oldEnv))) {
        }
    }

    protected Environment(ExecutorService threadPool, int parallelExecThreshold, Printer printer) {
        this.threadPool = threadPool;
        this.parallelExecThreshold = parallelExecThreshold;
        this.printer = printer;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public int parallelExecThreshold() {
        return this.parallelExecThreshold;
    }

    public Printer printer() {
        return this.printer;
    }

    static void setCommonEnv(Environment env) {
        commonEnv.set(env);
    }

    static {
        Environment defaultEnv = new Environment(ForkJoinPool.commonPool(), 5000, new InlineClassExposingPrinter());
        commonEnv = new AtomicReference<Environment>(defaultEnv);
    }
}

