/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Comparator;
import java.util.Random;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.builder.BoolBuilder;
import org.dflib.op.ReplaceOp;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.DoubleIndexedSeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.TrueSeries;
import org.dflib.set.Diff;
import org.dflib.set.Intersect;

public interface DoubleSeries
extends Series<Double> {
    @Override
    default public Class<Double> getNominalType() {
        return Double.TYPE;
    }

    @Override
    default public Class<?> getInferredType() {
        return Double.TYPE;
    }

    @Override
    default public DoubleSeries castAsDouble() {
        return this;
    }

    @Override
    default public DoubleSeries compactDouble(double forNull) {
        return this;
    }

    @Override
    default public Double get(int index) {
        return this.getDouble(index);
    }

    public double getDouble(int var1);

    @Override
    default public Series<Double> replace(int index, Double with) {
        return with != null ? this.replaceDouble(index, with) : ReplaceOp.replace(this, index, with);
    }

    default public DoubleSeries replaceDouble(int index, double with) {
        if (this.getDouble(index) == with) {
            return this;
        }
        int len = this.size();
        double[] doubles = new double[len];
        this.copyToDouble(doubles, 0, 0, len);
        doubles[index] = with;
        return Series.ofDouble(doubles);
    }

    public void copyToDouble(double[] var1, int var2, int var3, int var4);

    public DoubleSeries materialize();

    @Override
    default public int position(Double value) {
        if (value == null) {
            return -1;
        }
        double pval = value;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (pval != this.getDouble(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public Series<?> expand(Object ... values) {
        int len = values.length;
        if (len == 0) {
            return this;
        }
        double[] primitives = new double[len];
        for (int i = 0; i < len; ++i) {
            if (!(values[i] instanceof Double)) {
                return Series.super.expand(values);
            }
            primitives[i] = (Double)values[i];
        }
        return this.expandDouble(primitives);
    }

    default public DoubleSeries expandDouble(double ... values) {
        int rlen = values.length;
        if (rlen == 0) {
            return this;
        }
        int llen = this.size();
        double[] expanded = new double[llen + rlen];
        this.copyToDouble(expanded, 0, 0, llen);
        System.arraycopy(values, 0, expanded, llen, rlen);
        return Series.ofDouble(expanded);
    }

    @Override
    default public Series<?> insert(int pos, Object ... values) {
        int ilen = values.length;
        double[] doubles = new double[ilen];
        for (int i = 0; i < ilen; ++i) {
            if (!(values[i] instanceof Double)) {
                return Series.super.insert(pos, values);
            }
            doubles[i] = (Double)values[i];
        }
        return this.insertDouble(pos, doubles);
    }

    default public DoubleSeries insertDouble(int pos, double ... values) {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative insert position: " + pos);
        }
        int slen = this.size();
        if (pos > slen) {
            throw new IllegalArgumentException("Insert position past the end of the Series: " + pos + ", len: " + slen);
        }
        int ilen = values.length;
        if (ilen == 0) {
            return this;
        }
        double[] expanded = new double[slen + ilen];
        if (pos > 0) {
            this.copyToDouble(expanded, 0, 0, pos);
        }
        System.arraycopy(values, 0, expanded, pos, ilen);
        if (pos < slen) {
            this.copyToDouble(expanded, pos, pos + ilen, slen - pos);
        }
        return Series.ofDouble(expanded);
    }

    public DoubleSeries concatDouble(DoubleSeries ... var1);

    default public DoubleSeries diff(Series<? extends Double> other) {
        return Diff.diffDouble(this, other);
    }

    default public DoubleSeries intersect(Series<? extends Double> other) {
        return Intersect.intersectDouble(this, other);
    }

    public DoubleSeries rangeDouble(int var1, int var2);

    default public DoubleSeries head(int len) {
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.tail(this.size() + len) : this.rangeDouble(0, len);
    }

    default public DoubleSeries tail(int len) {
        int size = this.size();
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.head(size + len) : this.rangeDouble(size - len, size);
    }

    public DoubleSeries select(Condition var1);

    public DoubleSeries select(Predicate<Double> var1);

    public DoubleSeries select(BooleanSeries var1);

    @Override
    default public Series<Double> select(IntSeries positions) {
        return DoubleIndexedSeries.of(this, positions);
    }

    public DoubleSeries selectDouble(DoublePredicate var1);

    public DoubleSeries sort(Sorter ... var1);

    public DoubleSeries sort(Comparator<? super Double> var1);

    public DoubleSeries sortDouble();

    public IntSeries indexDouble(DoublePredicate var1);

    public BooleanSeries locateDouble(DoublePredicate var1);

    @Override
    default public BooleanSeries isNull() {
        return new FalseSeries(this.size());
    }

    @Override
    default public BooleanSeries isNotNull() {
        return new TrueSeries(this.size());
    }

    public DoubleSeries unique();

    public DoubleSeries sample(int var1);

    public DoubleSeries sample(int var1, Random var2);

    default public double[] toDoubleArray() {
        int len = this.size();
        double[] copy = new double[len];
        this.copyToDouble(copy, 0, 0, len);
        return copy;
    }

    public DoubleSeries cumSum();

    public double max();

    public double min();

    public double sum();

    public double avg();

    default public double median() {
        return this.quantile(0.5);
    }

    public double quantile(double var1);

    default public double stdDev(boolean usePopulationStdDev) {
        double variance = this.variance(usePopulationStdDev);
        return Math.sqrt(variance);
    }

    default public double stdDev() {
        return this.stdDev(true);
    }

    default public double variance(boolean usePopulationVariance) {
        int len = this.size();
        double avg = this.avg();
        double denominator = usePopulationVariance ? (double)len : (double)(len - 1);
        double acc = 0.0;
        for (int i = 0; i < len; ++i) {
            double x = this.getDouble(i);
            acc += (x - avg) * (x - avg);
        }
        return acc / denominator;
    }

    default public double variance() {
        return this.variance(true);
    }

    @Override
    default public BooleanSeries eq(Series<?> s) {
        if (!(s instanceof DoubleSeries)) {
            return Series.super.eq(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleSeries as = (DoubleSeries)s;
        return BoolBuilder.buildSeries(i -> this.getDouble(i) == as.getDouble(i), len);
    }

    @Override
    default public BooleanSeries ne(Series<?> s) {
        if (!(s instanceof DoubleSeries)) {
            return Series.super.ne(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleSeries as = (DoubleSeries)s;
        return BoolBuilder.buildSeries(i -> this.getDouble(i) != as.getDouble(i), len);
    }

    default public DoubleSeries add(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getDouble(i) + s.getDouble(i);
        }
        return new DoubleArraySeries(data);
    }

    default public DoubleSeries add(double v) {
        int len = this.size();
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getDouble(i) + v;
        }
        return new DoubleArraySeries(data);
    }

    default public DoubleSeries sub(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getDouble(i) - s.getDouble(i);
        }
        return new DoubleArraySeries(data);
    }

    default public DoubleSeries mul(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getDouble(i) * s.getDouble(i);
        }
        return new DoubleArraySeries(data);
    }

    default public DoubleSeries mul(double v) {
        int len = this.size();
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getDouble(i) * v;
        }
        return new DoubleArraySeries(data);
    }

    default public DoubleSeries div(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getDouble(i) / s.getDouble(i);
        }
        return new DoubleArraySeries(data);
    }

    default public DoubleSeries mod(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getDouble(i) % s.getDouble(i);
        }
        return new DoubleArraySeries(data);
    }

    default public BooleanSeries lt(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getDouble(i) < s.getDouble(i), len);
    }

    default public BooleanSeries le(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getDouble(i) <= s.getDouble(i), len);
    }

    default public BooleanSeries gt(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getDouble(i) > s.getDouble(i), len);
    }

    default public BooleanSeries ge(DoubleSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getDouble(i) >= s.getDouble(i), len);
    }

    default public BooleanSeries between(DoubleSeries from, DoubleSeries to) {
        int len = this.size();
        if (len != from.size()) {
            throw new IllegalArgumentException("'from' Series size " + from.size() + " is not the same as this size " + len);
        }
        if (len != to.size()) {
            throw new IllegalArgumentException("'to' Series size " + to.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> {
            double v = this.getDouble(i);
            return v >= from.getDouble(i) && v <= to.getDouble(i);
        }, len);
    }
}

