/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.dflib.ByteSources;
import org.dflib.codec.Codec;
import org.dflib.zip.Zip;

@FunctionalInterface
public interface ByteSource {
    public InputStream stream();

    default public Optional<String> uri() {
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T processStream(Function<InputStream, T> processor) {
        try (InputStream in = this.stream();){
            InputStream t = processor.apply(in);
            return (T)t;
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing stream", e);
        }
    }

    default public ByteSources unzip() {
        return Zip.of(this).sources();
    }

    default public ByteSource decompress(Codec codec) {
        return codec.decompress(this);
    }

    default public byte[] asBytes() {
        byte[] byArray;
        block8: {
            InputStream in = this.stream();
            try {
                byArray = in.readAllBytes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading stream", e);
                }
            }
            in.close();
        }
        return byArray;
    }

    public static ByteSource of(final byte[] bytes) {
        return new ByteSource(){

            @Override
            public InputStream stream() {
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public byte[] asBytes() {
                return bytes;
            }
        };
    }

    public static ByteSource ofUrl(final URL url) {
        Objects.requireNonNull(url);
        return new ByteSource(){

            @Override
            public Optional<String> uri() {
                return Optional.of(url.toString());
            }

            @Override
            public InputStream stream() {
                try {
                    return url.openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading the URL:" + String.valueOf(url), e);
                }
            }
        };
    }

    public static ByteSource ofUrl(final String url) {
        Objects.requireNonNull(url);
        return new ByteSource(){

            @Override
            public Optional<String> uri() {
                return Optional.of(url);
            }

            @Override
            public InputStream stream() {
                try {
                    return new URL(url).openStream();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Bad URL:" + url, e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading the URL:" + url, e);
                }
            }
        };
    }

    public static ByteSource ofPath(Path path) {
        return ByteSource.ofFile(path.toFile());
    }

    public static ByteSource ofFile(String file) {
        return ByteSource.ofFile(new File(file));
    }

    public static ByteSource ofFile(final File file) {
        Objects.requireNonNull(file);
        return new ByteSource(){

            @Override
            public Optional<String> uri() {
                return Optional.of(file.getAbsolutePath());
            }

            @Override
            public InputStream stream() {
                try {
                    return new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading file: " + String.valueOf(file), e);
                }
            }
        };
    }
}

