/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Comparator;
import java.util.Random;
import java.util.function.Predicate;
import org.dflib.Condition;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.builder.BoolAccum;
import org.dflib.builder.BoolBuilder;
import org.dflib.op.BooleanSeriesOps;
import org.dflib.op.ReplaceOp;
import org.dflib.series.BooleanIndexedSeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.TrueSeries;
import org.dflib.set.Diff;
import org.dflib.set.Intersect;

public interface BooleanSeries
extends Series<Boolean> {
    public static BooleanSeries andAll(BooleanSeries ... series) {
        return BooleanSeriesOps.andAll(series);
    }

    public static BooleanSeries orAll(BooleanSeries ... series) {
        return BooleanSeriesOps.orAll(series);
    }

    @Override
    default public Class<Boolean> getNominalType() {
        return Boolean.TYPE;
    }

    @Override
    default public Class<?> getInferredType() {
        return Boolean.TYPE;
    }

    @Override
    default public BooleanSeries castAsBool() {
        return this;
    }

    @Override
    default public BooleanSeries compactBool() {
        return this;
    }

    @Override
    default public Boolean get(int index) {
        return this.getBool(index);
    }

    public boolean getBool(int var1);

    @Override
    default public Series<Boolean> replace(int index, Boolean with) {
        return with != null ? this.replaceBool(index, with) : ReplaceOp.replace(this, index, with);
    }

    default public BooleanSeries replaceBool(int index, boolean with) {
        if (this.getBool(index) == with) {
            return this;
        }
        int len = this.size();
        BoolAccum accum = new BoolAccum(len);
        accum.fill(this, 0, 0, len);
        accum.fill(index, index + 1, with);
        return accum.toSeries();
    }

    public void copyToBool(boolean[] var1, int var2, int var3, int var4);

    public BooleanSeries materialize();

    @Override
    default public int position(Boolean value) {
        if (value == null) {
            return -1;
        }
        boolean pval = value;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (pval != this.getBool(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public Series<?> expand(Object ... values) {
        int len = values.length;
        if (len == 0) {
            return this;
        }
        boolean[] bools = new boolean[len];
        for (int i = 0; i < len; ++i) {
            if (!(values[i] instanceof Boolean)) {
                return Series.super.expand(values);
            }
            bools[i] = (Boolean)values[i];
        }
        return this.expandBool(bools);
    }

    default public BooleanSeries expandBool(boolean ... values) {
        int rlen = values.length;
        if (rlen == 0) {
            return this;
        }
        int llen = this.size();
        boolean[] expanded = new boolean[llen + rlen];
        this.copyToBool(expanded, 0, 0, llen);
        System.arraycopy(values, 0, expanded, llen, rlen);
        return Series.ofBool(expanded);
    }

    @Override
    default public Series<?> insert(int pos, Object ... values) {
        int ilen = values.length;
        boolean[] bools = new boolean[ilen];
        for (int i = 0; i < ilen; ++i) {
            if (!(values[i] instanceof Boolean)) {
                return Series.super.insert(pos, values);
            }
            bools[i] = (Boolean)values[i];
        }
        return this.insertBool(pos, bools);
    }

    default public BooleanSeries insertBool(int pos, boolean ... values) {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative insert position: " + pos);
        }
        int slen = this.size();
        if (pos > slen) {
            throw new IllegalArgumentException("Insert position past the end of the Series: " + pos + ", len: " + slen);
        }
        int ilen = values.length;
        if (ilen == 0) {
            return this;
        }
        boolean[] expanded = new boolean[slen + ilen];
        if (pos > 0) {
            this.copyToBool(expanded, 0, 0, pos);
        }
        System.arraycopy(values, 0, expanded, pos, ilen);
        if (pos < slen) {
            this.copyToBool(expanded, pos, pos + ilen, slen - pos);
        }
        return Series.ofBool(expanded);
    }

    public BooleanSeries concatBool(BooleanSeries ... var1);

    default public BooleanSeries diff(Series<? extends Boolean> other) {
        return Diff.diffBool(this, other);
    }

    default public BooleanSeries intersect(Series<? extends Boolean> other) {
        return Intersect.intersectBool(this, other);
    }

    public BooleanSeries rangeBool(int var1, int var2);

    default public BooleanSeries head(int len) {
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.tail(this.size() + len) : this.rangeBool(0, len);
    }

    default public BooleanSeries tail(int len) {
        int size = this.size();
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.head(size + len) : this.rangeBool(size - len, size);
    }

    public BooleanSeries select(BooleanSeries var1);

    public BooleanSeries select(Predicate<Boolean> var1);

    public BooleanSeries select(Condition var1);

    @Override
    default public Series<Boolean> select(IntSeries positions) {
        return BooleanIndexedSeries.of(this, positions);
    }

    public BooleanSeries sort(Sorter ... var1);

    public BooleanSeries sort(Comparator<? super Boolean> var1);

    public int firstTrue();

    public int firstFalse();

    public IntSeries indexTrue();

    public IntSeries indexFalse();

    public boolean isTrue();

    public boolean isFalse();

    @Override
    default public BooleanSeries isNull() {
        return new FalseSeries(this.size());
    }

    @Override
    default public BooleanSeries isNotNull() {
        return new TrueSeries(this.size());
    }

    public BooleanSeries unique();

    public BooleanSeries and(BooleanSeries var1);

    public BooleanSeries or(BooleanSeries var1);

    public BooleanSeries not();

    public BooleanSeries sample(int var1);

    public BooleanSeries sample(int var1, Random var2);

    public int countTrue();

    public int countFalse();

    default public boolean[] toBoolArray() {
        int len = this.size();
        boolean[] copy = new boolean[len];
        this.copyToBool(copy, 0, 0, len);
        return copy;
    }

    public IntSeries cumSum();

    @Override
    default public BooleanSeries eq(Series<?> s) {
        if (!(s instanceof BooleanSeries)) {
            return Series.super.eq(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        BooleanSeries anotherBool = (BooleanSeries)s;
        return BoolBuilder.buildSeries(i -> this.getBool(i) == anotherBool.getBool(i), len);
    }

    @Override
    default public BooleanSeries ne(Series<?> s) {
        if (!(s instanceof BooleanSeries)) {
            return Series.super.ne(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        BooleanSeries anotherBool = (BooleanSeries)s;
        return BoolBuilder.buildSeries(i -> this.getBool(i) != anotherBool.getBool(i), len);
    }
}

