/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.sender.factory;

import com.sourcekraft.documentburster.common.settings.model.EmailSettings;
import com.sourcekraft.documentburster.common.settings.model.SmsSettings;
import com.sourcekraft.documentburster.common.settings.model.UploadSettings;
import com.sourcekraft.documentburster.common.settings.model.WebUploadSettings;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.sender.AbstractSender;
import com.sourcekraft.documentburster.sender.EmailSender;
import com.sourcekraft.documentburster.sender.SmsSender;
import com.sourcekraft.documentburster.sender.UploadSender;
import com.sourcekraft.documentburster.sender.WebUploadSender;
import com.sourcekraft.documentburster.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendersFactory {
    private static Logger log = LoggerFactory.getLogger(SendersFactory.class);

    public static List<AbstractSender> makeSenders(BurstingContext ctx, boolean execute) throws Exception {
        AbstractSender sender;
        log.debug("getSenders(BurstingContext context, String testName, boolean execute) : context=[" + ctx + "]; testName=" + ctx.testName + "; execute=" + execute);
        ArrayList<AbstractSender> senders = new ArrayList<AbstractSender>();
        EmailSettings emailSettings = ctx.settings.getEmailSettings();
        UploadSettings uploadSettings = ctx.settings.getUploadSettings();
        WebUploadSettings webUploadSettings = ctx.settings.getWebUploadSettings();
        SmsSettings smsSettings = ctx.settings.getSmsSettings();
        boolean isValidEmailMessage = Utils.isValidEmailMessage((BurstingContext)ctx, (EmailSettings)emailSettings);
        boolean isValidFtpCommand = Utils.isValidFtpCommand((BurstingContext)ctx, (UploadSettings)uploadSettings);
        boolean isValidFileShareCommand = Utils.isValidFileShareCommand((BurstingContext)ctx, (UploadSettings)uploadSettings);
        boolean isValidFtpsCommand = Utils.isValidFtpsCommand((BurstingContext)ctx, (UploadSettings)uploadSettings);
        boolean isValidSftpCommand = Utils.isValidSftpCommand((BurstingContext)ctx, (UploadSettings)uploadSettings);
        boolean isValidHttpCommand = Utils.isValidHttpCommand((BurstingContext)ctx, (UploadSettings)uploadSettings);
        boolean isValidCloudUploadCommand = Utils.isValidCloudUploadCommand((BurstingContext)ctx, (UploadSettings)uploadSettings);
        boolean isValidDocumentBursterWebCommand = Utils.isValidDocumentBursterWebCommand((BurstingContext)ctx, (WebUploadSettings)webUploadSettings);
        boolean isValidMSSharePointCommand = Utils.isValidMSSharePointCommand((BurstingContext)ctx, (WebUploadSettings)webUploadSettings);
        boolean isValidWordPressCommand = Utils.isValidWordPressCommand((BurstingContext)ctx, (WebUploadSettings)webUploadSettings);
        boolean isValidDrupalCommand = Utils.isValidDrupalCommand((BurstingContext)ctx, (WebUploadSettings)webUploadSettings);
        boolean isValidJoomlaCommand = Utils.isValidJoomlaCommand((BurstingContext)ctx, (WebUploadSettings)webUploadSettings);
        boolean isValidOtherWebCommand = Utils.isValidOtherWebCommand((BurstingContext)ctx, (WebUploadSettings)webUploadSettings);
        boolean isValidTwilioMessage = Utils.isValidTwilioMessage((BurstingContext)ctx, (SmsSettings)smsSettings);
        boolean isValidSmsMessage = Utils.isValidSmsMessage((BurstingContext)ctx, (SmsSettings)smsSettings);
        boolean isSendFilesEmail = ctx.settings.getSendFiles().email;
        boolean isSendFilesUpload = ctx.settings.getSendFiles().upload;
        boolean isSendFilesWeb = ctx.settings.getSendFiles().web;
        boolean isSendFilesSms = ctx.settings.getSendFiles().sms;
        if (isSendFilesEmail && isValidEmailMessage) {
            sender = new EmailSender(execute, ctx);
            senders.add(sender);
            log.debug("Following email destination was matched for the token : " + ctx.token + ", destination : " + emailSettings);
        }
        if (isSendFilesUpload) {
            if (isValidFtpCommand) {
                sender = new UploadSender(execute, ctx);
                ((UploadSender)sender).setType(UploadSender.UploadType.FTP);
                senders.add(sender);
                log.debug("Following FTP upload destination was matched for the token : " + ctx.token + ", destination : " + uploadSettings);
            }
            if (isValidFileShareCommand) {
                sender = new UploadSender(execute, ctx);
                ((UploadSender)sender).setType(UploadSender.UploadType.FILESHARE);
                senders.add(sender);
                log.debug("Following File Share upload destination was matched for the token : " + ctx.token + ", destination : " + uploadSettings);
            }
            if (isValidFtpsCommand) {
                sender = new UploadSender(execute, ctx);
                ((UploadSender)sender).setType(UploadSender.UploadType.FTPS);
                senders.add(sender);
                log.debug("Following FTPS upload destination was matched for the token : " + ctx.token + ", destination : " + uploadSettings);
            }
            if (isValidSftpCommand) {
                sender = new UploadSender(execute, ctx);
                ((UploadSender)sender).setType(UploadSender.UploadType.SFTP);
                senders.add(sender);
                log.debug("Following SFTP upload destination was matched for the token : " + ctx.token + ", destination : " + uploadSettings);
            }
            if (isValidHttpCommand) {
                sender = new UploadSender(execute, ctx);
                ((UploadSender)sender).setType(UploadSender.UploadType.HTTP);
                senders.add(sender);
                log.debug("Following HTTP upload destination was matched for the token : " + ctx.token + ", destination : " + uploadSettings);
            }
            if (isValidCloudUploadCommand) {
                sender = new UploadSender(execute, ctx);
                ((UploadSender)sender).setType(UploadSender.UploadType.CLOUD);
                senders.add(sender);
                log.debug("Following CLOUD upload destination was matched for the token : " + ctx.token + ", destination : " + uploadSettings);
            }
        }
        if (isSendFilesWeb) {
            if (isValidDocumentBursterWebCommand) {
                sender = new WebUploadSender(execute, ctx);
                ((WebUploadSender)sender).setType(WebUploadSender.UploadType.DOCUMENTBURSTERWEB);
                senders.add(sender);
                log.debug("Following DocumentBursterWeb upload destination was matched for the token : " + ctx.token + ", destination : " + webUploadSettings);
            }
            if (isValidMSSharePointCommand) {
                sender = new WebUploadSender(execute, ctx);
                ((WebUploadSender)sender).setType(WebUploadSender.UploadType.MSSHAREPOINT);
                senders.add(sender);
                log.debug("Following Microsoft SharePoint upload destination was matched for the token : " + ctx.token + ", destination : " + webUploadSettings);
            }
            if (isValidWordPressCommand) {
                sender = new WebUploadSender(execute, ctx);
                ((WebUploadSender)sender).setType(WebUploadSender.UploadType.WORDPRESS);
                senders.add(sender);
                log.debug("Following WordPress upload destination was matched for the token : " + ctx.token + ", destination : " + webUploadSettings);
            }
            if (isValidDrupalCommand) {
                sender = new WebUploadSender(execute, ctx);
                ((WebUploadSender)sender).setType(WebUploadSender.UploadType.DRUPAL);
                senders.add(sender);
                log.debug("Following Drupal upload destination was matched for the token : " + ctx.token + ", destination : " + webUploadSettings);
            }
            if (isValidJoomlaCommand) {
                sender = new WebUploadSender(execute, ctx);
                ((WebUploadSender)sender).setType(WebUploadSender.UploadType.JOOMLA);
                senders.add(sender);
                log.debug("Following Joomla upload destination was matched for the token : " + ctx.token + ", destination : " + webUploadSettings);
            }
            if (isValidOtherWebCommand) {
                sender = new WebUploadSender(execute, ctx);
                ((WebUploadSender)sender).setType(WebUploadSender.UploadType.OTHERWEB);
                senders.add(sender);
                log.debug("Following OtherWeb upload destination was matched for the token : " + ctx.token + ", destination : " + webUploadSettings);
            }
        }
        if (isSendFilesSms) {
            if (isValidTwilioMessage) {
                sender = new SmsSender(execute, ctx);
                ((SmsSender)sender).setType(SmsSender.SmsType.TWILIO);
                senders.add(sender);
                log.debug("Following Twilio SMS destination was matched for the token : " + ctx.token + ", destination : " + smsSettings);
            } else if (isValidSmsMessage) {
                sender = new SmsSender(execute, ctx);
                ((SmsSender)sender).setType(SmsSender.SmsType.SMS);
                senders.add(sender);
                log.debug("Following SMS destination was matched for the token : " + ctx.token + ", destination : " + smsSettings);
            }
        }
        if (isSendFilesEmail && !isValidEmailMessage) {
            throw new IllegalArgumentException("Missing EMAIL configuration for the token : " + ctx.token + "!");
        }
        if (!(!isSendFilesUpload || isValidFtpCommand || isValidFileShareCommand || isValidFtpsCommand || isValidSftpCommand || isValidHttpCommand || isValidCloudUploadCommand)) {
            throw new IllegalArgumentException("Missing UPLOAD configuration for the token : " + ctx.token + "!");
        }
        if (!(!isSendFilesWeb || isValidDocumentBursterWebCommand || isValidMSSharePointCommand || isValidWordPressCommand || isValidDrupalCommand || isValidJoomlaCommand || isValidOtherWebCommand)) {
            throw new IllegalArgumentException("Missing Web Upload configuration for the token : " + ctx.token + "!");
        }
        if (isSendFilesSms && !isValidTwilioMessage && !isValidSmsMessage) {
            throw new IllegalArgumentException("Missing SMS configuration for the token : " + ctx.token + "!");
        }
        return senders;
    }
}

