/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.sender;

import com.sourcekraft.documentburster.common.settings.model.WebUploadSettings;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.sender.AbstractSender;
import com.sourcekraft.documentburster.sender.model.UploadMessage;
import com.sourcekraft.documentburster.utils.Utils;
import com.sourcekraft.documentburster.variables.Variables;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class WebUploadSender
extends AbstractSender {
    UploadType type;

    public WebUploadSender(boolean execute, BurstingContext ctx) {
        super(execute, ctx);
    }

    public void setType(UploadType type) {
        this.type = type;
    }

    @Override
    protected void doSend() throws Exception {
        UploadMessage message = new UploadMessage();
        message.token = this.ctx.token;
        WebUploadSettings webUploadSettings = this.ctx.settings.getWebUploadSettings();
        String typeStr = "documentbursterweb";
        switch (this.type) {
            case DOCUMENTBURSTERWEB: {
                message.uploadCommand = Utils.getStringFromTemplate((String)webUploadSettings.documentbursterwebcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "documentbursterweb";
                break;
            }
            case MSSHAREPOINT: {
                message.uploadCommand = Utils.getStringFromTemplate((String)webUploadSettings.mssharepointcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "mssharepoint";
                break;
            }
            case WORDPRESS: {
                message.uploadCommand = Utils.getStringFromTemplate((String)webUploadSettings.wordpresscommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "wordpress";
                break;
            }
            case DRUPAL: {
                message.uploadCommand = Utils.getStringFromTemplate((String)webUploadSettings.drupalcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "drupal";
                break;
            }
            case JOOMLA: {
                message.uploadCommand = Utils.getStringFromTemplate((String)webUploadSettings.joomlacommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "joomla";
                break;
            }
            case OTHERWEB: {
                message.uploadCommand = Utils.getStringFromTemplate((String)webUploadSettings.otherwebcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "otherweb";
                break;
            }
            default: {
                message.uploadCommand = Utils.getStringFromTemplate((String)webUploadSettings.documentbursterwebcommand, (Variables)this.ctx.variables, (String)this.ctx.token);
                typeStr = "documentbursterweb";
            }
        }
        this.log.info("Web-Uploading " + this.ctx.attachments + " using command " + message.uploadCommand);
        if (this.ctx.isQARunningMode) {
            FileUtils.writeStringToFile((File)new File(this.ctx.outputFolder + "/quality-assurance/" + this.ctx.token + "_" + typeStr + "_documents2webupload.txt"), (String)message.toString(), (String)"UTF-8");
        }
        if (this.execute) {
            this.scripting.executeSenderScript(this.ctx.scripts.webUpload, message);
        }
        this.log.info("Attachments " + this.ctx.attachments + " web-uploaded successfully.");
    }

    public static enum UploadType {
        DOCUMENTBURSTERWEB,
        MSSHAREPOINT,
        WORDPRESS,
        DRUPAL,
        JOOMLA,
        OTHERWEB;

    }
}

