/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.sender;

import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.sender.AbstractSender;
import com.sourcekraft.documentburster.sender.factory.EmailMessageFactory;
import com.sourcekraft.documentburster.sender.model.EmailMessage;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class EmailSender
extends AbstractSender {
    public EmailSender(boolean execute, BurstingContext ctx) {
        super(execute, ctx);
    }

    @Override
    protected void doSend() throws Exception {
        EmailMessage message = new EmailMessageFactory().createEmailMessage(this.ctx, this.ctx.isQARunningMode);
        this.log.info("Sending email with attachments " + this.ctx.attachments + " TO : " + message.tos + ", CC : " + message.ccs + ", BCC: " + message.bccs);
        if (this.ctx.isQARunningMode) {
            FileUtils.writeStringToFile((File)new File(this.ctx.outputFolder + "/quality-assurance/" + this.ctx.token + "_email.txt"), (String)message.toString(), (String)"UTF-8");
        }
        if (this.execute) {
            this.scripting.executeSenderScript(this.ctx.scripts.email, message);
        }
        if (this.ctx.isQARunningMode) {
            this.log.info("(Running in QA Mode) Email with attachments " + this.ctx.attachments + " was sent successfully TO : " + message.tos + ", CC : " + message.ccs + ", BCC: " + message.bccs + " (emails and upload commands are only logged if you run QA for all the burst tokens found in the report)");
        } else {
            this.log.info("Email with attachments " + this.ctx.attachments + " was sent successfully TO : " + message.tos + ", CC : " + message.ccs + ", BCC: " + message.bccs);
        }
    }
}

