/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.scripting;

import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.sender.model.AbstractMessage;
import com.sourcekraft.documentburster.utils.Utils;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scripting {
    private static Logger log = LoggerFactory.getLogger(Scripting.class);
    private String[] engineRoots = new String[]{"scripts/burst", "scripts/burst/internal"};

    public void executeBurstingLifeCycleScript(String scriptFileName, BurstingContext context) throws Exception {
        this.executeScript(scriptFileName, context, "ctx");
    }

    public void executeSenderScript(String scriptFileName, AbstractMessage message) throws Exception {
        this.executeScript(scriptFileName, (Object)message, "message");
    }

    private void executeScript(String scriptFileName, Object context, String contextObjectName) throws Exception {
        String scriptFilePath = this.engineRoots[0] + "/" + scriptFileName;
        boolean scriptFound = false;
        for (int i = 0; i < this.engineRoots.length && !scriptFound; ++i) {
            scriptFilePath = this.engineRoots[i] + "/" + scriptFileName;
            File scriptFile = new File(scriptFilePath);
            scriptFound = scriptFile.exists();
        }
        if (!Utils.isEmptyFile((String)scriptFilePath)) {
            GroovyScriptEngine gse = new GroovyScriptEngine(this.engineRoots);
            Binding binding = new Binding();
            binding.setVariable(contextObjectName, context);
            binding.setVariable("log", (Object)log);
            gse.run(scriptFileName, binding);
        }
    }

    public void setRoots(String[] roots) {
        this.engineRoots = Arrays.copyOf(roots, roots.length);
    }
}

