/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.reporting;

import com.sourcekraft.documentburster.engine.AbstractReporter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlReporter
extends AbstractReporter {
    private static final Logger log = LoggerFactory.getLogger(XmlReporter.class);

    public XmlReporter(String configFilePath) {
        super(configFilePath);
    }

    @Override
    protected void fetchData() throws Exception {
        int i;
        log.trace("Entering fetchData...");
        String repeatingNodeXPath = this.ctx.settings.getReportDataSource().xmloptions.repeatingnodexpath;
        String idColumn = this.ctx.settings.getReportDataSource().xmloptions.idcolumn;
        String namespaceMappings = this.ctx.settings.getReportDataSource().xmloptions.namespacemappings;
        String encoding = this.ctx.settings.getReportDataSource().xmloptions.encoding;
        boolean ignoreLeadingWhitespace = this.ctx.settings.getReportDataSource().xmloptions.ignoreleadingwhitespace;
        if (StringUtils.isBlank((CharSequence)repeatingNodeXPath)) {
            throw new IllegalArgumentException("repeatingnodexpath must be provided in XML options.");
        }
        boolean namespaceAware = StringUtils.isNotBlank((CharSequence)namespaceMappings);
        log.debug("XML Options: repeatingNodeXPath={}, idColumn={}, namespaceAware={}, encoding={}, ignoreLeadingWhitespace={}, namespaceMappings={}", new Object[]{repeatingNodeXPath, idColumn, namespaceAware, encoding, ignoreLeadingWhitespace, namespaceMappings});
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(namespaceAware);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(Files.newInputStream(Paths.get(this.filePath, new String[0]), new OpenOption[0]), encoding);
        doc.getDocumentElement().normalize();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        if (namespaceAware) {
            String[] lines;
            final HashMap<String, String> nsMap = new HashMap<String, String>();
            for (String line : lines = namespaceMappings.split("\\r?\\n")) {
                int eq;
                String trimmed = line.trim();
                if (trimmed.isEmpty() || (eq = trimmed.indexOf(61)) <= 0 || eq >= trimmed.length() - 1) continue;
                String prefix = trimmed.substring(0, eq).trim();
                String uri = trimmed.substring(eq + 1).trim();
                nsMap.put(prefix, uri);
            }
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return nsMap.getOrDefault(prefix, "");
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    for (Map.Entry entry : nsMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(namespaceURI)) continue;
                        return (String)entry.getKey();
                    }
                    return null;
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    ArrayList<String> prefixes = new ArrayList<String>();
                    for (Map.Entry entry : nsMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(namespaceURI)) continue;
                        prefixes.add((String)entry.getKey());
                    }
                    return prefixes.iterator();
                }
            });
        }
        NodeList repeatingNodes = (NodeList)xpath.evaluate(repeatingNodeXPath, doc, XPathConstants.NODESET);
        int nodeCount = repeatingNodes.getLength();
        log.info("Found {} repeating nodes using XPath '{}'", (Object)nodeCount, (Object)repeatingNodeXPath);
        this.ctx.reportData = new ArrayList();
        this.ctx.reportColumnNames = new ArrayList();
        LinkedHashSet<String> columnSet = new LinkedHashSet<String>();
        for (i = 0; i < nodeCount; ++i) {
            Node node = repeatingNodes.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap attrs = node.getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                columnSet.add("@" + attrs.item(j).getNodeName());
            }
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                columnSet.add(child.getNodeName());
            }
        }
        this.ctx.reportColumnNames.addAll(columnSet);
        for (i = 0; i < nodeCount; ++i) {
            Node node = repeatingNodes.item(i);
            LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>();
            NamedNodeMap attrs = node.getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                String attrName = "@" + attrs.item(j).getNodeName();
                String value = attrs.item(j).getNodeValue();
                if (ignoreLeadingWhitespace && value != null) {
                    value = value.trim();
                }
                rowMap.put(attrName, this.toObject(value));
            }
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                String value = child.getTextContent();
                if (ignoreLeadingWhitespace && value != null) {
                    value = value.trim();
                }
                rowMap.put(child.getNodeName(), this.toObject(value));
            }
            this.ctx.reportData.add(rowMap);
            log.trace("Added data row map: {}", rowMap);
        }
        String fm = this.ctx.settings.getReportDataSource().xmloptions.fieldmappings;
        if (StringUtils.isNotBlank((CharSequence)fm)) {
            this.applyFieldMappings(fm);
        }
        log.info("XML data fetched successfully. Columns: {}. Data rows: {}", (Object)this.ctx.reportColumnNames.size(), (Object)this.ctx.reportData.size());
        log.trace("Exiting fetchData.");
    }

    private void applyFieldMappings(String fieldMappings) {
        if (StringUtils.isBlank((CharSequence)fieldMappings)) {
            return;
        }
        Map<String, String> mappings = this.parseFieldMappings(fieldMappings);
        ListIterator<String> headerIt = this.ctx.reportColumnNames.listIterator();
        while (headerIt.hasNext()) {
            String col = (String)headerIt.next();
            if (!mappings.containsKey(col)) continue;
            headerIt.set(mappings.get(col));
        }
        for (Map row : this.ctx.reportData) {
            for (Map.Entry<String, String> me : mappings.entrySet()) {
                String orig = me.getKey();
                if (!row.containsKey(orig)) continue;
                Object val = row.remove(orig);
                row.put(me.getValue(), val);
            }
        }
    }

    private Map<String, String> parseFieldMappings(String fm) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (String pair : fm.split("\\s*,\\s*")) {
            String[] kv = pair.split("\\s*:\\s*");
            if (kv.length != 2) continue;
            m.put(kv[0], kv[1]);
        }
        return m;
    }
}

