/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.reporting;

import com.sourcekraft.documentburster.common.db.DatabaseHelper;
import com.sourcekraft.documentburster.common.settings.model.ReportSettings;
import com.sourcekraft.documentburster.engine.AbstractReporter;
import com.sourcekraft.documentburster.utils.Utils;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlReporter
extends AbstractReporter {
    private static final Logger log = LoggerFactory.getLogger(SqlReporter.class);
    protected DatabaseHelper dbHelper;

    public SqlReporter(String configFilePath) {
        super(configFilePath);
        this.dbHelper = new DatabaseHelper(configFilePath);
        log.debug("SqlReporter initialized with config path: {}", (Object)configFilePath);
    }

    @Override
    protected void initializeResources() throws Exception {
        super.initializeResources();
        this.dbHelper.setCtx(this.ctx);
        this.ctx.variables.set("input_document_name", (Object)Utils.sanitizeFileName((String)this.ctx.settings.getTemplateName()));
    }

    @Override
    protected void fetchData() throws Exception {
        log.trace("Entering fetchData...");
        ReportSettings.DataSource.SQLOptions sqlOptions = this.ctx.settings.getReportDataSource().sqloptions;
        if (sqlOptions == null) {
            log.error("SQLOptions are null.");
            throw new IllegalStateException("SQLOptions cannot be null.");
        }
        String connectionCode = sqlOptions.conncode;
        String sqlQuery = sqlOptions.query;
        log.debug("SQL Options: conncode={}, query={}", (Object)connectionCode, (Object)sqlQuery);
        if (StringUtils.isBlank((CharSequence)connectionCode)) {
            throw new IllegalArgumentException("Database connection code (conncode) cannot be empty for SQL data source.");
        }
        if (StringUtils.isBlank((CharSequence)sqlQuery)) {
            throw new IllegalArgumentException("SQL query (sqlquery) cannot be empty for SQL data source.");
        }
        Jdbi jdbiInstance = this.retrieveJdbiInstance(connectionCode);
        String jdbiQuery = this.dbHelper.convertToJdbiParameters(sqlQuery);
        List queryParams = this.dbHelper.findQueryParameters(jdbiQuery);
        log.info("Executing SQL: {}", (Object)sqlQuery);
        log.debug("Converted JDBI query: '{}' with params: {}", (Object)jdbiQuery, (Object)queryParams);
        try (Handle handle = jdbiInstance.open();){
            Query query = handle.createQuery(jdbiQuery);
            Map currentVars = this.ctx.variables.getUserVariables(this.ctx.token);
            if (currentVars != null && !queryParams.isEmpty()) {
                StringBuilder paramLog = new StringBuilder("Parameters: ");
                boolean first = true;
                for (String paramName : queryParams) {
                    if (!currentVars.containsKey(paramName)) continue;
                    if (!first) {
                        paramLog.append(", ");
                    }
                    paramLog.append(paramName).append("='").append(currentVars.get(paramName)).append("'");
                    first = false;
                }
                log.info("{}", (Object)paramLog.toString());
            }
            if (currentVars != null) {
                for (String paramName : queryParams) {
                    if (currentVars.containsKey(paramName)) {
                        query.bind(paramName, currentVars.get(paramName));
                        continue;
                    }
                    log.warn("SQL parameter :{} not found in variables.", (Object)paramName);
                }
            }
            List dataRows = query.map((rs, rctx) -> {
                ResultSetMetaData md = rs.getMetaData();
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                for (int i = 1; i <= md.getColumnCount(); ++i) {
                    String columnName = md.getColumnLabel(i);
                    if (StringUtils.isBlank((CharSequence)columnName)) {
                        columnName = md.getColumnName(i);
                    }
                    row.put(columnName, rs.getObject(i));
                }
                return row;
            }).list();
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
            if (!dataRows.isEmpty()) {
                for (String col : ((LinkedHashMap)dataRows.get(0)).keySet()) {
                    headerMap.put(col, col);
                }
            }
            ArrayList finalRows = new ArrayList();
            finalRows.addAll(dataRows);
            this.ctx.reportData = finalRows;
            this.ctx.reportColumnNames = !dataRows.isEmpty() ? new ArrayList(((LinkedHashMap)dataRows.get(0)).keySet()) : new ArrayList();
            log.info("SQL query executed. Fetched {} result rows.", (Object)this.ctx.reportData.size());
        }
        log.trace("Exiting fetchData.");
    }

    protected Jdbi retrieveJdbiInstance(String connectionCode) throws Exception {
        return this.dbHelper.retrieveJdbiInstance(connectionCode);
    }

    @Override
    protected void backupFile() throws Exception {
        log.debug("Skipping backupFile for SqlReporter");
    }
}

