/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.reporting;

import com.sourcekraft.documentburster.common.settings.model.ReportSettings;
import com.sourcekraft.documentburster.common.settings.model.ServerDatabaseSettings;
import com.sourcekraft.documentburster.engine.AbstractReporter;
import com.sourcekraft.documentburster.utils.Utils;
import groovy.sql.Sql;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedReporter
extends AbstractReporter {
    private static final Logger log = LoggerFactory.getLogger(ScriptedReporter.class);
    private transient Sql dbSql = null;

    public ScriptedReporter(String configFilePath) {
        super(configFilePath);
        log.debug("ScriptedReporter initialized with config path: {}", (Object)configFilePath);
    }

    @Override
    protected void initializeResources() throws Exception {
        super.initializeResources();
        if (!this.hasRealInputFile()) {
            String templateName;
            String string = templateName = this.ctx.settings != null ? this.ctx.settings.getTemplateName() : null;
            if (StringUtils.isNotBlank((CharSequence)templateName)) {
                this.ctx.variables.set("input_document_name", (Object)Utils.sanitizeFileName((String)templateName));
            }
        }
    }

    @Override
    protected void fetchData() throws Exception {
        log.trace("Entering fetchData...");
        ReportSettings.DataSource.ScriptOptions scriptOptions = this.ctx.settings.getReportDataSource().scriptoptions;
        if (scriptOptions == null) {
            log.error("ScriptOptions are null in settings.");
            throw new IllegalStateException("ScriptOptions cannot be null for script data source.");
        }
        String scriptName = scriptOptions.scriptname;
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            scriptName = this.getReportFolderName() + "-script.groovy";
        }
        String connectionCode = scriptOptions.conncode;
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            throw new IllegalArgumentException("Script name (scriptname) cannot be empty for script data source.");
        }
        log.debug("Script Options: scriptName={}, conncode={}", (Object)scriptName, (Object)connectionCode);
        this.dbSql = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)connectionCode)) {
                ServerDatabaseSettings dbs = this.getServerDatabaseSettings(connectionCode);
                dbs.ensureDriverAndUrl();
                this.ctx.dbSql = this.dbSql = Sql.newInstance((String)dbs.url, (String)dbs.userid, (String)dbs.userpassword, (String)dbs.driver);
                log.debug("Created and provided dbSql for connection code: {}", (Object)connectionCode);
            }
            this.ctx.reportData = new ArrayList();
            this.ctx.reportColumnNames = new ArrayList();
            log.info("Executing Groovy script '{}' using Scripting engine...", (Object)scriptName);
            this.scripting.executeBurstingLifeCycleScript(scriptName, this.ctx);
            log.info("Groovy script execution finished.");
            if (this.ctx.reportData == null) {
                log.warn("Script did not populate ctx.reportData. Initializing to empty list.");
                this.ctx.reportData = new ArrayList();
            }
            if (this.ctx.reportColumnNames.isEmpty() && !this.ctx.reportData.isEmpty()) {
                Map firstRow = (Map)this.ctx.reportData.get(0);
                if (firstRow != null && !firstRow.isEmpty()) {
                    this.ctx.reportColumnNames.addAll(firstRow.keySet());
                    log.debug("Derived column names from first data row: {}", (Object)this.ctx.reportColumnNames);
                } else {
                    log.warn("First data row is null or empty, cannot derive column names.");
                }
            } else if (!this.ctx.reportColumnNames.isEmpty()) {
                log.debug("Script explicitly set column names: {}", (Object)this.ctx.reportColumnNames);
            } else {
                log.debug("Source data is empty, no column names to derive or set.");
            }
            log.info("Script generated {} data rows.", (Object)this.ctx.reportData.size());
            if (!this.ctx.reportData.isEmpty()) {
                log.debug("First row sample: {}", this.ctx.reportData.get(0));
            }
        }
        catch (Exception e) {
            log.error("Error executing Groovy script '{}': {}", new Object[]{scriptName, e.getMessage(), e});
            Throwable cause = e.getCause();
            String errorMessage = "Failed to fetch data using script '" + scriptName + "': " + e.getMessage();
            if (cause != null && cause.getClass().getName().contains("groovy")) {
                errorMessage = "Error in Groovy script '" + scriptName + "': " + cause.getMessage();
            }
            throw new RuntimeException(errorMessage, e);
        }
        finally {
            if (this.dbSql != null) {
                try {
                    this.dbSql.close();
                }
                catch (Exception exception) {}
                this.ctx.dbSql = null;
                this.dbSql = null;
            }
        }
        log.trace("Exiting fetchData.");
    }

    @Override
    public void parseBurstingMetaData() throws Exception {
        String idColumn;
        log.debug("Entering parseBurstingMetaData...");
        if (this.ctx.reportData == null || this.ctx.reportData.isEmpty()) {
            log.warn("No data available from script (reportData is null or empty). Cannot parse metadata.");
            this.ctx.burstTokens = new ArrayList();
            return;
        }
        String rawIdColumn = this.ctx.settings.getReportDataSource().scriptoptions.idcolumn;
        if (StringUtils.isEmpty((CharSequence)rawIdColumn)) {
            idColumn = "notused";
            log.warn("idcolumn not configured in scriptoptions, defaulting to '{}'", (Object)idColumn);
        } else {
            idColumn = rawIdColumn;
        }
        log.debug("Using configuredIdColumn: '{}' for token extraction.", (Object)idColumn);
        this.ctx.burstTokens.clear();
        int lineIndex = 0;
        log.debug("Starting to process {} rows generated by script for metadata parsing.", (Object)this.ctx.reportData.size());
        for (Map row : this.ctx.reportData) {
            String token;
            if (row == null) {
                log.warn("Skipping null row at index {}", (Object)lineIndex);
                ++lineIndex;
                continue;
            }
            log.trace("Processing script-generated row index: {}", (Object)lineIndex);
            log.trace("Row data: {}", (Object)row);
            if (idColumn.equalsIgnoreCase("notused")) {
                token = String.valueOf(lineIndex + 1);
                log.debug("Using 1-based index as token (NOT_USED): '{}'", (Object)token);
            } else {
                Object idValue = row.entrySet().stream().filter(entry -> idColumn.equalsIgnoreCase((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
                log.trace("Attempted to retrieve idValue for column '{}' (case-insensitive): {}", (Object)idColumn, idValue);
                if (idValue != null) {
                    token = String.valueOf(idValue);
                    log.debug("Using value from column '{}' as token: '{}'", (Object)idColumn, (Object)token);
                } else {
                    token = String.valueOf(lineIndex + 1);
                    log.warn("idValue was null or column '{}' not found in script row at index {}. Falling back to 1-based index token: '{}'", new Object[]{idColumn, lineIndex, token});
                    log.debug("Available columns in row: {}", row.keySet());
                }
            }
            this.ctx.variables.parseUserVariablesFromMap(token, row);
            this.ctx.burstTokens.add(token);
            ++lineIndex;
        }
        log.info("Generated {} tokens from script data.", (Object)this.ctx.burstTokens.size());
        log.debug("Final tokens list: {}", (Object)this.ctx.burstTokens);
        log.debug("Exiting parseBurstingMetaData.");
    }

    protected ServerDatabaseSettings getServerDatabaseSettings(String connectionCode) throws Exception {
        return this.ctx.dbManager.getServerDatabaseSettings(connectionCode);
    }

    @Override
    protected void closeResources() throws Exception {
        log.trace("closeResources - db handle cleanup handled in fetchData.");
    }

    @Override
    protected void backupFile() throws Exception {
        log.debug("Skipping backupFile for ScriptedReporter as there is no single input file.");
    }

    private boolean hasRealInputFile() {
        if (this.ctx == null) {
            return false;
        }
        String p = this.ctx.inputDocumentFilePath;
        if (StringUtils.isBlank((CharSequence)p)) {
            return false;
        }
        if (p.startsWith("file:")) {
            p = p.substring("file:".length());
        }
        try {
            String name = Paths.get(p, new String[0]).getFileName().toString();
            String ext = FilenameUtils.getExtension((String)name).toLowerCase();
            HashSet<String> sqliteExts = new HashSet<String>(Arrays.asList("db", "sqlite", "sqlite3", "db3"));
            if (sqliteExts.contains(ext)) {
                return false;
            }
            return Files.exists(Paths.get(p, new String[0]), new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }
}

