/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.reporting;

import com.sourcekraft.documentburster.engine.AbstractReporter;
import com.sourcekraft.documentburster.engine.excel.ExcelUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReporter
extends AbstractReporter {
    private static Logger log = LoggerFactory.getLogger(ExcelReporter.class);

    public ExcelReporter(String configFilePath) {
        super(configFilePath);
    }

    @Override
    protected void fetchData() throws Exception {
        log.trace("Entering fetchData...");
        String idColumn = this.ctx.settings.getReportDataSource().exceloptions.idcolumn;
        String headerSetting = this.ctx.settings.getReportDataSource().exceloptions.header;
        int userSkipLines = this.ctx.settings.getReportDataSource().exceloptions.skiplines;
        boolean ignoreLeadingWhitespace = this.ctx.settings.getReportDataSource().exceloptions.ignoreleadingwhitespace;
        boolean useFormulaResults = this.ctx.settings.getReportDataSource().exceloptions.useformularesults;
        int sheetIndex = this.ctx.settings.getReportDataSource().exceloptions.sheetindex;
        if (StringUtils.isEmpty((CharSequence)idColumn)) {
            throw new IllegalArgumentException("idcolumn setting must be configured - use 'notused' for sequential numbering");
        }
        if (!(idColumn.equalsIgnoreCase("notused") || idColumn.equalsIgnoreCase("firstcolumn") || idColumn.equalsIgnoreCase("lastcolumn") || StringUtils.isNumeric((CharSequence)idColumn))) {
            log.warn("idcolumn validation passed for: {}", (Object)idColumn);
            throw new IllegalArgumentException("idcolumn must be 'first', 'last', 'notused' or a numeric column index (e.g., 0, 1, ...)");
        }
        if (userSkipLines < 0) {
            log.warn("Invalid negative skipLines ({}) provided. Defaulting to 0.", (Object)userSkipLines);
            userSkipLines = 0;
        }
        boolean hasHeader = "firstline".equalsIgnoreCase(headerSetting) || "multiline".equalsIgnoreCase(headerSetting);
        log.debug("Excel Options: headerSetting={}, userSkipLines={}, hasHeader={}, ignoreLeadingWhitespace={}, useFormulaResults={}, sheetIndex={}", new Object[]{headerSetting, userSkipLines, hasHeader, ignoreLeadingWhitespace, useFormulaResults, sheetIndex});
        this.ctx.reportData = new ArrayList();
        this.ctx.reportColumnNames = new ArrayList();
        Object[] headers = null;
        int maxColsBasedOnHeader = 0;
        try (FileInputStream excelFile = new FileInputStream(this.filePath);
             Workbook workbook = WorkbookFactory.create((InputStream)excelFile);){
            int currentRowIndex;
            Sheet sheet;
            try {
                sheet = workbook.getSheetAt(sheetIndex);
                if (sheet == null) {
                    throw new IllegalArgumentException("Sheet index " + sheetIndex + " does not exist in the workbook.");
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid sheet index: " + sheetIndex + ". Workbook has " + workbook.getNumberOfSheets() + " sheets.", e);
            }
            log.debug("Selected sheet '{}' at index {}.", (Object)sheet.getSheetName(), (Object)sheetIndex);
            if (hasHeader) {
                log.debug("Attempting to read header from the first row (index 0).");
                Row headerRow = sheet.getRow(0);
                if (headerRow == null) {
                    log.warn("Header row (index 0) is null or physically missing, but header setting was '{}'. Will attempt to generate generic headers from data.", (Object)headerSetting);
                } else {
                    maxColsBasedOnHeader = headerRow.getLastCellNum();
                    if (maxColsBasedOnHeader < 0) {
                        maxColsBasedOnHeader = 0;
                    }
                    if (maxColsBasedOnHeader == 0) {
                        log.warn("Header row (index 0) has no cells. Will attempt to generate generic headers from data.");
                    } else {
                        headers = new String[maxColsBasedOnHeader];
                        log.trace("Header row has {} potential columns.", (Object)maxColsBasedOnHeader);
                        for (int i = 0; i < maxColsBasedOnHeader; ++i) {
                            Cell cell = headerRow.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                            headers[i] = ExcelUtils.getCellValueAsString(cell);
                            if (ignoreLeadingWhitespace && headers[i] != null) {
                                headers[i] = ((String)headers[i]).trim();
                            }
                            if (!StringUtils.isBlank((CharSequence)headers[i])) continue;
                            headers[i] = "col" + i;
                            log.trace("Header cell at index {} was blank, assigned default name '{}'.", (Object)i, headers[i]);
                        }
                        log.debug("Successfully read header from first row ({} columns): {}", (Object)headers.length, (Object)Arrays.toString(headers));
                    }
                }
            } else {
                log.debug("Header setting is 'noheader'. No header row will be read.");
            }
            int dataStartRowIndex = hasHeader ? Math.max(userSkipLines, 1) : userSkipLines;
            log.debug("Calculated data start row index (0-based): {}. (Based on hasHeader={}, userSkipLines={})", new Object[]{dataStartRowIndex, hasHeader, userSkipLines});
            Iterator rowIterator = sheet.iterator();
            for (currentRowIndex = 0; currentRowIndex < dataStartRowIndex && rowIterator.hasNext(); ++currentRowIndex) {
                rowIterator.next();
            }
            if (currentRowIndex < dataStartRowIndex) {
                log.warn("Reached end of sheet while skipping initial rows. Expected to start data at index {}, but sheet only has {} rows.", (Object)dataStartRowIndex, (Object)currentRowIndex);
            } else {
                log.debug("Starting data processing from physical row index {}.", (Object)currentRowIndex);
            }
            int dataRowCounter = 0;
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                log.trace("Processing physical row index: {}", (Object)currentRowIndex);
                int lastColumnForRow = row.getLastCellNum();
                if (lastColumnForRow < 0) {
                    lastColumnForRow = 0;
                }
                if (headers == null && dataRowCounter == 0) {
                    if (lastColumnForRow == 0) {
                        log.warn("First data row encountered (index {}) has no cells. Cannot generate headers.", (Object)currentRowIndex);
                        ++currentRowIndex;
                        continue;
                    }
                    headers = new String[lastColumnForRow];
                    for (int i = 0; i < lastColumnForRow; ++i) {
                        headers[i] = "Column" + (i + 1);
                    }
                    maxColsBasedOnHeader = lastColumnForRow;
                    log.debug("Generated generic headers based on first data row read ({} columns): {}", (Object)headers.length, (Object)Arrays.toString(headers));
                } else if (headers == null) {
                    log.error("Headers are unexpectedly null while processing data row index {}. Stopping data read.", (Object)currentRowIndex);
                    break;
                }
                int colsToProcess = maxColsBasedOnHeader > 0 ? maxColsBasedOnHeader : (int)lastColumnForRow;
                LinkedHashMap<Object, Object> rowMap = new LinkedHashMap<Object, Object>();
                boolean hasContent = false;
                for (int i = 0; i < colsToProcess; ++i) {
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    Object cellValue = null;
                    Object columnName = headers != null && i < headers.length ? headers[i] : "Column" + (i + 1);
                    try {
                        switch (cell.getCellType()) {
                            case NUMERIC: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    cellValue = cell.getDateCellValue();
                                    break;
                                }
                                cellValue = cell.getNumericCellValue();
                                break;
                            }
                            case BOOLEAN: {
                                cellValue = cell.getBooleanCellValue();
                                break;
                            }
                            case FORMULA: {
                                if (useFormulaResults) {
                                    try {
                                        cellValue = cell.getNumericCellValue();
                                    }
                                    catch (IllegalStateException | NumberFormatException eNum) {
                                        try {
                                            cellValue = cell.getStringCellValue();
                                            if (ignoreLeadingWhitespace && cellValue != null) {
                                                cellValue = ((String)cellValue).trim();
                                            }
                                        }
                                        catch (IllegalStateException eStr) {
                                            log.trace("Could not evaluate formula at [{},{}] as numeric or string, using formula string.", new Object[]{row.getRowNum(), i, eStr});
                                            cellValue = cell.getCellFormula();
                                        }
                                    }
                                    break;
                                }
                                cellValue = cell.getCellFormula();
                                break;
                            }
                            case BLANK: {
                                cellValue = null;
                                break;
                            }
                            case STRING: {
                                cellValue = cell.getStringCellValue();
                                if (ignoreLeadingWhitespace && cellValue != null) {
                                    cellValue = ((String)cellValue).trim();
                                }
                                break;
                            }
                            default: {
                                log.trace("Unhandled cell type {} at [{},{}]. Treating as null.", new Object[]{cell.getCellType(), row.getRowNum(), i});
                                cellValue = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.warn("Error reading cell at [{},{}] (Header: '{}'). Using null. Error: {}", new Object[]{row.getRowNum(), i, columnName, e.getMessage()});
                        cellValue = null;
                    }
                    Object uniqueHeaderName = columnName;
                    int duplicateCount = 2;
                    while (rowMap.containsKey(uniqueHeaderName)) {
                        uniqueHeaderName = (String)columnName + "_" + duplicateCount++;
                    }
                    if (!((String)uniqueHeaderName).equals(columnName)) {
                        log.trace("Duplicate header '{}' encountered for this row, using '{}' in map.", columnName, uniqueHeaderName);
                    }
                    rowMap.put(uniqueHeaderName, cellValue);
                    if (cellValue == null || cellValue instanceof String && ((String)cellValue).trim().isEmpty()) continue;
                    hasContent = true;
                }
                if (hasContent) {
                    this.ctx.reportData.add(rowMap);
                    log.trace("Added data row map (physical index {}): {}", (Object)currentRowIndex, rowMap);
                    ++dataRowCounter;
                } else {
                    log.trace("Skipped row at physical index {} because it contained no content.", (Object)currentRowIndex);
                }
                ++currentRowIndex;
            }
            log.info("Finished reading Excel data. Total data rows processed: {}", (Object)dataRowCounter);
        }
        if (headers != null) {
            LinkedHashMap<Object, Integer> headerCounts = new LinkedHashMap<Object, Integer>();
            for (Object header : headers) {
                int count = headerCounts.getOrDefault(header, 0) + 1;
                headerCounts.put(header, count);
                Object uniqueHeader = count > 1 && Arrays.stream(headers).filter(arg_0 -> ExcelReporter.lambda$fetchData$0((String)header, arg_0)).count() > 1L ? (String)header + "_" + count : header;
                this.ctx.reportColumnNames.add(uniqueHeader);
            }
            log.debug("Stored final column names (duplicates adjusted): {}", (Object)this.ctx.reportColumnNames);
        } else if (!this.ctx.reportData.isEmpty()) {
            log.warn("No headers were read or generated, but data rows exist. Column names context will be empty.");
        } else {
            log.debug("No headers found and no data rows processed.");
        }
        if (!this.ctx.reportData.isEmpty() && ((LinkedHashMap)this.ctx.reportData.get(0)).size() == 1) {
            log.warn("Validation check: Excel file appears to contain only 1 column with value: '{}'", ((LinkedHashMap)this.ctx.reportData.get(0)).values().iterator().next());
        }
        log.info("Excel data fetched successfully. Headers: {}. Data rows: {}", (Object)this.ctx.reportColumnNames.size(), (Object)this.ctx.reportData.size());
        log.trace("Exiting fetchData.");
    }

    private static /* synthetic */ boolean lambda$fetchData$0(String header, String h) {
        return h.equals(header);
    }
}

