/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSmartCopy;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.utils.Utils;
import com.sourcekraft.documentburster.variables.Variables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merger {
    protected Logger log = LoggerFactory.getLogger(Merger.class);
    private Settings settings;
    private Variables variables;
    private String outputFolder;
    private String backupFolder;
    private String outputFileName;
    private String mergedFilePath;
    private List<InputStream> streamOfPDFFiles = new ArrayList<InputStream>();

    public Merger(Settings settings) {
        this.settings = settings;
    }

    private void createFoldersAndPrepare(List<String> filePaths) throws Exception {
        File backupDir;
        if (StringUtils.isEmpty((CharSequence)this.outputFileName)) {
            this.outputFileName = this.settings.getMergeFileName();
        }
        if (StringUtils.isEmpty((CharSequence)this.outputFileName)) {
            this.outputFileName = "merged.pdf";
        }
        this.outputFolder = Utils.getStringFromTemplate((String)this.settings.getOutputFolder(), (Variables)this.variables, (String)"");
        this.backupFolder = Utils.getStringFromTemplate((String)this.settings.getBackupFolder(), (Variables)this.variables, (String)"") + "/merge/files";
        File outputDir = new File(this.outputFolder);
        if (!outputDir.exists()) {
            FileUtils.forceMkdir((File)outputDir);
        }
        if (!(backupDir = new File(this.backupFolder)).exists()) {
            FileUtils.forceMkdir((File)backupDir);
        }
        for (String filePath : filePaths) {
            String fileName = FilenameUtils.getName((String)filePath);
            File file = new File(this.backupFolder + "/" + fileName);
            FileUtils.copyFile((File)new File(filePath), (File)file);
            this.streamOfPDFFiles.add(new FileInputStream(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doMerge(List<String> filePaths, String outFileName) throws Exception {
        this.log.debug("Merger:doMerge filePaths = " + filePaths + ", outputFileName = " + outFileName);
        this.outputFileName = outFileName;
        if (StringUtils.isEmpty((CharSequence)this.outputFileName)) {
            this.outputFileName = this.settings.getMergeFileName();
        }
        if (StringUtils.isEmpty((CharSequence)this.outputFileName)) {
            this.outputFileName = "merged.pdf";
        }
        this.variables = new Variables(this.outputFileName, this.settings.getLanguage(), this.settings.getCountry(), this.settings.getNumberOfUserVariables());
        this.createFoldersAndPrepare(filePaths);
        this.mergedFilePath = this.outputFolder + "/" + this.outputFileName;
        List<InputStream> pdfs = this.streamOfPDFFiles;
        Iterator<InputStream> iteratorPDFs = pdfs.iterator();
        ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
        while (iteratorPDFs.hasNext()) {
            InputStream pdf = iteratorPDFs.next();
            PdfReader pdfReader = new PdfReader(pdf);
            readers.add(pdfReader);
            pdf.close();
        }
        PdfSmartCopy copy = null;
        Document document = new Document();
        try {
            copy = new PdfSmartCopy(document, (OutputStream)new FileOutputStream(this.mergedFilePath));
            document.open();
            for (PdfReader pdfReader : readers) {
                int n = pdfReader.getNumberOfPages();
                int page = 0;
                while (page < n) {
                    copy.addPage(copy.getImportedPage(pdfReader, ++page));
                }
                copy.freeReader(pdfReader);
                pdfReader.close();
            }
        }
        finally {
            document.addCreator(Utils.getProductName((String)this.settings.getVersion()));
            document.addAuthor(Utils.getProductName((String)this.settings.getVersion()));
            if (document.isOpen()) {
                document.close();
            }
            if (copy != null) {
                copy.close();
            }
        }
        return this.mergedFilePath;
    }

    public String getBackupFolder() {
        return this.backupFolder;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }
}

