/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine.excel.extractor;

import com.sourcekraft.documentburster.engine.excel.ExcelUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiExcelExtractor {
    private Logger log = LoggerFactory.getLogger(PoiExcelExtractor.class);
    private List<CellStyle> destStyles = new ArrayList<CellStyle>();
    private String inputFilePath;
    private String outputFilePath;
    private String token;
    private String tempWorkbookPath;

    public PoiExcelExtractor(String inputFilePath, String outputFilePath, String token) {
        this.log.debug("inputFilePath = , outputFilePath = " + outputFilePath + ", token = " + token);
        this.inputFilePath = inputFilePath;
        this.outputFilePath = outputFilePath;
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExtractForDistinctColumnValueCopy(int sheetIndex, int columnIndex) throws Exception {
        this.log.debug("sheetIndex = " + sheetIndex + ", columnIndex = " + columnIndex);
        FileOutputStream fileOut = null;
        FileInputStream input = null;
        try {
            FileInputStream dest = new FileInputStream(new File(this.tempWorkbookPath));
            Workbook destWorkbook = WorkbookFactory.create((InputStream)dest);
            Sheet destSheet = destWorkbook.getSheetAt(sheetIndex);
            input = new FileInputStream(new File(this.inputFilePath));
            Workbook inputWorkbook = WorkbookFactory.create((InputStream)input);
            Sheet inputSheet = inputWorkbook.getSheetAt(sheetIndex);
            this.copyMatchingRows(columnIndex, destWorkbook, destSheet, inputSheet);
            destWorkbook.setActiveSheet(sheetIndex);
            this.setActiveCell(destSheet);
            fileOut = new FileOutputStream(this.outputFilePath);
            destWorkbook.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (Throwable throwable) {
            this.closeResources(fileOut, input);
            throw throwable;
        }
        this.closeResources(fileOut, input);
    }

    private void copyMatchingRows(int columnIndex, Workbook destWorkbook, Sheet destSheet, Sheet inputSheet) {
        int burstColumnIndex = -1;
        int destRowNum = 0;
        for (Row inputRow : inputSheet) {
            if (burstColumnIndex == -1) {
                burstColumnIndex = this.getBurstColumnIndex(columnIndex, inputRow);
            }
            Cell burstCell = null;
            if (inputRow != null) {
                burstCell = inputRow.getCell(burstColumnIndex);
            }
            String cellValue = "";
            if (burstCell != null) {
                cellValue = ExcelUtils.getCellValueAsString(burstCell);
            }
            if (StringUtils.isEmpty((CharSequence)cellValue)) {
                cellValue = "keep-row";
            }
            if (!(cellValue = cellValue.trim()).equals("keep-row") && !cellValue.equals(this.token)) continue;
            this.copyRow(destWorkbook, inputSheet, destSheet, inputRow, destRowNum);
            ++destRowNum;
        }
    }

    private void closeResources(FileOutputStream fileOut, InputStream input) throws IOException {
        if (fileOut != null) {
            fileOut.close();
        }
        if (input != null) {
            input.close();
        }
    }

    private void setActiveCell(Sheet destSheet) {
        Cell activeCell;
        Row activeRow = destSheet.getRow(0);
        if (activeRow != null && (activeCell = activeRow.getCell(0)) != null) {
            activeCell.setAsActiveCell();
        }
    }

    private int getBurstColumnIndex(int columnIndex, Row inputRow) {
        int lastCellIndex = 0;
        if (inputRow != null) {
            lastCellIndex = inputRow.getLastCellNum() - 1;
        }
        int burstColumnIndex = columnIndex > lastCellIndex ? lastCellIndex : columnIndex;
        return burstColumnIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExtractSheet() throws Exception {
        this.log.debug("doExtractSheet()");
        FileInputStream input = null;
        FileOutputStream fileOut = null;
        try {
            input = new FileInputStream(new File(this.inputFilePath));
            Workbook Workbook2 = WorkbookFactory.create((InputStream)input);
            int sheetIndex = 0;
            int sheetCount = Workbook2.getNumberOfSheets();
            while (sheetIndex < sheetCount && sheetCount > 1) {
                String currentSheetName = Workbook2.getSheetName(sheetIndex);
                if (!this.token.equals(currentSheetName)) {
                    Workbook2.removeSheetAt(sheetIndex);
                    sheetIndex = 0;
                    sheetCount = Workbook2.getNumberOfSheets();
                    continue;
                }
                ++sheetIndex;
            }
            Workbook2.setActiveSheet(0);
            fileOut = new FileOutputStream(this.outputFilePath);
            Workbook2.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (Throwable throwable) {
            this.closeResources(fileOut, input);
            throw throwable;
        }
        this.closeResources(fileOut, input);
    }

    public void setTempWorkbookPath(String tempWorkbookPath) {
        this.tempWorkbookPath = tempWorkbookPath;
    }

    private void copyRow(Workbook destWorkbook, Sheet sourceWorkSheet, Sheet destWorkSheet, Row sourceRow, int destinationRowNum) {
        this.cacheStyles(destWorkbook);
        Row newRow = destWorkSheet.createRow(destinationRowNum);
        for (int i = 0; i < sourceRow.getLastCellNum(); ++i) {
            Cell oldCell = sourceRow.getCell(i);
            if (oldCell == null) continue;
            Cell newCell = newRow.createCell(i);
            this.copyCellStyle(destWorkbook, oldCell, newCell);
            this.copyCellCommentAndLink(oldCell, newCell);
            this.copyCellContent(oldCell, newCell);
        }
        this.copyMergedRegions(sourceWorkSheet, destWorkSheet, sourceRow, newRow);
    }

    private void copyMergedRegions(Sheet sourceWorkSheet, Sheet destWorkSheet, Row sourceRow, Row newRow) {
        for (int i = 0; i < sourceWorkSheet.getNumMergedRegions(); ++i) {
            this.log.debug("New merged region found in the sourceWorkSheet - i = " + i);
            CellRangeAddress cellRangeAddress = sourceWorkSheet.getMergedRegion(i);
            if (cellRangeAddress.getFirstRow() != sourceRow.getRowNum()) continue;
            this.log.debug("New merged region matched for sourceRow.getRowNum() = " + sourceRow.getRowNum());
            CellRangeAddress newCellRangeAddress = new CellRangeAddress(newRow.getRowNum(), newRow.getRowNum() + (cellRangeAddress.getFirstRow() - cellRangeAddress.getLastRow()), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn());
            destWorkSheet.addMergedRegion(newCellRangeAddress);
        }
    }

    private void copyCellCommentAndLink(Cell oldCell, Cell newCell) {
        if (newCell.getCellComment() != null) {
            newCell.setCellComment(oldCell.getCellComment());
        }
        if (oldCell.getHyperlink() != null) {
            newCell.setHyperlink(oldCell.getHyperlink());
        }
    }

    private void copyCellStyle(Workbook destWorkbook, Cell oldCell, Cell newCell) {
        CellStyle sourceCellStyle = oldCell.getCellStyle();
        if (this.destStyles.contains(sourceCellStyle)) {
            newCell.setCellStyle(this.destStyles.get(this.destStyles.indexOf(sourceCellStyle)));
        } else {
            CellStyle newCellStyle = destWorkbook.createCellStyle();
            newCellStyle.cloneStyleFrom(oldCell.getCellStyle());
            newCell.setCellStyle(newCellStyle);
            this.destStyles.add(newCellStyle);
        }
    }

    private void copyCellContent(Cell oldCell, Cell newCell) {
        CellType cellType = oldCell.getCellType();
        switch (cellType) {
            case BOOLEAN: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case NUMERIC: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case STRING: {
                newCell.setCellValue(oldCell.getRichStringCellValue());
                break;
            }
            default: {
                newCell.setCellValue(oldCell.getStringCellValue());
            }
        }
    }

    private void cacheStyles(Workbook destWorkbook) {
        if (this.destStyles.size() == 0) {
            int numberOfStyles = destWorkbook.getNumCellStyles();
            for (int i = 0; i < numberOfStyles; i = (int)((short)(i + 1))) {
                this.destStyles.add(destWorkbook.getCellStyleAt(i));
            }
        }
    }
}

