/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine;

import com.sourcekraft.documentburster.engine.AbstractBurster;
import com.sourcekraft.documentburster.engine.excel.PoiExcelBurster;
import com.sourcekraft.documentburster.engine.pdf.PdfBurster;
import com.sourcekraft.documentburster.engine.reporting.CsvReporter;
import com.sourcekraft.documentburster.engine.reporting.ExcelReporter;
import com.sourcekraft.documentburster.engine.reporting.FixedWidthReporter;
import com.sourcekraft.documentburster.engine.reporting.ScriptedReporter;
import com.sourcekraft.documentburster.engine.reporting.SqlReporter;
import com.sourcekraft.documentburster.engine.reporting.XmlReporter;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BursterFactory {
    private static Logger log = LoggerFactory.getLogger(BursterFactory.class);
    static String MODE_BURST = "burst";

    public static AbstractBurster create(String filePath, String configurationFilePath, String jobType) throws Exception {
        log.debug("BursterFactory.create: filePath = " + filePath + "configurationFilePath = " + configurationFilePath + ", jobType = " + jobType);
        String extension = FilenameUtils.getExtension((String)filePath);
        if (MODE_BURST.equals(jobType)) {
            AbstractBurster burster = null;
            burster = extension.equalsIgnoreCase("pdf") ? new PdfBurster(configurationFilePath) : new PoiExcelBurster(configurationFilePath);
            burster.setJobType(MODE_BURST);
            return burster;
        }
        AbstractBurster reporter = null;
        switch (jobType) {
            case "ds.xmlfile": {
                reporter = new XmlReporter(configurationFilePath);
                break;
            }
            case "ds.csvfile": {
                reporter = new CsvReporter(configurationFilePath);
                break;
            }
            case "ds.tsvfile": {
                reporter = new CsvReporter(configurationFilePath);
                break;
            }
            case "ds.excelfile": {
                reporter = new ExcelReporter(configurationFilePath);
                break;
            }
            case "ds.sqlquery": {
                reporter = new SqlReporter(configurationFilePath);
                break;
            }
            case "ds.scriptfile": {
                reporter = new ScriptedReporter(configurationFilePath);
                break;
            }
            case "ds.gsheet": {
                break;
            }
            case "ds.o365sheet": {
                break;
            }
            case "ds.fixedwidthfile": {
                reporter = new FixedWidthReporter(configurationFilePath);
                break;
            }
        }
        reporter.setJobType(jobType);
        return reporter;
    }
}

