/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.engine;

import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.sourcekraft.documentburster.common.settings.model.FreeMarkerSettings;
import com.sourcekraft.documentburster.common.settings.model.Locale;
import com.sourcekraft.documentburster.common.settings.model.ReportSettings;
import com.sourcekraft.documentburster.context.BurstingContext;
import com.sourcekraft.documentburster.engine.AbstractBurster;
import com.sourcekraft.documentburster.utils.DocumentBursterFreemarkerInitializer;
import com.sourcekraft.documentburster.utils.Utils;
import com.sourcekraft.documentburster.variables.Variables;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.docx4j.Docx4J;
import org.docx4j.model.datastorage.migration.VariablePrepare;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.certait.htmlexporter.writer.excel.ExcelExporter;

public abstract class AbstractReporter
extends AbstractBurster {
    private static final Logger log = LoggerFactory.getLogger(AbstractReporter.class);
    private Map<String, String> reportParameters;
    private boolean isPreviewMode = false;

    public AbstractReporter(String configFilePath) {
        super(configFilePath);
    }

    public void setReportParameters(Map<String, String> reportParameters) {
        this.reportParameters = reportParameters;
    }

    @Override
    protected void processAttachments() throws Exception {
        String extractedFilePathVar = "${extracted_file_path}";
        try {
            Field field = Variables.class.getDeclaredField("EXTRACTED_FILE_PATH");
            field.setAccessible(true);
            extractedFilePathVar = (String)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.warn("Could not reflectively access Variables.EXTRACTED_FILE_PATH, using default placeholder.", (Throwable)e);
        }
        String finalExtractedFilePathVar = extractedFilePathVar;
        if (this.ctx.settings.getReportTemplate().outputtype.equals("output.none")) {
            this.ctx.settings.getAttachments().removeIf(attachment -> attachment.path.contains(finalExtractedFilePathVar));
        }
        super.processAttachments();
    }

    @Override
    protected void quarantineDocument() throws Exception {
        if (!this.ctx.settings.getReportTemplate().outputtype.equals("output.none")) {
            super.quarantineDocument();
        }
    }

    @Override
    protected void extractDocument() throws Exception {
        if (!this.ctx.settings.getReportTemplate().outputtype.equals("output.none")) {
            super.extractDocument();
        } else {
            super.createOutputFoldersIfTheyDontExist();
        }
    }

    @Override
    protected void initializeResources() throws Exception {
        this.ctx.burstTokens = new ArrayList();
        this.ctx.variables.setVarAliases(Arrays.asList("col"));
        String outputTypeExtVar = "output_type_extension";
        try {
            Field field = Variables.class.getDeclaredField("OUTPUT_TYPE_EXTENSION");
            field.setAccessible(true);
            outputTypeExtVar = (String)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.warn("Could not reflectively access Variables.OUTPUT_TYPE_EXTENSION, using default key name.", (Throwable)e);
        }
        this.ctx.variables.set(outputTypeExtVar, (Object)FilenameUtils.getExtension((String)this.ctx.settings.getReportTemplate().outputtype));
        if (this.reportParameters != null) {
            this.reportParameters.forEach((k, v) -> {
                System.out.println("[DEBUG] AbstractReporter.initializeResources - Setting ctx.variables " + k + " = " + v);
                this.ctx.variables.set(k, v);
            });
        }
        DocumentBursterFreemarkerInitializer.configureFreeMarker((Locale)this.ctx.settings.docSettings.settings.locale, (FreeMarkerSettings)this.ctx.settings.docSettings.settings.freemarker);
        if (this.isPreviewMode) {
            this._setPreviewMode();
        }
    }

    @Override
    protected void parseBurstingMetaData() throws Exception {
        if (this.ctx.reportData == null || this.ctx.reportData.isEmpty()) {
            this.ctx.burstTokens = new ArrayList();
            return;
        }
        String idColumnSetting = this.getIdColumnSetting();
        if (StringUtils.isEmpty((CharSequence)idColumnSetting)) {
            idColumnSetting = "notused";
        }
        log.debug("Resolved idColumn setting: {}", (Object)idColumnSetting);
        this.ctx.burstTokens = new ArrayList();
        int index = 0;
        String lowerIdColumnSetting = idColumnSetting.toLowerCase();
        for (Map row : this.ctx.reportData) {
            String token = null;
            switch (lowerIdColumnSetting) {
                case "notused": {
                    token = String.valueOf(index);
                    log.trace("Using index as token (idcolumn=notused): {}", (Object)token);
                    break;
                }
                case "firstcolumn": {
                    token = !row.isEmpty() ? Objects.toString(row.values().iterator().next(), String.valueOf(index + 1)) : String.valueOf(index + 1);
                    log.trace("Using first column value as token: {}", (Object)token);
                    break;
                }
                case "lastcolumn": {
                    Object lastValue = null;
                    if (!row.isEmpty()) {
                        for (Object v : row.values()) {
                            lastValue = v;
                        }
                        token = Objects.toString(lastValue, String.valueOf(index + 1));
                    } else {
                        token = String.valueOf(index + 1);
                    }
                    log.trace("Using last column value as token: {}", (Object)token);
                    break;
                }
                default: {
                    if (StringUtils.isNumeric((CharSequence)idColumnSetting)) {
                        try {
                            ArrayList keys = new ArrayList(row.keySet());
                            int pos = Integer.parseInt(idColumnSetting);
                            if (pos >= 0 && pos < keys.size()) {
                                String key = (String)keys.get(pos);
                                token = Objects.toString(row.get(key), String.valueOf(index + 1));
                                log.trace("Using numeric index {} (key='{}') as token: {}", new Object[]{pos, key, token});
                                break;
                            }
                            log.warn("Numeric idcolumn index {} out of bounds for row with {} columns. Falling back to index.", (Object)pos, (Object)keys.size());
                            token = String.valueOf(index + 1);
                        }
                        catch (NumberFormatException e) {
                            log.error("Error parsing numeric idcolumn '{}'. Falling back to index.", (Object)idColumnSetting, (Object)e);
                            token = String.valueOf(index + 1);
                        }
                        break;
                    }
                    boolean found = false;
                    for (Map.Entry entry : row.entrySet()) {
                        String currentKey = (String)entry.getKey();
                        if (currentKey == null || !currentKey.toLowerCase().equals(lowerIdColumnSetting)) continue;
                        token = Objects.toString(entry.getValue(), String.valueOf(index + 1));
                        log.trace("Found token using case-insensitive idcolumn '{}' (original key '{}'): {}", new Object[]{idColumnSetting, currentKey, token});
                        found = true;
                        break;
                    }
                    if (found) break;
                    log.warn("idcolumn '{}' not found (case-insensitive) in row keys {}. Falling back to index.", (Object)idColumnSetting, row.keySet());
                    token = String.valueOf(index + 1);
                }
            }
            if (token == null) {
                log.error("Token became null unexpectedly for row index {}. Using index as fallback.", (Object)index);
                token = String.valueOf(index + 1);
            }
            try {
                this.ctx.variables.parseUserVariablesFromMap(token, row);
                this.ctx.variables.setUserVariable(token, "burst_token", (Object)token);
                this.ctx.variables.setUserVariable(token, "row_index", (Object)String.valueOf(index));
                this.ctx.variables.setUserVariable(token, "row_number", (Object)String.valueOf(index + 1));
                log.trace("Populated variables for token '{}' using parseUserVariablesFromMap.", (Object)token);
            }
            catch (Exception e) {
                log.error("Error calling parseUserVariablesFromMap for token '{}'. Variables might be incomplete.", (Object)token, (Object)e);
            }
            this.ctx.burstTokens.add(token);
            ++index;
        }
        log.debug("Generated {} burst tokens.", (Object)this.ctx.burstTokens.size());
    }

    private String getIdColumnSetting() {
        String typeString = this.ctx.settings.reportingSettings.report.datasource.type;
        log.debug("Determined active data source type string: {}", (Object)typeString);
        ReportSettings.DataSource dataSource = this.ctx.settings.getReportDataSource();
        if (typeString.equalsIgnoreCase("ds.sqlquery")) {
            return dataSource.sqloptions.idcolumn;
        }
        if (typeString.equalsIgnoreCase("ds.csvfile") || typeString.equalsIgnoreCase("ds.tsvfile")) {
            return dataSource.csvoptions.idcolumn;
        }
        if (typeString.equalsIgnoreCase("ds.fixedwidthfile")) {
            return dataSource.fixedwidthoptions.idcolumn;
        }
        if (typeString.equalsIgnoreCase("ds.xmlfile")) {
            return dataSource.xmloptions.idcolumn;
        }
        if (typeString.equalsIgnoreCase("ds.excelfile")) {
            return dataSource.exceloptions.idcolumn;
        }
        if (typeString.equalsIgnoreCase("ds.scriptfile")) {
            return dataSource.scriptoptions.idcolumn;
        }
        if (typeString.equalsIgnoreCase("ds.gsheet") || typeString.equalsIgnoreCase("ds.o365sheet")) {
            log.warn("idcolumn setting not currently implemented/checked for type: {}", (Object)typeString);
            return null;
        }
        log.warn("Unknown data source type string '{}'. Cannot determine idcolumn.", (Object)typeString);
        return null;
    }

    @Override
    protected void extractOutputBurstDocument() throws Exception {
        String templateFilePath = this.ctx.settings.getReportTemplate().retrieveTemplateFilePath();
        if (this.ctx.settings.getReportTemplate().outputtype.equals("output.docx")) {
            this.generateDocxFromDocxTemplateUsingXDocReport(this.ctx.extractedFilePath, templateFilePath, this.ctx.variables.getUserVariables(this.ctx.token));
        } else if (this.ctx.settings.getReportTemplate().outputtype.equals("output.html")) {
            this.generateFileFromFreemarkerTemplate(this.ctx.extractedFilePath, templateFilePath, this.ctx.variables.getUserVariables(this.ctx.token), "Built by");
        } else if (this.ctx.settings.getReportTemplate().outputtype.equals("output.any")) {
            this.generateFileFromFreemarkerTemplate(this.ctx.extractedFilePath, templateFilePath, this.ctx.variables.getUserVariables(this.ctx.token), "none");
        } else if (this.ctx.settings.getReportTemplate().outputtype.equals("output.pdf")) {
            this.generatePDFFromHtmlTemplateUsingFlywingSaucer(this.ctx.extractedFilePath, templateFilePath, this.ctx.variables.getUserVariables(this.ctx.token));
        } else if (this.ctx.settings.getReportTemplate().outputtype.equals("output.fop2pdf")) {
            String foContent = this.generateFileContentFromFreemarkerTemplate(templateFilePath, this.ctx.variables.getUserVariables(this.ctx.token));
            this.renderPdfFromFoContent(this.ctx.extractedFilePath, foContent);
        } else if (this.ctx.settings.getReportTemplate().outputtype.equals("output.xlsx")) {
            this.generateExcelFromHtmlTemplateUsingHtmlExporter(this.ctx.extractedFilePath, templateFilePath, this.ctx.variables.getUserVariables(this.ctx.token));
        }
    }

    protected void generateExcelFromHtmlTemplateUsingHtmlExporter(String documentPath, String templatePath, Map<String, Object> userVariables) throws Exception {
        String tempHtmlPath = documentPath.replace(".xlsx", ".html");
        this.generateFileFromFreemarkerTemplate(tempHtmlPath, templatePath, userVariables, "none");
        String html = Files.readString(Paths.get(tempHtmlPath, new String[0]));
        new ExcelExporter().exportHtml(html, new File(documentPath));
        Files.deleteIfExists(Paths.get(tempHtmlPath, new String[0]));
    }

    protected Object toObject(String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String trimmed = value.trim();
        if (trimmed.matches("-?\\d+")) {
            try {
                return Integer.parseInt(trimmed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (trimmed.matches("-?\\d+\\.\\d+")) {
            try {
                return Double.parseDouble(trimmed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    private void generateFileFromFreemarkerTemplate(String extractedFilePath, String templatePath, Map<String, Object> userVariables, String bType) throws Exception {
        String template = FileUtils.readFileToString((File)new File(templatePath), (String)"UTF-8");
        Template engine = new Template("template", template, DocumentBursterFreemarkerInitializer.FREE_MARKER_CFG);
        StringWriter stringWriter = new StringWriter();
        engine.process(userVariables, (Writer)stringWriter);
        stringWriter.flush();
        String htmlContent = stringWriter.toString();
        if (!bType.equals("none")) {
            try {
                htmlContent = Utils.ibContent((String)htmlContent, (String)bType);
            }
            catch (Exception e) {
                log.error("Error calling common.utils.Utils.ibContent", (Throwable)e);
            }
        }
        FileUtils.writeStringToFile((File)new File(extractedFilePath), (String)htmlContent, (String)"UTF-8");
    }

    private String generateFileContentFromFreemarkerTemplate(String templatePath, Map<String, Object> userVariables) throws Exception {
        String template = FileUtils.readFileToString((File)new File(templatePath), (String)"UTF-8");
        Template engine = new Template("template", template, DocumentBursterFreemarkerInitializer.FREE_MARKER_CFG);
        StringWriter stringWriter = new StringWriter();
        engine.process(userVariables, (Writer)stringWriter);
        stringWriter.flush();
        return stringWriter.toString();
    }

    private void generateDocxFromDocxTemplateUsingXDocReport(String documentPath, String templatePath, Map<String, Object> variablesData) throws Exception {
        InputStream is = Files.newInputStream(Paths.get(templatePath, new String[0]), new OpenOption[0]);
        IXDocReport report = XDocReportRegistry.getRegistry().loadReport(is, TemplateEngineKind.Freemarker);
        DocumentBursterFreemarkerInitializer.applySettingsTo((ITemplateEngine)report.getTemplateEngine());
        IContext context = report.createContext();
        context.putMap(variablesData);
        FileOutputStream out = new FileOutputStream(new File(documentPath));
        report.process(context, (OutputStream)out);
        ((OutputStream)out).close();
        is.close();
    }

    public void generateDocxFromDocxTemplateUsingDocx4j(String documentPath, String templatePath, Map<String, String> variablesData) throws Exception {
        File outputFile = new File(documentPath);
        outputFile.getParentFile().mkdirs();
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(templatePath));
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        VariablePrepare.prepare((WordprocessingMLPackage)wordMLPackage);
        documentPart.variableReplace(variablesData);
        wordMLPackage.save(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDocxToPDFUsingDocx4j(String docxFilePath, String pdfFilePath) throws Exception {
        FileInputStream templateInputStream = new FileInputStream(docxFilePath);
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((InputStream)templateInputStream);
        FileOutputStream os = new FileOutputStream(pdfFilePath);
        try {
            Docx4J.toPDF((WordprocessingMLPackage)wordMLPackage, (OutputStream)os);
        }
        finally {
            os.flush();
            os.close();
            ((InputStream)templateInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDocxToPDFUsingXDocReport(String docxFilePath, String pdfFilePath) throws Exception {
        FileInputStream in = new FileInputStream(new File(docxFilePath));
        XWPFDocument document = new XWPFDocument((InputStream)in);
        PdfOptions options = PdfOptions.create();
        FileOutputStream out = new FileOutputStream(new File(pdfFilePath));
        try {
            PdfConverter.getInstance().convert(document, (OutputStream)out, (Options)options);
        }
        finally {
            ((OutputStream)out).close();
            ((InputStream)in).close();
            document.close();
        }
    }

    private void renderPdfFromFoContent(String pdfPath, String foContent) throws Exception {
        URI baseUri = new File(".").toURI();
        FopFactory fopFactory = FopFactory.newInstance((URI)baseUri);
        try (FileOutputStream out = new FileOutputStream(pdfPath);
             ByteArrayInputStream in = new ByteArrayInputStream(foContent.getBytes(StandardCharsets.UTF_8));){
            Fop fop = fopFactory.newFop("application/pdf", (OutputStream)out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamSource src = new StreamSource(in);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePDFFromHtmlTemplateUsingFlywingSaucer(String documentPath, String templatePath, Map<String, Object> variablesData) throws Exception {
        String tempHtmlPath = documentPath.replace(".pdf", ".html");
        this.generateFileFromFreemarkerTemplate(tempHtmlPath, templatePath, variablesData, "Built by");
        String html = Files.readString(Paths.get(tempHtmlPath, new String[0]));
        File parentDir = new File(templatePath).getParentFile();
        String baseUri = parentDir.toURI().toString();
        try (FileOutputStream os = new FileOutputStream(documentPath);){
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withHtmlContent(html, baseUri);
            builder.toStream((OutputStream)os);
            builder.run();
        }
        finally {
            try {
                Files.deleteIfExists(Paths.get(tempHtmlPath, new String[0]));
            }
            catch (IOException e) {
                log.warn("Failed to delete temporary HTML file: {}", (Object)tempHtmlPath, (Object)e);
            }
        }
    }

    public void _setPreviewMode() {
        this.ctx.settings.setSendFilesEmail(false);
        this.ctx.settings.setSendFilesSms(false);
        this.ctx.settings.setSendFilesUpload(false);
        this.ctx.settings.setSendFilesWeb(false);
        this.ctx.settings.getReportTemplate().outputtype = "output.none";
    }

    public void setPreviewMode(boolean isPreviewMode) {
        this.isPreviewMode = isPreviewMode;
    }

    @Override
    protected void checkLicense() throws Exception {
        if (!this.isPreviewMode) {
            super.checkLicense();
        }
    }

    @Override
    protected void executeBurstingLifeCycleScript(String scriptFileName, BurstingContext context) throws Exception {
        if (!this.isPreviewMode) {
            super.executeBurstingLifeCycleScript(scriptFileName, context);
        } else {
            if (scriptFileName.equals("controller.groovy")) {
                this.ctx.settings.loadSettings();
                this.ctx.variables = new Variables(this.fileName, this.ctx.settings.getLanguage(), this.ctx.settings.getCountry(), this.ctx.settings.getNumberOfUserVariables());
            }
            if (scriptFileName.endsWith("-additional-transformation.groovy") || scriptFileName.endsWith("-script.groovy")) {
                super.executeBurstingLifeCycleScript(scriptFileName, context);
            }
        }
    }

    @Override
    protected void writeStatsFile() throws Exception {
        if (!this.isPreviewMode) {
            super.writeStatsFile();
        }
    }

    protected String getReportFolderName() {
        File configFile = new File(this.configurationFilePath);
        File configFolder = configFile.getParentFile();
        return configFolder.getName();
    }

    @Override
    protected void setUpScriptingRoots() {
        String[] defaultRoots = new String[]{"scripts/burst", "scripts/burst/internal"};
        File configFile = new File(this.configurationFilePath);
        File configFolder = configFile.getParentFile();
        String configFolderPath = configFolder.getAbsolutePath();
        String[] roots = new String[]{configFolderPath, defaultRoots[0], defaultRoots[1]};
        this.scripting.setRoots(roots);
        String additionalScriptName = this.getReportFolderName() + "-additional-transformation.groovy";
        File additionalScriptFile = new File(configFolder, additionalScriptName);
        if (additionalScriptFile.exists() && additionalScriptFile.length() > 0L) {
            this.ctx.scripts.transformFetchedData = additionalScriptName;
            log.info("Configured ctx.scripts.transformFetchedData to be: {}", (Object)additionalScriptName);
        }
    }
}

