/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster;

import com.sourcekraft.documentburster.GlobalContext;
import com.sourcekraft.documentburster.MainProgram;
import com.sourcekraft.documentburster.utils.Utils;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class DocumentBurster {
    private static Logger log = LoggerFactory.getLogger(DocumentBurster.class);

    public static void main(String[] args) throws Throwable {
        int exitCode = 0;
        args = (String[])Arrays.stream(args).filter(arg -> arg != null && !arg.trim().isEmpty() && !arg.startsWith("${arg")).toArray(String[]::new);
        log.info("***********************Program Started with Arguments : " + Arrays.toString(args) + "***********************");
        GlobalContext global = new GlobalContext();
        try {
            MainProgram program = new MainProgram();
            program.setGlobal(global);
            CommandLine commandLine = new CommandLine((Object)program);
            commandLine.setParameterExceptionHandler((ex, args1) -> {
                String errorMsg = "Command parameter validation error: " + ex.getMessage();
                log.error(errorMsg, (Throwable)ex);
                ex.getCommandLine().usage(System.err);
                return 2;
            });
            commandLine.setExecutionExceptionHandler((ex, cmd, parseResult) -> {
                String errorMsg = ex.getMessage();
                log.error(errorMsg, (Throwable)ex);
                return 1;
            });
            exitCode = commandLine.execute(args);
            if (exitCode != 0) {
                String errorMsg = "Command execution failed with exit code: " + exitCode;
                log.error(errorMsg);
            }
        }
        catch (Throwable e) {
            exitCode = -1;
            log.error("Exception: ", e);
            throw e;
        }
        finally {
            log.info("***************************Execution Ended***************************");
            if (StringUtils.isNotEmpty((CharSequence)global.logsArchivesFolder)) {
                Utils.archiveLogFiles((String)global.logsArchivesFolder);
            }
            System.exit(exitCode);
        }
    }
}

