/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.variables;

import com.sourcekraft.documentburster.utils.Utils;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variables {
    private static final Logger log = LoggerFactory.getLogger(Variables.class);
    private static final String SKIP_END_SHORT = "</s>";
    private static final String SKIP_START_SHORT = "<s>";
    private static final String SKIP_END_LONG = "</skip>";
    private static final String SKIP_START_LONG = "<skip>";
    public static final String INPUT_DOCUMENT_NAME = "input_document_name";
    public static final String INPUT_DOCUMENT_EXTENSION = "input_document_extension";
    public static final String OUTPUT_TYPE_EXTENSION = "output_type_extension";
    public static final String BURST_TOKEN = "burst_token";
    public static final String BURST_INDEX = "burst_index";
    public static final String OUTPUT_FOLDER = "output_folder";
    public static final String EXTRACTED_FILE_PATH = "extracted_file_path";
    public static final String EXTRACTED_FILE_PATHS_AFTER_SPLITTING_2ND_TIME = "extracted_file_paths_after_splitting_2nd_time";
    public static final String QUARANTINE_FOLDER = "quarantine_folder";
    public static final String STATS_INFO_TEMPLATE = "${num_pages}pages-${num_files_extracted}extracted-${num_files_distributed}distributed";
    public static final String STATS_INFO = "stats_info";
    public static final String NUM_PAGES = "num_pages";
    public static final String NUM_TOKENS = "num_tokens";
    public static final String NUM_FILES_EXTRACTED = "num_files_extracted";
    public static final String NUM_MESSAGES_SENT = "num_messages_sent";
    public static final String NUM_FILES_DISTRIBUTED = "num_files_distributed";
    public static final String NUM_FILES_SKIPPED_DISTRIBUTION = "num_files_skipped_distribution";
    public static final String NUM_FILES_QUARANTINED = "num_files_quarantined";
    public static final String NOW = "now";
    public static final String NOW_DEFAULT_DATE = "now_default_date";
    public static final String NOW_SHORT_DATE = "now_short_date";
    public static final String NOW_MEDIUM_DATE = "now_medium_date";
    public static final String NOW_LONG_DATE = "now_long_date";
    public static final String NOW_FULL_DATE = "now_full_date";
    public static final String NOW_DEFAULT_TIME = "now_default_time";
    public static final String NOW_SHORT_TIME = "now_short_time";
    public static final String NOW_MEDIUM_TIME = "now_medium_time";
    public static final String NOW_LONG_TIME = "now_long_time";
    public static final String NOW_FULL_TIME = "now_full_time";
    public static final String NOW_QUARTER = "now_quarter";
    public static final String SKIP = "skip";
    private List<String> varAliases;
    private Map<String, Object> vars = Collections.synchronizedMap(new HashMap());
    private int numberOfUserVariables;

    public Variables(String documentName, String language, String country, int numberOfUserVariables) {
        this.vars.put(INPUT_DOCUMENT_NAME, documentName);
        this.vars.put(INPUT_DOCUMENT_EXTENSION, FilenameUtils.getExtension((String)documentName));
        this.vars.put(OUTPUT_TYPE_EXTENSION, FilenameUtils.getExtension((String)documentName));
        this.addDateSystemVariables(language, country);
        this.numberOfUserVariables = numberOfUserVariables;
    }

    private void addDateSystemVariables(String language, String country) {
        Locale locale = null;
        Date now = new Date();
        this.vars.put(NOW, now);
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            locale = new Locale(language, country);
            this.vars.put(NOW_DEFAULT_DATE, DateFormat.getDateInstance(2, locale).format(now));
            this.vars.put(NOW_SHORT_DATE, DateFormat.getDateInstance(3, locale).format(now));
            this.vars.put(NOW_MEDIUM_DATE, DateFormat.getDateInstance(2, locale).format(now));
            this.vars.put(NOW_LONG_DATE, DateFormat.getDateInstance(1, locale).format(now));
            this.vars.put(NOW_FULL_DATE, DateFormat.getDateInstance(0, locale).format(now));
            this.vars.put(NOW_DEFAULT_TIME, DateFormat.getTimeInstance(2, locale).format(now));
            this.vars.put(NOW_SHORT_TIME, DateFormat.getTimeInstance(3, locale).format(now));
            this.vars.put(NOW_MEDIUM_TIME, DateFormat.getTimeInstance(2, locale).format(now));
            this.vars.put(NOW_LONG_TIME, DateFormat.getTimeInstance(1, locale).format(now));
            this.vars.put(NOW_FULL_TIME, DateFormat.getTimeInstance(0, locale).format(now));
        } else {
            this.vars.put(NOW_DEFAULT_DATE, DateFormat.getDateInstance(2).format(now));
            this.vars.put(NOW_SHORT_DATE, DateFormat.getDateInstance(3).format(now));
            this.vars.put(NOW_MEDIUM_DATE, DateFormat.getDateInstance(2).format(now));
            this.vars.put(NOW_LONG_DATE, DateFormat.getDateInstance(1).format(now));
            this.vars.put(NOW_FULL_DATE, DateFormat.getDateInstance(0).format(now));
            this.vars.put(NOW_DEFAULT_TIME, DateFormat.getTimeInstance(2).format(now));
            this.vars.put(NOW_SHORT_TIME, DateFormat.getTimeInstance(3).format(now));
            this.vars.put(NOW_MEDIUM_TIME, DateFormat.getTimeInstance(2).format(now));
            this.vars.put(NOW_LONG_TIME, DateFormat.getTimeInstance(1).format(now));
            this.vars.put(NOW_FULL_TIME, DateFormat.getTimeInstance(0).format(now));
        }
        this.vars.put(NOW_QUARTER, Integer.toString(Utils.getQuarter(now, locale)));
    }

    public void setVarAliases(List<String> varAliases) {
        this.varAliases = varAliases;
    }

    public void setNumberOfUserVariables(int numberOfUserVariables) {
        this.numberOfUserVariables = numberOfUserVariables;
    }

    public void parseUserVariables(String token, String text) {
        for (int i = 0; i < this.numberOfUserVariables; ++i) {
            String end;
            String start = "<" + i + ">";
            String value = StringUtils.substringBetween((String)text, (String)start, (String)(end = "</" + i + ">"));
            if (value == null) continue;
            this.setUserVariable(token, "var" + i, value);
        }
        this.parseSkipVariable(token, text);
    }

    public void parseUserVariablesFromMap(String token, Map<String, Object> dataRow) {
        int index = 0;
        if (dataRow != null) {
            for (Map.Entry<String, Object> entry : dataRow.entrySet()) {
                String columnName = entry.getKey();
                Object value = entry.getValue();
                this.setUserVariable(token, "var" + index, value);
                if (!this.isIndexedVariableOrAlias(columnName, index)) {
                    this.vars.put(token + "." + columnName, value);
                }
                ++index;
            }
        }
    }

    private boolean isIndexedVariableOrAlias(String key, int index) {
        if (key.equals("var" + index)) {
            return true;
        }
        if (this.varAliases != null) {
            for (String alias : this.varAliases) {
                if (!key.equals(alias + index)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getUserVariables(String token) {
        TreeMap<String, Object> userVars = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        userVars.putAll(this._getBuildInVariables());
        String prefix = token + ".";
        Set tokenVarKeys = this.vars.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toSet());
        for (String fullKey : tokenVarKeys) {
            String key = fullKey.substring(prefix.length());
            Object value = this.vars.get(fullKey);
            userVars.put(key, value);
        }
        if (!userVars.containsKey(SKIP)) {
            userVars.put(SKIP, "false");
        }
        for (int i = 0; i < this.numberOfUserVariables; ++i) {
            String varKey = "var" + i;
            if (!userVars.containsKey(varKey)) {
                userVars.put(varKey, "");
            }
            if (this.varAliases == null) continue;
            for (String alias : this.varAliases) {
                String aliasKey = alias + i;
                if (userVars.containsKey(aliasKey)) continue;
                userVars.put(aliasKey, "");
            }
        }
        for (String fullKey : this.vars.keySet()) {
            if (fullKey.contains(".") || userVars.containsKey(fullKey)) continue;
            userVars.put(fullKey, this.vars.get(fullKey));
        }
        log.debug("Variables map for token '{}' before returning: {}", (Object)token, userVars);
        return userVars;
    }

    private Map<String, Object> _getBuildInVariables() {
        HashMap<String, Object> builtInVars = new HashMap<String, Object>();
        builtInVars.put(INPUT_DOCUMENT_NAME, this.vars.get(INPUT_DOCUMENT_NAME));
        builtInVars.put(INPUT_DOCUMENT_EXTENSION, this.vars.get(INPUT_DOCUMENT_EXTENSION));
        builtInVars.put(OUTPUT_TYPE_EXTENSION, this.vars.get(OUTPUT_TYPE_EXTENSION));
        builtInVars.put(BURST_TOKEN, this.vars.get(BURST_TOKEN));
        builtInVars.put(BURST_INDEX, this.vars.get(BURST_INDEX));
        builtInVars.put(OUTPUT_FOLDER, this.vars.get(OUTPUT_FOLDER));
        builtInVars.put(EXTRACTED_FILE_PATH, this.vars.get(EXTRACTED_FILE_PATH));
        builtInVars.put(EXTRACTED_FILE_PATHS_AFTER_SPLITTING_2ND_TIME, this.vars.get(EXTRACTED_FILE_PATHS_AFTER_SPLITTING_2ND_TIME));
        builtInVars.put(QUARANTINE_FOLDER, this.vars.get(QUARANTINE_FOLDER));
        builtInVars.put(STATS_INFO, this.vars.get(STATS_INFO));
        builtInVars.put(NUM_PAGES, this.vars.get(NUM_PAGES));
        builtInVars.put(NUM_TOKENS, this.vars.get(NUM_TOKENS));
        builtInVars.put(NUM_FILES_EXTRACTED, this.vars.get(NUM_FILES_EXTRACTED));
        builtInVars.put(NUM_MESSAGES_SENT, this.vars.get(NUM_MESSAGES_SENT));
        builtInVars.put(NUM_FILES_DISTRIBUTED, this.vars.get(NUM_FILES_DISTRIBUTED));
        builtInVars.put(NUM_FILES_SKIPPED_DISTRIBUTION, this.vars.get(NUM_FILES_SKIPPED_DISTRIBUTION));
        builtInVars.put(NUM_FILES_QUARANTINED, this.vars.get(NUM_FILES_QUARANTINED));
        builtInVars.put(NOW, this.vars.get(NOW));
        builtInVars.put(NOW_DEFAULT_DATE, this.vars.get(NOW_DEFAULT_DATE));
        builtInVars.put(NOW_SHORT_DATE, this.vars.get(NOW_SHORT_DATE));
        builtInVars.put(NOW_MEDIUM_DATE, this.vars.get(NOW_MEDIUM_DATE));
        builtInVars.put(NOW_LONG_DATE, this.vars.get(NOW_LONG_DATE));
        builtInVars.put(NOW_FULL_DATE, this.vars.get(NOW_FULL_DATE));
        builtInVars.put(NOW_DEFAULT_TIME, this.vars.get(NOW_DEFAULT_TIME));
        builtInVars.put(NOW_SHORT_TIME, this.vars.get(NOW_SHORT_TIME));
        builtInVars.put(NOW_MEDIUM_TIME, this.vars.get(NOW_MEDIUM_TIME));
        builtInVars.put(NOW_LONG_TIME, this.vars.get(NOW_LONG_TIME));
        builtInVars.put(NOW_FULL_TIME, this.vars.get(NOW_FULL_TIME));
        builtInVars.put(NOW_QUARTER, this.vars.get(NOW_QUARTER));
        return builtInVars;
    }

    public Object set(String key, Object value) {
        return this.vars.put(key, value);
    }

    public Object get(String key) {
        return this.vars.get(key);
    }

    public Object setUserVariable(String token, String key, Object value) {
        Object previousValue;
        block11: {
            block12: {
                previousValue = this.vars.put(token + "." + key, value);
                if (Objects.isNull(this.varAliases)) break block12;
                if (key.startsWith("var") && key.length() > 3) {
                    try {
                        int index = Integer.parseInt(key.substring(3));
                        for (String alias : this.varAliases) {
                            String aliasKey = alias + index;
                            this.vars.put(token + "." + aliasKey, value);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    for (String alias : this.varAliases) {
                        if (!key.startsWith(alias) || key.length() <= alias.length()) continue;
                        try {
                            int index = Integer.parseInt(key.substring(alias.length()));
                            String varKey = "var" + index;
                            this.vars.put(token + "." + varKey, value);
                            for (String otherAlias : this.varAliases) {
                                if (otherAlias.equals(alias)) continue;
                                String otherAliasKey = otherAlias + index;
                                this.vars.put(token + "." + otherAliasKey, value);
                            }
                            break block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                }
                break block11;
            }
            if (!key.startsWith("var") || key.length() <= 3) break block11;
            try {
                Integer.parseInt(key.substring(3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return previousValue;
    }

    public String toString() {
        return this.vars.toString();
    }

    private void parseSkipVariable(String token, String text) {
        String skip = StringUtils.substringBetween((String)text, (String)SKIP_START_SHORT, (String)SKIP_END_SHORT);
        if (StringUtils.isEmpty((CharSequence)skip)) {
            skip = StringUtils.substringBetween((String)text, (String)SKIP_START_LONG, (String)SKIP_END_LONG);
        }
        if (StringUtils.isNotEmpty((CharSequence)skip)) {
            String key = token + "." + SKIP;
            this.vars.put(key, skip);
        }
    }
}

