/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.tabulator;

import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class TabulatorOptionsScript
extends Script {
    private final Map<String, Object> layoutOptions = new LinkedHashMap<String, Object>();
    private final List<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
    private final List<Map<String, Object>> dataRows = new ArrayList<Map<String, Object>>();
    private Map<String, Object> currentColumn = null;

    public void tabulator(Closure<?> body) {
        body.setDelegate((Object)this);
        body.setResolveStrategy(1);
        body.call();
    }

    public void layoutOptions(Map<String, Object> args) {
        if (args != null) {
            this.layoutOptions.putAll(args);
        }
    }

    public void layoutOptions(Closure<?> body) {
        body.setDelegate((Object)this);
        body.setResolveStrategy(1);
        body.call();
    }

    public void layout(String v) {
        this.layoutOptions.put("layout", v);
    }

    public void height(Object v) {
        this.layoutOptions.put("height", v);
    }

    public void autoColumns(Object v) {
        this.layoutOptions.put("autoColumns", v);
    }

    public void renderVertical(String v) {
        this.layoutOptions.put("renderVertical", v);
    }

    public void renderHorizontal(String v) {
        this.layoutOptions.put("renderHorizontal", v);
    }

    public void layoutColumnsOnNewData(Object v) {
        this.layoutOptions.put("layoutColumnsOnNewData", v);
    }

    public void width(Object v) {
        this.layoutOptions.put("width", v);
    }

    public void columns(Closure<?> body) {
        body.setDelegate((Object)this);
        body.setResolveStrategy(1);
        body.call();
    }

    public void column(Map<String, Object> args) {
        this.column(args, null);
    }

    public void column(Closure<?> body) {
        this.column(new LinkedHashMap<String, Object>(), body);
    }

    public void column(Map<String, Object> args, Closure<?> body) {
        LinkedHashMap<String, Object> c = new LinkedHashMap<String, Object>(args);
        this.columns.add(c);
        if (body != null) {
            ColumnDelegate d = new ColumnDelegate(c);
            body.setDelegate((Object)d);
            body.setResolveStrategy(1);
            body.call();
        }
    }

    public void data(List<Map<String, Object>> rows) {
        if (rows != null) {
            for (Map<String, Object> r : rows) {
                this.dataRows.add(new LinkedHashMap<String, Object>(r));
            }
        }
    }

    public Map<String, Object> getOptions() {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        if (!this.layoutOptions.isEmpty()) {
            out.put("layoutOptions", new LinkedHashMap<String, Object>(this.layoutOptions));
        }
        if (!this.columns.isEmpty()) {
            out.put("columns", new ArrayList<Map<String, Object>>(this.columns));
        }
        if (!this.dataRows.isEmpty()) {
            out.put("data", new ArrayList<Map<String, Object>>(this.dataRows));
        }
        return out;
    }

    public Object run() {
        return null;
    }

    private static class ColumnDelegate {
        private final Map<String, Object> map;

        ColumnDelegate(Map<String, Object> map) {
            this.map = map;
        }

        public void title(String t) {
            this.map.put("title", t);
        }

        public void field(String f) {
            this.map.put("field", f);
        }

        public void hozAlign(String a) {
            this.map.put("hozAlign", a);
        }

        public void vertAlign(String a) {
            this.map.put("vertAlign", a);
        }

        public void headerHozAlign(String a) {
            this.map.put("headerHozAlign", a);
        }

        public void width(Object w) {
            this.map.put("width", w);
        }

        public void minWidth(Object w) {
            this.map.put("minWidth", w);
        }

        public void maxWidth(Object w) {
            this.map.put("maxWidth", w);
        }

        public void widthGrow(Object w) {
            this.map.put("widthGrow", w);
        }

        public void widthShrink(Object w) {
            this.map.put("widthShrink", w);
        }

        public void visible(Object v) {
            this.map.put("visible", v);
        }

        public void frozen(Object f) {
            this.map.put("frozen", f);
        }

        public void responsive(Object r) {
            this.map.put("responsive", r);
        }

        public void resizable(Object r) {
            this.map.put("resizable", r);
        }

        public void sorter(Object s) {
            this.map.put("sorter", s);
        }

        public void sorterParams(Object p) {
            this.map.put("sorterParams", p);
        }

        public void headerSort(Object h) {
            this.map.put("headerSort", h);
        }

        public void headerFilter(Object f) {
            this.map.put("headerFilter", f);
        }

        public void headerFilterParams(Object p) {
            this.map.put("headerFilterParams", p);
        }

        public void headerFilterPlaceholder(String p) {
            this.map.put("headerFilterPlaceholder", p);
        }

        public void formatter(Object f) {
            this.map.put("formatter", f);
        }

        public void formatterParams(Object p) {
            this.map.put("formatterParams", p);
        }

        public void cssClass(String c) {
            this.map.put("cssClass", c);
        }

        public void tooltip(Object t) {
            this.map.put("tooltip", t);
        }

        public void editor(Object e) {
            this.map.put("editor", e);
        }

        public void editorParams(Object p) {
            this.map.put("editorParams", p);
        }

        public void editable(Object e) {
            this.map.put("editable", e);
        }

        public void validator(Object v) {
            this.map.put("validator", v);
        }

        public void headerTooltip(Object t) {
            this.map.put("headerTooltip", t);
        }

        public void headerVertical(Object v) {
            this.map.put("headerVertical", v);
        }

        public void methodMissing(String name, Object args) {
            if (args instanceof Object[] && ((Object[])args).length > 0) {
                this.map.put(name, ((Object[])args)[0]);
            } else {
                this.map.put(name, args);
            }
        }
    }
}

