/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.settings.model;

import com.sourcekraft.documentburster.utils.DumpToString;

public class ServerDatabaseSettings
extends DumpToString {
    private static final long serialVersionUID = 1L;
    public String type;
    public String host;
    public String port;
    public String database;
    public String userid;
    public String userpassword;
    public boolean usessl;
    public String defaultquery;
    public String driver;
    public String url;

    public void ensureDriverAndUrl() {
        String t;
        if (this.type == null) {
            return;
        }
        switch (t = this.type.toLowerCase()) {
            case "sqlite": {
                if (ServerDatabaseSettings.isBlank(this.driver)) {
                    this.driver = "org.sqlite.JDBC";
                }
                if (!ServerDatabaseSettings.isBlank(this.url)) break;
                this.url = "jdbc:sqlite:" + this.database;
                break;
            }
            case "mysql": {
                if (ServerDatabaseSettings.isBlank(this.driver)) {
                    this.driver = "com.mysql.cj.jdbc.Driver";
                }
                if (!ServerDatabaseSettings.isBlank(this.url)) break;
                String ssl = this.usessl ? "true" : "false";
                this.url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=" + ssl + "&allowPublicKeyRetrieval=true&serverTimezone=UTC";
                break;
            }
            case "mariadb": {
                if (ServerDatabaseSettings.isBlank(this.driver)) {
                    this.driver = "org.mariadb.jdbc.Driver";
                }
                if (!ServerDatabaseSettings.isBlank(this.url)) break;
                this.url = "jdbc:mariadb://" + this.host + ":" + this.port + "/" + this.database;
                break;
            }
            case "postgresql": 
            case "postgres": {
                if (ServerDatabaseSettings.isBlank(this.driver)) {
                    this.driver = "org.postgresql.Driver";
                }
                if (!ServerDatabaseSettings.isBlank(this.url)) break;
                this.url = "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.database;
                break;
            }
            case "sqlserver": {
                if (ServerDatabaseSettings.isBlank(this.driver)) {
                    this.driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                }
                if (!ServerDatabaseSettings.isBlank(this.url)) break;
                this.url = "jdbc:sqlserver://" + this.host + ":" + this.port + ";databaseName=" + this.database + ";encrypt=false";
                break;
            }
            case "oracle": {
                if (ServerDatabaseSettings.isBlank(this.driver)) {
                    this.driver = "oracle.jdbc.driver.OracleDriver";
                }
                if (!ServerDatabaseSettings.isBlank(this.url)) break;
                this.url = "jdbc:oracle:thin:@" + this.host + ":" + this.port + "/" + this.database;
                break;
            }
            case "ibmdb2": 
            case "db2": {
                if (ServerDatabaseSettings.isBlank(this.driver)) {
                    this.driver = "com.ibm.db2.jcc.DB2Driver";
                }
                if (!ServerDatabaseSettings.isBlank(this.url)) break;
                this.url = "jdbc:db2://" + this.host + ":" + this.port + "/" + this.database;
            }
        }
    }

    private static boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }
}

