/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.settings;

import com.sourcekraft.documentburster.common.settings.model.Archive;
import com.sourcekraft.documentburster.common.settings.model.Attachment;
import com.sourcekraft.documentburster.common.settings.model.Attachments;
import com.sourcekraft.documentburster.common.settings.model.BurstTokenDelimiters;
import com.sourcekraft.documentburster.common.settings.model.BursterSettings;
import com.sourcekraft.documentburster.common.settings.model.Capabilities;
import com.sourcekraft.documentburster.common.settings.model.ConnectionDatabaseSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterConnectionDatabaseSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterConnectionEmailSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterSettingsInternal;
import com.sourcekraft.documentburster.common.settings.model.EmailRfc2822Validator;
import com.sourcekraft.documentburster.common.settings.model.EmailSettings;
import com.sourcekraft.documentburster.common.settings.model.FreeMarkerSettings;
import com.sourcekraft.documentburster.common.settings.model.Items;
import com.sourcekraft.documentburster.common.settings.model.Locale;
import com.sourcekraft.documentburster.common.settings.model.QualityAssurance;
import com.sourcekraft.documentburster.common.settings.model.ReportSettings;
import com.sourcekraft.documentburster.common.settings.model.ReportingSettings;
import com.sourcekraft.documentburster.common.settings.model.RetryPolicy;
import com.sourcekraft.documentburster.common.settings.model.SendFiles;
import com.sourcekraft.documentburster.common.settings.model.ServerDatabaseSettings;
import com.sourcekraft.documentburster.common.settings.model.ServerEmailSettings;
import com.sourcekraft.documentburster.common.settings.model.SimpleJavaMail;
import com.sourcekraft.documentburster.common.settings.model.SmsSettings;
import com.sourcekraft.documentburster.common.settings.model.UploadSettings;
import com.sourcekraft.documentburster.common.settings.model.WebUploadSettings;
import com.sourcekraft.documentburster.utils.DumpToString;
import com.sourcekraft.documentburster.utils.Utils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings
extends DumpToString {
    public static String PORTABLE_EXECUTABLE_DIR_PATH = "";
    private static final long serialVersionUID = 6953576182023603829L;
    private Logger log = LoggerFactory.getLogger(Settings.class);
    private String configurationFilePath;
    public DocumentBursterSettings docSettings;
    public DocumentBursterSettingsInternal docSettingsInternal;
    public ReportingSettings reportingSettings;
    public DocumentBursterConnectionEmailSettings connectionEmailSettings;
    public DocumentBursterConnectionDatabaseSettings connectionDatabaseSettings;

    public Settings(String configFilePath) {
        Path initialPath = Paths.get(configFilePath, new String[0]).toAbsolutePath().normalize();
        this.configurationFilePath = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{configFilePath}) && Files.exists(initialPath, new LinkOption[0]) ? initialPath.toString() : Paths.get("./config/burst/settings.xml", new String[0]).toAbsolutePath().normalize().toString();
        Path path = Paths.get(this.configurationFilePath, new String[0]);
        Path parentPath = path.getParent();
        Path grandParentPath = parentPath.getParent().getParent();
        PORTABLE_EXECUTABLE_DIR_PATH = this.configurationFilePath.replace("\\", "/").endsWith("config/burst/settings.xml") || this.configurationFilePath.replace("\\", "/").endsWith("config/_internal/settings.xml") ? grandParentPath.toAbsolutePath().toString().replace("\\", "/") : grandParentPath.getParent().toAbsolutePath().toString().replace("\\", "/");
    }

    private void normalizeDocSettings() {
        if (this.docSettings == null || this.docSettings.settings == null) {
            return;
        }
        BursterSettings s = this.docSettings.settings;
        if (s.attachments == null) {
            s.attachments = new Attachments();
        }
        if (s.attachments.items == null) {
            s.attachments.items = new Items();
        }
        if (s.attachments.items.attachmentItems == null) {
            s.attachments.items.attachmentItems = new ArrayList<Attachment>();
        }
        if (s.attachments.archive == null) {
            s.attachments.archive = new Archive();
        }
        if (s.freemarker == null) {
            s.freemarker = new FreeMarkerSettings();
        }
        if (s.bursttokendelimiters == null) {
            s.bursttokendelimiters = new BurstTokenDelimiters();
        }
        if (s.retrypolicy == null) {
            s.retrypolicy = new RetryPolicy();
        }
        if (s.emailserver == null) {
            s.emailserver = new ServerEmailSettings();
        }
        if (s.simplejavamail == null) {
            s.simplejavamail = new SimpleJavaMail();
        }
        if (s.uploadsettings == null) {
            s.uploadsettings = new UploadSettings();
        }
        if (s.webuploadsettings == null) {
            s.webuploadsettings = new WebUploadSettings();
        }
        if (s.smssettings == null) {
            s.smssettings = new SmsSettings();
        }
        if (s.qualityassurance == null) {
            s.qualityassurance = new QualityAssurance();
        }
        if (s.qualityassurance.emailserver == null) {
            s.qualityassurance.emailserver = new ServerEmailSettings();
        }
        if (s.locale == null) {
            s.locale = new Locale();
        }
        if (s.deletefiles == null) {
            s.deletefiles = Boolean.FALSE;
        }
        if (s.quarantinefiles == null) {
            s.quarantinefiles = Boolean.FALSE;
        }
        if (s.sortbyposition == null) {
            s.sortbyposition = Boolean.FALSE;
        }
        if (s.shouldseparatebybeads == null) {
            s.shouldseparatebybeads = Boolean.FALSE;
        }
        if (s.suppressduplicateoverlappingtext == null) {
            s.suppressduplicateoverlappingtext = Boolean.FALSE;
        }
        if (s.htmlemail == null) {
            s.htmlemail = Boolean.FALSE;
        }
        if (s.htmlemaileditcode == null) {
            s.htmlemaileditcode = Boolean.FALSE;
        }
        if (s.reusetokenswhennotfound == null) {
            s.reusetokenswhennotfound = Boolean.FALSE;
        }
        if (s.failjobifanydistributionfails == null) {
            s.failjobifanydistributionfails = Boolean.FALSE;
        }
        if (s.enableretrypolicy == null) {
            s.enableretrypolicy = Boolean.FALSE;
        }
        if (s.split2ndtime == null) {
            s.split2ndtime = Boolean.FALSE;
        }
        if (s.dumprecorddataasxml == null) {
            s.dumprecorddataasxml = Boolean.FALSE;
        }
        if (s.enableincubatingfeatures == null) {
            s.enableincubatingfeatures = Boolean.FALSE;
        }
        if (s.averagechartolerancevalue == null) {
            s.averagechartolerancevalue = Float.valueOf(0.0f);
        }
        if (s.spacingtolerancevalue == null) {
            s.spacingtolerancevalue = Float.valueOf(0.0f);
        }
        if (s.numberofuservariables == null) {
            s.numberofuservariables = 0;
        }
        if (s.delayeachdistributionby == null) {
            s.delayeachdistributionby = 0.0;
        }
        SimpleJavaMail sjm = s.simplejavamail;
        if (sjm.active == null) {
            sjm.active = Boolean.FALSE;
        }
        if (sjm.javaxmaildebug == null) {
            sjm.javaxmaildebug = Boolean.FALSE;
        }
        if (sjm.transportmodeloggingonly == null) {
            sjm.transportmodeloggingonly = Boolean.FALSE;
        }
        if (sjm.async == null) {
            sjm.async = Boolean.FALSE;
        }
        if (sjm.poolsize == null) {
            sjm.poolsize = 0;
        }
        if (sjm.poolsizekeepalivetime == null) {
            sjm.poolsizekeepalivetime = 0;
        }
        if (sjm.sessiontimeoutmillis == null) {
            sjm.sessiontimeoutmillis = 0;
        }
        if (sjm.trustallhosts == null) {
            sjm.trustallhosts = Boolean.FALSE;
        }
        if (sjm.verifyserveridentity == null) {
            sjm.verifyserveridentity = Boolean.FALSE;
        }
        if (sjm.opportunistictls == null) {
            sjm.opportunistictls = Boolean.FALSE;
        }
        if (s.attachments != null && s.attachments.items != null && s.attachments.items.attachmentItems != null) {
            for (Attachment a : s.attachments.items.attachmentItems) {
                if (a.order != null) continue;
                a.order = 0;
            }
        }
    }

    public String getReportingPrimaryDatabaseConnectionCode() {
        if (Objects.isNull(this.reportingSettings)) {
            return "";
        }
        if (!Objects.isNull(this.reportingSettings.report.datasource.sqloptions)) {
            return this.reportingSettings.report.datasource.sqloptions.conncode;
        }
        return this.reportingSettings.report.datasource.scriptoptions.conncode;
    }

    public DocumentBursterSettings loadSettings() throws Exception {
        this.log.debug("loadSettings()");
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterSettings.class});
        Unmarshaller u = jc.createUnmarshaller();
        try (FileInputStream fis = new FileInputStream(new File(this.configurationFilePath));){
            this.docSettings = (DocumentBursterSettings)u.unmarshal((InputStream)fis);
            this.normalizeDocSettings();
        }
        this._sortAttachments();
        if (!Objects.isNull(this.docSettings.settings.capabilities) && this.docSettings.settings.capabilities.reportgenerationmailmerge) {
            this.loadSettingsReporting();
        }
        return this.docSettings;
    }

    public DocumentBursterSettingsInternal loadSettingsInternal() throws Exception {
        String internalConfigFilePath = Paths.get(PORTABLE_EXECUTABLE_DIR_PATH, "config/_internal/settings.xml").normalize().toString();
        JAXBContext jcr = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterSettingsInternal.class});
        Unmarshaller ur = jcr.createUnmarshaller();
        try (FileInputStream fis = new FileInputStream(new File(internalConfigFilePath));){
            this.docSettingsInternal = (DocumentBursterSettingsInternal)ur.unmarshal((InputStream)fis);
        }
        return this.docSettingsInternal;
    }

    public void loadSettingsReporting() throws Exception {
        String connCode;
        String configFolderPath = Paths.get(this.configurationFilePath, new String[0]).getParent().toString();
        String reportingConfigFilePath = configFolderPath + "/reporting.xml";
        JAXBContext jcr = JAXBContext.newInstance((Class[])new Class[]{ReportingSettings.class});
        Unmarshaller ur = jcr.createUnmarshaller();
        try (FileInputStream fis = new FileInputStream(new File(reportingConfigFilePath));){
            this.reportingSettings = (ReportingSettings)ur.unmarshal((InputStream)fis);
        }
        if (!Objects.isNull(this.reportingSettings.report.datasource.sqloptions) && !Objects.isNull(this.reportingSettings.report.datasource.sqloptions.conncode) && StringUtils.isNotBlank((CharSequence)(connCode = this.reportingSettings.report.datasource.sqloptions.conncode))) {
            String codeLower;
            configFolderPath = Paths.get(this.configurationFilePath, new String[0]).getParent().toString();
            configFolderPath = Paths.get(configFolderPath, new String[0]).getParent().toString();
            configFolderPath = Paths.get(configFolderPath, new String[0]).getParent().toString();
            String dbConfigFilePath = configFolderPath + "/connections/" + connCode + "/" + connCode + ".xml";
            String string = codeLower = connCode == null ? "" : connCode.trim().toLowerCase();
            if (codeLower.contains("rbt-sample-northwind-sqlite-4f2")) {
                String dbFilePath = null;
                String portable = System.getenv("PORTABLE_EXECUTABLE_DIR");
                if (portable != null && !portable.trim().isEmpty()) {
                    dbFilePath = portable + File.separator + "db" + File.separator + "sample-northwind-sqlite" + File.separator + "northwind.db";
                } else {
                    try {
                        dbFilePath = Utils.getDbFolderPath() + File.separator + "sample-northwind-sqlite" + File.separator + "northwind.db";
                    }
                    catch (Throwable t) {
                        dbFilePath = "db" + File.separator + "sample-northwind-sqlite" + File.separator + "northwind.db";
                    }
                }
                File dbFile = new File(dbFilePath);
                String resolvedPath = dbFile.getAbsolutePath();
                String jdbcUrl = "jdbc:sqlite:" + resolvedPath;
                this.connectionDatabaseSettings = new DocumentBursterConnectionDatabaseSettings();
                ConnectionDatabaseSettings conn = new ConnectionDatabaseSettings();
                ServerDatabaseSettings server = new ServerDatabaseSettings();
                server.type = "sqlite";
                server.driver = "org.sqlite.JDBC";
                server.url = jdbcUrl;
                server.userid = "";
                server.userpassword = "";
                conn.databaseserver = server;
                this.connectionDatabaseSettings.connection = conn;
            } else {
                jcr = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterConnectionDatabaseSettings.class});
                ur = jcr.createUnmarshaller();
                try (FileInputStream fis = new FileInputStream(new File(dbConfigFilePath));){
                    this.connectionDatabaseSettings = (DocumentBursterConnectionDatabaseSettings)ur.unmarshal((InputStream)fis);
                }
            }
            if (this.connectionDatabaseSettings.connection != null && this.connectionDatabaseSettings.connection.databaseserver != null) {
                this.connectionDatabaseSettings.connection.databaseserver.ensureDriverAndUrl();
            }
        }
    }

    public ReportingSettings loadSettingsReportingWithCode(String reportCode) throws Exception {
        ReportingSettings repSettings;
        String reportingFilePath = Paths.get(PORTABLE_EXECUTABLE_DIR_PATH, "config/reports", reportCode, "reporting.xml").normalize().toString();
        JAXBContext jcr = JAXBContext.newInstance((Class[])new Class[]{ReportingSettings.class});
        Unmarshaller ur = jcr.createUnmarshaller();
        try (FileInputStream fis = new FileInputStream(new File(reportingFilePath));){
            repSettings = (ReportingSettings)ur.unmarshal((InputStream)fis);
        }
        return repSettings;
    }

    public ReportingSettings loadSettingsReportingWithPath(String reportPath) throws Exception {
        JAXBContext jcr = JAXBContext.newInstance((Class[])new Class[]{ReportingSettings.class});
        Unmarshaller ur = jcr.createUnmarshaller();
        try (FileInputStream fis = new FileInputStream(new File(reportPath));){
            this.reportingSettings = (ReportingSettings)ur.unmarshal((InputStream)fis);
        }
        return this.reportingSettings;
    }

    public DocumentBursterConnectionEmailSettings loadSettingsConnectionEmail(String connectionCode) throws Exception {
        String connectionFilePath = Paths.get(PORTABLE_EXECUTABLE_DIR_PATH, connectionCode).normalize().toString();
        JAXBContext jcr = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterConnectionEmailSettings.class});
        Unmarshaller ur = jcr.createUnmarshaller();
        try (FileInputStream fis = new FileInputStream(new File(connectionFilePath));){
            this.connectionEmailSettings = (DocumentBursterConnectionEmailSettings)ur.unmarshal((InputStream)fis);
        }
        return this.connectionEmailSettings;
    }

    public DocumentBursterConnectionDatabaseSettings loadSettingsConnectionDatabase(String connectionCode) throws Exception {
        String connectionConfigFilePath = Paths.get(PORTABLE_EXECUTABLE_DIR_PATH, "config/connections", connectionCode, connectionCode + ".xml").normalize().toString();
        return this.loadSettingsConnectionDatabaseByPath(connectionConfigFilePath);
    }

    public DocumentBursterConnectionDatabaseSettings loadSettingsConnectionDatabaseByPath(String connectionFilePath) throws Exception {
        DocumentBursterConnectionDatabaseSettings connDatabaseSettings;
        String pathLower;
        String string = pathLower = connectionFilePath == null ? "" : connectionFilePath.toLowerCase();
        if (pathLower.contains("sample-northwind-sqlite") || pathLower.contains("northwind-sqlite") || pathLower.contains("northwind-sqlite-sample")) {
            String dbFilePath = null;
            String portable = System.getenv("PORTABLE_EXECUTABLE_DIR");
            if (portable != null && !portable.trim().isEmpty()) {
                dbFilePath = portable + File.separator + "db" + File.separator + "sample-northwind-sqlite" + File.separator + "northwind.db";
            } else {
                try {
                    dbFilePath = Utils.getDbFolderPath() + File.separator + "sample-northwind-sqlite" + File.separator + "northwind.db";
                }
                catch (Throwable t) {
                    dbFilePath = "db" + File.separator + "sample-northwind-sqlite" + File.separator + "northwind.db";
                }
            }
            File dbFile = new File(dbFilePath);
            String resolvedPath = dbFile.getAbsolutePath();
            String jdbcUrl = "jdbc:sqlite:" + resolvedPath;
            DocumentBursterConnectionDatabaseSettings connDatabaseSettings2 = new DocumentBursterConnectionDatabaseSettings();
            ConnectionDatabaseSettings conn = new ConnectionDatabaseSettings();
            ServerDatabaseSettings server = new ServerDatabaseSettings();
            server.type = "sqlite";
            server.driver = "org.sqlite.JDBC";
            server.url = jdbcUrl;
            server.userid = "";
            server.userpassword = "";
            conn.databaseserver = server;
            connDatabaseSettings2.connection = conn;
            if (connDatabaseSettings2.connection != null && connDatabaseSettings2.connection.databaseserver != null) {
                connDatabaseSettings2.connection.databaseserver.ensureDriverAndUrl();
            }
            return connDatabaseSettings2;
        }
        JAXBContext jcr = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterConnectionDatabaseSettings.class});
        Unmarshaller ur = jcr.createUnmarshaller();
        try (FileInputStream fis = new FileInputStream(new File(connectionFilePath));){
            connDatabaseSettings = (DocumentBursterConnectionDatabaseSettings)ur.unmarshal((InputStream)fis);
        }
        if (connDatabaseSettings != null && connDatabaseSettings.connection != null && connDatabaseSettings.connection.databaseserver != null) {
            connDatabaseSettings.connection.databaseserver.ensureDriverAndUrl();
        }
        return connDatabaseSettings;
    }

    private void _sortAttachments() {
        if (this.docSettings.settings.attachments.items.attachmentItems == null) {
            return;
        }
        if (this.docSettings.settings.attachments.items.attachmentItems.size() > 0) {
            Comparator<Attachment> COMPARATOR = new Comparator<Attachment>(){

                @Override
                public int compare(Attachment a1, Attachment a2) {
                    return a1.order - a2.order;
                }
            };
            Collections.sort(this.docSettings.settings.attachments.items.attachmentItems, COMPARATOR);
        }
    }

    public BursterSettings getSettings() {
        return this.docSettings.settings;
    }

    public FreeMarkerSettings getFreeMarkerSettings() {
        return this.docSettings.settings.freemarker;
    }

    public ReportSettings.DataSource getReportDataSource() {
        return this.reportingSettings.report.datasource;
    }

    public String getReportFolderNameId() {
        if (!this.getCapabilities().reportgenerationmailmerge) {
            return "";
        }
        return this.getTemplateName().toLowerCase();
    }

    public ReportSettings.Template getReportTemplate() {
        return this.reportingSettings.report.template;
    }

    public String getConfigurationFilePath() {
        return this.configurationFilePath;
    }

    public String setConfigurationFilePath(String configurationFilePath) {
        this.configurationFilePath = configurationFilePath;
        return this.configurationFilePath;
    }

    public Capabilities getCapabilities() {
        return this.docSettings.settings.capabilities;
    }

    public String getTemplateName() {
        return this.docSettings.settings.template.trim();
    }

    public String getVersion() {
        return this.docSettings.settings.version;
    }

    public String getBurstFileName() {
        return this.docSettings.settings.burstfilename.trim();
    }

    public String getOutputFolder() {
        return this.docSettings.settings.outputfolder.trim();
    }

    public String getBackupFolder() {
        return this.docSettings.settings.backupfolder.trim();
    }

    public boolean isQuarantineFiles() {
        return this.docSettings.settings.quarantinefiles;
    }

    public String getQuarantineFolder() {
        return this.docSettings.settings.quarantinefolder.trim();
    }

    public String getStatsFileName() {
        return this.docSettings.settings.statsfilename.trim();
    }

    public String getLogsArchivesFolder() {
        return this.docSettings.settings.logsarchivesfolder.trim();
    }

    public SendFiles getSendFiles() {
        return this.docSettings.settings.sendfiles;
    }

    public boolean isDeleteFiles() {
        return this.docSettings.settings.deletefiles;
    }

    public boolean isHtmlEmail() {
        return this.docSettings.settings.htmlemail;
    }

    public void setHtmlEmail(boolean htmlEmail) {
        this.docSettings.settings.htmlemail = htmlEmail;
    }

    public boolean isHtmlEmailEditCode() {
        return this.docSettings.settings.htmlemaileditcode;
    }

    public boolean isSortByPosition() {
        return this.docSettings.settings.sortbyposition;
    }

    public boolean isShouldSeparateByBeads() {
        return this.docSettings.settings.shouldseparatebybeads;
    }

    public boolean isSuppressDuplicateOverlappingText() {
        return this.docSettings.settings.suppressduplicateoverlappingtext;
    }

    public float getAverageCharTolerance() {
        return this.docSettings.settings.averagechartolerancevalue.floatValue();
    }

    public float getSpacingTolerance() {
        return this.docSettings.settings.spacingtolerancevalue.floatValue();
    }

    public int getNumberOfUserVariables() {
        return this.docSettings.settings.numberofuservariables;
    }

    public void setNumberOfVariables(int numberOfUserVariables) {
        this.docSettings.settings.numberofuservariables = numberOfUserVariables;
    }

    public double getDelayEachDistributionBy() {
        return this.docSettings.settings.delayeachdistributionby;
    }

    public void setDelayEachDistributionBy(double delayEachDistributionBy) {
        this.docSettings.settings.delayeachdistributionby = delayEachDistributionBy;
    }

    public boolean isReuseTokensWhenNotFound() {
        return this.docSettings.settings.reusetokenswhennotfound;
    }

    public boolean isSplit2ndTime() {
        return this.docSettings.settings.split2ndtime;
    }

    public boolean isFailJobIfAnyDistributionFails() {
        return this.docSettings.settings.failjobifanydistributionfails;
    }

    public boolean isEnableRetryPolicy() {
        return this.docSettings.settings.enableretrypolicy;
    }

    public String getLanguage() {
        return this.docSettings.settings.locale.language;
    }

    public String getCountry() {
        return this.docSettings.settings.locale.country;
    }

    public List<Attachment> getAttachments() {
        if (this.docSettings.settings.attachments.items.attachmentItems == null) {
            return new ArrayList<Attachment>();
        }
        return this.docSettings.settings.attachments.items.attachmentItems;
    }

    public boolean isArchiveAttachments() {
        return this.docSettings.settings.attachments.archive.archiveattachments;
    }

    public String getArchiveFileName() {
        return this.docSettings.settings.attachments.archive.archivefilename;
    }

    public EmailSettings getEmailSettings() {
        return this.docSettings.settings.emailsettings;
    }

    public boolean getEmailServerUseConn() {
        return this.docSettings.settings.emailserver.useconn;
    }

    public String getEmailServerConnCode() {
        return this.docSettings.settings.emailserver.conncode;
    }

    public String getEmailServerUserId() {
        return this.docSettings.settings.emailserver.userid;
    }

    public String getEmailServerUserPassword() {
        return this.docSettings.settings.emailserver.userpassword;
    }

    public String getEmailServerHost() {
        return this.docSettings.settings.emailserver.host;
    }

    public String getEmailServerPort() {
        return this.docSettings.settings.emailserver.port;
    }

    public String getEmailServerFrom() {
        return this.docSettings.settings.emailserver.fromaddress;
    }

    public String getEmailServerName() {
        return this.docSettings.settings.emailserver.name;
    }

    public boolean isEmailServerUseTLS() {
        return this.docSettings.settings.emailserver.usetls;
    }

    public boolean isEmailServerUseSSL() {
        return this.docSettings.settings.emailserver.usessl;
    }

    public String getTestEmailServerUserId() {
        return this.docSettings.settings.qualityassurance.emailserver.userid;
    }

    public String getTestEmailServerUserPassword() {
        return this.docSettings.settings.qualityassurance.emailserver.userpassword;
    }

    public String getTestEmailServerHost() {
        return this.docSettings.settings.qualityassurance.emailserver.host;
    }

    public String getTestEmailServerPort() {
        return this.docSettings.settings.qualityassurance.emailserver.port;
    }

    public String getTestEmailServerFrom() {
        return this.docSettings.settings.qualityassurance.emailserver.fromaddress;
    }

    public String getTestEmailServerName() {
        return this.docSettings.settings.qualityassurance.emailserver.name;
    }

    public boolean isTestEmailServerUseTLS() {
        return this.docSettings.settings.qualityassurance.emailserver.usetls;
    }

    public boolean isTestEmailServerUseSSL() {
        return this.docSettings.settings.qualityassurance.emailserver.usessl;
    }

    public SimpleJavaMail getSimpleJavaMail() {
        return this.docSettings.settings.simplejavamail;
    }

    public SimpleJavaMail setSimpleJavaMail(SimpleJavaMail sjm) {
        this.docSettings.settings.simplejavamail = sjm;
        return this.docSettings.settings.simplejavamail;
    }

    public EmailRfc2822Validator getEmailRfc2822Validator() {
        return this.docSettings.settings.emailrfc2822validator;
    }

    public UploadSettings getUploadSettings() {
        return this.docSettings.settings.uploadsettings;
    }

    public WebUploadSettings getWebUploadSettings() {
        return this.docSettings.settings.webuploadsettings;
    }

    public SmsSettings getSmsSettings() {
        return this.docSettings.settings.smssettings;
    }

    public RetryPolicy getRetryPolicy() {
        return this.docSettings.settings.retrypolicy;
    }

    public String getMergeFileName() {
        return this.docSettings.settings.mergefilename;
    }

    public void setSendFilesEmail(boolean sendFilesEmail) {
        this.docSettings.settings.sendfiles.email = sendFilesEmail;
    }

    public void setSendFilesUpload(boolean sendFilesUpload) {
        this.docSettings.settings.sendfiles.upload = sendFilesUpload;
    }

    public void setSendFilesWeb(boolean sendFilesWeb) {
        this.docSettings.settings.sendfiles.web = sendFilesWeb;
    }

    public void setSendFilesSms(boolean sendFilesSms) {
        this.docSettings.settings.sendfiles.sms = sendFilesSms;
    }

    public void setCapabilityReportGenerationMailMerge(boolean reportgenerationmailmerge) {
        this.docSettings.settings.capabilities.reportgenerationmailmerge = reportgenerationmailmerge;
    }

    public void setEmailServerHost(String host) {
        this.docSettings.settings.emailserver.host = host;
    }

    public void setEmailServerPort(String port) {
        this.docSettings.settings.emailserver.port = port;
    }

    public void setEmailServerUserId(String userId) {
        this.docSettings.settings.emailserver.userid = userId;
    }

    public void setEmailServerUserPassword(String userPassword) {
        this.docSettings.settings.emailserver.userpassword = userPassword;
    }

    public void setEmailServerUseTLS(boolean useTls) {
        this.docSettings.settings.emailserver.usetls = useTls;
    }

    public void setEmailServerUseSSL(boolean useSsl) {
        this.docSettings.settings.emailserver.usessl = useSsl;
    }

    public void setEmailServerFrom(String fromAddress) {
        this.docSettings.settings.emailserver.fromaddress = fromAddress;
    }

    public void setEmailServerName(String name) {
        this.docSettings.settings.emailserver.name = name;
    }

    public void setTestEmailServerHost(String host) {
        this.docSettings.settings.qualityassurance.emailserver.host = host;
    }

    public void setTestEmailServerPort(String port) {
        this.docSettings.settings.qualityassurance.emailserver.port = port;
    }

    public void setTesttEmailServerUserId(String userId) {
        this.docSettings.settings.qualityassurance.emailserver.userid = userId;
    }

    public void setTestEmailServerUserPassword(String userPassword) {
        this.docSettings.settings.qualityassurance.emailserver.userpassword = userPassword;
    }

    public void setTestEmailServerUseTLS(boolean useTls) {
        this.docSettings.settings.qualityassurance.emailserver.usetls = useTls;
    }

    public void setTestEmailServerUseSSL(boolean useSsl) {
        this.docSettings.settings.qualityassurance.emailserver.usessl = useSsl;
    }

    public void setTestEmailServerFrom(String fromAddress) {
        this.docSettings.settings.qualityassurance.emailserver.fromaddress = fromAddress;
    }

    public void setTestEmailServerName(String name) {
        this.docSettings.settings.qualityassurance.emailserver.name = name;
    }

    public void setEmailTo(String to) {
        this.docSettings.settings.emailsettings.to = to;
    }

    public void setEmailCc(String cc) {
        this.docSettings.settings.emailsettings.cc = cc;
    }

    public void setEmailBcc(String bcc) {
        this.docSettings.settings.emailsettings.bcc = bcc;
    }

    public void setEmailSubject(String subject) {
        this.docSettings.settings.emailsettings.subject = subject;
    }

    public void setEmailText(String text) {
        this.docSettings.settings.emailsettings.text = text;
    }

    public void addAttachment(Attachment item) {
        this.getAttachments().add(item);
    }

    public void setSplit2ndTime(boolean split2ndtime) {
        this.docSettings.settings.split2ndtime = split2ndtime;
    }

    public void setArchiveAttachments(boolean archiveAttachments) {
        this.docSettings.settings.attachments.archive.archiveattachments = archiveAttachments;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.docSettings.settings.attachments.archive.archivefilename = archiveFileName;
    }

    public void setDeleteFiles(boolean deleteFiles) {
        this.docSettings.settings.deletefiles = deleteFiles;
    }

    public void setFtpCommand(String ftpCommand) {
        this.docSettings.settings.uploadsettings.ftpcommand = ftpCommand;
    }

    public void setOutputFolder(String folder) {
        this.docSettings.settings.outputfolder = folder;
    }

    public void setBackupFolder(String folder) {
        this.docSettings.settings.backupfolder = folder;
    }

    public void setQuarantineFolder(String folder) {
        this.docSettings.settings.quarantinefolder = folder;
    }

    public void setBurstFileName(String burstFileName) {
        this.docSettings.settings.burstfilename = burstFileName;
    }

    public void setStatsFileName(String statsFileName) {
        this.docSettings.settings.statsfilename = statsFileName;
    }

    public void setLogsArchivesFolder(String folder) {
        this.docSettings.settings.logsarchivesfolder = folder;
    }

    public void setReuseTokensWhenNotFound(boolean reuseTokenWhenNotFound) {
        this.docSettings.settings.reusetokenswhennotfound = reuseTokenWhenNotFound;
    }

    public void setFailJobIfAnyDistributionFails(boolean failJobIfAnyDistributionFails) {
        this.docSettings.settings.failjobifanydistributionfails = failJobIfAnyDistributionFails;
    }

    public void setEnableRetryPolicy(boolean enableRetryPolicy) {
        this.docSettings.settings.enableretrypolicy = enableRetryPolicy;
    }

    public String getStartBurstTokenDelimiter() {
        return this.docSettings.settings.bursttokendelimiters.start;
    }

    public String getEndBurstTokenDelimiter() {
        return this.docSettings.settings.bursttokendelimiters.end;
    }

    public void setStartBurstTokenDelimiter(String startDelimiter) {
        this.docSettings.settings.bursttokendelimiters.start = startDelimiter;
    }

    public boolean getDumpRecordDataAsXml() {
        return this.docSettings.settings.dumprecorddataasxml;
    }

    public void setDumpRecordDataAsXml(boolean dumprecorddataasxml) {
        this.docSettings.settings.dumprecorddataasxml = dumprecorddataasxml;
    }

    public void setEndBurstTokenDelimiter(String endDelimiter) {
        this.docSettings.settings.bursttokendelimiters.end = endDelimiter;
    }

    public String getStartBurstTokenDelimiter2nd() {
        return this.docSettings.settings.bursttokendelimiters.start2nd;
    }

    public String getEndBurstTokenDelimiter2nd() {
        return this.docSettings.settings.bursttokendelimiters.end2nd;
    }

    public void setStartBurstTokenDelimiter2nd(String startDelimiter) {
        this.docSettings.settings.bursttokendelimiters.start2nd = startDelimiter;
    }

    public void setEndBurstTokenDelimiter2nd(String endDelimiter) {
        this.docSettings.settings.bursttokendelimiters.end2nd = endDelimiter;
    }

    public void setFileShareCommand(String fileShareCommand) {
        this.docSettings.settings.uploadsettings.filesharecommand = fileShareCommand;
    }

    public void setFtpsCommand(String ftpsCommand) {
        this.docSettings.settings.uploadsettings.ftpscommand = ftpsCommand;
    }

    public void setSftpCommand(String sftpCommand) {
        this.docSettings.settings.uploadsettings.sftpcommand = sftpCommand;
    }

    public void setHttpCommand(String httpCommand) {
        this.docSettings.settings.uploadsettings.httpcommand = httpCommand;
    }

    public void setCloudCommand(String cloudCommand) {
        this.docSettings.settings.uploadsettings.cloudcommand = cloudCommand;
    }

    public void setDocumentBursterWebCommand(String documentBursterWebCommand) {
        this.docSettings.settings.webuploadsettings.documentbursterwebcommand = documentBursterWebCommand;
    }

    public void setMSSharePointCommand(String msSharePointCommand) {
        this.docSettings.settings.webuploadsettings.mssharepointcommand = msSharePointCommand;
    }

    public void setWordPressCommand(String wordPressCommand) {
        this.docSettings.settings.webuploadsettings.wordpresscommand = wordPressCommand;
    }

    public void setDrupalCommand(String drupalCommand) {
        this.docSettings.settings.webuploadsettings.drupalcommand = drupalCommand;
    }

    public void setJoomlaCommand(String joomlaCommand) {
        this.docSettings.settings.webuploadsettings.joomlacommand = joomlaCommand;
    }

    public void setOtherWebCommand(String otherWebCommand) {
        this.docSettings.settings.webuploadsettings.otherwebcommand = otherWebCommand;
    }

    public void setRetryPolicyDelay(int delay) {
        this.docSettings.settings.retrypolicy.delay = delay;
    }

    public void setRetryPolicyMaxDelay(int maxDelay) {
        this.docSettings.settings.retrypolicy.maxdelay = maxDelay;
    }

    public void setRetryPolicyMaxRetries(int maxRetries) {
        this.docSettings.settings.retrypolicy.maxretries = maxRetries;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

