/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.settings;

import com.sourcekraft.documentburster.common.settings.model.connection.ConnectionEmailDetails;
import com.sourcekraft.documentburster.utils.Utils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FilenameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailConnection {
    private Logger log = LoggerFactory.getLogger(EmailConnection.class);
    private ConnectionEmailDetails emailConnectionDetails = new ConnectionEmailDetails();

    public void loadDetails(String connectionFilePath) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ConnectionEmailDetails.class});
        Unmarshaller u = jc.createUnmarshaller();
        this.emailConnectionDetails = (ConnectionEmailDetails)u.unmarshal(new File(connectionFilePath));
        this.log.debug("loadDetails - emailConnectionDetails = [" + this.emailConnectionDetails + "]");
    }

    public void loadDetailsUsingCode(String connectionCode, String configurationFilePath) throws Exception {
        FilenameFilter emailConnectionsFilesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String fileName) {
                return fileName.startsWith("eml-") && fileName.endsWith(".xml");
            }
        };
        File[] emailConnectionFiles = new File(Utils.getConfigurationFolderPath(configurationFilePath) + "/connections").listFiles(emailConnectionsFilesFilter);
        boolean found = false;
        for (int i = 0; i < emailConnectionFiles.length && !found; ++i) {
            File emailConnectionFile = emailConnectionFiles[i];
            String emailConnectionFilePath = emailConnectionFile.getAbsolutePath();
            this.loadDetails(emailConnectionFilePath);
            found = this.emailConnectionDetails.connection.code.equals(connectionCode);
        }
    }

    public void loadDetailsDefault(String configFolderPath) throws Exception {
        FilenameFilter emailConnectionsFilesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String fileName) {
                return fileName.startsWith("eml-") && fileName.endsWith(".xml");
            }
        };
        File[] emailConnectionFiles = new File(Utils.getConfigurationFolderPath(configFolderPath) + "/connections").listFiles(emailConnectionsFilesFilter);
        boolean found = false;
        for (int i = 0; i < emailConnectionFiles.length && !found; ++i) {
            File emailConnectionFile = emailConnectionFiles[i];
            String emailConnectionFilePath = emailConnectionFile.getAbsolutePath();
            this.loadDetails(emailConnectionFilePath);
            found = this.emailConnectionDetails.connection.defaultConnection;
        }
    }

    public ConnectionEmailDetails getDetails() {
        return this.emailConnectionDetails;
    }
}

