/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.reportparameters;

import com.sourcekraft.documentburster.common.reportparameters.ReportParameter;
import com.sourcekraft.documentburster.common.reportparameters.ReportParametersScript;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;

public class ReportParametersHelper {
    public static List<ReportParameter> parseGroovyParametersDslCode(String groovyParametersDslCode) throws Exception {
        Binding binding = new Binding();
        binding.setVariable("reportParametersProvided", (Object)false);
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(ReportParametersScript.class.getName());
        GroovyShell shell = new GroovyShell(binding, config);
        ReportParametersScript script = (ReportParametersScript)shell.parse(groovyParametersDslCode);
        script.setBinding(binding);
        script.run();
        List<Map<String, Object>> paramsMetadataList = script.getParamsMetadataList();
        ArrayList<ReportParameter> reportParameters = new ArrayList<ReportParameter>();
        if (paramsMetadataList != null) {
            for (Map<String, Object> paramMap : paramsMetadataList) {
                ReportParameter rp = new ReportParameter();
                rp.id = (String)paramMap.get("id");
                rp.label = (String)paramMap.get("label");
                Object t = paramMap.get("type");
                rp.type = t instanceof Class ? ((Class)t).getSimpleName() : String.valueOf(t);
                rp.description = (String)paramMap.get("description");
                Object defVal = paramMap.get("defaultValue");
                rp.defaultValue = defVal != null ? String.valueOf(defVal) : null;
                Map constraints = paramMap.getOrDefault("constraints", Collections.emptyMap());
                Map uiHints = paramMap.getOrDefault("ui", Collections.emptyMap());
                rp.constraints.putAll(constraints);
                rp.uiHints.putAll(uiHints);
                reportParameters.add(rp);
            }
        }
        return reportParameters;
    }
}

