/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Employee;
import com.sourcekraft.documentburster.common.db.northwind.entities.Region;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Territories\"")
public class Territory {
    @Id
    @Column(name="\"TerritoryID\"", length=20)
    private String territoryId;
    @Column(name="\"TerritoryDescription\"", length=50, nullable=false)
    private String territoryDescription;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"RegionID\"", nullable=false)
    private Region region;
    @ManyToMany(mappedBy="territories", fetch=FetchType.LAZY)
    private List<Employee> employees = new ArrayList<Employee>();

    public Territory() {
    }

    public Territory(String territoryId, String territoryDescription, Region region) {
        this.territoryId = territoryId;
        this.territoryDescription = territoryDescription;
        this.region = region;
    }

    public String getTerritoryId() {
        return this.territoryId;
    }

    public void setTerritoryId(String territoryId) {
        this.territoryId = territoryId;
    }

    public String getTerritoryDescription() {
        return this.territoryDescription;
    }

    public void setTerritoryDescription(String territoryDescription) {
        this.territoryDescription = territoryDescription;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public List<Employee> getEmployees() {
        return this.employees;
    }

    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }

    public void addEmployee(Employee employee) {
        this.employees.add(employee);
        employee.getTerritories().add(this);
    }

    public void removeEmployee(Employee employee) {
        this.employees.remove(employee);
        employee.getTerritories().remove(this);
    }

    public String getFullDescription() {
        return this.territoryDescription + (this.region != null ? " (" + this.region.getRegionDescription() + ")" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Territory territory = (Territory)o;
        return Objects.equals(this.territoryId, territory.territoryId);
    }

    public int hashCode() {
        return Objects.hash(this.territoryId);
    }

    public String toString() {
        return "Territory{territoryId='" + this.territoryId + '\'' + ", territoryDescription='" + this.territoryDescription + '\'' + ", region=" + (this.region != null ? this.region.getRegionDescription() : null) + ", employeeCount=" + (this.employees != null ? this.employees.size() : 0) + '}';
    }
}

