/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Order;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Shippers\"")
public class Shipper {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="\"ShipperID\"")
    private Integer shipperId;
    @Column(name="\"CompanyName\"", length=40, nullable=false)
    private String companyName;
    @Column(name="\"Phone\"", length=24)
    private String phone;
    @OneToMany(mappedBy="shipper", fetch=FetchType.LAZY)
    private List<Order> orders = new ArrayList<Order>();

    public Shipper() {
    }

    public Shipper(String companyName, String phone) {
        this.companyName = companyName;
        this.phone = phone;
    }

    public Integer getShipperId() {
        return this.shipperId;
    }

    public void setShipperId(Integer shipperId) {
        this.shipperId = shipperId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public void addOrder(Order order) {
        this.orders.add(order);
        order.setShipper(this);
    }

    public void removeOrder(Order order) {
        this.orders.remove(order);
        order.setShipper(null);
    }

    public int getOrderCount() {
        return this.orders.size();
    }

    public int getShippedOrderCount() {
        return (int)this.orders.stream().filter(Order::isShipped).count();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shipper shipper = (Shipper)o;
        return Objects.equals(this.shipperId, shipper.shipperId);
    }

    public int hashCode() {
        return Objects.hash(this.shipperId);
    }

    public String toString() {
        return "Shipper{shipperId=" + this.shipperId + ", companyName='" + this.companyName + '\'' + ", phone='" + this.phone + '\'' + ", orderCount=" + this.getOrderCount() + '}';
    }
}

