/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Territory;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Region\"")
public class Region {
    @Id
    @Column(name="\"RegionID\"")
    private Integer regionId;
    @Column(name="\"RegionDescription\"", length=50, nullable=false)
    private String regionDescription;
    @OneToMany(mappedBy="region", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<Territory> territories = new ArrayList<Territory>();

    public Region() {
    }

    public Region(Integer regionId, String regionDescription) {
        this.regionId = regionId;
        this.regionDescription = regionDescription;
    }

    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer regionId) {
        this.regionId = regionId;
    }

    public String getRegionDescription() {
        return this.regionDescription;
    }

    public void setRegionDescription(String regionDescription) {
        this.regionDescription = regionDescription;
    }

    public List<Territory> getTerritories() {
        return this.territories;
    }

    public void setTerritories(List<Territory> territories) {
        this.territories = territories;
    }

    public void addTerritory(Territory territory) {
        if (territory != null && !this.territories.contains(territory)) {
            this.territories.add(territory);
            territory.setRegion(this);
        }
    }

    public void removeTerritory(Territory territory) {
        if (territory != null) {
            this.territories.remove(territory);
            territory.setRegion(null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Region)) {
            return false;
        }
        Region region = (Region)o;
        return this.regionId != null && Objects.equals(this.regionId, region.regionId);
    }

    public int hashCode() {
        return Objects.hash(this.regionId);
    }

    public String toString() {
        return "Region{regionId=" + this.regionId + ", regionDescription='" + this.regionDescription + '\'' + '}';
    }
}

