/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Category;
import com.sourcekraft.documentburster.common.db.northwind.entities.OrderDetail;
import com.sourcekraft.documentburster.common.db.northwind.entities.Supplier;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Products\"")
public class Product {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="\"ProductID\"")
    private Integer productId;
    @Column(name="\"ProductName\"", length=40, nullable=false)
    private String productName;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"SupplierID\"")
    private Supplier supplier;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"CategoryID\"")
    private Category category;
    @Column(name="\"QuantityPerUnit\"", length=20)
    private String quantityPerUnit;
    @Column(name="\"UnitPrice\"", precision=19, scale=4)
    private BigDecimal unitPrice;
    @Column(name="\"UnitsInStock\"")
    private Short unitsInStock = 0;
    @Column(name="\"UnitsOnOrder\"")
    private Short unitsOnOrder = 0;
    @Column(name="\"ReorderLevel\"")
    private Short reorderLevel;
    @Column(name="\"Discontinued\"", nullable=false)
    private boolean discontinued = false;
    @OneToMany(mappedBy="product", fetch=FetchType.LAZY)
    private List<OrderDetail> orderDetails = new ArrayList<OrderDetail>();

    public Product() {
    }

    public Product(String productName, BigDecimal unitPrice) {
        this();
        this.productName = productName;
        this.unitPrice = unitPrice;
    }

    public Product(String productName, BigDecimal unitPrice, Category category, Supplier supplier) {
        this(productName, unitPrice);
        this.category = category;
        this.supplier = supplier;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getQuantityPerUnit() {
        return this.quantityPerUnit;
    }

    public void setQuantityPerUnit(String quantityPerUnit) {
        this.quantityPerUnit = quantityPerUnit;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Short getUnitsInStock() {
        return this.unitsInStock;
    }

    public void setUnitsInStock(Short unitsInStock) {
        this.unitsInStock = unitsInStock;
    }

    public Short getUnitsOnOrder() {
        return this.unitsOnOrder;
    }

    public void setUnitsOnOrder(Short unitsOnOrder) {
        this.unitsOnOrder = unitsOnOrder;
    }

    public Short getReorderLevel() {
        return this.reorderLevel;
    }

    public void setReorderLevel(Short reorderLevel) {
        this.reorderLevel = reorderLevel;
    }

    public boolean isDiscontinued() {
        return this.discontinued;
    }

    public void setDiscontinued(boolean discontinued) {
        this.discontinued = discontinued;
    }

    public List<OrderDetail> getOrderDetails() {
        return this.orderDetails;
    }

    public void setOrderDetails(List<OrderDetail> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public void addOrderDetail(OrderDetail orderDetail) {
        this.orderDetails.add(orderDetail);
        orderDetail.setProduct(this);
    }

    public void removeOrderDetail(OrderDetail orderDetail) {
        this.orderDetails.remove(orderDetail);
        orderDetail.setProduct(null);
    }

    public boolean isInStock() {
        return this.unitsInStock != null && this.unitsInStock > 0;
    }

    public BigDecimal getInventoryValue() {
        if (this.unitsInStock == null || this.unitPrice == null) {
            return BigDecimal.ZERO;
        }
        return this.unitPrice.multiply(new BigDecimal(this.unitsInStock.shortValue()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return Objects.equals(this.productId, product.productId);
    }

    public int hashCode() {
        return Objects.hash(this.productId);
    }

    public String toString() {
        return "Product{productId=" + this.productId + ", productName='" + this.productName + '\'' + ", category=" + (this.category != null ? this.category.getCategoryName() : null) + ", unitPrice=" + this.unitPrice + ", inStock=" + this.isInStock() + '}';
    }
}

