/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Order;
import com.sourcekraft.documentburster.common.db.northwind.entities.Territory;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Employees\"")
public class Employee {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="\"EmployeeID\"")
    private Integer employeeId;
    @Column(name="\"LastName\"", length=20, nullable=false)
    private String lastName;
    @Column(name="\"FirstName\"", length=10, nullable=false)
    private String firstName;
    @Column(name="\"Title\"", length=30)
    private String title;
    @Column(name="\"TitleOfCourtesy\"", length=25)
    private String titleOfCourtesy;
    @Column(name="\"BirthDate\"")
    private LocalDate birthDate;
    @Column(name="\"HireDate\"")
    private LocalDate hireDate;
    @Column(name="\"Address\"", length=60)
    private String address;
    @Column(name="\"City\"", length=15)
    private String city;
    @Column(name="\"Region\"", length=15)
    private String region;
    @Column(name="\"PostalCode\"", length=10)
    private String postalCode;
    @Column(name="\"Country\"", length=15)
    private String country;
    @Column(name="\"HomePhone\"", length=24)
    private String phone;
    @Column(name="\"Extension\"", length=4)
    private String extension;
    @Column(name="\"Mobile\"", length=24)
    private String mobile;
    @Column(name="\"Email\"", length=225)
    private String email;
    @Lob
    @Column(name="\"Photo\"")
    private byte[] photo;
    @Lob
    @Column(name="\"Notes\"")
    private String notes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"ReportsTo\"")
    private Employee manager;
    @Column(name="\"PhotoPath\"", length=255)
    private String photoPath;
    @OneToMany(mappedBy="manager", fetch=FetchType.LAZY)
    private List<Employee> directReports = new ArrayList<Employee>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="\"EmployeeTerritories\"", joinColumns={@JoinColumn(name="\"EmployeeID\"")}, inverseJoinColumns={@JoinColumn(name="\"TerritoryID\"")})
    private List<Territory> territories = new ArrayList<Territory>();
    @OneToMany(mappedBy="employee", fetch=FetchType.LAZY)
    private List<Order> orders = new ArrayList<Order>();

    public Employee() {
    }

    public Employee(String firstName, String lastName, String title) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.title = title;
    }

    public Integer getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(Integer employeeId) {
        this.employeeId = employeeId;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleOfCourtesy() {
        return this.titleOfCourtesy;
    }

    public void setTitleOfCourtesy(String titleOfCourtesy) {
        this.titleOfCourtesy = titleOfCourtesy;
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public LocalDate getHireDate() {
        return this.hireDate;
    }

    public void setHireDate(LocalDate hireDate) {
        this.hireDate = hireDate;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public byte[] getPhoto() {
        return this.photo;
    }

    public void setPhoto(byte[] photo) {
        this.photo = photo;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Employee getManager() {
        return this.manager;
    }

    public void setManager(Employee manager) {
        this.manager = manager;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public void setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
    }

    public List<Employee> getDirectReports() {
        return this.directReports;
    }

    public void setDirectReports(List<Employee> directReports) {
        this.directReports = directReports;
    }

    public List<Territory> getTerritories() {
        return this.territories;
    }

    public void setTerritories(List<Territory> territories) {
        this.territories = territories;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public void addDirectReport(Employee employee) {
        this.directReports.add(employee);
        employee.setManager(this);
    }

    public void removeDirectReport(Employee employee) {
        this.directReports.remove(employee);
        employee.setManager(null);
    }

    public void addTerritory(Territory territory) {
        this.territories.add(territory);
        territory.getEmployees().add(this);
    }

    public void removeTerritory(Territory territory) {
        this.territories.remove(territory);
        territory.getEmployees().remove(this);
    }

    public void addOrder(Order order) {
        this.orders.add(order);
        order.setEmployee(this);
    }

    public void removeOrder(Order order) {
        this.orders.remove(order);
        order.setEmployee(null);
    }

    public String getFullName() {
        return this.titleOfCourtesy != null ? this.titleOfCourtesy + " " + this.firstName + " " + this.lastName : this.firstName + " " + this.lastName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employee employee = (Employee)o;
        return Objects.equals(this.employeeId, employee.employeeId);
    }

    public int hashCode() {
        return Objects.hash(this.employeeId);
    }

    public String toString() {
        return "Employee{employeeId=" + this.employeeId + ", fullName='" + this.getFullName() + '\'' + ", title='" + this.title + '\'' + '}';
    }
}

