/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.Customer;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"CustomerDemographics\"")
public class CustomerDemographics {
    @Id
    @Column(name="\"CustomerTypeID\"", length=10)
    private String customerTypeId;
    @Lob
    @Column(name="\"CustomerDesc\"")
    private String customerDesc;
    @ManyToMany(mappedBy="demographics", fetch=FetchType.LAZY)
    private List<Customer> customers = new ArrayList<Customer>();

    public CustomerDemographics() {
    }

    public CustomerDemographics(String customerTypeId, String customerDesc) {
        this.customerTypeId = customerTypeId;
        this.customerDesc = customerDesc;
    }

    public String getCustomerTypeId() {
        return this.customerTypeId;
    }

    public void setCustomerTypeId(String customerTypeId) {
        this.customerTypeId = customerTypeId;
    }

    public String getCustomerDesc() {
        return this.customerDesc;
    }

    public void setCustomerDesc(String customerDesc) {
        this.customerDesc = customerDesc;
    }

    public List<Customer> getCustomers() {
        return this.customers;
    }

    public void setCustomers(List<Customer> customers) {
        this.customers = customers;
    }

    public void addCustomer(Customer customer) {
        this.customers.add(customer);
        if (!customer.getDemographics().contains(this)) {
            customer.getDemographics().add(this);
        }
    }

    public void removeCustomer(Customer customer) {
        this.customers.remove(customer);
        customer.getDemographics().remove(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerDemographics that = (CustomerDemographics)o;
        return Objects.equals(this.customerTypeId, that.customerTypeId);
    }

    public int hashCode() {
        return Objects.hash(this.customerTypeId);
    }

    public String toString() {
        return "CustomerDemographics{customerTypeId='" + this.customerTypeId + '\'' + ", customerDesc='" + (this.customerDesc != null ? this.customerDesc.substring(0, Math.min(this.customerDesc.length(), 20)) + "..." : null) + '\'' + '}';
    }
}

