/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db.northwind.entities;

import com.sourcekraft.documentburster.common.db.northwind.entities.CustomerDemographics;
import com.sourcekraft.documentburster.common.db.northwind.entities.Order;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="\"Customers\"")
public class Customer {
    @Id
    @Column(name="\"CustomerID\"", length=5)
    private String customerId;
    @Column(name="\"CompanyName\"", length=40, nullable=false)
    private String companyName;
    @Column(name="\"ContactName\"", length=30)
    private String contactName;
    @Column(name="\"ContactTitle\"", length=30)
    private String contactTitle;
    @Column(name="\"Address\"", length=60)
    private String address;
    @Column(name="\"City\"", length=15)
    private String city;
    @Column(name="\"Region\"", length=15)
    private String region;
    @Column(name="\"PostalCode\"", length=10)
    private String postalCode;
    @Column(name="\"Country\"", length=15)
    private String country;
    @Column(name="\"Phone\"", length=24)
    private String phone;
    @Column(name="\"Fax\"", length=24)
    private String fax;
    @Column(name="\"Email\"", length=225)
    private String email;
    @OneToMany(mappedBy="customer", fetch=FetchType.LAZY)
    private List<Order> orders = new ArrayList<Order>();
    @ManyToMany
    @JoinTable(name="\"CustomerCustomerDemo\"", joinColumns={@JoinColumn(name="\"CustomerID\"")}, inverseJoinColumns={@JoinColumn(name="\"CustomerTypeID\"")})
    private List<CustomerDemographics> demographics = new ArrayList<CustomerDemographics>();

    public Customer() {
    }

    public Customer(String customerId, String companyName, String contactName) {
        this.customerId = customerId;
        this.companyName = companyName;
        this.contactName = contactName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactTitle() {
        return this.contactTitle;
    }

    public void setContactTitle(String contactTitle) {
        this.contactTitle = contactTitle;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public List<CustomerDemographics> getDemographics() {
        return this.demographics;
    }

    public void setDemographics(List<CustomerDemographics> demographics) {
        this.demographics = demographics;
    }

    public void addOrder(Order order) {
        this.orders.add(order);
        order.setCustomer(this);
    }

    public void removeOrder(Order order) {
        this.orders.remove(order);
        order.setCustomer(null);
    }

    public void addDemographic(CustomerDemographics demographic) {
        this.demographics.add(demographic);
        demographic.getCustomers().add(this);
    }

    public void removeDemographic(CustomerDemographics demographic) {
        this.demographics.remove(demographic);
        demographic.getCustomers().remove(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return Objects.equals(this.customerId, customer.customerId);
    }

    public int hashCode() {
        return Objects.hash(this.customerId);
    }

    public String toString() {
        return "Customer{customerId='" + this.customerId + '\'' + ", companyName='" + this.companyName + '\'' + ", contactName='" + this.contactName + '\'' + '}';
    }
}

