/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common.db;

import com.sourcekraft.documentburster.context.BurstingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseHelper {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHelper.class);
    private BurstingContext ctx;

    public DatabaseHelper(String configFilePath) {
        log.debug("SqlReporter initialized with config path: {}", (Object)configFilePath);
    }

    public void setCtx(BurstingContext ctx) {
        this.ctx = ctx;
    }

    public List<String> findQueryParameters(String sql) {
        Pattern pattern = Pattern.compile("(?<!')(:(\\w+))(?!')");
        Matcher matcher = pattern.matcher(sql);
        ArrayList<String> params = new ArrayList<String>();
        while (matcher.find()) {
            params.add(matcher.group(2));
        }
        return params.stream().distinct().collect(Collectors.toList());
    }

    public String convertToJdbiParameters(String sql) {
        Pattern pattern = Pattern.compile("[\\$#]\\{([^}]+)\\}|@(\\w+)@");
        Matcher matcher = pattern.matcher(sql);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String varName = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            if (varName == null) continue;
            matcher.appendReplacement(sb, ":" + varName);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public Jdbi retrieveJdbiInstance(String connectionCode) throws Exception {
        return this.ctx.dbManager.getJdbi(connectionCode);
    }
}

