/*
 * Decompiled with CFR 0.152.
 */
package com.sourcekraft.documentburster.common;

import com.sourcekraft.documentburster.common.db.northwind.NorthwindManager;
import com.sourcekraft.documentburster.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class ServicesManager {
    private static final Logger log = LoggerFactory.getLogger(ServicesManager.class);
    private static final NorthwindManager dbManager;
    private static final List<String> FLOWKRAFT_APPS;
    private static final String DB_FAMILY = "database";
    private static final String APP_FAMILY = "app";
    private static final String NORTHWIND_PACK = "northwind";
    private static final String CMD_START = "start";
    private static final String CMD_STOP = "stop";
    private static final String CMD_LIST = "list";
    private static final String CMD_INFO = "info";
    private static final String CMD_QUERY = "query";

    public static Result execute(String commandLine) throws Exception {
        String[] tokens = commandLine.trim().split("\\s+");
        if (tokens[0].equalsIgnoreCase(DB_FAMILY)) {
            String subCmd = tokens[1].toLowerCase();
            String packName = tokens[2].toLowerCase();
            if (!packName.equals(NORTHWIND_PACK)) {
                return new Result("error", "Unknown pack name '" + packName + "' in family '" + DB_FAMILY + "'.");
            }
            String managerArgsString = tokens.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(tokens, 3, tokens.length)) : "";
            switch (subCmd) {
                case "start": {
                    String out = ServicesManager.captureOutput(() -> ServicesManager.handleNorthwindStart(managerArgsString));
                    String status = out.contains("\u2713 Northwind") || out.contains("database is running") ? "running" : (out.contains("\u2717") ? "error" : "running");
                    return new Result(status, out);
                }
                case "stop": {
                    String out = ServicesManager.captureOutput(() -> ServicesManager.handleNorthwindStop(managerArgsString));
                    return new Result("stopped", out);
                }
                case "list": {
                    String out = ServicesManager.captureOutput(() -> ServicesManager.handleNorthwindList());
                    return new Result("ok", out);
                }
                case "info": {
                    String out = ServicesManager.captureOutput(() -> ServicesManager.handleNorthwindInfo(managerArgsString));
                    String status = out.contains("Status:    RUNNING") ? "running" : (out.contains("is not running") ? "stopped" : "ok");
                    return new Result(status, out);
                }
                case "query": {
                    String out = ServicesManager.captureOutput(() -> ServicesManager.handleNorthwindQuery(managerArgsString));
                    String status = out.toLowerCase().contains("error") ? "error" : "ok";
                    return new Result(status, out);
                }
            }
            return new Result("error", "Unknown database command: " + subCmd);
        }
        if (tokens[0].equalsIgnoreCase(APP_FAMILY)) {
            String subCmd = tokens[1].toLowerCase();
            String serviceName = tokens[2];
            String args = tokens.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(tokens, 3, tokens.length)) : "";
            switch (subCmd) {
                case "start": {
                    String out = ServicesManager.captureOutput(() -> ServicesManager.handleAppStart(serviceName, args));
                    String status = out.contains("\u2713") ? "running" : (out.contains("\u2717") ? "error" : "running");
                    return new Result(status, out);
                }
                case "stop": {
                    String out = ServicesManager.captureOutput(() -> ServicesManager.handleAppStop(serviceName, args));
                    return new Result("stopped", out);
                }
            }
            return new Result("error", "Unknown app command: " + subCmd);
        }
        return new Result("error", "Unknown family or command: " + tokens[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String captureOutput(ThrowableRunnable action) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream original = System.out;
        PrintStream ps = new PrintStream(baos);
        try {
            System.setOut(ps);
            action.run();
        }
        finally {
            System.setOut(original);
            ps.close();
        }
        return baos.toString();
    }

    private static void handleNorthwindStart(String managerArgsString) throws Exception {
        String[] parts = managerArgsString.split("\\s+");
        String vendorName = parts[0].toUpperCase();
        String customPath = null;
        Integer customPort = null;
        if (parts.length > 1) {
            boolean isNumeric = parts[1].matches("\\d+");
            if (isNumeric) {
                customPort = Integer.parseInt(parts[1]);
            } else {
                customPath = parts[1];
                if (parts.length > 2) {
                    customPort = Integer.parseInt(parts[2]);
                }
            }
        }
        NorthwindManager.DatabaseVendor vendor = NorthwindManager.DatabaseVendor.valueOf(vendorName);
        dbManager.startDatabase(vendor, customPath, customPort);
    }

    private static void handleNorthwindStop(String managerArgsString) throws Exception {
        String vendorName = managerArgsString.split("\\s+")[0].toUpperCase();
        NorthwindManager.DatabaseVendor vendor = NorthwindManager.DatabaseVendor.valueOf(vendorName);
        dbManager.stopDatabase(vendor);
    }

    private static void handleNorthwindList() throws Exception {
        for (NorthwindManager.DatabaseVendor vendor : NorthwindManager.DatabaseVendor.values()) {
            boolean running = dbManager.isRunning(vendor);
            if (!running) continue;
            dbManager.getDatabaseVersion(vendor);
        }
    }

    private static void handleNorthwindInfo(String managerArgsString) throws Exception {
        block14: {
            String vendorName = managerArgsString.split("\\s+")[0].toUpperCase();
            NorthwindManager.DatabaseVendor vendor = NorthwindManager.DatabaseVendor.valueOf(vendorName);
            if (!dbManager.isRunning(vendor)) {
                return;
            }
            dbManager.getActualDataPath(vendor);
            dbManager.getActualHostPort(vendor);
            dbManager.getJdbcUrl(vendor);
            dbManager.getUsername(vendor);
            dbManager.getPassword(vendor);
            dbManager.getDatabaseVersion(vendor);
            Map<String, String> jpaProps = dbManager.getJpaProperties(vendor, false);
            for (Map.Entry<String, String> entry : jpaProps.entrySet()) {
                if (!entry.getKey().startsWith("jakarta.persistence.jdbc") && !entry.getKey().startsWith("hibernate.dialect")) continue;
            }
            try (Connection conn = dbManager.getConnection(vendor);){
                if (conn == null) break block14;
                try (Statement stmt = conn.createStatement();){
                    ServicesManager.printDatabaseStats(vendor, conn, stmt);
                }
            }
        }
    }

    private static void handleNorthwindQuery(String managerArgsString) throws Exception {
        block22: {
            String[] parts = managerArgsString.split("\\s+", 2);
            String vendorName = parts[0].toUpperCase();
            String sql = parts[1].trim();
            NorthwindManager.DatabaseVendor vendor = NorthwindManager.DatabaseVendor.valueOf(vendorName);
            if (!dbManager.isRunning(vendor)) {
                return;
            }
            try (Connection conn = dbManager.getConnection(vendor);){
                if (conn == null) {
                    return;
                }
                try (Statement stmt = conn.createStatement();){
                    boolean isQuery = stmt.execute(sql);
                    if (isQuery) {
                        try (ResultSet rs = stmt.getResultSet();){
                            ServicesManager.printResultSet(rs);
                            break block22;
                        }
                    }
                    stmt.getUpdateCount();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void printDatabaseStats(NorthwindManager.DatabaseVendor vendor, Connection conn, Statement stmt) throws Exception {
        tableQuery = null;
        switch (1.$SwitchMap$com$sourcekraft$documentburster$common$db$northwind$NorthwindManager$DatabaseVendor[vendor.ordinal()]) {
            case 1: {
                tableQuery = "SELECT table_name, num_rows FROM user_tables ORDER BY table_name";
                break;
            }
            case 2: {
                tableQuery = "SELECT t.name AS table_name, p.rows AS num_rows FROM sys.tables t JOIN sys.schemas s ON t.schema_id = s.schema_id JOIN sys.partitions p ON t.object_id = p.object_id WHERE p.index_id IN (0, 1) AND s.name = SCHEMA_NAME() ORDER BY t.name";
                break;
            }
            case 3: {
                tableQuery = "SELECT tabname AS table_name, card AS num_rows FROM syscat.tables WHERE tabschema = CURRENT SCHEMA ORDER BY tabname";
                break;
            }
            case 4: {
                tableQuery = "SELECT tablename AS table_name, COALESCE(n_live_tup, 0) AS num_rows FROM pg_stat_user_tables WHERE schemaname = current_schema() ORDER BY tablename";
                break;
            }
            case 5: 
            case 6: {
                tableQuery = "SELECT table_name, table_rows AS num_rows FROM information_schema.tables WHERE table_schema = DATABASE() ORDER BY table_name";
                break;
            }
            case 7: {
                rs = stmt.executeQuery("SELECT name FROM sqlite_master WHERE type='table' AND name NOT LIKE 'sqlite_%' ORDER BY name");
lbl20:
                // 3 sources

                try {
                    while (rs.next()) {
                        tableName = rs.getString(1);
                        countStmt = conn.createStatement();
                        try {
                            countRs = countStmt.executeQuery("SELECT COUNT(*) FROM \"" + tableName + "\"");
                            try {
                                if (!countRs.next()) continue;
                                countRs.getLong(1);
                            }
                            finally {
                                if (countRs == null) ** GOTO lbl20
                                countRs.close();
                            }
                        }
                        finally {
                            if (countStmt == null) ** GOTO lbl20
                            countStmt.close();
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
        rs = stmt.executeQuery(tableQuery);
        try {
            while (rs.next()) {
                rs.getString("table_name");
                rs.getLong("num_rows");
                if (!rs.wasNull()) continue;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private static void printResultSet(ResultSet rs) throws Exception {
        int i;
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        int[] columnWidths = new int[columnCount];
        for (int i2 = 1; i2 <= columnCount; ++i2) {
            columnWidths[i2 - 1] = metaData.getColumnLabel(i2).length();
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        while (rs.next()) {
            String[] row = new String[columnCount];
            for (i = 1; i <= columnCount; ++i) {
                String value = rs.getString(i);
                row[i - 1] = value = value == null ? "NULL" : value;
                columnWidths[i - 1] = Math.max(columnWidths[i - 1], value.length());
            }
            rows.add(row);
        }
        int MAX_COL_WIDTH = 40;
        for (i = 0; i < columnWidths.length; ++i) {
            columnWidths[i] = Math.min(columnWidths[i], 40);
        }
        for (i = 1; i <= columnCount; ++i) {
        }
        if (!rows.isEmpty()) {
            for (String[] row : rows) {
                for (int i3 = 0; i3 < columnCount; ++i3) {
                    String value = row[i3];
                    if (value.length() <= columnWidths[i3]) continue;
                    value = value.substring(0, columnWidths[i3] - 3) + "...";
                }
            }
        }
    }

    private static void handleAppStart(String serviceName, String args) throws Exception {
        ServicesManager.ensurePortableAppsConfig();
        String composePath = ServicesManager.getComposePath(serviceName);
        log.info("PORTABLE_EXECUTABLE_DIR (system property)='{}', env='{}', Utils.getPortableExecutableDir='{}'", new Object[]{System.getProperty("PORTABLE_EXECUTABLE_DIR"), System.getenv("PORTABLE_EXECUTABLE_DIR"), Utils.getPortableExecutableDir()});
        log.info("handleAppStart: composePath='{}' | process.cwd='{}'", (Object)composePath, (Object)Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
        Path composeFilePathCheck = Paths.get(composePath, new String[0]);
        Path workingDirCheck = composeFilePathCheck.getParent();
        Path absWorkingDir = workingDirCheck.isAbsolute() ? workingDirCheck : Paths.get(".", new String[0]).toAbsolutePath().resolve(workingDirCheck).normalize();
        boolean composeExists = Files.exists(absWorkingDir.resolve(composeFilePathCheck.getFileName()), new LinkOption[0]);
        log.info("Resolved workingDir absolute='{}' | compose file exists='{}'", (Object)absWorkingDir.toString(), (Object)composeExists);
        boolean testgroundE2eAppsExists = Files.exists(Paths.get(".", new String[0]).toAbsolutePath().resolve("testground").resolve("e2e").resolve("_apps"), new LinkOption[0]);
        boolean testgroundAppsExists = Files.exists(Paths.get(".", new String[0]).toAbsolutePath().resolve("testground").resolve("_apps"), new LinkOption[0]);
        log.info("testground/e2e/_apps exists='{}' | testground/_apps exists='{}'", (Object)testgroundE2eAppsExists, (Object)testgroundAppsExists);
        Path composeFilePath = Paths.get(composePath, new String[0]);
        Path workingDir = composeFilePath.getParent();
        String composeFileName = composeFilePath.getFileName().toString();
        String customPort = null;
        boolean shouldBuild = false;
        boolean noCache = false;
        boolean enableLiquibase = false;
        boolean enableFull = false;
        boolean forceRecreate = false;
        boolean reprovision = false;
        if (args != null && !args.trim().isEmpty()) {
            String[] argParts;
            for (String part : argParts = args.trim().split("\\s+")) {
                if (part.matches("\\d+")) {
                    customPort = part;
                    continue;
                }
                if (part.equalsIgnoreCase("--build")) {
                    shouldBuild = true;
                    continue;
                }
                if (part.equalsIgnoreCase("--no-cache")) {
                    noCache = true;
                    continue;
                }
                if (part.equalsIgnoreCase("--liquibase")) {
                    enableLiquibase = true;
                    continue;
                }
                if (part.equalsIgnoreCase("--full")) {
                    enableFull = true;
                    noCache = true;
                    continue;
                }
                if (part.equalsIgnoreCase("--force-recreate")) {
                    forceRecreate = true;
                    continue;
                }
                if (!part.equalsIgnoreCase("--rebuild-theme") && !part.equalsIgnoreCase("--theme-rebuild") && !part.equalsIgnoreCase("--reprovision")) continue;
                reprovision = true;
            }
        }
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        if (customPort != null) {
            env.put("HOST_PORT", customPort);
            log.info("Using custom HOST_PORT={}", customPort);
        }
        if (enableLiquibase) {
            env.put("ENABLE_LIQUIBASE_GROOVY_MIGRATIONS", "true");
            env.put("DB_CREATE", "none");
            env.put("DDL_AUTO", "none");
            log.info("Enabling Liquibase Groovy migrations: ENABLE_LIQUIBASE_GROOVY_MIGRATIONS=true, DB_CREATE=none, DDL_AUTO=none");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("docker");
        command.add("compose");
        command.add("-f");
        command.add(composeFileName);
        command.add("up");
        if (shouldBuild) {
            command.add("--build");
            log.info("Using --build flag to rebuild image");
        }
        command.add("-d");
        command.add("--remove-orphans");
        command.add("--force-recreate");
        if (reprovision) {
            log.info("Reprovision requested for {} in {}", (Object)serviceName, (Object)workingDir);
            env.put("FORCE_BUILD", "true");
            ArrayList<String> helperCmd = new ArrayList<String>();
            helperCmd.add("docker");
            helperCmd.add("compose");
            helperCmd.add("-f");
            helperCmd.add(composeFileName);
            helperCmd.add("run");
            helperCmd.add("--rm");
            helperCmd.add("cms-webportal-playground-cli");
            helperCmd.add("sh");
            helperCmd.add("-c");
            helperCmd.add("rm -f /var/www/html/.provisioned || true && wp option delete reportburster_demo_data_provisioned --allow-root || true");
            try {
                log.info("Running cms-webportal-playground-cli for reprovision cleanup: {}", helperCmd);
                ProcessResult helperResult = new ProcessExecutor().command(helperCmd).directory(workingDir.toFile()).redirectOutput((OutputStream)Slf4jStream.of((Logger)log).asInfo()).redirectError((OutputStream)Slf4jStream.of((Logger)log).asInfo()).timeout(600L, TimeUnit.SECONDS).environment(env).execute();
                log.info("Reprovision cleanup exit code: {}", (Object)helperResult.getExitValue());
            }
            catch (Exception e) {
                log.warn("Failed to run reprovision cleanup: {}", (Object)e.getMessage());
            }
        }
        String normalizedServiceName = serviceName == null ? "" : serviceName.trim();
        log.info("handleAppStart: serviceName='{}' | normalized='{}'", (Object)serviceName, (Object)normalizedServiceName);
        if (!normalizedServiceName.equals("cms-webportal-playground")) {
            command.add(serviceName);
        } else {
            log.info("Starting full compose for cms-webportal-playground (letting compose orchestrate all dependent services)");
        }
        if (enableFull) {
            log.info("Running docker compose down --remove-orphans --rmi local first (full mode)");
            ArrayList<String> downCmd = new ArrayList<String>();
            downCmd.add("docker");
            downCmd.add("compose");
            downCmd.add("-f");
            downCmd.add(composeFileName);
            downCmd.add("down");
            downCmd.add("--remove-orphans");
            downCmd.add("--rmi");
            downCmd.add("local");
            ProcessExecutor downExecutor = new ProcessExecutor().command(downCmd).directory(workingDir.toFile()).redirectOutput((OutputStream)Slf4jStream.of((Logger)log).asInfo()).redirectError((OutputStream)Slf4jStream.of((Logger)log).asInfo()).timeout(300L, TimeUnit.SECONDS).environment(env);
            log.info("Executing down command (full mode): {} in directory: {}", downCmd, (Object)workingDir);
            ProcessResult downResult = downExecutor.execute();
            log.info("Down command exit code: {}", (Object)downResult.getExitValue());
            if (downResult.getExitValue() != 0) {
                System.out.println("\u2717 Failed to run docker compose down for full mode. Exit code: " + downResult.getExitValue());
            }
        }
        if (noCache) {
            log.info("Running docker compose build --no-cache first");
            ArrayList<String> buildCommand = new ArrayList<String>();
            buildCommand.add("docker");
            buildCommand.add("compose");
            buildCommand.add("-f");
            buildCommand.add(composeFileName);
            buildCommand.add("build");
            buildCommand.add("--no-cache");
            String buildTarget = serviceName;
            buildCommand.add(buildTarget);
            ProcessExecutor buildExecutor = new ProcessExecutor().command(buildCommand).directory(workingDir.toFile()).redirectOutput((OutputStream)Slf4jStream.of((Logger)log).asInfo()).redirectError((OutputStream)Slf4jStream.of((Logger)log).asInfo()).timeout(7200L, TimeUnit.SECONDS).environment(env);
            log.info("Executing build command: {} in directory: {}", buildCommand, (Object)workingDir);
            ProcessResult buildResult = buildExecutor.execute();
            if (buildResult.getExitValue() != 0) {
                System.out.println("\u2717 Failed to build app '" + serviceName + "' with --no-cache. Exit code: " + buildResult.getExitValue());
                return;
            }
        }
        log.info("Executing command: {} in directory: {}", command, (Object)workingDir);
        ProcessExecutor executor = new ProcessExecutor().command(command).directory(workingDir.toFile()).redirectOutput((OutputStream)Slf4jStream.of((Logger)log).asInfo()).redirectError((OutputStream)Slf4jStream.of((Logger)log).asInfo()).timeout(7200L, TimeUnit.SECONDS).environment(env);
        ProcessResult result = executor.execute();
        log.info("Command exit code: {}", (Object)result.getExitValue());
        if (result.getExitValue() == 0) {
            System.out.println("\u2713 App '" + serviceName + "' started successfully.");
        } else {
            System.out.println("\u2717 Failed to start app '" + serviceName + "'. Exit code: " + result.getExitValue());
        }
    }

    private static void ensurePortableAppsConfig() throws Exception {
        String portableDir = Utils.getPortableExecutableDir();
        if (StringUtils.isBlank((CharSequence)portableDir)) {
            return;
        }
        Path pedpPath = Paths.get(portableDir, new String[0]).resolve("config").resolve("_internal").resolve(".pedp-apps");
        if (Files.exists(pedpPath, new LinkOption[0])) {
            return;
        }
        Path appsDir = Paths.get(portableDir, new String[0]).resolve("_apps");
        Path flowkraftEnv = appsDir.resolve("flowkraft").resolve(".env");
        Path cmsEnv = appsDir.resolve("cms-webportal-playground").resolve(".env");
        String newLine = "PORTABLE_EXECUTABLE_DIR_PATH=" + portableDir;
        Consumer<Path> updateEnv = path -> {
            try {
                List<Object> lines = new ArrayList();
                if (Files.exists(path, new LinkOption[0])) {
                    lines = Files.readAllLines(path);
                    boolean replaced = false;
                    for (int i = 0; i < lines.size(); ++i) {
                        String l = (String)lines.get(i);
                        if (!l.startsWith("PORTABLE_EXECUTABLE_DIR_PATH=")) continue;
                        lines.set(i, newLine);
                        replaced = true;
                        break;
                    }
                    if (!replaced) {
                        lines.add(newLine);
                    }
                } else {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    lines.add(newLine);
                }
                Files.write(path, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception e) {
                System.err.println("Failed to update env file " + path + " : " + e.getMessage());
            }
        };
        updateEnv.accept(flowkraftEnv);
        updateEnv.accept(cmsEnv);
        try {
            Files.createDirectories(pedpPath.getParent(), new FileAttribute[0]);
            Files.write(pedpPath, Collections.singletonList(""), StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            System.err.println("Failed to create .pedp-apps marker: " + e.getMessage());
        }
    }

    private static void handleAppStop(String serviceName, String args) throws Exception {
        String composePath = ServicesManager.getComposePath(serviceName);
        log.info("handleAppStop: composePath='{}' | jvm.cwd='{}'", (Object)composePath, (Object)System.getProperty("user.dir"));
        Path composeFilePath = Paths.get(composePath, new String[0]);
        Path workingDir = composeFilePath.getParent();
        String composeFileName = composeFilePath.getFileName().toString();
        boolean removeVolumes = false;
        if (args != null && !args.trim().isEmpty()) {
            String[] parts;
            for (String p : parts = args.trim().split("\\s+")) {
                if (!p.equalsIgnoreCase("--volumes") && !p.equalsIgnoreCase("-v") && !p.equalsIgnoreCase("--remove-volumes")) continue;
                removeVolumes = true;
                break;
            }
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("docker");
        command.add("compose");
        command.add("-f");
        command.add(composeFileName);
        command.add("down");
        command.add("--remove-orphans");
        if (removeVolumes) {
            command.add("--volumes");
        }
        ProcessExecutor executor = new ProcessExecutor().command(command).directory(workingDir.toFile()).redirectOutput((OutputStream)Slf4jStream.of((Logger)log).asInfo()).redirectError((OutputStream)Slf4jStream.of((Logger)log).asInfo()).timeout(300L, TimeUnit.SECONDS);
        ProcessResult result = executor.execute();
        log.info("Command exit code: {}", (Object)result.getExitValue());
        if (result.getExitValue() == 0) {
            System.out.println("\u2713 App '" + serviceName + "' stopped successfully.");
        } else {
            System.out.println("\u2717 Failed to stop app '" + serviceName + "'. Exit code: " + result.getExitValue());
        }
    }

    private static String getComposePath(String serviceName) {
        String appsFolderPath = Utils.getAppsFolderPath();
        if (FLOWKRAFT_APPS.contains(serviceName)) {
            return appsFolderPath + "flowkraft/docker-compose.yml";
        }
        return appsFolderPath + serviceName + "/docker-compose.yml";
    }

    static {
        try {
            dbManager = new NorthwindManager();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize NorthwindManager", e);
        }
        FLOWKRAFT_APPS = List.of("admin-grails-playground", "bkend-boot-groovy-playground", "frend-grails-playground");
    }

    public static class Result {
        public final String status;
        public final String output;

        public Result(String status, String output) {
            this.status = status;
            this.output = output;
        }
    }

    @FunctionalInterface
    private static interface ThrowableRunnable {
        public void run() throws Exception;
    }
}

