/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelCrossType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.TimeFrame;
import org.apache.calcite.rel.type.TimeFrameSet;
import org.apache.calcite.rel.type.TimeFrames;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Feature;
import org.apache.calcite.runtime.ImmutablePairList;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAccessEnum;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlAsofJoin;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLambda;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchFunction;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlOverOperator;
import org.apache.calcite.sql.SqlPivot;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.SqlUnknownLiteral;
import org.apache.calcite.sql.SqlUnpivot;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.TableCharacteristic;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.AssignableOperandTypeChecker;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.IdPair;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.AggFinder;
import org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.AliasNamespace;
import org.apache.calcite.sql.validate.CatalogScope;
import org.apache.calcite.sql.validate.CollectNamespace;
import org.apache.calcite.sql.validate.CollectScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.EmptyScope;
import org.apache.calcite.sql.validate.FieldNamespace;
import org.apache.calcite.sql.validate.FilterRequirement;
import org.apache.calcite.sql.validate.GroupByScope;
import org.apache.calcite.sql.validate.IdentifierNamespace;
import org.apache.calcite.sql.validate.JoinNamespace;
import org.apache.calcite.sql.validate.JoinScope;
import org.apache.calcite.sql.validate.LambdaNamespace;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.MatchRecognizeNamespace;
import org.apache.calcite.sql.validate.MatchRecognizeScope;
import org.apache.calcite.sql.validate.MeasureScope;
import org.apache.calcite.sql.validate.OrderByScope;
import org.apache.calcite.sql.validate.OverScope;
import org.apache.calcite.sql.validate.ParameterScope;
import org.apache.calcite.sql.validate.PivotNamespace;
import org.apache.calcite.sql.validate.PivotScope;
import org.apache.calcite.sql.validate.ProcedureNamespace;
import org.apache.calcite.sql.validate.ScopeChild;
import org.apache.calcite.sql.validate.SelectNamespace;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SetopNamespace;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlIdentifierMoniker;
import org.apache.calcite.sql.validate.SqlLambdaScope;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlScopedShuttle;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql.validate.TableConstructorNamespace;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.sql.validate.TableScope;
import org.apache.calcite.sql.validate.UnnestNamespace;
import org.apache.calcite.sql.validate.UnpivotNamespace;
import org.apache.calcite.sql.validate.UnpivotScope;
import org.apache.calcite.sql.validate.WithItemNamespace;
import org.apache.calcite.sql.validate.WithNamespace;
import org.apache.calcite.sql.validate.WithRecursiveScope;
import org.apache.calcite.sql.validate.WithScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apiguardian.api.API;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;

public class SqlValidatorImpl
implements SqlValidatorWithHints {
    public static final Logger TRACER = CalciteTrace.PARSER_LOGGER;
    public static final String UPDATE_SRC_ALIAS = "SYS$SRC";
    public static final String UPDATE_TGT_ALIAS = "SYS$TGT";
    public static final String UPDATE_ANON_PREFIX = "SYS$ANON";
    private final SqlOperatorTable opTab;
    final SqlValidatorCatalogReader catalogReader;
    protected final Map<String, IdInfo> idPositions = new HashMap<String, IdInfo>();
    protected final IdentityHashMap<SqlNode, SqlValidatorScope> scopes = new IdentityHashMap();
    private final Map<IdPair<SqlSelect, Clause>, SqlValidatorScope> clauseScopes = new HashMap<IdPair<SqlSelect, Clause>, SqlValidatorScope>();
    private @Nullable TableScope tableScope = null;
    protected final IdentityHashMap<SqlNode, SqlValidatorNamespace> namespaces = new IdentityHashMap();
    private final Set<SqlNode> cursorSet = Sets.newIdentityHashSet();
    protected final Deque<FunctionParamInfo> functionCallStack = new ArrayDeque<FunctionParamInfo>();
    private int nextGeneratedId;
    protected final RelDataTypeFactory typeFactory;
    protected final RelDataType unknownType;
    private final RelDataType booleanType;
    protected final TimeFrameSet timeFrameSet;
    private final IdentityHashMap<SqlNode, RelDataType> nodeToTypeMap = new IdentityHashMap();
    public final IdentityHashMap<SqlCall, List<RelDataType>> callToOperandTypesMap = new IdentityHashMap();
    private final AggFinder aggFinder;
    private final AggFinder aggOrOverFinder;
    private final AggFinder aggOrOverOrGroupFinder;
    private final AggFinder groupFinder;
    private final AggFinder overFinder;
    private SqlValidator.Config config;
    private final Map<SqlNode, SqlNode> originalExprs = new HashMap<SqlNode, SqlNode>();
    private @Nullable SqlNode top;
    private boolean validatingSqlMerge;
    private boolean inWindow;
    private final ValidationErrorFunction validationErrorFunction = new ValidationErrorFunction();
    private final TypeCoercion typeCoercion;

    protected SqlValidatorImpl(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlValidator.Config config) {
        TypeCoercion typeCoercion;
        this.opTab = Objects.requireNonNull(opTab, "opTab");
        this.catalogReader = Objects.requireNonNull(catalogReader, "catalogReader");
        this.typeFactory = Objects.requireNonNull(typeFactory, "typeFactory");
        RelDataTypeSystem typeSystem = typeFactory.getTypeSystem();
        this.timeFrameSet = Objects.requireNonNull(typeSystem.deriveTimeFrameSet(TimeFrames.CORE), "timeFrameSet");
        this.config = Objects.requireNonNull(config, "config");
        this.unknownType = typeFactory.createTypeWithNullability(typeFactory.createUnknownType(), true);
        this.booleanType = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        SqlNameMatcher nameMatcher = catalogReader.nameMatcher();
        this.aggFinder = new AggFinder(opTab, false, true, false, null, nameMatcher);
        this.aggOrOverFinder = new AggFinder(opTab, true, true, false, null, nameMatcher);
        this.overFinder = new AggFinder(opTab, true, false, false, this.aggOrOverFinder, nameMatcher);
        this.groupFinder = new AggFinder(opTab, false, false, true, null, nameMatcher);
        this.aggOrOverOrGroupFinder = new AggFinder(opTab, true, true, true, null, nameMatcher);
        this.typeCoercion = typeCoercion = config.typeCoercionFactory().create(typeFactory, this);
        if (config.conformance().allowLenientCoercion()) {
            SqlTypeCoercionRule rules = Util.first(config.typeCoercionRules(), SqlTypeCoercionRule.instance());
            ImmutableSet arrayMapping = ImmutableSet.builder().addAll((Iterable)rules.getTypeMapping().getOrDefault((Object)SqlTypeName.ARRAY, (ImmutableSet<SqlTypeName>)ImmutableSet.of())).add((Object)SqlTypeName.VARCHAR).add((Object)SqlTypeName.CHAR).build();
            HashMap<SqlTypeName, ImmutableSet<SqlTypeName>> mapping = new HashMap<SqlTypeName, ImmutableSet<SqlTypeName>>(rules.getTypeMapping());
            mapping.replace(SqlTypeName.ARRAY, (ImmutableSet<SqlTypeName>)arrayMapping);
            SqlTypeCoercionRule rules2 = SqlTypeCoercionRule.instance(mapping);
            SqlTypeCoercionRule.THREAD_PROVIDERS.set(rules2);
        } else if (config.typeCoercionRules() != null) {
            SqlTypeCoercionRule.THREAD_PROVIDERS.set(config.typeCoercionRules());
        }
    }

    public SqlConformance getConformance() {
        return this.config.conformance();
    }

    @Override
    @Pure
    public SqlValidatorCatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    @Pure
    public SqlOperatorTable getOperatorTable() {
        return this.opTab;
    }

    @Override
    @Pure
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public RelDataType getUnknownType() {
        return this.unknownType;
    }

    @Override
    public TimeFrameSet getTimeFrameSet() {
        return this.timeFrameSet;
    }

    @Override
    public SqlNodeList expandStar(SqlNodeList selectList, SqlSelect select, boolean includeSystemVars) {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        PairList<String, RelDataType> types = PairList.of();
        for (SqlNode selectItem : selectList) {
            RelDataType originalType = this.getValidatedNodeTypeIfKnown(selectItem);
            this.expandSelectItem(selectItem, select, Util.first(originalType, this.unknownType), list, this.catalogReader.nameMatcher().createSet(), types, includeSystemVars);
        }
        this.getRawSelectScopeNonNull(select).setExpandedSelectList(list);
        return new SqlNodeList(list, SqlParserPos.ZERO);
    }

    @Override
    public void declareCursor(SqlSelect select, SqlValidatorScope parentScope) {
        this.cursorSet.add(select);
        FunctionParamInfo funcParamInfo = Objects.requireNonNull(this.functionCallStack.peek(), "functionCall");
        Map<Integer, SqlSelect> cursorMap = funcParamInfo.cursorPosToSelectMap;
        int cursorCount = cursorMap.size();
        cursorMap.put(cursorCount, select);
        SelectScope cursorScope = new SelectScope(parentScope, this.getEmptyScope(), select);
        this.clauseScopes.put(IdPair.of(select, Clause.CURSOR), cursorScope);
        SelectNamespace selectNs = this.createSelectNamespace(select, select);
        String alias = SqlValidatorUtil.alias(select, this.nextGeneratedId++);
        this.registerNamespace(cursorScope, alias, selectNs, false);
    }

    @Override
    public void pushFunctionCall() {
        FunctionParamInfo funcInfo = new FunctionParamInfo();
        this.functionCallStack.push(funcInfo);
    }

    @Override
    public void popFunctionCall() {
        this.functionCallStack.pop();
    }

    @Override
    public @Nullable String getParentCursor(String columnListParamName) {
        FunctionParamInfo funcParamInfo = Objects.requireNonNull(this.functionCallStack.peek(), "functionCall");
        Map<String, String> parentCursorMap = funcParamInfo.columnListParamToParentCursorMap;
        return parentCursorMap.get(columnListParamName);
    }

    private boolean expandSelectItem(SqlNode selectItem, SqlSelect select, RelDataType targetType, List<SqlNode> selectItems, Set<String> aliases, PairList<String, RelDataType> fields, boolean includeSystemVars) {
        String newAlias;
        SqlNode expanded;
        SqlValidatorScope selectScope;
        if (SqlValidatorUtil.isMeasure(selectItem)) {
            selectScope = this.getMeasureScope(select);
            expanded = selectItem;
        } else {
            SelectScope scope = (SelectScope)this.getWhereScope(select);
            if (this.expandStar(selectItems, aliases, fields, includeSystemVars, scope, selectItem)) {
                return true;
            }
            selectScope = this.getSelectScope(select);
            expanded = this.expandSelectExpr(selectItem, scope, select);
        }
        String alias = SqlValidatorUtil.alias(selectItem, aliases.size());
        if (expanded != selectItem && !Objects.equals(newAlias = SqlValidatorUtil.alias(expanded, aliases.size()), alias)) {
            expanded = SqlStdOperatorTable.AS.createCall(selectItem.getParserPosition(), expanded, new SqlIdentifier(alias, SqlParserPos.ZERO));
            this.deriveTypeImpl(selectScope, expanded);
        }
        selectItems.add(expanded);
        aliases.add(alias);
        this.inferUnknownTypes(targetType, selectScope, expanded);
        RelDataType type = this.deriveType(selectScope, expanded);
        if (selectScope instanceof AggregatingSelectScope) {
            type = Objects.requireNonNull(selectScope.nullifyType(SqlUtil.stripAs(expanded), type));
        }
        this.setValidatedNodeType(expanded, type);
        fields.add(alias, type);
        return false;
    }

    private static SqlNode expandExprFromJoin(SqlJoin join, SqlIdentifier identifier, SelectScope scope) {
        if (join.getConditionType() != JoinConditionType.USING) {
            return identifier;
        }
        Map<String, String> fieldAliases = SqlValidatorImpl.getFieldAliases(scope);
        for (String name : SqlIdentifier.simpleNames((SqlNodeList)SqlNonNullableAccessors.getCondition(join))) {
            if (!identifier.getSimple().equals(name)) continue;
            ArrayList<SqlIdentifier> qualifiedNode = new ArrayList<SqlIdentifier>();
            for (ScopeChild child : Objects.requireNonNull(scope, (String)"scope").children) {
                if (!child.namespace.getRowType().getFieldNames().contains(name)) continue;
                SqlIdentifier exp = new SqlIdentifier((List<String>)ImmutableList.of((Object)child.name, (Object)name), identifier.getParserPosition());
                qualifiedNode.add(exp);
            }
            assert (qualifiedNode.size() == 2);
            boolean haveAlias = fieldAliases.containsKey(name);
            SqlCall coalesceCall = SqlStdOperatorTable.COALESCE.createCall(SqlParserPos.ZERO, (SqlNode)qualifiedNode.get(0), (SqlNode)qualifiedNode.get(1));
            if (haveAlias) {
                return coalesceCall;
            }
            return SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, coalesceCall, new SqlIdentifier(name, SqlParserPos.ZERO));
        }
        SqlNode node = join.getLeft();
        if (node instanceof SqlJoin) {
            return SqlValidatorImpl.expandExprFromJoin((SqlJoin)node, identifier, scope);
        }
        return identifier;
    }

    private static Map<String, String> getFieldAliases(SelectScope scope) {
        ImmutableMap.Builder fieldAliases = new ImmutableMap.Builder();
        for (SqlNode selectItem : scope.getNode().getSelectList()) {
            SqlCall call;
            if (!(selectItem instanceof SqlCall) || !((call = (SqlCall)selectItem).getOperator() instanceof SqlAsOperator) || !(call.operand(0) instanceof SqlIdentifier)) continue;
            SqlIdentifier fieldIdentifier = (SqlIdentifier)call.operand(0);
            fieldAliases.put((Object)fieldIdentifier.getSimple(), (Object)((SqlIdentifier)call.operand(1)).getSimple());
        }
        return fieldAliases.build();
    }

    public @Nullable List<String> usingNames(SqlJoin join) {
        switch (join.getConditionType()) {
            case USING: {
                SqlNodeList condition = (SqlNodeList)SqlNonNullableAccessors.getCondition(join);
                List<String> simpleNames = SqlIdentifier.simpleNames(condition);
                return this.catalogReader.nameMatcher().distinctCopy(simpleNames);
            }
            case NONE: {
                if (join.isNatural()) {
                    return this.deriveNaturalJoinColumnList(join);
                }
                return null;
            }
        }
        return null;
    }

    private List<String> deriveNaturalJoinColumnList(SqlJoin join) {
        return SqlValidatorUtil.deriveNaturalJoinColumnList(this.catalogReader.nameMatcher(), this.getNamespaceOrThrow(join.getLeft()).getRowType(), this.getNamespaceOrThrow(join.getRight()).getRowType());
    }

    private static SqlNode expandCommonColumn(SqlSelect sqlSelect, SqlNode selectItem, SelectScope scope, SqlValidatorImpl validator) {
        if (!(selectItem instanceof SqlIdentifier)) {
            return selectItem;
        }
        SqlNode from = sqlSelect.getFrom();
        if (!(from instanceof SqlJoin)) {
            return selectItem;
        }
        SqlIdentifier identifier = (SqlIdentifier)selectItem;
        if (!identifier.isSimple()) {
            if (!validator.config().conformance().allowQualifyingCommonColumn()) {
                SqlValidatorImpl.validateQualifiedCommonColumn((SqlJoin)from, identifier, scope, validator);
            }
            return selectItem;
        }
        return SqlValidatorImpl.expandExprFromJoin((SqlJoin)from, identifier, scope);
    }

    private static void validateQualifiedCommonColumn(SqlJoin join, SqlIdentifier identifier, SelectScope scope, SqlValidatorImpl validator) {
        List<String> names = validator.usingNames(join);
        if (names == null) {
            return;
        }
        for (ScopeChild child : scope.children) {
            if (!Objects.equals(child.name, identifier.getComponent(0).toString()) || !names.contains(identifier.getComponent(1).toString())) continue;
            throw validator.newValidationError(identifier, Static.RESOURCE.disallowsQualifyingCommonColumn(identifier.toString()));
        }
        SqlNode node = join.getLeft();
        if (node instanceof SqlJoin) {
            SqlValidatorImpl.validateQualifiedCommonColumn((SqlJoin)node, identifier, scope, validator);
        }
    }

    private boolean expandStar(List<SqlNode> selectItems, Set<String> aliases, PairList<String, RelDataType> fields, boolean includeSystemVars, SelectScope scope, SqlNode node) {
        if (!(node instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier identifier = (SqlIdentifier)node;
        if (!identifier.isStar()) {
            return false;
        }
        int originalSize = selectItems.size();
        SqlParserPos startPosition = identifier.getParserPosition();
        switch (identifier.names.size()) {
            case 1: {
                SqlNode from = scope.getNode().getFrom();
                if (from == null) {
                    throw this.newValidationError(identifier, Static.RESOURCE.selectStarRequiresFrom());
                }
                boolean hasDynamicStruct = false;
                for (ScopeChild child : scope.children) {
                    int before = fields.size();
                    if (child.namespace.getRowType().isDynamicStruct()) {
                        hasDynamicStruct = true;
                        SqlIdentifier exp = new SqlIdentifier((List<String>)ImmutableList.of((Object)child.name, (Object)"**"), startPosition);
                        this.addToSelectList(selectItems, aliases, fields, exp, scope, includeSystemVars);
                    } else {
                        SqlNode from2 = SqlNonNullableAccessors.getNode(child);
                        SqlValidatorNamespace fromNs = this.getNamespaceOrThrow(from2, (SqlValidatorScope)scope);
                        RelDataType rowType = fromNs.getRowType();
                        for (RelDataTypeField field : rowType.getFieldList()) {
                            String columnName = field.getName();
                            SqlIdentifier exp = new SqlIdentifier((List<String>)ImmutableList.of((Object)child.name, (Object)columnName), startPosition);
                            if (this.isRolledUpColumn(exp, scope)) continue;
                            this.addOrExpandField(selectItems, aliases, fields, includeSystemVars, scope, exp, field);
                        }
                    }
                    if (!child.nullable) continue;
                    for (int i = before; i < fields.size(); ++i) {
                        Map.Entry entry = (Map.Entry)fields.get(i);
                        RelDataType type = (RelDataType)entry.getValue();
                        if (type.isNullable()) continue;
                        fields.set(i, (String)entry.getKey(), this.typeFactory.createTypeWithNullability(type, true));
                    }
                }
                if (!hasDynamicStruct) {
                    int offset = Math.min(SqlValidatorImpl.calculatePermuteOffset(selectItems), originalSize);
                    new Permute(from, offset).permute(selectItems, fields);
                }
                return true;
            }
        }
        SqlIdentifier prefixId = identifier.skipLast(1);
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        SqlNameMatcher nameMatcher = scope.validator.catalogReader.nameMatcher();
        scope.resolve((List<String>)prefixId.names, nameMatcher, true, resolved);
        if (resolved.count() == 0) {
            throw this.newValidationError(prefixId, Static.RESOURCE.unknownIdentifier(prefixId.toString()));
        }
        RelDataType rowType = resolved.only().rowType();
        if (rowType.isDynamicStruct()) {
            this.addToSelectList(selectItems, aliases, fields, prefixId.plus("**", startPosition), scope, includeSystemVars);
        } else if (rowType.isStruct()) {
            for (RelDataTypeField field : rowType.getFieldList()) {
                String columnName = field.getName();
                this.addOrExpandField(selectItems, aliases, fields, includeSystemVars, scope, prefixId.plus(columnName, startPosition), field);
            }
        } else {
            throw this.newValidationError(prefixId, Static.RESOURCE.starRequiresRecordType());
        }
        return true;
    }

    private static int calculatePermuteOffset(List<SqlNode> selectItems) {
        for (int i = 0; i < selectItems.size(); ++i) {
            SqlNode selectItem = selectItems.get(i);
            SqlNode col = SqlUtil.stripAs(selectItem);
            if (col.getKind() != SqlKind.IDENTIFIER || selectItem.getKind() == SqlKind.AS) continue;
            return i;
        }
        return 0;
    }

    private SqlNode maybeCast(SqlNode node, RelDataType currentType, RelDataType desiredType) {
        return SqlTypeUtil.equalSansNullability(this.typeFactory, currentType, desiredType) ? node : SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, SqlTypeUtil.convertTypeToSpec(desiredType));
    }

    private boolean addOrExpandField(List<SqlNode> selectItems, Set<String> aliases, PairList<String, RelDataType> fields, boolean includeSystemVars, SelectScope scope, SqlIdentifier id, RelDataTypeField field) {
        switch (field.getType().getStructKind()) {
            case PEEK_FIELDS: 
            case PEEK_FIELDS_DEFAULT: {
                SqlIdentifier starExp = id.plusStar();
                this.expandStar(selectItems, aliases, fields, includeSystemVars, scope, starExp);
                return true;
            }
        }
        this.addToSelectList(selectItems, aliases, fields, id, scope, includeSystemVars);
        return false;
    }

    @Override
    public SqlNode validate(SqlNode topNode) {
        SqlValidatorScope scope = new EmptyScope(this);
        scope = new CatalogScope(scope, (List<String>)ImmutableList.of((Object)"CATALOG"));
        SqlNode topNode2 = this.validateScopedExpression(topNode, scope);
        RelDataType type = this.getValidatedNodeType(topNode2);
        Util.discard(type);
        return topNode2;
    }

    @Override
    public List<SqlMoniker> lookupHints(SqlNode topNode, SqlParserPos pos) {
        SqlValidatorNamespace ns;
        EmptyScope scope = new EmptyScope(this);
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        if ((ns = this.getNamespace(outermostNode)) == null) {
            throw new AssertionError((Object)("Not a query: " + outermostNode));
        }
        TreeSet hintList = Sets.newTreeSet(SqlMoniker.COMPARATOR);
        this.lookupSelectHints(ns, pos, (Collection<SqlMoniker>)hintList);
        return ImmutableList.copyOf((Collection)hintList);
    }

    @Override
    public @Nullable SqlMoniker lookupQualifiedName(SqlNode topNode, SqlParserPos pos) {
        String posString = pos.toString();
        IdInfo info = this.idPositions.get(posString);
        if (info != null) {
            SqlQualified qualified = info.scope.fullyQualify(info.id);
            return new SqlIdentifierMoniker(qualified.identifier);
        }
        return null;
    }

    void lookupSelectHints(SqlSelect select, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        IdInfo info = this.idPositions.get(pos.toString());
        if (info == null) {
            SqlNode fromNode = select.getFrom();
            SqlValidatorScope fromScope = this.getFromScope(select);
            this.lookupFromHints(fromNode, fromScope, pos, hintList);
        } else {
            this.lookupNameCompletionHints(info.scope, (List<String>)info.id.names, info.id.getParserPosition(), hintList);
        }
    }

    private void lookupSelectHints(SqlValidatorNamespace ns, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        SqlNode node = ns.getNode();
        if (node instanceof SqlSelect) {
            this.lookupSelectHints((SqlSelect)node, pos, hintList);
        }
    }

    private void lookupFromHints(@Nullable SqlNode node, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        if (node == null) {
            return;
        }
        SqlValidatorNamespace ns = this.getNamespaceOrThrow(node);
        if (ns.isWrapperFor(IdentifierNamespace.class)) {
            IdentifierNamespace idNs = ns.unwrap(IdentifierNamespace.class);
            SqlIdentifier id = idNs.getId();
            for (int i = 0; i < id.names.size(); ++i) {
                if (!pos.toString().equals(id.getComponent(i).getParserPosition().toString())) continue;
                ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
                SqlValidatorUtil.getSchemaObjectMonikers(this.getCatalogReader(), (List<String>)id.names.subList(0, i + 1), objNames);
                for (SqlMoniker objName : objNames) {
                    if (objName.getType() == SqlMonikerType.FUNCTION) continue;
                    hintList.add(objName);
                }
                return;
            }
        }
        switch (node.getKind()) {
            case JOIN: {
                this.lookupJoinHints((SqlJoin)node, scope, pos, hintList);
                break;
            }
            default: {
                this.lookupSelectHints(ns, pos, hintList);
            }
        }
    }

    private void lookupJoinHints(SqlJoin join, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlNode condition = join.getCondition();
        this.lookupFromHints(left, scope, pos, hintList);
        if (!hintList.isEmpty()) {
            return;
        }
        this.lookupFromHints(right, scope, pos, hintList);
        if (!hintList.isEmpty()) {
            return;
        }
        JoinConditionType conditionType = join.getConditionType();
        switch (conditionType) {
            case ON: {
                Objects.requireNonNull(condition, () -> "join.getCondition() for " + join).findValidOptions(this, this.getScopeOrThrow(join), pos, hintList);
                return;
            }
        }
    }

    public final void lookupNameCompletionHints(SqlValidatorScope scope, List<String> names, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        List<String> subNames = Util.skipLast(names);
        if (!subNames.isEmpty()) {
            RelDataType rowType;
            SqlValidatorNamespace ns = null;
            for (String name : subNames) {
                if (ns == null) {
                    SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
                    SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
                    scope.resolve((List<String>)ImmutableList.of((Object)name), nameMatcher, false, resolved);
                    if (resolved.count() == 1) {
                        ns = resolved.only().namespace;
                    }
                } else {
                    ns = ns.lookupChild(name);
                }
                if (ns != null) continue;
                break;
            }
            if (ns != null && (rowType = ns.getRowType()).isStruct()) {
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
            SqlValidatorImpl.findAllValidFunctionNames(names, this, hintList, pos);
        } else {
            scope.findAliases(hintList);
            SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(scope);
            if (selectScope != null && selectScope.getChildren().size() == 1) {
                RelDataType rowType = selectScope.getChildren().get(0).getRowType();
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
        }
        SqlValidatorImpl.findAllValidUdfNames(names, this, hintList);
    }

    private static void findAllValidUdfNames(List<String> names, SqlValidator validator, Collection<SqlMoniker> result) {
        ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
        SqlValidatorUtil.getSchemaObjectMonikers(validator.getCatalogReader(), names, objNames);
        for (SqlMoniker objName : objNames) {
            if (objName.getType() != SqlMonikerType.FUNCTION) continue;
            result.add(objName);
        }
    }

    private static void findAllValidFunctionNames(List<String> names, SqlValidator validator, Collection<SqlMoniker> result, SqlParserPos pos) {
        if (names.size() > 1) {
            return;
        }
        for (SqlOperator op : validator.getOperatorTable().getOperatorList()) {
            SqlIdentifier curOpId = new SqlIdentifier(op.getName(), pos);
            SqlCall call = validator.makeNullaryCall(curOpId);
            if (call != null) {
                result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
                continue;
            }
            if (op.getSyntax() != SqlSyntax.FUNCTION && op.getSyntax() != SqlSyntax.PREFIX) continue;
            if (op.getOperandTypeChecker() != null) {
                String sig = op.getAllowedSignatures();
                sig = sig.replace("'", "");
                result.add(new SqlMonikerImpl(sig, SqlMonikerType.FUNCTION));
                continue;
            }
            result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
        }
    }

    @Override
    public SqlNode validateParameterizedExpression(SqlNode topNode, Map<String, RelDataType> nameToTypeMap) {
        ParameterScope scope = new ParameterScope(this, nameToTypeMap);
        return this.validateScopedExpression(topNode, scope);
    }

    private SqlNode validateScopedExpression(SqlNode topNode, SqlValidatorScope scope) {
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        this.top = outermostNode;
        TRACER.trace("After unconditional rewrite: {}", (Object)outermostNode);
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        outermostNode.validate(this, scope);
        if (!outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.deriveType(scope, outermostNode);
        }
        TRACER.trace("After validation: {}", (Object)outermostNode);
        return outermostNode;
    }

    @Override
    public void validateQuery(SqlNode node, SqlValidatorScope scope, RelDataType targetRowType) {
        SqlValidatorNamespace ns = this.getNamespaceOrThrow(node, scope);
        if (node.getKind() == SqlKind.TABLESAMPLE) {
            List<SqlNode> operands = ((SqlCall)node).getOperandList();
            SqlSampleSpec sampleSpec = SqlLiteral.sampleValue(operands.get(1));
            if (sampleSpec instanceof SqlSampleSpec.SqlTableSampleSpec) {
                BigDecimal samplePercentage = ((SqlSampleSpec.SqlTableSampleSpec)sampleSpec).sampleRate;
                if (samplePercentage.compareTo(BigDecimal.ZERO) < 0 || samplePercentage.compareTo(BigDecimal.ONE) > 0) {
                    throw SqlUtil.newContextException(node.getParserPosition(), Static.RESOURCE.invalidSampleSize());
                }
                this.validateFeature(Static.RESOURCE.sQLFeature_T613(), node.getParserPosition());
            } else if (sampleSpec instanceof SqlSampleSpec.SqlSubstitutionSampleSpec) {
                this.validateFeature(Static.RESOURCE.sQLFeatureExt_T613_Substitution(), node.getParserPosition());
            }
        }
        this.validateNamespace(ns, targetRowType);
        switch (node.getKind()) {
            case EXTEND: {
                this.deriveType(Objects.requireNonNull(scope, "scope"), node);
                break;
            }
        }
        if (node == this.top && !this.config.embeddedQuery()) {
            this.validateModality(node);
        }
        this.validateAccess(node, ns.getTable(), SqlAccessEnum.SELECT);
        this.validateSnapshot(node, scope, ns);
    }

    protected void validateNamespace(SqlValidatorNamespace namespace, RelDataType targetRowType) {
        block4: {
            RelDataType type;
            SqlNode node;
            block5: {
                block7: {
                    FilterRequirement filterRequirement;
                    block6: {
                        namespace.validate(targetRowType);
                        node = namespace.getNode();
                        if (node == null) break block4;
                        type = namespace.getType();
                        if (node != this.top) break block5;
                        filterRequirement = namespace.getFilterRequirement();
                        if (!filterRequirement.filterFields.isEmpty()) break block6;
                        if (filterRequirement.remnantFilterFields.isEmpty()) break block7;
                    }
                    Stream<String> mustFilterStream = filterRequirement.filterFields.stream().mapToObj(namespace.getRowType().getFieldNames()::get);
                    Stream<String> remnantStream = filterRequirement.remnantFilterFields.stream().map(q -> q.suffix().get(0));
                    Set fieldNameSet = Stream.concat(mustFilterStream, remnantStream).collect(Collectors.toCollection(TreeSet::new));
                    throw this.newValidationError(node, Static.RESOURCE.mustFilterFieldsMissing(fieldNameSet.toString()));
                }
                if (!this.config.embeddedQuery()) {
                    type = SqlTypeUtil.fromMeasure(this.typeFactory, type);
                }
            }
            this.setValidatedNodeType(node, type);
        }
    }

    @Override
    public SqlValidatorScope getEmptyScope() {
        return new EmptyScope(this);
    }

    private SqlValidatorScope getScope(SqlSelect select, Clause clause) {
        return Objects.requireNonNull(this.clauseScopes.get(IdPair.of(select, clause)), () -> "no " + (Object)((Object)clause) + " scope for " + select);
    }

    public SqlValidatorScope getCursorScope(SqlSelect select) {
        return this.getScope(select, Clause.CURSOR);
    }

    @Override
    public SqlValidatorScope getWhereScope(SqlSelect select) {
        return this.getScope(select, Clause.WHERE);
    }

    @Override
    public SqlValidatorScope getSelectScope(SqlSelect select) {
        return this.getScope(select, Clause.SELECT);
    }

    @Override
    public SqlValidatorScope getMeasureScope(SqlSelect select) {
        return this.getScope(select, Clause.MEASURE);
    }

    @Override
    public @Nullable SelectScope getRawSelectScope(SqlSelect select) {
        SqlValidatorScope scope = this.clauseScopes.get(IdPair.of(select, Clause.SELECT));
        if (scope instanceof AggregatingSelectScope) {
            scope = ((AggregatingSelectScope)scope).getParent();
        }
        return (SelectScope)scope;
    }

    private SelectScope getRawSelectScopeNonNull(SqlSelect select) {
        return Objects.requireNonNull(this.getRawSelectScope(select), () -> "getRawSelectScope for " + select);
    }

    @Override
    public SqlValidatorScope getHavingScope(SqlSelect select) {
        return this.getScope(select, Clause.SELECT);
    }

    @Override
    public SqlValidatorScope getGroupScope(SqlSelect select) {
        return this.getScope(select, Clause.WHERE);
    }

    @Override
    public SqlValidatorScope getFromScope(SqlSelect select) {
        return Objects.requireNonNull(this.scopes.get(select), () -> "no scope for " + select);
    }

    @Override
    public SqlValidatorScope getOrderScope(SqlSelect select) {
        return this.getScope(select, Clause.ORDER);
    }

    @Override
    public SqlValidatorScope getMatchRecognizeScope(SqlMatchRecognize node) {
        return this.getScopeOrThrow(node);
    }

    @Override
    public SqlValidatorScope getLambdaScope(SqlLambda node) {
        return this.getScopeOrThrow(node);
    }

    @Override
    public SqlValidatorScope getJoinScope(SqlNode node) {
        return Objects.requireNonNull(this.scopes.get(SqlUtil.stripAs(node)), () -> "scope for " + node);
    }

    @Override
    public SqlValidatorScope getOverScope(SqlNode node) {
        return this.getScopeOrThrow(node);
    }

    @Override
    public SqlValidatorScope getWithScope(SqlNode withItem) {
        assert (withItem.getKind() == SqlKind.WITH_ITEM);
        return this.getScopeOrThrow(withItem);
    }

    private SqlValidatorScope getScopeOrThrow(SqlNode node) {
        return Objects.requireNonNull(this.scopes.get(node), () -> "scope for " + node);
    }

    private @Nullable SqlValidatorNamespace getNamespace(SqlNode node, SqlValidatorScope scope) {
        if (node instanceof SqlIdentifier && scope instanceof DelegatingScope) {
            SqlIdentifier id = (SqlIdentifier)node;
            DelegatingScope idScope = (DelegatingScope)((DelegatingScope)scope).getParent();
            return this.getNamespace(id, idScope);
        }
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            switch (call.getOperator().getKind()) {
                case TABLE_REF: {
                    return this.getNamespace((SqlNode)call.operand(0), scope);
                }
                case EXTEND: {
                    SqlNode operand0 = call.getOperandList().get(0);
                    SqlIdentifier identifier = operand0.getKind() == SqlKind.TABLE_REF ? (SqlIdentifier)((SqlCall)operand0).operand(0) : (SqlIdentifier)operand0;
                    DelegatingScope idScope = (DelegatingScope)scope;
                    return this.getNamespace(identifier, idScope);
                }
                case AS: {
                    SqlNode nested = call.getOperandList().get(0);
                    switch (nested.getKind()) {
                        case EXTEND: 
                        case TABLE_REF: {
                            return this.getNamespace(nested, scope);
                        }
                    }
                    break;
                }
            }
        }
        return this.getNamespace(node);
    }

    private @Nullable SqlValidatorNamespace getNamespace(SqlIdentifier id, @Nullable DelegatingScope scope) {
        if (id.isSimple()) {
            SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            Objects.requireNonNull(scope, () -> "scope needed to lookup " + id).resolve((List<String>)id.names, nameMatcher, false, resolved);
            if (resolved.count() == 1) {
                return resolved.only().namespace;
            }
        }
        return this.getNamespace(id);
    }

    @Override
    public @Nullable SqlValidatorNamespace getNamespace(SqlNode node) {
        switch (node.getKind()) {
            case AS: {
                SqlValidatorNamespace ns = this.namespaces.get(node);
                if (ns != null) {
                    return ns;
                }
            }
            case TABLE_REF: 
            case SNAPSHOT: 
            case OVER: 
            case COLLECTION_TABLE: 
            case ORDER_BY: 
            case TABLESAMPLE: {
                return this.getNamespace((SqlNode)((SqlCall)node).operand(0));
            }
        }
        return this.namespaces.get(node);
    }

    @API(since="1.27", status=API.Status.INTERNAL)
    SqlValidatorNamespace getNamespaceOrThrow(SqlNode node) {
        return Objects.requireNonNull(this.getNamespace(node), () -> "namespace for " + node);
    }

    @API(since="1.27", status=API.Status.INTERNAL)
    SqlValidatorNamespace getNamespaceOrThrow(SqlNode node, SqlValidatorScope scope) {
        return Objects.requireNonNull(this.getNamespace(node, scope), () -> "namespace for " + node + ", scope " + scope);
    }

    @API(since="1.26", status=API.Status.INTERNAL)
    SqlValidatorNamespace getNamespaceOrThrow(SqlIdentifier id, @Nullable DelegatingScope scope) {
        return Objects.requireNonNull(this.getNamespace(id, scope), () -> "namespace for " + id + ", scope " + scope);
    }

    private void handleOffsetFetch(@Nullable SqlNode offset, @Nullable SqlNode fetch) {
        if (offset instanceof SqlDynamicParam) {
            this.setValidatedNodeType(offset, this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        }
        if (fetch instanceof SqlDynamicParam) {
            this.setValidatedNodeType(fetch, this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        }
    }

    protected @PolyNull SqlNode performUnconditionalRewrites(@PolyNull SqlNode node, boolean underFrom) {
        if (node == null) {
            return null;
        }
        if (node instanceof SqlCall) {
            if (node instanceof SqlMerge) {
                this.validatingSqlMerge = true;
            }
            SqlCall call = (SqlCall)node;
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            for (int i = 0; i < operands.size(); ++i) {
                boolean childUnderFrom;
                SqlNode operand = operands.get(i);
                SqlNode newOperand = this.performUnconditionalRewrites(operand, childUnderFrom = kind == SqlKind.SELECT ? i == 2 : (kind == SqlKind.AS && i == 0 ? underFrom : false));
                if (newOperand == null || newOperand == operand) continue;
                call.setOperand(i, newOperand);
            }
            if (call.getOperator() instanceof SqlUnresolvedFunction) {
                assert (call instanceof SqlBasicCall);
                SqlUnresolvedFunction function = (SqlUnresolvedFunction)call.getOperator();
                ArrayList<SqlOperator> overloads = new ArrayList<SqlOperator>();
                this.opTab.lookupOperatorOverloads(function.getNameAsId(), function.getFunctionType(), SqlSyntax.FUNCTION, overloads, this.catalogReader.nameMatcher());
                if (overloads.size() == 1) {
                    ((SqlBasicCall)call).setOperator((SqlOperator)overloads.get(0));
                }
            }
            if (this.config.callRewrite()) {
                node = call.getOperator().rewriteCall(this, call);
            }
        } else if (node instanceof SqlNodeList) {
            SqlNodeList list = (SqlNodeList)node;
            for (int i = 0; i < list.size(); ++i) {
                SqlNode operand = list.get(i);
                SqlNode newOperand = this.performUnconditionalRewrites(operand, false);
                if (newOperand == null) continue;
                list.set(i, newOperand);
            }
        }
        SqlKind kind = node.getKind();
        switch (kind) {
            case VALUES: {
                return node;
            }
            case ORDER_BY: {
                SqlNodeList orderList;
                SqlSelect select;
                SqlOrderBy orderBy = (SqlOrderBy)node;
                this.handleOffsetFetch(orderBy.offset, orderBy.fetch);
                if (orderBy.query instanceof SqlSelect && (select = (SqlSelect)orderBy.query).getOrderList() == null) {
                    select.setOrderBy(orderBy.orderList);
                    select.setOffset(orderBy.offset);
                    select.setFetch(orderBy.fetch);
                    return select;
                }
                if (orderBy.query instanceof SqlWith && ((SqlWith)orderBy.query).body instanceof SqlSelect) {
                    SqlWith with = (SqlWith)orderBy.query;
                    SqlSelect select2 = (SqlSelect)with.body;
                    if (select2.getOrderList() == null) {
                        select2.setOrderBy(orderBy.orderList);
                        select2.setOffset(orderBy.offset);
                        select2.setFetch(orderBy.fetch);
                        return with;
                    }
                }
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
                SqlSelect innerSelect = SqlValidatorImpl.getInnerSelect(node);
                if (innerSelect != null && this.isAggregate(innerSelect)) {
                    orderList = SqlNode.clone(orderBy.orderList);
                    for (int i = 0; i < orderList.size(); ++i) {
                        SqlNode sqlNode = orderList.get(i);
                        SqlNodeList selectList2 = SqlNonNullableAccessors.getSelectList(innerSelect);
                        for (Ord sel : Ord.zip((List)selectList2)) {
                            if (!SqlUtil.stripAs((SqlNode)sel.e).equalsDeep(sqlNode, Litmus.IGNORE)) continue;
                            orderList.set(i, SqlLiteral.createExactNumeric(Integer.toString(sel.i + 1), SqlParserPos.ZERO));
                        }
                    }
                } else {
                    orderList = orderBy.orderList;
                }
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, orderBy.query, null, null, null, null, null, orderList, orderBy.offset, orderBy.fetch, null);
            }
            case EXPLICIT_TABLE: {
                SqlCall call = (SqlCall)node;
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, (SqlNode)call.operand(0), null, null, null, null, null, null, null, null, null);
            }
            case DELETE: {
                SqlCall call = (SqlDelete)node;
                SqlSelect select = this.createSourceSelectForDelete((SqlDelete)call);
                ((SqlDelete)call).setSourceSelect(select);
                break;
            }
            case UPDATE: {
                SqlNode selfJoinSrcExpr;
                SqlCall call = (SqlUpdate)node;
                SqlSelect select = this.createSourceSelectForUpdate((SqlUpdate)call);
                ((SqlUpdate)call).setSourceSelect(select);
                if (this.validatingSqlMerge || (selfJoinSrcExpr = this.getSelfJoinExprForUpdate(((SqlUpdate)call).getTargetTable(), UPDATE_SRC_ALIAS)) == null) break;
                node = this.rewriteUpdateToMerge((SqlUpdate)call, selfJoinSrcExpr);
                break;
            }
            case MERGE: {
                SqlCall call = (SqlMerge)node;
                SqlValidatorImpl.rewriteMerge((SqlMerge)call);
                break;
            }
        }
        return node;
    }

    private static @Nullable SqlSelect getInnerSelect(SqlNode node) {
        while (true) {
            if (node instanceof SqlSelect) {
                return (SqlSelect)node;
            }
            if (node instanceof SqlOrderBy) {
                node = ((SqlOrderBy)node).query;
                continue;
            }
            if (!(node instanceof SqlWith)) break;
            node = ((SqlWith)node).body;
        }
        return null;
    }

    private static void rewriteMerge(SqlMerge call) {
        SqlNodeList selectList;
        SqlUpdate updateStmt = call.getUpdateCall();
        if (updateStmt != null) {
            SqlSelect sourceSelect = SqlNonNullableAccessors.getSourceSelect(updateStmt);
            selectList = SqlNode.clone(SqlNonNullableAccessors.getSelectList(sourceSelect));
        } else {
            selectList = new SqlNodeList(SqlParserPos.ZERO);
            selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        }
        SqlNode targetTable = call.getTargetTable();
        if (call.getAlias() != null) {
            targetTable = SqlValidatorUtil.addAlias(targetTable, call.getAlias().getSimple());
        }
        SqlNode sourceTableRef = call.getSourceTableRef();
        SqlInsert insertCall = call.getInsertCall();
        JoinType joinType = insertCall == null ? JoinType.INNER : JoinType.LEFT;
        SqlNode leftJoinTerm = SqlNode.clone(sourceTableRef);
        SqlJoin outerJoin = new SqlJoin(SqlParserPos.ZERO, leftJoinTerm, SqlLiteral.createBoolean(false, SqlParserPos.ZERO), joinType.symbol(SqlParserPos.ZERO), targetTable, JoinConditionType.ON.symbol(SqlParserPos.ZERO), call.getCondition());
        SqlSelect select = new SqlSelect(SqlParserPos.ZERO, null, selectList, outerJoin, null, null, null, null, null, null, null, null, null);
        call.setSourceSelect(select);
        if (insertCall != null) {
            SqlCall valuesCall = (SqlCall)insertCall.getSource();
            SqlCall rowCall = (SqlCall)valuesCall.operand(0);
            selectList = new SqlNodeList(rowCall.getOperandList(), SqlParserPos.ZERO);
            SqlNode insertSource = SqlNode.clone(sourceTableRef);
            select = new SqlSelect(SqlParserPos.ZERO, null, selectList, insertSource, null, null, null, null, null, null, null, null, null);
            insertCall.setSource(select);
        }
    }

    private SqlNode rewriteUpdateToMerge(SqlUpdate updateCall, SqlNode selfJoinSrcExpr) {
        SqlIdentifier updateAlias = updateCall.getAlias();
        if (updateAlias == null) {
            updateAlias = new SqlIdentifier(UPDATE_TGT_ALIAS, SqlParserPos.ZERO);
            updateCall.setAlias(updateAlias);
        }
        SqlNode selfJoinTgtExpr = this.getSelfJoinExprForUpdate(updateCall.getTargetTable(), updateAlias.getSimple());
        Objects.requireNonNull(selfJoinTgtExpr, "selfJoinTgtExpr");
        SqlNode condition = updateCall.getCondition();
        SqlCall selfJoinCond = SqlStdOperatorTable.EQUALS.createCall(SqlParserPos.ZERO, selfJoinSrcExpr, selfJoinTgtExpr);
        condition = condition == null ? selfJoinCond : SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, selfJoinCond, condition);
        SqlNode target = updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        IdentifierNamespace ns = new IdentifierNamespace(this, target, null, (SqlValidatorScope)Nullness.castNonNull(null));
        RelDataType rowType = ns.getRowType();
        SqlNode source = updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        int i = 1;
        for (RelDataTypeField field : rowType.getFieldList()) {
            SqlIdentifier col = new SqlIdentifier(field.getName(), SqlParserPos.ZERO);
            selectList.add(SqlValidatorUtil.addAlias(col, UPDATE_ANON_PREFIX + i));
            ++i;
        }
        source = new SqlSelect(SqlParserPos.ZERO, null, selectList, source, null, null, null, null, null, null, null, null, null);
        source = SqlValidatorUtil.addAlias(source, UPDATE_SRC_ALIAS);
        SqlMerge mergeCall = new SqlMerge(updateCall.getParserPosition(), target, condition, source, updateCall, null, null, updateCall.getAlias());
        SqlValidatorImpl.rewriteMerge(mergeCall);
        return mergeCall;
    }

    protected @Nullable SqlNode getSelfJoinExprForUpdate(SqlNode table, String alias) {
        return null;
    }

    protected SqlSelect createSourceSelectForUpdate(SqlUpdate call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        int ordinal = 0;
        for (SqlNode exp : call.getSourceExpressionList()) {
            String alias = SqlUtil.deriveAliasFromOrdinal(ordinal);
            selectList.add(SqlValidatorUtil.addAlias(exp, alias));
            ++ordinal;
        }
        SqlNode sourceTable = call.getTargetTable();
        SqlIdentifier alias = call.getAlias();
        if (alias != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, alias.getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null, null);
    }

    protected SqlSelect createSourceSelectForDelete(SqlDelete call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        SqlNode sourceTable = call.getTargetTable();
        SqlIdentifier alias = call.getAlias();
        if (alias != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, alias.getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null, null);
    }

    @Nullable RelDataType getTableConstructorRowType(SqlCall values, SqlValidatorScope scope) {
        List<SqlNode> rows = values.getOperandList();
        assert (!rows.isEmpty());
        ArrayList<RelDataType> rowTypes = new ArrayList<RelDataType>();
        for (SqlNode row : rows) {
            assert (row.getKind() == SqlKind.ROW);
            SqlCall rowConstructor = (SqlCall)row;
            ArrayList<String> aliasList = new ArrayList<String>();
            ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
            for (Ord column : Ord.zip(rowConstructor.getOperandList())) {
                String alias = SqlValidatorUtil.alias((SqlNode)column.e, column.i);
                aliasList.add(alias);
                RelDataType type = this.deriveType(scope, (SqlNode)column.e);
                typeList.add(type);
            }
            rowTypes.add(this.typeFactory.createStructType(typeList, aliasList));
        }
        if (rows.size() == 1) {
            return (RelDataType)rowTypes.get(0);
        }
        return this.typeFactory.leastRestrictive(rowTypes);
    }

    @Override
    public RelDataType getValidatedNodeType(SqlNode node) {
        RelDataType type = this.getValidatedNodeTypeIfKnown(node);
        if (type == null) {
            if (node.getKind() == SqlKind.IDENTIFIER) {
                throw this.newValidationError(node, Static.RESOURCE.unknownIdentifier(node.toString()));
            }
            throw Util.needToImplement(node);
        }
        return type;
    }

    @Override
    public @Nullable RelDataType getValidatedNodeTypeIfKnown(SqlNode node) {
        RelDataType type = this.nodeToTypeMap.get(node);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(node);
        if (ns != null) {
            return ns.getType();
        }
        SqlNode original = this.originalExprs.get(node);
        if (original != null && original != node) {
            return this.getValidatedNodeTypeIfKnown(original);
        }
        if (node instanceof SqlIdentifier) {
            return this.getCatalogReader().getNamedType((SqlIdentifier)node);
        }
        return null;
    }

    @Override
    public @Nullable List<RelDataType> getValidatedOperandTypes(SqlCall call) {
        return this.callToOperandTypesMap.get(call);
    }

    @Override
    public final void setValidatedNodeType(SqlNode node, RelDataType type) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(node, "node");
        if (type.equals(this.unknownType)) {
            return;
        }
        this.nodeToTypeMap.put(node, type);
    }

    @Override
    public void removeValidatedNodeType(SqlNode node) {
        this.nodeToTypeMap.remove(node);
    }

    @Override
    public @Nullable SqlCall makeNullaryCall(SqlIdentifier id) {
        if (!id.isComponentQuoted(id.names.size() - 1)) {
            ArrayList<SqlOperator> list = new ArrayList<SqlOperator>();
            this.opTab.lookupOperatorOverloads(id, null, SqlSyntax.FUNCTION, list, this.catalogReader.nameMatcher());
            for (SqlOperator operator : list) {
                if (operator.getSyntax() != SqlSyntax.FUNCTION_ID && operator.getSyntax() != SqlSyntax.FUNCTION_ID_CONSTANT) continue;
                SqlCall sqlCall = new SqlBasicCall(operator, (List<? extends SqlNode>)ImmutableList.of(), id.getParserPosition(), null).withExpanded(true);
                if (operator.getSyntax() == SqlSyntax.FUNCTION_ID_CONSTANT && !this.config.conformance().allowNiladicConstantWithoutParentheses()) {
                    throw this.handleUnresolvedFunction(sqlCall, operator, (List<RelDataType>)ImmutableList.of(), null);
                }
                return sqlCall;
            }
        }
        return null;
    }

    @Override
    public RelDataType deriveType(SqlValidatorScope scope, SqlNode expr) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(expr, "expr");
        RelDataType type = this.nodeToTypeMap.get(expr);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(expr);
        if (ns != null) {
            return ns.getType();
        }
        type = this.deriveTypeImpl(scope, expr);
        Objects.requireNonNull(type, "SqlValidator.deriveTypeInternal returned null");
        this.setValidatedNodeType(expr, type);
        return type;
    }

    RelDataType deriveTypeImpl(SqlValidatorScope scope, SqlNode operand) {
        DeriveTypeVisitor v = new DeriveTypeVisitor(scope);
        RelDataType type = operand.accept(v);
        return Objects.requireNonNull(scope.nullifyType(operand, type));
    }

    @Override
    public RelDataType deriveConstructorType(SqlValidatorScope scope, SqlCall call, SqlFunction unresolvedConstructor, @Nullable SqlFunction resolvedConstructor, List<RelDataType> argTypes) {
        SqlIdentifier sqlIdentifier = unresolvedConstructor.getSqlIdentifier();
        Objects.requireNonNull(sqlIdentifier, "sqlIdentifier");
        RelDataType type = this.catalogReader.getNamedType(sqlIdentifier);
        if (type == null) {
            throw this.newValidationError(sqlIdentifier, Static.RESOURCE.unknownDatatypeName(sqlIdentifier.toString()));
        }
        if (resolvedConstructor == null) {
            if (call.operandCount() > 0) {
                throw this.handleUnresolvedFunction(call, unresolvedConstructor, argTypes, null);
            }
        } else {
            SqlCall testCall = resolvedConstructor.createCall(call.getParserPosition(), call.getOperandList());
            RelDataType returnType = resolvedConstructor.validateOperands(this, scope, testCall);
            assert (type == returnType);
        }
        if (this.config.identifierExpansion()) {
            if (resolvedConstructor != null) {
                ((SqlBasicCall)call).setOperator(resolvedConstructor);
            } else {
                ((SqlBasicCall)call).setOperator(new SqlFunction(Objects.requireNonNull(type.getSqlIdentifier(), () -> "sqlIdentifier of " + type), ReturnTypes.explicit(type), null, null, null, SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR));
            }
        }
        return type;
    }

    @Override
    public CalciteException handleUnresolvedFunction(SqlCall call, SqlOperator unresolvedFunction, List<RelDataType> argTypes, @Nullable List<String> argNames) {
        String signature;
        SqlFunction fun;
        ArrayList<SqlOperator> overloads = new ArrayList<SqlOperator>();
        this.opTab.lookupOperatorOverloads(unresolvedFunction.getNameAsId(), null, SqlSyntax.FUNCTION, overloads, this.catalogReader.nameMatcher());
        if (overloads.size() == 1 && (fun = (SqlFunction)overloads.get(0)).getSqlIdentifier() == null && fun.getSyntax() != SqlSyntax.FUNCTION_ID && fun.getSyntax() != SqlSyntax.FUNCTION_ID_CONSTANT) {
            int expectedArgCount = fun.getOperandCountRange().getMin();
            throw this.newValidationError(call, Static.RESOURCE.invalidArgCount(call.getOperator().getName(), expectedArgCount));
        }
        if (unresolvedFunction instanceof SqlFunction) {
            AssignableOperandTypeChecker typeChecking = new AssignableOperandTypeChecker(argTypes, argNames);
            signature = typeChecking.getAllowedSignatures(unresolvedFunction, unresolvedFunction.getName());
        } else {
            signature = unresolvedFunction.getName();
        }
        throw this.newValidationError(call, Static.RESOURCE.validatorUnknownFunction(signature));
    }

    protected void inferUnknownTypes(RelDataType inferredType, SqlValidatorScope scope, SqlNode node) {
        block17: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block16: {
                                Objects.requireNonNull(inferredType, "inferredType");
                                Objects.requireNonNull(scope, "scope");
                                Objects.requireNonNull(node, "node");
                                SqlValidatorScope newScope = this.scopes.get(node);
                                if (newScope != null) {
                                    scope = newScope;
                                }
                                boolean isNullLiteral = SqlUtil.isNullLiteral(node, false);
                                if (!(node instanceof SqlDynamicParam) && !isNullLiteral) break block16;
                                if (inferredType.equals(this.unknownType)) {
                                    if (isNullLiteral) {
                                        if (this.config.typeCoercionEnabled()) {
                                            this.deriveType(scope, node);
                                            return;
                                        }
                                        throw this.newValidationError(node, Static.RESOURCE.nullIllegal());
                                    }
                                    throw this.newValidationError(node, Static.RESOURCE.dynamicParamIllegal());
                                }
                                RelDataType newInferredType = this.typeFactory.createTypeWithNullability(inferredType, true);
                                if (SqlTypeUtil.inCharFamily(inferredType)) {
                                    newInferredType = this.typeFactory.createTypeWithCharsetAndCollation(newInferredType, NonNullableAccessors.getCharset(inferredType), NonNullableAccessors.getCollation(inferredType));
                                }
                                this.setValidatedNodeType(node, newInferredType);
                                break block17;
                            }
                            if (!(node instanceof SqlNodeList)) break block18;
                            SqlNodeList nodeList = (SqlNodeList)node;
                            if (inferredType.isStruct() && inferredType.getFieldCount() != nodeList.size()) {
                                return;
                            }
                            int i = 0;
                            for (SqlNode child : nodeList) {
                                RelDataType type;
                                if (inferredType.isStruct()) {
                                    type = inferredType.getFieldList().get(i).getType();
                                    ++i;
                                } else {
                                    type = inferredType;
                                }
                                this.inferUnknownTypes(type, scope, child);
                            }
                            break block17;
                        }
                        if (!(node instanceof SqlCase)) break block19;
                        SqlCase caseCall = (SqlCase)node;
                        RelDataType whenType = caseCall.getValueOperand() == null ? this.booleanType : this.unknownType;
                        for (Object sqlNode : caseCall.getWhenOperands()) {
                            this.inferUnknownTypes(whenType, scope, (SqlNode)sqlNode);
                        }
                        RelDataType returnType = this.deriveType(scope, node);
                        for (SqlNode sqlNode : caseCall.getThenOperands()) {
                            this.inferUnknownTypes(returnType, scope, sqlNode);
                        }
                        SqlNode elseOperand = Objects.requireNonNull(caseCall.getElseOperand(), () -> "elseOperand for " + caseCall);
                        if (!SqlUtil.isNullLiteral(elseOperand, false)) {
                            this.inferUnknownTypes(returnType, scope, elseOperand);
                        } else {
                            this.setValidatedNodeType(elseOperand, returnType);
                        }
                        break block17;
                    }
                    if (node.getKind() != SqlKind.AS) break block20;
                    this.inferUnknownTypes(inferredType, scope, (SqlNode)((SqlCall)node).operand(0));
                    break block17;
                }
                if (node.getKind() != SqlKind.MEASURE) break block21;
                if (scope instanceof SelectScope) {
                    scope = this.getMeasureScope(((SelectScope)scope).getNode());
                }
                this.inferUnknownTypes(inferredType, scope, (SqlNode)((SqlCall)node).operand(0));
                break block17;
            }
            if (!(node instanceof SqlCall)) break block17;
            SqlCall call = (SqlCall)node;
            SqlOperandTypeInference operandTypeInference = call.getOperator().getOperandTypeInference();
            SqlCallBinding callBinding = new SqlCallBinding(this, scope, call);
            List<SqlNode> operands = callBinding.operands();
            Object[] operandTypes = new RelDataType[operands.size()];
            Arrays.fill(operandTypes, this.unknownType);
            if (operandTypeInference != null) {
                operandTypeInference.inferOperandTypes(callBinding, inferredType, (RelDataType[])operandTypes);
            }
            for (int i = 0; i < operands.size(); ++i) {
                SqlNode operand = operands.get(i);
                if (operand == null) continue;
                this.inferUnknownTypes((RelDataType)operandTypes[i], scope, operand);
            }
        }
    }

    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        String uniqueAlias;
        @Nullable String alias = SqlValidatorUtil.alias(exp);
        if (!Objects.equals(alias, uniqueAlias = SqlValidatorUtil.uniquify(alias, aliases, SqlValidatorUtil.EXPR_SUGGESTER))) {
            exp = SqlValidatorUtil.addAlias(exp, uniqueAlias);
        }
        ((PairList)fieldList).add(uniqueAlias, this.deriveType(scope, exp));
        list.add(exp);
    }

    @Override
    public @Nullable String deriveAlias(SqlNode node, int ordinal) {
        return ordinal < 0 ? SqlValidatorUtil.alias(node) : SqlValidatorUtil.alias(node, ordinal);
    }

    protected boolean shouldAllowIntermediateOrderBy() {
        return true;
    }

    private void registerMatchRecognize(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlMatchRecognize call, SqlNode enclosingNode, @Nullable String alias, boolean forceNullable) {
        MatchRecognizeNamespace matchRecognizeNamespace = this.createMatchRecognizeNameSpace(call, enclosingNode);
        this.registerNamespace(usingScope, alias, matchRecognizeNamespace, forceNullable);
        MatchRecognizeScope matchRecognizeScope = new MatchRecognizeScope(parentScope, call);
        this.scopes.put(call, matchRecognizeScope);
        SqlNode expr = call.getTableRef();
        SqlNode newExpr = this.registerFrom(usingScope, matchRecognizeScope, true, expr, expr, null, null, forceNullable, false);
        if (expr != newExpr) {
            call.setOperand(0, newExpr);
        }
    }

    protected MatchRecognizeNamespace createMatchRecognizeNameSpace(SqlMatchRecognize call, SqlNode enclosingNode) {
        return new MatchRecognizeNamespace(this, call, enclosingNode);
    }

    private void registerPivot(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlPivot pivot, SqlNode enclosingNode, @Nullable String alias, boolean forceNullable) {
        PivotNamespace namespace = this.createPivotNameSpace(pivot, enclosingNode);
        this.registerNamespace(usingScope, alias, namespace, forceNullable);
        PivotScope scope = new PivotScope(parentScope, pivot);
        this.scopes.put(pivot, scope);
        SqlNode expr = pivot.query;
        SqlNode newExpr = this.registerFrom(parentScope, scope, true, expr, expr, null, null, forceNullable, false);
        if (expr != newExpr) {
            pivot.setOperand(0, newExpr);
        }
    }

    protected PivotNamespace createPivotNameSpace(SqlPivot call, SqlNode enclosingNode) {
        return new PivotNamespace(this, call, enclosingNode);
    }

    private void registerUnpivot(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlUnpivot call, SqlNode enclosingNode, @Nullable String alias, boolean forceNullable) {
        UnpivotNamespace namespace = this.createUnpivotNameSpace(call, enclosingNode);
        this.registerNamespace(usingScope, alias, namespace, forceNullable);
        UnpivotScope scope = new UnpivotScope(parentScope, call);
        this.scopes.put(call, scope);
        SqlNode expr = call.query;
        SqlNode newExpr = this.registerFrom(parentScope, scope, true, expr, expr, null, null, forceNullable, false);
        if (expr != newExpr) {
            call.setOperand(0, newExpr);
        }
    }

    protected UnpivotNamespace createUnpivotNameSpace(SqlUnpivot call, SqlNode enclosingNode) {
        return new UnpivotNamespace(this, call, enclosingNode);
    }

    protected void registerNamespace(@Nullable SqlValidatorScope usingScope, @Nullable String alias, SqlValidatorNamespace ns, boolean forceNullable) {
        SqlValidatorNamespace namespace = this.namespaces.get(Objects.requireNonNull(ns.getNode(), () -> "ns.getNode() for " + ns));
        if (namespace == null) {
            this.namespaces.put(Objects.requireNonNull(ns.getNode()), ns);
            namespace = ns;
        }
        if (usingScope != null) {
            if (alias == null) {
                throw new IllegalArgumentException("Registering namespace " + ns + ", into scope " + usingScope + ", so alias must not be null");
            }
            usingScope.addChild(namespace, alias, forceNullable);
        }
    }

    private SqlNode registerFrom(SqlValidatorScope parentScope0, SqlValidatorScope usingScope, boolean register, SqlNode node, SqlNode enclosingNode, @Nullable String alias, @Nullable SqlNodeList extendList, boolean forceNullable, boolean lateral) {
        SqlValidatorScope parentScope;
        SqlKind kind = node.getKind();
        SqlNode newNode = node;
        if (alias == null) {
            switch (kind) {
                case OVER: 
                case IDENTIFIER: {
                    alias = SqlValidatorUtil.alias(node);
                    if (alias == null) {
                        alias = SqlValidatorUtil.alias(node, this.nextGeneratedId++);
                    }
                    if (!this.config.identifierExpansion()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias);
                    break;
                }
                case COLLECTION_TABLE: 
                case VALUES: 
                case SELECT: 
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case UNNEST: 
                case OTHER_FUNCTION: 
                case PIVOT: 
                case UNPIVOT: 
                case MATCH_RECOGNIZE: 
                case WITH: {
                    alias = SqlValidatorUtil.alias(node, this.nextGeneratedId++);
                    if (!this.config.identifierExpansion()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias);
                    break;
                }
            }
        }
        if (lateral) {
            SqlValidatorScope s = usingScope;
            while (s instanceof JoinScope) {
                s = ((JoinScope)s).getUsingScope();
            }
            SqlNode node2 = s != null ? s.getNode() : node;
            TableScope tableScope = new TableScope(parentScope0, node2);
            if (usingScope instanceof ListScope) {
                for (ScopeChild child : ((ListScope)usingScope).children) {
                    tableScope.addChild(child.namespace, child.name, child.nullable);
                }
            }
            parentScope = tableScope;
        } else {
            parentScope = parentScope0;
        }
        switch (kind) {
            case AS: {
                SqlCall call = (SqlCall)node;
                if (alias == null) {
                    alias = String.valueOf(call.operand(1));
                }
                Object expr = call.operand(0);
                boolean needAliasNamespace = call.operandCount() > 2 || ((SqlNode)expr).getKind() == SqlKind.VALUES || ((SqlNode)expr).getKind() == SqlKind.UNNEST || ((SqlNode)expr).getKind() == SqlKind.COLLECTION_TABLE;
                SqlNode newExpr = this.registerFrom(parentScope, usingScope, !needAliasNamespace, (SqlNode)expr, enclosingNode, alias, extendList, forceNullable, lateral);
                if (newExpr != expr) {
                    call.setOperand(0, newExpr);
                }
                if (needAliasNamespace) {
                    this.registerNamespace(usingScope, alias, new AliasNamespace(this, call, enclosingNode), forceNullable);
                }
                return node;
            }
            case MATCH_RECOGNIZE: {
                this.registerMatchRecognize(parentScope, usingScope, (SqlMatchRecognize)node, enclosingNode, alias, forceNullable);
                return node;
            }
            case PIVOT: {
                this.registerPivot(parentScope, usingScope, (SqlPivot)node, enclosingNode, alias, forceNullable);
                return node;
            }
            case UNPIVOT: {
                this.registerUnpivot(parentScope, usingScope, (SqlUnpivot)node, enclosingNode, alias, forceNullable);
                return node;
            }
            case TABLESAMPLE: {
                SqlCall call = (SqlCall)node;
                Object expr = call.operand(0);
                SqlNode newExpr = this.registerFrom(parentScope, usingScope, true, (SqlNode)expr, enclosingNode, alias, extendList, forceNullable, lateral);
                if (newExpr != expr) {
                    call.setOperand(0, newExpr);
                }
                return node;
            }
            case JOIN: {
                SqlNode newRight;
                SqlJoin join = (SqlJoin)node;
                JoinScope joinScope = new JoinScope(parentScope, usingScope, join);
                this.scopes.put(join, joinScope);
                SqlNode left = join.getLeft();
                SqlNode right = join.getRight();
                boolean forceLeftNullable = forceNullable;
                boolean forceRightNullable = forceNullable;
                switch (join.getJoinType()) {
                    case LEFT: 
                    case LEFT_ASOF: {
                        forceRightNullable = true;
                        break;
                    }
                    case RIGHT: {
                        forceLeftNullable = true;
                        break;
                    }
                    case FULL: {
                        forceLeftNullable = true;
                        forceRightNullable = true;
                        break;
                    }
                }
                SqlNode newLeft = this.registerFrom(parentScope, joinScope, true, left, left, null, null, forceLeftNullable, lateral);
                if (newLeft != left) {
                    join.setLeft(newLeft);
                }
                if ((newRight = this.registerFrom(parentScope, joinScope, true, right, right, null, null, forceRightNullable, lateral)) != right) {
                    join.setRight(newRight);
                }
                this.scopes.putIfAbsent(SqlUtil.stripAs(join.getRight()), parentScope);
                this.scopes.putIfAbsent(SqlUtil.stripAs(join.getLeft()), parentScope);
                this.registerSubQueries(joinScope, join.getCondition());
                JoinNamespace joinNamespace = new JoinNamespace(this, join);
                this.registerNamespace(null, null, joinNamespace, forceNullable);
                return join;
            }
            case IDENTIFIER: {
                SqlIdentifier id = (SqlIdentifier)node;
                IdentifierNamespace newNs = new IdentifierNamespace(this, id, extendList, enclosingNode, parentScope);
                this.registerNamespace(register ? usingScope : null, alias, newNs, forceNullable);
                if (this.tableScope == null) {
                    this.tableScope = new TableScope(parentScope, node);
                }
                this.tableScope.addChild(newNs, Objects.requireNonNull(alias, "alias"), forceNullable);
                if (extendList != null && !extendList.isEmpty()) {
                    return enclosingNode;
                }
                return newNode;
            }
            case LATERAL: {
                return this.registerFrom(parentScope, usingScope, register, (SqlNode)((SqlCall)node).operand(0), enclosingNode, alias, extendList, forceNullable, true);
            }
            case COLLECTION_TABLE: {
                SqlBasicCall call1;
                SqlOperator op;
                SqlCall call = (SqlCall)node;
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, usingScope, register, (SqlNode)operand, enclosingNode, alias, extendList, forceNullable, lateral);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                if (operand instanceof SqlBasicCall && (op = (call1 = (SqlBasicCall)operand).getOperator()) instanceof SqlWindowTableFunction && ((SqlNode)call1.operand(0)).getKind() == SqlKind.SELECT) {
                    this.scopes.put(node, this.getSelectScope((SqlSelect)call1.operand(0)));
                    return newNode;
                }
                this.scopes.put(node, usingScope);
                return newNode;
            }
            case UNNEST: {
                if (!lateral) {
                    return this.registerFrom(parentScope, usingScope, register, node, enclosingNode, alias, extendList, forceNullable, true);
                }
            }
            case VALUES: 
            case SELECT: 
            case UNION: 
            case INTERSECT: 
            case EXCEPT: 
            case OTHER_FUNCTION: 
            case WITH: {
                if (alias == null) {
                    alias = SqlValidatorUtil.alias(node, this.nextGeneratedId++);
                }
                this.registerQuery(parentScope, register ? usingScope : null, node, enclosingNode, alias, forceNullable);
                return newNode;
            }
            case OVER: {
                if (!this.shouldAllowOverRelation()) {
                    throw Util.unexpected(kind);
                }
                SqlCall call = (SqlCall)node;
                OverScope overScope = new OverScope(usingScope, call);
                this.scopes.put(call, overScope);
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, overScope, true, (SqlNode)operand, enclosingNode, alias, extendList, forceNullable, lateral);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                for (ScopeChild child : overScope.children) {
                    this.registerNamespace(register ? usingScope : null, child.name, child.namespace, forceNullable);
                }
                return newNode;
            }
            case TABLE_REF: {
                SqlCall call = (SqlCall)node;
                this.registerFrom(parentScope, usingScope, register, (SqlNode)call.operand(0), enclosingNode, alias, extendList, forceNullable, lateral);
                if (extendList != null && !extendList.isEmpty()) {
                    return enclosingNode;
                }
                return newNode;
            }
            case EXTEND: {
                SqlCall extend = (SqlCall)node;
                return this.registerFrom(parentScope, usingScope, true, extend.getOperandList().get(0), extend, alias, (SqlNodeList)extend.getOperandList().get(1), forceNullable, lateral);
            }
            case SNAPSHOT: {
                SqlCall call = (SqlCall)node;
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, usingScope, register, (SqlNode)operand, enclosingNode, alias, extendList, forceNullable, lateral);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                this.scopes.put(node, usingScope);
                return newNode;
            }
        }
        throw Util.unexpected(kind);
    }

    protected boolean shouldAllowOverRelation() {
        return false;
    }

    protected SelectNamespace createSelectNamespace(SqlSelect select, SqlNode enclosingNode) {
        return new SelectNamespace(this, select, enclosingNode);
    }

    protected SetopNamespace createSetopNamespace(SqlCall call, SqlNode enclosingNode) {
        return new SetopNamespace(this, call, enclosingNode);
    }

    protected void registerQuery(SqlValidatorScope parentScope, @Nullable SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, @Nullable String alias, boolean forceNullable) {
        Preconditions.checkArgument((usingScope == null || alias != null ? 1 : 0) != 0);
        this.registerQuery(parentScope, usingScope, node, enclosingNode, alias, forceNullable, true);
    }

    private void registerQuery(SqlValidatorScope parentScope, @Nullable SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, @Nullable String alias, boolean forceNullable, boolean checkUpdate) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(enclosingNode, "enclosingNode");
        Preconditions.checkArgument((usingScope == null || alias != null ? 1 : 0) != 0);
        switch (node.getKind()) {
            case SELECT: {
                SqlCall agg;
                SqlNode newFrom;
                SqlSelect select = (SqlSelect)node;
                SelectNamespace selectNs = this.createSelectNamespace(select, enclosingNode);
                this.registerNamespace(usingScope, alias, selectNs, forceNullable);
                SqlValidatorScope windowParentScope = Util.first(usingScope, parentScope);
                SelectScope selectScope = new SelectScope(parentScope, windowParentScope, select);
                this.scopes.put(select, selectScope);
                this.clauseScopes.put(IdPair.of(select, Clause.WHERE), selectScope);
                this.registerOperandSubQueries(selectScope, select, 3);
                this.registerOperandSubQueries(selectScope, select, 7);
                SqlNode from = select.getFrom();
                if (from != null && (newFrom = this.registerFrom(parentScope, selectScope, true, from, from, null, null, false, false)) != from) {
                    select.setFrom(newFrom);
                }
                DelegatingScope selectScope2 = this.isAggregate(select) ? new AggregatingSelectScope(selectScope, select, false) : selectScope;
                this.clauseScopes.put(IdPair.of(select, Clause.SELECT), selectScope2);
                this.clauseScopes.put(IdPair.of(select, Clause.MEASURE), new MeasureScope(selectScope, select));
                if (select.getGroup() != null) {
                    GroupByScope groupByScope = new GroupByScope(selectScope, select.getGroup(), select);
                    this.clauseScopes.put(IdPair.of(select, Clause.GROUP_BY), groupByScope);
                    this.registerSubQueries(groupByScope, select.getGroup());
                }
                this.registerOperandSubQueries(selectScope2, select, 5);
                this.registerSubQueries(selectScope2, SqlNonNullableAccessors.getSelectList(select));
                SqlNodeList orderList = select.getOrderList();
                if (orderList == null) break;
                DelegatingScope selectScope3 = select.isDistinct() ? new AggregatingSelectScope(selectScope, select, true) : selectScope2;
                OrderByScope orderScope = new OrderByScope(selectScope3, orderList, select);
                this.clauseScopes.put(IdPair.of(select, Clause.ORDER), orderScope);
                this.registerSubQueries(orderScope, orderList);
                if (this.isAggregate(select) || (agg = this.aggFinder.findAgg(orderList)) == null) break;
                throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInOrderBy());
            }
            case INTERSECT: {
                this.validateFeature(Static.RESOURCE.sQLFeature_F302(), node.getParserPosition());
                this.registerSetop(parentScope, usingScope, node, node, alias, forceNullable);
                break;
            }
            case EXCEPT: {
                this.validateFeature(Static.RESOURCE.sQLFeature_E071_03(), node.getParserPosition());
                this.registerSetop(parentScope, usingScope, node, node, alias, forceNullable);
                break;
            }
            case UNION: {
                this.registerSetop(parentScope, usingScope, node, enclosingNode, alias, forceNullable);
                break;
            }
            case LAMBDA: {
                SqlCall call = (SqlCall)node;
                SqlLambdaScope lambdaScope = new SqlLambdaScope(parentScope, (SqlLambda)call);
                this.scopes.put(call, lambdaScope);
                LambdaNamespace lambdaNamespace = new LambdaNamespace(this, (SqlLambda)call, node);
                this.registerNamespace(usingScope, alias, lambdaNamespace, forceNullable);
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    this.registerOperandSubQueries(parentScope, call, i);
                }
                break;
            }
            case WITH: {
                this.registerWith(parentScope, usingScope, (SqlWith)node, enclosingNode, alias, forceNullable, checkUpdate);
                break;
            }
            case VALUES: {
                SqlCall call = (SqlCall)node;
                this.scopes.put(call, parentScope);
                TableConstructorNamespace tableConstructorNamespace = new TableConstructorNamespace(this, call, parentScope, enclosingNode);
                this.registerNamespace(usingScope, alias, tableConstructorNamespace, forceNullable);
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    assert (operands.get(i).getKind() == SqlKind.ROW);
                    this.registerOperandSubQueries(parentScope, call, i);
                }
                break;
            }
            case INSERT: {
                SqlInsert insertCall = (SqlInsert)node;
                InsertNamespace insertNs = new InsertNamespace(this, insertCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, insertNs, forceNullable);
                this.registerQuery(parentScope, usingScope, insertCall.getSource(), enclosingNode, null, false);
                break;
            }
            case DELETE: {
                SqlDelete deleteCall = (SqlDelete)node;
                DeleteNamespace deleteNs = new DeleteNamespace(this, deleteCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, deleteNs, forceNullable);
                this.registerQuery(parentScope, usingScope, SqlNonNullableAccessors.getSourceSelect(deleteCall), enclosingNode, null, false);
                break;
            }
            case UPDATE: {
                if (checkUpdate) {
                    this.validateFeature(Static.RESOURCE.sQLFeature_E101_03(), node.getParserPosition());
                }
                SqlUpdate updateCall = (SqlUpdate)node;
                UpdateNamespace updateNs = new UpdateNamespace(this, updateCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, updateNs, forceNullable);
                this.registerQuery(parentScope, usingScope, SqlNonNullableAccessors.getSourceSelect(updateCall), enclosingNode, null, false);
                break;
            }
            case MERGE: {
                SqlInsert mergeInsertCall;
                this.validateFeature(Static.RESOURCE.sQLFeature_F312(), node.getParserPosition());
                SqlMerge mergeCall = (SqlMerge)node;
                MergeNamespace mergeNs = new MergeNamespace(this, mergeCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, mergeNs, forceNullable);
                this.registerQuery(parentScope, usingScope, SqlNonNullableAccessors.getSourceSelect(mergeCall), enclosingNode, null, false);
                SqlUpdate mergeUpdateCall = mergeCall.getUpdateCall();
                if (mergeUpdateCall != null) {
                    this.registerQuery(this.getScope(SqlNonNullableAccessors.getSourceSelect(mergeCall), Clause.WHERE), null, mergeUpdateCall, enclosingNode, null, false, false);
                }
                if ((mergeInsertCall = mergeCall.getInsertCall()) == null) break;
                this.registerQuery(parentScope, null, mergeInsertCall, enclosingNode, null, false);
                break;
            }
            case UNNEST: {
                SqlCall call = (SqlCall)node;
                UnnestNamespace unnestNs = new UnnestNamespace(this, call, parentScope, enclosingNode);
                this.registerNamespace(usingScope, alias, unnestNs, forceNullable);
                this.registerOperandSubQueries(parentScope, call, 0);
                this.scopes.put(node, parentScope);
                break;
            }
            case OTHER_FUNCTION: {
                SqlCall call = (SqlCall)node;
                ProcedureNamespace procNs = new ProcedureNamespace(this, parentScope, call, enclosingNode);
                this.registerNamespace(usingScope, alias, procNs, forceNullable);
                this.registerSubQueries(parentScope, call);
                break;
            }
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: {
                this.validateFeature(Static.RESOURCE.sQLFeature_S271(), node.getParserPosition());
                SqlCall call = (SqlCall)node;
                CollectScope cs = new CollectScope(parentScope, usingScope, call);
                CollectNamespace tableConstructorNs = new CollectNamespace(call, cs, enclosingNode);
                String alias2 = SqlValidatorUtil.alias(node, this.nextGeneratedId++);
                this.registerNamespace(usingScope, alias2, tableConstructorNs, forceNullable);
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    this.registerOperandSubQueries(parentScope, call, i);
                }
                break;
            }
            default: {
                throw Util.unexpected(node.getKind());
            }
        }
    }

    private void registerSetop(SqlValidatorScope parentScope, @Nullable SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, @Nullable String alias, boolean forceNullable) {
        SqlCall call = (SqlCall)node;
        SetopNamespace setopNamespace = this.createSetopNamespace(call, enclosingNode);
        this.registerNamespace(usingScope, alias, setopNamespace, forceNullable);
        this.scopes.put(call, parentScope);
        SqlValidatorScope recursiveScope = parentScope;
        if (enclosingNode.getKind() == SqlKind.WITH_ITEM) {
            if (node.getKind() != SqlKind.UNION) {
                throw this.newValidationError(node, Static.RESOURCE.recursiveWithMustHaveUnionSetOp());
            }
            if (call.getOperandList().size() > 2) {
                throw this.newValidationError(node, Static.RESOURCE.recursiveWithMustHaveTwoChildUnionSetOp());
            }
            WithScope scope = (WithScope)this.scopes.get(enclosingNode);
            recursiveScope = scope != null && scope.recursiveScope != null ? (SqlValidatorScope)Objects.requireNonNull(scope.recursiveScope) : parentScope;
        }
        for (int i = 0; i < call.getOperandList().size(); ++i) {
            SqlNode operand = call.getOperandList().get(i);
            @NonNull SqlValidatorScope scope = i == 0 ? parentScope : recursiveScope;
            this.registerQuery(scope, null, operand, operand, null, false);
        }
    }

    private void registerWith(SqlValidatorScope parentScope, @Nullable SqlValidatorScope usingScope, SqlWith with, SqlNode enclosingNode, @Nullable String alias, boolean forceNullable, boolean checkUpdate) {
        WithNamespace withNamespace = new WithNamespace(this, with, enclosingNode);
        this.registerNamespace(usingScope, alias, withNamespace, forceNullable);
        this.scopes.put(with, parentScope);
        SqlValidatorScope scope = parentScope;
        for (SqlNode withItem_ : with.withList) {
            SqlWithItem withItem = (SqlWithItem)withItem_;
            boolean isRecursiveWith = withItem.recursive.booleanValue();
            WithScope withScope = new WithScope(scope, withItem, isRecursiveWith ? new WithRecursiveScope(scope, withItem) : null);
            this.scopes.put(withItem, withScope);
            this.registerQuery(scope, null, withItem.query, withItem.recursive.booleanValue() ? withItem : with, withItem.name.getSimple(), forceNullable);
            this.registerNamespace(null, alias, new WithItemNamespace(this, withItem, enclosingNode), false);
            scope = withScope;
        }
        this.registerQuery(scope, null, with.body, enclosingNode, alias, forceNullable, checkUpdate);
    }

    @Override
    public boolean isAggregate(SqlSelect select) {
        if (this.getAggregate(select) != null) {
            return true;
        }
        for (SqlCall call : this.overFinder.findAll(SqlNonNullableAccessors.getSelectList(select))) {
            assert (call.getKind() == SqlKind.OVER);
            if (this.isNestedAggregateWindow((SqlNode)call.operand(0))) {
                return true;
            }
            if (!this.isOverAggregateWindow((SqlNode)call.operand(1))) continue;
            return true;
        }
        return false;
    }

    protected boolean isNestedAggregateWindow(SqlNode node) {
        AggFinder nestedAggFinder = new AggFinder(this.opTab, false, false, false, this.aggFinder, this.catalogReader.nameMatcher());
        return nestedAggFinder.findAgg(node) != null;
    }

    protected boolean isOverAggregateWindow(SqlNode node) {
        return this.aggFinder.findAgg(node) != null;
    }

    protected @Nullable SqlNode getAggregate(SqlSelect select) {
        SqlNode node = select.getGroup();
        if (node != null) {
            return node;
        }
        node = select.getHaving();
        if (node != null) {
            return node;
        }
        return this.getAgg(select);
    }

    private @Nullable SqlNode getAgg(SqlSelect select) {
        List<SqlNode> selectList;
        SelectScope selectScope = this.getRawSelectScope(select);
        if (selectScope != null && (selectList = selectScope.getExpandedSelectList()) != null) {
            return this.aggFinder.findAgg(selectList);
        }
        return this.aggFinder.findAgg(SqlNonNullableAccessors.getSelectList(select));
    }

    @Override
    @Deprecated
    public boolean isAggregate(SqlNode selectNode) {
        return this.aggFinder.findAgg(selectNode) != null;
    }

    private void validateNodeFeature(SqlNode node) {
        switch (node.getKind()) {
            case MULTISET_VALUE_CONSTRUCTOR: {
                this.validateFeature(Static.RESOURCE.sQLFeature_S271(), node.getParserPosition());
                break;
            }
        }
    }

    private void registerSubQueries(SqlValidatorScope parentScope, @Nullable SqlNode node) {
        block5: {
            block6: {
                block4: {
                    if (node == null) {
                        return;
                    }
                    if (!node.getKind().belongsTo(SqlKind.QUERY) && node.getKind() != SqlKind.LAMBDA && node.getKind() != SqlKind.MULTISET_QUERY_CONSTRUCTOR && node.getKind() != SqlKind.MULTISET_VALUE_CONSTRUCTOR) break block4;
                    this.registerQuery(parentScope, null, node, node, null, false);
                    break block5;
                }
                if (!(node instanceof SqlCall)) break block6;
                this.validateNodeFeature(node);
                SqlCall call = (SqlCall)node;
                for (int i = 0; i < call.operandCount(); ++i) {
                    this.registerOperandSubQueries(parentScope, call, i);
                }
                break block5;
            }
            if (!(node instanceof SqlNodeList)) break block5;
            SqlNodeList list = (SqlNodeList)node;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                SqlNode listNode = list.get(i);
                if (listNode.getKind().belongsTo(SqlKind.QUERY)) {
                    listNode = SqlStdOperatorTable.SCALAR_QUERY.createCall(listNode.getParserPosition(), listNode);
                    list.set(i, listNode);
                }
                this.registerSubQueries(parentScope, listNode);
            }
        }
    }

    private void registerOperandSubQueries(SqlValidatorScope parentScope, SqlCall call, int operandOrdinal) {
        Object operand = call.operand(operandOrdinal);
        if (operand == null) {
            return;
        }
        if (((SqlNode)operand).getKind().belongsTo(SqlKind.QUERY) && call.getOperator().argumentMustBeScalar(operandOrdinal)) {
            operand = SqlStdOperatorTable.SCALAR_QUERY.createCall(((SqlNode)operand).getParserPosition(), new SqlNode[]{operand});
            call.setOperand(operandOrdinal, (SqlNode)operand);
        }
        this.registerSubQueries(parentScope, (SqlNode)operand);
    }

    @Override
    public void validateIdentifier(SqlIdentifier id, SqlValidatorScope scope) {
        SqlQualified fqId = scope.fullyQualify(id);
        if (this.config.columnReferenceExpansion()) {
            id.assignNamesFrom(fqId.identifier);
        } else {
            Util.discard(fqId);
        }
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        switch (literal.getTypeName()) {
            case DECIMAL: {
                RelDataTypeSystem typeSystem = this.getTypeFactory().getTypeSystem();
                BigDecimal bd = literal.getValueAs(BigDecimal.class);
                BigDecimal noTrailingZeros = bd.stripTrailingZeros();
                int maxPrecision = typeSystem.getMaxNumericPrecision();
                if (noTrailingZeros.precision() > maxPrecision) {
                    throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
                }
                int maxScale = typeSystem.getMaxNumericScale();
                if (noTrailingZeros.scale() <= maxScale) break;
                throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
            }
            case DOUBLE: 
            case FLOAT: 
            case REAL: {
                this.validateLiteralAsDouble(literal);
                break;
            }
            case BINARY: {
                BitString bitString = literal.getValueAs(BitString.class);
                if (bitString.getBitCount() % 8 == 0) break;
                throw this.newValidationError(literal, Static.RESOURCE.binaryLiteralOdd());
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                Calendar calendar = literal.getValueAs(Calendar.class);
                int year = calendar.get(1);
                int era = calendar.get(0);
                if (year >= 1 && era != 0 && year <= 9999) break;
                throw this.newValidationError(literal, Static.RESOURCE.dateLiteralOutOfRange(literal.toString()));
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                if (!(literal instanceof SqlIntervalLiteral)) break;
                SqlIntervalLiteral.IntervalValue interval = literal.getValueAs(SqlIntervalLiteral.IntervalValue.class);
                SqlIntervalQualifier intervalQualifier = interval.getIntervalQualifier();
                this.validateIntervalQualifier(intervalQualifier);
                String intervalStr = interval.getIntervalLiteral();
                int[] values = intervalQualifier.evaluateIntervalLiteral(intervalStr, literal.getParserPosition(), this.typeFactory.getTypeSystem());
                Util.discard(values);
                break;
            }
        }
    }

    private void validateLiteralAsDouble(SqlLiteral literal) {
        BigDecimal bd = literal.getValueAs(BigDecimal.class);
        double d = bd.doubleValue();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(Util.toScientificNotation(bd)));
        }
    }

    @Override
    public void validateIntervalQualifier(SqlIntervalQualifier qualifier) {
        Objects.requireNonNull(qualifier, "qualifier");
        boolean startPrecisionOutOfRange = false;
        boolean fractionalSecondPrecisionOutOfRange = false;
        RelDataTypeSystem typeSystem = this.typeFactory.getTypeSystem();
        int startPrecision = qualifier.getStartPrecision(typeSystem);
        int fracPrecision = qualifier.getFractionalSecondPrecision(typeSystem);
        int maxPrecision = typeSystem.getMaxPrecision(qualifier.typeName());
        int minPrecision = typeSystem.getMinPrecision(qualifier.typeName());
        int minScale = typeSystem.getMinScale(qualifier.typeName());
        int maxScale = typeSystem.getMaxScale(qualifier.typeName());
        if (startPrecision < minPrecision || startPrecision > maxPrecision) {
            startPrecisionOutOfRange = true;
        } else if (fracPrecision < minScale || fracPrecision > maxScale) {
            fractionalSecondPrecisionOutOfRange = true;
        }
        if (startPrecisionOutOfRange) {
            throw this.newValidationError(qualifier, Static.RESOURCE.intervalStartPrecisionOutOfRange(startPrecision, "INTERVAL " + qualifier));
        }
        if (fractionalSecondPrecisionOutOfRange) {
            throw this.newValidationError(qualifier, Static.RESOURCE.intervalFractionalSecondPrecisionOutOfRange(fracPrecision, "INTERVAL " + qualifier));
        }
    }

    @Override
    public TimeFrame validateTimeFrame(SqlIntervalQualifier qualifier) {
        if (qualifier.timeFrameName == null) {
            TimeFrame timeFrame = this.timeFrameSet.get(qualifier.getUnit());
            return Objects.requireNonNull(timeFrame, () -> "time frame for " + qualifier.getUnit());
        }
        @Nullable TimeFrame timeFrame = this.timeFrameSet.getOpt(qualifier.timeFrameName);
        if (timeFrame != null) {
            return timeFrame;
        }
        throw this.newValidationError(qualifier, Static.RESOURCE.invalidTimeFrame(qualifier.timeFrameName));
    }

    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(targetRowType, "targetRowType");
        switch (node.getKind()) {
            case TABLE_REF: 
            case AS: {
                this.validateFrom((SqlNode)((SqlCall)node).operand(0), targetRowType, scope);
                break;
            }
            case VALUES: {
                this.validateValues((SqlCall)node, targetRowType, scope);
                break;
            }
            case JOIN: {
                this.validateJoin((SqlJoin)node, scope);
                break;
            }
            case OVER: {
                this.validateOver((SqlCall)node, scope);
                break;
            }
            case UNNEST: {
                this.validateUnnest((SqlCall)node, scope, targetRowType);
                break;
            }
            case COLLECTION_TABLE: {
                this.validateTableFunction((SqlCall)node, scope, targetRowType);
                break;
            }
            default: {
                this.validateQuery(node, scope, targetRowType);
            }
        }
        this.getNamespaceOrThrow(node, scope).validate(targetRowType);
    }

    protected void validateTableFunction(SqlCall node, SqlValidatorScope scope, RelDataType targetRowType) {
        SqlCall call = (SqlCall)node.operand(0);
        if (call.getOperator() instanceof SqlTableFunction) {
            SqlTableFunction tableFunction = (SqlTableFunction)((Object)call.getOperator());
            boolean visitedRowSemanticsTable = false;
            for (int idx = 0; idx < call.operandCount(); ++idx) {
                Object realNode;
                Object currentNode;
                TableCharacteristic tableCharacteristic = tableFunction.tableCharacteristic(idx);
                if (tableCharacteristic != null) {
                    if (tableCharacteristic.semantics == TableCharacteristic.Semantics.SET) continue;
                    if (visitedRowSemanticsTable) {
                        throw this.newValidationError(call, Static.RESOURCE.multipleRowSemanticsTables(call.getOperator().getName()));
                    }
                    visitedRowSemanticsTable = true;
                }
                if (!((currentNode = call.operand(idx)) instanceof SqlCall)) continue;
                SqlOperator op = ((SqlCall)currentNode).getOperator();
                if (op == SqlStdOperatorTable.ARGUMENT_ASSIGNMENT && (realNode = ((SqlBasicCall)currentNode).operand(0)) instanceof SqlCall) {
                    currentNode = realNode;
                    op = ((SqlCall)realNode).getOperator();
                }
                if (op != SqlStdOperatorTable.SET_SEMANTICS_TABLE) continue;
                this.throwInvalidRowSemanticsTable(call, idx, (SqlCall)currentNode);
            }
        }
        this.validateQuery(node, scope, targetRowType);
    }

    private void throwInvalidRowSemanticsTable(SqlCall call, int idx, SqlCall table) {
        SqlNodeList partitionList = (SqlNodeList)table.operand(1);
        if (!partitionList.isEmpty()) {
            throw this.newValidationError(call, Static.RESOURCE.invalidPartitionKeys(idx, call.getOperator().getName()));
        }
        SqlNodeList orderList = (SqlNodeList)table.operand(2);
        if (!orderList.isEmpty()) {
            throw this.newValidationError(call, Static.RESOURCE.invalidOrderBy(idx, call.getOperator().getName()));
        }
    }

    protected void validateOver(SqlCall call, SqlValidatorScope scope) {
        throw new AssertionError((Object)"OVER unexpected in this context");
    }

    protected void validateUnnest(SqlCall call, SqlValidatorScope scope, RelDataType targetRowType) {
        for (int i = 0; i < call.operandCount(); ++i) {
            SqlNode expandedItem = this.expand((SqlNode)call.operand(i), scope);
            call.setOperand(i, expandedItem);
        }
        this.validateQuery(call, scope, targetRowType);
    }

    private void checkRollUpInUsing(SqlIdentifier identifier, SqlNode leftOrRight, SqlValidatorScope scope) {
        String column;
        Table table;
        SqlValidatorTable sqlValidatorTable;
        SqlValidatorNamespace namespace = this.getNamespace(leftOrRight, scope);
        if (namespace != null && (sqlValidatorTable = namespace.getTable()) != null && (table = sqlValidatorTable.table()).isRolledUp(column = Util.last(identifier.names))) {
            throw this.newValidationError(identifier, Static.RESOURCE.rolledUpNotAllowed(column, "USING"));
        }
    }

    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        boolean natural = join.isNatural();
        JoinType joinType = join.getJoinType();
        JoinConditionType conditionType = join.getConditionType();
        SqlValidatorScope joinScope = this.getScopeOrThrow(join);
        this.validateFrom(left, this.unknownType, joinScope);
        this.validateFrom(right, this.unknownType, joinScope);
        switch (conditionType) {
            case NONE: {
                Preconditions.checkArgument((join.getCondition() == null ? 1 : 0) != 0);
                break;
            }
            case ON: {
                SqlNode condition = this.expand(SqlNonNullableAccessors.getCondition(join), joinScope);
                join.setOperand(5, condition);
                this.validateWhereOrOn(joinScope, condition, "ON");
                this.checkRollUp(null, join, condition, joinScope, "ON");
                break;
            }
            case USING: {
                List list = (List)((Object)SqlNonNullableAccessors.getCondition(join));
                Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"Empty USING clause");
                for (SqlIdentifier id : list) {
                    this.validateCommonJoinColumn(id, left, right, scope, natural);
                }
                break;
            }
            default: {
                throw Util.unexpected(conditionType);
            }
        }
        if (natural) {
            if (join.getCondition() != null) {
                throw this.newValidationError(SqlNonNullableAccessors.getCondition(join), Static.RESOURCE.naturalDisallowsOnOrUsing());
            }
            for (String name : this.deriveNaturalJoinColumnList(join)) {
                SqlIdentifier id = new SqlIdentifier(name, join.isNaturalNode().getParserPosition());
                this.validateCommonJoinColumn(id, left, right, scope, natural);
            }
        }
        switch (joinType) {
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: {
                if (!this.config.conformance().isLiberal()) {
                    throw this.newValidationError(join.getJoinTypeNode(), Static.RESOURCE.dialectDoesNotSupportFeature(joinType.name()));
                }
            }
            case LEFT: 
            case RIGHT: 
            case FULL: 
            case INNER: {
                if (join.getCondition() != null || natural) break;
                throw this.newValidationError(join, Static.RESOURCE.joinRequiresCondition());
            }
            case COMMA: 
            case CROSS: {
                if (join.getCondition() != null) {
                    throw this.newValidationError(join.getConditionTypeNode(), Static.RESOURCE.crossJoinDisallowsCondition());
                }
                if (!natural) break;
                throw this.newValidationError(join.getConditionTypeNode(), Static.RESOURCE.crossJoinDisallowsCondition());
            }
            case LEFT_ASOF: 
            case ASOF: {
                SqlAsofJoin asof = (SqlAsofJoin)join;
                SqlNode matchCondition = SqlNonNullableAccessors.getMatchCondition(asof);
                matchCondition = this.expand(matchCondition, joinScope);
                join.setOperand(6, matchCondition);
                this.validateWhereOrOn(joinScope, matchCondition, "MATCH_CONDITION");
                SqlNode condition = join.getCondition();
                if (condition == null) {
                    throw this.newValidationError(join, Static.RESOURCE.joinRequiresCondition());
                }
                ConjunctionOfEqualities conj = new ConjunctionOfEqualities();
                condition.accept(conj);
                if (conj.illegal) {
                    throw this.newValidationError(condition, Static.RESOURCE.asofConditionMustBeComparison());
                }
                CompareFromBothSides validateCompare = new CompareFromBothSides(joinScope, this.catalogReader, Static.RESOURCE.asofConditionMustBeComparison());
                condition.accept(validateCompare);
                if (!(matchCondition instanceof SqlCall)) {
                    throw this.newValidationError(matchCondition, Static.RESOURCE.asofMatchMustBeComparison());
                }
                SqlCall matchCall = (SqlCall)matchCondition;
                SqlOperator operator = matchCall.getOperator();
                if (!SqlKind.ORDER_COMPARISON.contains((Object)operator.kind)) {
                    throw this.newValidationError(matchCondition, Static.RESOURCE.asofMatchMustBeComparison());
                }
                validateCompare = new CompareFromBothSides(joinScope, this.catalogReader, Static.RESOURCE.asofMatchMustBeComparison());
                matchCondition.accept(validateCompare);
                break;
            }
            default: {
                throw Util.unexpected(joinType);
            }
        }
    }

    private void validateNoAggs(AggFinder aggFinder, SqlNode node, String clause) {
        SqlCall agg = aggFinder.findAgg(node);
        if (agg == null) {
            return;
        }
        SqlOperator op = agg.getOperator();
        if (op == SqlStdOperatorTable.OVER) {
            throw this.newValidationError(agg, Static.RESOURCE.windowedAggregateIllegalInClause(clause));
        }
        if (op.isGroup() || op.isGroupAuxiliary()) {
            throw this.newValidationError(agg, Static.RESOURCE.groupFunctionMustAppearInGroupByClause(op.getName()));
        }
        throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInClause(clause));
    }

    private void validateCommonJoinColumn(SqlIdentifier id, SqlNode left, SqlNode right, SqlValidatorScope scope, boolean natural) {
        RelDataType rightColType;
        if (id.names.size() != 1) {
            throw this.newValidationError(id, Static.RESOURCE.columnNotFound(id.toString()));
        }
        RelDataType leftColType = natural ? this.checkAndDeriveDataType(id, left) : this.validateCommonInputJoinColumn(id, left, scope, natural);
        if (!SqlTypeUtil.isComparable(leftColType, rightColType = this.validateCommonInputJoinColumn(id, right, scope, natural))) {
            throw this.newValidationError(id, Static.RESOURCE.naturalOrUsingColumnNotCompatible(id.getSimple(), leftColType.toString(), rightColType.toString()));
        }
    }

    private RelDataType checkAndDeriveDataType(SqlIdentifier id, SqlNode node) {
        Preconditions.checkArgument((id.names.size() == 1 ? 1 : 0) != 0);
        String name = (String)id.names.get(0);
        SqlNameMatcher nameMatcher = this.getCatalogReader().nameMatcher();
        RelDataType rowType = this.getNamespaceOrThrow(node).getRowType();
        RelDataTypeField field = Objects.requireNonNull(nameMatcher.field(rowType, name), () -> "unable to find left field " + name + " in " + rowType);
        return field.getType();
    }

    private RelDataType validateCommonInputJoinColumn(SqlIdentifier id, SqlNode leftOrRight, SqlValidatorScope scope, boolean natural) {
        Collection<RelDataType> rowTypes;
        Preconditions.checkArgument((id.names.size() == 1 ? 1 : 0) != 0);
        String name = (String)id.names.get(0);
        SqlValidatorNamespace namespace = this.getNamespaceOrThrow(leftOrRight);
        RelDataType rowType = namespace.getRowType();
        SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
        RelDataTypeField field = nameMatcher.field(rowType, name);
        if (field == null) {
            throw this.newValidationError(id, Static.RESOURCE.columnNotFound(name));
        }
        if (!natural && rowType instanceof RelCrossType) {
            RelCrossType crossType = (RelCrossType)rowType;
            rowTypes = new ArrayList<RelDataType>(crossType.getTypes());
        } else {
            rowTypes = Collections.singleton(rowType);
        }
        for (RelDataType rowType0 : rowTypes) {
            if (nameMatcher.frequency(rowType0.getFieldNames(), name) <= 1) continue;
            throw this.newValidationError(id, Static.RESOURCE.columnInUsingNotUnique(name));
        }
        this.checkRollUpInUsing(id, leftOrRight, scope);
        return field.getType();
    }

    protected void validateSelect(SqlSelect select, RelDataType targetRowType) {
        int duplicateAliasOrdinal;
        SqlIdentifier id;
        SqlNode selectItem;
        Objects.requireNonNull(targetRowType, "targetRowType");
        SelectNamespace ns = this.getNamespaceOrThrow(select).unwrap(SelectNamespace.class);
        assert (ns.rowType == null);
        SqlNode distinctNode = select.getModifierNode(SqlSelectKeyword.DISTINCT);
        if (distinctNode != null) {
            this.validateFeature(Static.RESOURCE.sQLFeature_E051_01(), distinctNode.getParserPosition());
        }
        SqlNodeList selectItems = SqlNonNullableAccessors.getSelectList(select);
        RelDataType fromType = this.unknownType;
        if (selectItems.size() == 1 && (selectItem = selectItems.get(0)) instanceof SqlIdentifier && (id = (SqlIdentifier)selectItem).isStar() && id.names.size() == 1) {
            fromType = targetRowType;
        }
        SelectScope fromScope = (SelectScope)this.getFromScope(select);
        List<@Nullable String> names = fromScope.getChildNames();
        if (!this.catalogReader.nameMatcher().isCaseSensitive()) {
            names = names.stream().map(s -> s == null ? null : s.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
        }
        if ((duplicateAliasOrdinal = Util.firstDuplicate(names)) >= 0) {
            ScopeChild child = (ScopeChild)fromScope.children.get(duplicateAliasOrdinal);
            throw this.newValidationError(Objects.requireNonNull(child.namespace.getEnclosingNode(), () -> "enclosingNode of namespace of " + child.name), Static.RESOURCE.fromAliasDuplicate(child.name));
        }
        SqlNode from = select.getFrom();
        if (from == null) {
            if (this.config.conformance().isFromRequired()) {
                throw this.newValidationError(select, Static.RESOURCE.selectMissingFrom());
            }
        } else {
            this.validateFrom(from, fromType, fromScope);
        }
        this.validateWhereClause(select);
        this.validateGroupClause(select);
        this.validateWindowClause(select);
        this.validateQualifyClause(select);
        this.handleOffsetFetch(select.getOffset(), select.getFetch());
        RelDataType rowType = this.validateSelectList(selectItems, select, targetRowType);
        ns.setType(rowType);
        this.validateHavingClause(select);
        this.validateMustFilterRequirements(select, ns);
        this.validateOrderList(select);
        if (SqlValidatorImpl.shouldCheckForRollUp(from)) {
            this.checkRollUpInSelectList(select);
            this.checkRollUp(null, select, select.getWhere(), this.getWhereScope(select));
            this.checkRollUp(null, select, select.getHaving(), this.getHavingScope(select));
            this.checkRollUpInWindowDecl(select);
            this.checkRollUpInGroupBy(select);
            this.checkRollUpInOrderBy(select);
        }
    }

    private static void forEachQualified(SqlNode node, final SqlValidatorScope scope, final Consumer<SqlQualified> consumer) {
        node.accept(new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlIdentifier id) {
                SqlQualified qualified = scope.fullyQualify(id);
                consumer.accept(qualified);
                return null;
            }
        });
    }

    private static void purgeForBypassFields(SqlNode node, final SqlValidatorScope scope, final Set<SqlQualified> qualifieds, final Set<SqlQualified> bypassQualifieds, final Set<SqlQualified> remnantMustFilterFields) {
        node.accept(new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlIdentifier id) {
                SqlQualified qualified = scope.fullyQualify(id);
                if (bypassQualifieds.contains(qualified)) {
                    Collection sameIdentifier = qualifieds.stream().filter(q -> SqlValidatorImpl.qualifiedMatchesIdentifier(q, qualified)).collect(Collectors.toList());
                    sameIdentifier.forEach(qualifieds::remove);
                    Collection sameIdentifier_ = remnantMustFilterFields.stream().filter(q -> SqlValidatorImpl.qualifiedMatchesIdentifier(q, qualified)).collect(Collectors.toList());
                    sameIdentifier_.forEach(remnantMustFilterFields::remove);
                }
                return null;
            }
        });
    }

    private static void toQualifieds(ImmutableBitSet fields, Set<SqlQualified> qualifiedSet, SelectScope fromScope, ScopeChild child, List<String> fieldNames) {
        fields.forEachInt(i -> qualifiedSet.add(SqlQualified.create(fromScope, 1, child.namespace, new SqlIdentifier((List<String>)ImmutableList.of((Object)child.name, fieldNames.get(i)), SqlParserPos.ZERO))));
    }

    private static boolean qualifiedMatchesIdentifier(SqlQualified q1, SqlQualified q2) {
        return ((String)q1.identifier.names.get(0)).equals(q2.identifier.names.get(0));
    }

    private void checkRollUpInSelectList(SqlSelect select) {
        SqlValidatorScope scope = this.getSelectScope(select);
        for (SqlNode item : SqlNonNullableAccessors.getSelectList(select)) {
            if (SqlValidatorUtil.isMeasure(item)) continue;
            this.checkRollUp(null, select, item, scope);
        }
    }

    private void checkRollUpInGroupBy(SqlSelect select) {
        SqlNodeList group = select.getGroup();
        if (group != null) {
            for (SqlNode node : group) {
                this.checkRollUp(null, select, node, this.getGroupScope(select), "GROUP BY");
            }
        }
    }

    private void checkRollUpInOrderBy(SqlSelect select) {
        SqlNodeList orderList = select.getOrderList();
        if (orderList != null) {
            for (SqlNode node : orderList) {
                this.checkRollUp(null, select, node, this.getOrderScope(select), "ORDER BY");
            }
        }
    }

    private void checkRollUpInWindow(@Nullable SqlWindow window, SqlValidatorScope scope) {
        if (window != null) {
            for (SqlNode node : window.getPartitionList()) {
                this.checkRollUp(null, window, node, scope, "PARTITION BY");
            }
            for (SqlNode node : window.getOrderList()) {
                this.checkRollUp(null, window, node, scope, "ORDER BY");
            }
        }
    }

    private void checkRollUpInWindowDecl(SqlSelect select) {
        for (SqlNode decl : select.getWindowList()) {
            this.checkRollUpInWindow((SqlWindow)decl, this.getSelectScope(select));
        }
    }

    private static SqlNode stripDot(SqlNode node) {
        SqlNode res = node;
        while (res.getKind() == SqlKind.DOT) {
            res = (SqlNode)Objects.requireNonNull(((SqlCall)res).operand(0), "operand");
        }
        return res;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void checkRollUp(@Nullable SqlNode grandParent, @Nullable SqlNode parent, @Nullable SqlNode current, SqlValidatorScope scope, @Nullable String contextClause) {
        SqlIdentifier id;
        if ((current = SqlUtil.stripAs(current)) instanceof SqlCall && !(current instanceof SqlSelect)) {
            this.checkRollUpInWindow(SqlValidatorImpl.getWindowInOver(current), scope);
            current = SqlValidatorImpl.stripOver(current);
            SqlNode stripDot = SqlValidatorImpl.stripDot(current);
            if (stripDot != current) {
                this.checkRollUp(grandParent, parent, stripDot, scope, contextClause);
            } else if (stripDot.getKind() == SqlKind.CONVERT || stripDot.getKind() == SqlKind.TRANSLATE || stripDot.getKind() == SqlKind.CONVERT_ORACLE) {
                SqlNode child = ((SqlCall)stripDot).getOperandList().get(0);
                this.checkRollUp(parent, current, child, scope, contextClause);
            } else if (stripDot.getKind() != SqlKind.LAMBDA) {
                List<@Nullable SqlNode> children = ((SqlCall)stripDot).getOperandList();
                for (SqlNode child : children) {
                    this.checkRollUp(parent, current, child, scope, contextClause);
                }
            }
        } else if (!(!(current instanceof SqlIdentifier) || (id = (SqlIdentifier)current).isStar() || !this.isRolledUpColumn(id, scope) || SqlValidatorImpl.isAggregation(Objects.requireNonNull(parent, "parent").getKind()) && this.isRolledUpColumnAllowedInAgg(id, scope, (SqlCall)parent, grandParent))) {
            String context = contextClause != null ? contextClause : parent.getKind().toString();
            throw this.newValidationError(id, Static.RESOURCE.rolledUpNotAllowed(SqlValidatorUtil.alias(id, 0), context));
        }
    }

    private void checkRollUp(@Nullable SqlNode grandParent, SqlNode parent, @Nullable SqlNode current, SqlValidatorScope scope) {
        this.checkRollUp(grandParent, parent, current, scope, null);
    }

    private static @Nullable SqlWindow getWindowInOver(SqlNode over) {
        if (over.getKind() == SqlKind.OVER) {
            SqlNode window = ((SqlCall)over).getOperandList().get(1);
            if (window instanceof SqlWindow) {
                return (SqlWindow)window;
            }
            return null;
        }
        return null;
    }

    private static SqlNode stripOver(SqlNode node) {
        switch (node.getKind()) {
            case OVER: {
                return ((SqlCall)node).getOperandList().get(0);
            }
        }
        return node;
    }

    private @Nullable Pair<String, String> findTableColumnPair(SqlIdentifier identifier, SqlValidatorScope scope) {
        SqlCall call = this.makeNullaryCall(identifier);
        if (call != null) {
            return null;
        }
        SqlQualified qualified = scope.fullyQualify(identifier);
        ImmutableList<String> names = qualified.identifier.names;
        if (names.size() < 2) {
            return null;
        }
        return new Pair<String, String>((String)names.get(names.size() - 2), Util.last(names));
    }

    private boolean isRolledUpColumnAllowedInAgg(SqlIdentifier identifier, SqlValidatorScope scope, SqlCall aggCall, @Nullable SqlNode parent) {
        Pair<String, String> pair = this.findTableColumnPair(identifier, scope);
        if (pair == null) {
            return true;
        }
        String columnName = (String)pair.right;
        Table table = SqlValidatorImpl.resolveTable(identifier, scope);
        if (table != null) {
            return table.rolledUpColumnValidInsideAgg(columnName, aggCall, parent, this.catalogReader.getConfig());
        }
        return true;
    }

    private static @Nullable Table resolveTable(SqlIdentifier identifier, SqlValidatorScope scope) {
        SqlQualified fullyQualified = scope.fullyQualify(identifier);
        if (fullyQualified.namespace == null) {
            throw new IllegalArgumentException("namespace must not be null in " + fullyQualified);
        }
        SqlValidatorTable sqlValidatorTable = fullyQualified.namespace.getTable();
        if (sqlValidatorTable != null) {
            return sqlValidatorTable.table();
        }
        return null;
    }

    private boolean isRolledUpColumn(SqlIdentifier identifier, SqlValidatorScope scope) {
        Pair<String, String> pair = this.findTableColumnPair(identifier, scope);
        if (pair == null) {
            return false;
        }
        String columnName = (String)pair.right;
        Table table = SqlValidatorImpl.resolveTable(identifier, scope);
        if (table != null) {
            return table.isRolledUp(columnName);
        }
        return false;
    }

    private static boolean shouldCheckForRollUp(@Nullable SqlNode from) {
        if (from != null) {
            SqlKind kind = SqlUtil.stripAs(from).getKind();
            return kind != SqlKind.VALUES && kind != SqlKind.SELECT;
        }
        return false;
    }

    private void validateModality(SqlNode query) {
        SqlModality modality = SqlValidatorImpl.deduceModality(query);
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            this.validateModality(select, modality, true);
        } else if (query.getKind() == SqlKind.VALUES) {
            switch (modality) {
                case STREAM: {
                    throw this.newValidationError(query, Static.RESOURCE.cannotStreamValues());
                }
            }
        } else if (query.getKind() == SqlKind.WITH) {
            this.validateModality(((SqlWith)query).body);
        } else {
            assert (query.isA(SqlKind.SET_QUERY));
            SqlCall call = (SqlCall)query;
            for (SqlNode operand : call.getOperandList()) {
                if (SqlValidatorImpl.deduceModality(operand) != modality) {
                    throw this.newValidationError(operand, Static.RESOURCE.streamSetOpInconsistentInputs());
                }
                this.validateModality(operand);
            }
        }
    }

    private static SqlModality deduceModality(SqlNode query) {
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            return select.getModifierNode(SqlSelectKeyword.STREAM) != null ? SqlModality.STREAM : SqlModality.RELATION;
        }
        if (query.getKind() == SqlKind.VALUES) {
            return SqlModality.RELATION;
        }
        if (query.getKind() == SqlKind.WITH) {
            return SqlValidatorImpl.deduceModality(((SqlWith)query).body);
        }
        assert (query.isA(SqlKind.SET_QUERY));
        SqlCall call = (SqlCall)query;
        return SqlValidatorImpl.deduceModality(call.getOperandList().get(0));
    }

    @Override
    public boolean validateModality(SqlSelect select, SqlModality modality, boolean fail) {
        SqlNodeList orderList;
        SqlNode aggregateNode;
        SelectScope scope = this.getRawSelectScopeNonNull(select);
        switch (modality) {
            case STREAM: {
                if (scope.children.size() == 1) {
                    for (Object child : scope.children) {
                        if (((ScopeChild)child).namespace.supportsModality(modality)) continue;
                        if (fail) {
                            SqlNode node = SqlNonNullableAccessors.getNode((ScopeChild)child);
                            throw this.newValidationError(node, Static.RESOURCE.cannotConvertToStream(((ScopeChild)child).name));
                        }
                        return false;
                    }
                    break;
                }
                int supportsModalityCount = 0;
                for (ScopeChild child : scope.children) {
                    if (!child.namespace.supportsModality(modality)) continue;
                    ++supportsModalityCount;
                }
                if (supportsModalityCount != 0) break;
                if (fail) {
                    String inputs = String.join((CharSequence)", ", scope.getChildNames());
                    throw this.newValidationError(select, Static.RESOURCE.cannotStreamResultsForNonStreamingInputs(inputs));
                }
                return false;
            }
            default: {
                for (Object child : scope.children) {
                    if (((ScopeChild)child).namespace.supportsModality(modality)) continue;
                    if (fail) {
                        SqlNode node = SqlNonNullableAccessors.getNode((ScopeChild)child);
                        throw this.newValidationError(node, Static.RESOURCE.cannotConvertToRelation(((ScopeChild)child).name));
                    }
                    return false;
                }
            }
        }
        if ((aggregateNode = this.getAggregate(select)) != null) {
            switch (modality) {
                case STREAM: {
                    SqlNodeList groupList = select.getGroup();
                    if (groupList != null && SqlValidatorUtil.containsMonotonic(scope, groupList)) break;
                    if (fail) {
                        throw this.newValidationError(aggregateNode, Static.RESOURCE.streamMustGroupByMonotonic());
                    }
                    return false;
                }
            }
        }
        if ((orderList = select.getOrderList()) != null && !orderList.isEmpty()) {
            switch (modality) {
                case STREAM: {
                    if (SqlValidatorImpl.hasSortedPrefix(scope, orderList)) break;
                    if (fail) {
                        throw this.newValidationError(orderList.get(0), Static.RESOURCE.streamMustOrderByMonotonic());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean hasSortedPrefix(SelectScope scope, SqlNodeList orderList) {
        return SqlValidatorImpl.isSortCompatible(scope, orderList.get(0), false);
    }

    private static boolean isSortCompatible(SelectScope scope, SqlNode node, boolean descending) {
        switch (node.getKind()) {
            case DESCENDING: {
                return SqlValidatorImpl.isSortCompatible(scope, ((SqlCall)node).getOperandList().get(0), true);
            }
        }
        SqlMonotonicity monotonicity = scope.getMonotonicity(node);
        switch (monotonicity) {
            case INCREASING: 
            case STRICTLY_INCREASING: {
                return !descending;
            }
            case DECREASING: 
            case STRICTLY_DECREASING: {
                return descending;
            }
        }
        return false;
    }

    protected void validateWindowClause(SqlSelect select) {
        SqlNodeList windowList = select.getWindowList();
        if (windowList.isEmpty()) {
            return;
        }
        SelectScope windowScope = (SelectScope)this.getFromScope(select);
        for (SqlWindow window : windowList) {
            SqlIdentifier declName = Objects.requireNonNull(window.getDeclName(), () -> "window.getDeclName() for " + window);
            if (!declName.isSimple()) {
                throw this.newValidationError(declName, Static.RESOURCE.windowNameMustBeSimple());
            }
            if (windowScope.existingWindowName(declName.toString())) {
                throw this.newValidationError(declName, Static.RESOURCE.duplicateWindowName());
            }
            windowScope.addWindowName(declName.toString());
        }
        for (int i = 0; i < windowList.size(); ++i) {
            SqlNode window1 = windowList.get(i);
            for (int j = i + 1; j < windowList.size(); ++j) {
                SqlNode window2 = windowList.get(j);
                if (!window1.equalsDeep(window2, Litmus.IGNORE)) continue;
                throw this.newValidationError(window2, Static.RESOURCE.dupWindowSpec());
            }
        }
        for (SqlWindow window : windowList) {
            SqlNodeList expandedOrderList = (SqlNodeList)this.expand(window.getOrderList(), windowScope);
            window.setOrderList(expandedOrderList);
            expandedOrderList.validate(this, windowScope);
            SqlNodeList expandedPartitionList = (SqlNodeList)this.expand(window.getPartitionList(), windowScope);
            window.setPartitionList(expandedPartitionList);
            expandedPartitionList.validate(this, windowScope);
        }
        windowList.validate(this, windowScope);
    }

    protected void validateQualifyClause(SqlSelect select) {
        boolean qualifyContainsWindowFunction;
        SqlNode qualifyNode = select.getQualify();
        if (qualifyNode == null) {
            return;
        }
        SqlValidatorScope qualifyScope = this.getSelectScope(select);
        qualifyNode = this.extendedExpand(qualifyNode, qualifyScope, select, Clause.QUALIFY);
        select.setQualify(qualifyNode);
        this.inferUnknownTypes(this.booleanType, qualifyScope, qualifyNode);
        qualifyNode.validate(this, qualifyScope);
        RelDataType type = this.deriveType(qualifyScope, qualifyNode);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw this.newValidationError(qualifyNode, Static.RESOURCE.condMustBeBoolean("QUALIFY"));
        }
        boolean bl = qualifyContainsWindowFunction = this.overFinder.findAgg(qualifyNode) != null;
        if (!qualifyContainsWindowFunction) {
            throw this.newValidationError(qualifyNode, Static.RESOURCE.qualifyExpressionMustContainWindowFunction(qualifyNode.toString()));
        }
    }

    protected void validateMustFilterRequirements(SqlSelect select, SelectNamespace ns) {
        ns.filterRequirement = FilterRequirement.EMPTY;
        if (select.getFrom() != null) {
            SelectScope fromScope = (SelectScope)this.getFromScope(select);
            BitSet projectedNonFilteredBypassField = new BitSet();
            LinkedHashSet<SqlQualified> qualifieds = new LinkedHashSet<SqlQualified>();
            LinkedHashSet<SqlQualified> bypassQualifieds = new LinkedHashSet<SqlQualified>();
            LinkedHashSet<SqlQualified> remnantQualifieds = new LinkedHashSet<SqlQualified>();
            for (ScopeChild child : fromScope.children) {
                List<String> fieldNames = child.namespace.getRowType().getFieldNames();
                FilterRequirement filterRequirement = child.namespace.getFilterRequirement();
                SqlValidatorImpl.toQualifieds(filterRequirement.filterFields, qualifieds, fromScope, child, fieldNames);
                SqlValidatorImpl.toQualifieds(filterRequirement.bypassFields, bypassQualifieds, fromScope, child, fieldNames);
                remnantQualifieds.addAll((Collection<SqlQualified>)filterRequirement.remnantFilterFields);
            }
            if (!qualifieds.isEmpty() || !bypassQualifieds.isEmpty()) {
                if (select.getWhere() != null) {
                    SqlValidatorImpl.forEachQualified(select.getWhere(), this.getWhereScope(select), qualifieds::remove);
                    SqlValidatorImpl.purgeForBypassFields(select.getWhere(), this.getWhereScope(select), qualifieds, bypassQualifieds, remnantQualifieds);
                }
                if (select.getHaving() != null) {
                    SqlValidatorImpl.forEachQualified(select.getHaving(), this.getHavingScope(select), qualifieds::remove);
                    SqlValidatorImpl.purgeForBypassFields(select.getHaving(), this.getHavingScope(select), qualifieds, bypassQualifieds, remnantQualifieds);
                }
                BitSet mustFilterFields = new BitSet();
                BitSet mustFilterBypassFields = new BitSet();
                List<SqlNode> expandedSelectItems = Objects.requireNonNull(fromScope.getExpandedSelectList(), "expandedSelectList");
                Ord.forEach(expandedSelectItems, (selectItem, i) -> {
                    if ((selectItem = SqlUtil.stripAs(selectItem)) instanceof SqlIdentifier) {
                        SqlQualified qualified = fromScope.fullyQualify((SqlIdentifier)selectItem);
                        if (qualifieds.remove(qualified)) {
                            mustFilterFields.set(i);
                        }
                        if (bypassQualifieds.remove(qualified)) {
                            mustFilterBypassFields.set(i);
                            projectedNonFilteredBypassField.set(0);
                        }
                    }
                });
                if (!qualifieds.isEmpty() && !projectedNonFilteredBypassField.get(0)) {
                    throw this.newValidationError(select, Static.RESOURCE.mustFilterFieldsMissing(qualifieds.stream().map(q -> q.suffix().get(0)).collect(Collectors.toCollection(TreeSet::new)).toString()));
                }
                ImmutableSet remnantMustFilterFields = (ImmutableSet)Stream.of(remnantQualifieds, qualifieds).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
                ns.filterRequirement = new FilterRequirement(ImmutableBitSet.fromBitSet(mustFilterFields), ImmutableBitSet.fromBitSet(mustFilterBypassFields), (Set<SqlQualified>)remnantMustFilterFields);
            }
        }
    }

    @Override
    public void validateWith(SqlWith with, SqlValidatorScope scope) {
        SqlValidatorNamespace namespace = this.getNamespaceOrThrow(with);
        this.validateNamespace(namespace, this.unknownType);
    }

    @Override
    public void validateWithItem(SqlWithItem withItem) {
        SqlNodeList columnList = withItem.columnList;
        if (columnList != null) {
            RelDataType rowType = this.getValidatedNodeType(withItem.query);
            int fieldCount = rowType.getFieldCount();
            if (columnList.size() != fieldCount) {
                throw this.newValidationError(columnList, Static.RESOURCE.columnCountMismatch());
            }
            SqlValidatorUtil.checkIdentifierListForDuplicates(columnList, this.validationErrorFunction);
        } else {
            List<String> fieldNames = this.getValidatedNodeType(withItem.query).getFieldNames();
            int i = Util.firstDuplicate(fieldNames);
            if (i >= 0) {
                throw this.newValidationError(withItem.query, Static.RESOURCE.duplicateColumnAndNoColumnList(fieldNames.get(i)));
            }
        }
    }

    @Override
    public void validateSequenceValue(SqlValidatorScope scope, SqlIdentifier id) {
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        scope.resolveTable((List<String>)id.names, this.catalogReader.nameMatcher(), SqlValidatorScope.Path.EMPTY, resolved);
        if (resolved.count() != 1) {
            throw this.newValidationError(id, Static.RESOURCE.tableNameNotFound(id.toString()));
        }
        SqlValidatorNamespace ns = resolved.only().namespace;
        if (ns instanceof TableNamespace) {
            Table table = SqlNonNullableAccessors.getTable(ns).table();
            switch (table.getJdbcTableType()) {
                case SEQUENCE: 
                case TEMPORARY_SEQUENCE: {
                    return;
                }
            }
        }
        throw this.newValidationError(id, Static.RESOURCE.notASequence(id.toString()));
    }

    @Override
    public TypeCoercion getTypeCoercion() {
        assert (this.config.typeCoercionEnabled());
        return this.typeCoercion;
    }

    @Override
    public SqlValidator.Config config() {
        return Objects.requireNonNull(this.config, "config");
    }

    @Override
    public SqlValidator transform(UnaryOperator<SqlValidator.Config> transform) {
        this.config = (SqlValidator.Config)Objects.requireNonNull(transform.apply(this.config), "config");
        return this;
    }

    protected void validateOrderList(SqlSelect select) {
        SqlNodeList orderList = select.getOrderList();
        if (orderList == null) {
            return;
        }
        if (!this.shouldAllowIntermediateOrderBy() && !this.cursorSet.contains(select)) {
            throw this.newValidationError(select, Static.RESOURCE.invalidOrderByPos());
        }
        SqlValidatorScope orderScope = this.getOrderScope(select);
        Objects.requireNonNull(orderScope, "orderScope");
        ArrayList<SqlNode> expandList = new ArrayList<SqlNode>();
        for (SqlNode orderItem : orderList) {
            SqlNode expandedOrderItem = this.expand(orderItem, orderScope);
            expandList.add(expandedOrderItem);
        }
        SqlNodeList expandedOrderList = new SqlNodeList(expandList, orderList.getParserPosition());
        select.setOrderBy(expandedOrderList);
        for (SqlNode orderItem : expandedOrderList) {
            this.validateOrderItem(select, orderItem);
        }
    }

    private void validateGroupByItem(SqlSelect select, SqlNode groupByItem) {
        SqlValidatorScope groupByScope = this.getGroupScope(select);
        this.validateGroupByExpr(groupByItem, groupByScope);
        groupByScope.validateExpr(groupByItem);
    }

    private void validateGroupByExpr(SqlNode groupByItem, SqlValidatorScope groupByScope) {
        switch (groupByItem.getKind()) {
            case GROUP_BY_DISTINCT: {
                SqlCall call = (SqlCall)groupByItem;
                for (SqlNode operand : call.getOperandList()) {
                    this.validateGroupByExpr(operand, groupByScope);
                }
                break;
            }
            case GROUPING_SETS: 
            case ROLLUP: 
            case CUBE: {
                SqlCall call = (SqlCall)groupByItem;
                for (SqlNode operand : call.getOperandList()) {
                    this.validateExpr(operand, groupByScope);
                }
                break;
            }
            default: {
                this.validateExpr(groupByItem, groupByScope);
            }
        }
    }

    private void validateOrderItem(SqlSelect select, SqlNode orderItem) {
        switch (orderItem.getKind()) {
            case DESCENDING: {
                this.validateFeature(Static.RESOURCE.sQLConformance_OrderByDesc(), orderItem.getParserPosition());
                this.validateOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0));
                return;
            }
        }
        SqlValidatorScope orderScope = this.getOrderScope(select);
        this.validateExpr(orderItem, orderScope);
    }

    @Override
    public SqlNode expandOrderExpr(SqlSelect select, SqlNode orderExpr) {
        SqlNode orderExpr2 = new OrderExpressionExpander(select, orderExpr).go();
        if (orderExpr2 == orderExpr) {
            return orderExpr2;
        }
        SqlValidatorScope scope = this.getOrderScope(select);
        this.inferUnknownTypes(this.unknownType, scope, orderExpr2);
        RelDataType type = this.deriveType(scope, orderExpr2);
        this.setValidatedNodeType(orderExpr2, type);
        if (!type.isMeasure()) {
            return orderExpr2;
        }
        SqlNode orderExpr3 = SqlValidatorImpl.measureToValue(orderExpr2);
        RelDataType type3 = this.deriveType(scope, orderExpr3);
        this.setValidatedNodeType(orderExpr3, type3);
        return orderExpr3;
    }

    private static SqlNode measureToValue(SqlNode e) {
        if (e.getKind() == SqlKind.V2M) {
            return ((SqlCall)e).operand(0);
        }
        return SqlInternalOperators.M2V.createCall(e.getParserPosition(), e);
    }

    protected void validateGroupClause(SqlSelect select) {
        SqlNodeList groupList = select.getGroup();
        if (groupList == null) {
            return;
        }
        String clause = "GROUP BY";
        this.validateNoAggs(this.aggOrOverFinder, groupList, "GROUP BY");
        SqlValidatorScope groupScope = this.getGroupScope(select);
        ArrayList<SqlNode> expandedList = new ArrayList<SqlNode>();
        for (SqlNode groupItem : groupList) {
            SqlNode expandedItem = this.extendedExpand(groupItem, groupScope, select, Clause.GROUP_BY);
            expandedList.add(expandedItem);
        }
        groupList = new SqlNodeList(expandedList, groupList.getParserPosition());
        select.setGroupBy(groupList);
        this.inferUnknownTypes(this.unknownType, groupScope, groupList);
        for (SqlNode groupItem : expandedList) {
            this.validateGroupByItem(select, groupItem);
        }
        block5: for (SqlNode node : groupList) {
            switch (node.getKind()) {
                case GROUP_BY_DISTINCT: 
                case GROUPING_SETS: 
                case ROLLUP: 
                case CUBE: {
                    node.validate(this, groupScope);
                    continue block5;
                }
            }
            node.validateExpr(this, groupScope);
        }
        SqlValidatorScope selectScope = this.getSelectScope(select);
        AggregatingSelectScope aggregatingScope = null;
        if (selectScope instanceof AggregatingSelectScope) {
            aggregatingScope = (AggregatingSelectScope)selectScope;
        }
        for (SqlNode groupItem : groupList) {
            if (groupItem instanceof SqlNodeList && ((SqlNodeList)groupItem).isEmpty()) continue;
            this.validateGroupItem(groupScope, aggregatingScope, groupItem);
        }
        SqlCall agg = this.aggFinder.findAgg(groupList);
        if (agg != null) {
            throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInClause("GROUP BY"));
        }
    }

    private void validateGroupItem(SqlValidatorScope groupScope, @Nullable AggregatingSelectScope aggregatingScope, SqlNode groupItem) {
        switch (groupItem.getKind()) {
            case GROUP_BY_DISTINCT: {
                for (SqlNode sqlNode : ((SqlCall)groupItem).getOperandList()) {
                    this.validateGroupItem(groupScope, aggregatingScope, sqlNode);
                }
                break;
            }
            case GROUPING_SETS: 
            case ROLLUP: 
            case CUBE: {
                this.validateGroupingSets(groupScope, aggregatingScope, (SqlCall)groupItem);
                break;
            }
            default: {
                if (groupItem instanceof SqlNodeList) break;
                RelDataType type = this.deriveType(groupScope, groupItem);
                this.setValidatedNodeType(groupItem, type);
            }
        }
    }

    private void validateGroupingSets(SqlValidatorScope groupScope, @Nullable AggregatingSelectScope aggregatingScope, SqlCall groupItem) {
        for (SqlNode node : groupItem.getOperandList()) {
            this.validateGroupItem(groupScope, aggregatingScope, node);
        }
    }

    protected void validateWhereClause(SqlSelect select) {
        SqlNode where = select.getWhere();
        if (where == null) {
            return;
        }
        SqlValidatorScope whereScope = this.getWhereScope(select);
        SqlNode expandedWhere = this.expand(where, whereScope);
        select.setWhere(expandedWhere);
        this.validateWhereOrOn(whereScope, expandedWhere, "WHERE");
    }

    protected void validateWhereOrOn(SqlValidatorScope scope, SqlNode condition, String clause) {
        this.validateNoAggs(this.aggOrOverOrGroupFinder, condition, clause);
        this.inferUnknownTypes(this.booleanType, scope, condition);
        condition.validate(this, scope);
        RelDataType type = this.deriveType(scope, condition);
        if (!SqlValidatorImpl.isReturnBooleanType(type)) {
            throw this.newValidationError(condition, Static.RESOURCE.condMustBeBoolean(clause));
        }
    }

    private static boolean isReturnBooleanType(RelDataType relDataType) {
        if (relDataType instanceof RelRecordType) {
            RelRecordType recordType = (RelRecordType)relDataType;
            Preconditions.checkState((recordType.getFieldList().size() == 1 ? 1 : 0) != 0, (Object)"sub-query as condition must return only one column");
            RelDataTypeField recordField = recordType.getFieldList().get(0);
            return SqlTypeUtil.inBooleanFamily(recordField.getType());
        }
        return SqlTypeUtil.inBooleanFamily(relDataType);
    }

    protected void validateHavingClause(SqlSelect select) {
        SqlNode newExpr;
        SqlNode having = select.getHaving();
        if (having == null) {
            return;
        }
        SqlNode originalHaving = having;
        AggregatingScope havingScope = (AggregatingScope)this.getSelectScope(select);
        if (this.config.conformance().isHavingAlias() && having != (newExpr = this.extendedExpand(having, havingScope, select, Clause.HAVING))) {
            having = newExpr;
            select.setHaving(newExpr);
        }
        if (SqlUtil.containsCall(having, call -> call.getOperator() instanceof SqlOverOperator)) {
            throw this.newValidationError(originalHaving, Static.RESOURCE.windowInHavingNotAllowed());
        }
        this.inferUnknownTypes(this.booleanType, havingScope, having);
        havingScope.checkAggregateExpr(having, true);
        having.validate(this, havingScope);
        RelDataType type = this.deriveType(havingScope, having);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw this.newValidationError(having, Static.RESOURCE.havingMustBeBoolean());
        }
    }

    protected RelDataType validateSelectList(SqlNodeList selectItems, SqlSelect select, RelDataType targetRowType) {
        SqlValidatorScope selectScope = this.getSelectScope(select);
        ArrayList<SqlNode> expandedSelectItems = new ArrayList<SqlNode>();
        HashSet<String> aliases = new HashSet<String>();
        PairList<String, RelDataType> fieldList = PairList.of();
        for (SqlNode selectItem : selectItems) {
            if (selectItem instanceof SqlSelect) {
                this.handleScalarSubQuery(select, (SqlSelect)selectItem, expandedSelectItems, aliases, fieldList);
                continue;
            }
            int fieldIdx = fieldList.size();
            RelDataType fieldType = targetRowType.isStruct() && targetRowType.getFieldCount() > fieldIdx ? targetRowType.getFieldList().get(fieldIdx).getType() : this.unknownType;
            this.expandSelectItem(selectItem, select, fieldType, expandedSelectItems, aliases, fieldList, false);
        }
        SqlNodeList newSelectList = new SqlNodeList(expandedSelectItems, selectItems.getParserPosition());
        if (this.config.identifierExpansion()) {
            select.setSelectList(newSelectList);
        }
        this.getRawSelectScopeNonNull(select).setExpandedSelectList(expandedSelectItems);
        this.inferUnknownTypes(targetRowType, selectScope, newSelectList);
        boolean aggregate = this.isAggregate(select) || select.isDistinct();
        for (SqlNode selectItem : expandedSelectItems) {
            if (SqlValidatorUtil.isMeasure(selectItem) && aggregate) {
                throw this.newValidationError(selectItem, Static.RESOURCE.measureInAggregateQuery());
            }
            this.validateNoAggs(this.groupFinder, selectItem, "SELECT");
            this.validateExpr(selectItem, selectScope);
        }
        return this.typeFactory.createStructType(fieldList);
    }

    private void validateExpr(SqlNode expr, SqlValidatorScope scope) {
        if (expr instanceof SqlCall) {
            SqlOperator op = ((SqlCall)expr).getOperator();
            if (op.isAggregator() && op.requiresOver()) {
                throw this.newValidationError(expr, Static.RESOURCE.absentOverClause());
            }
            if (op instanceof SqlTableFunction) {
                throw Static.RESOURCE.cannotCallTableFunctionHere(op.getName()).ex();
            }
        }
        if (!this.config.nakedMeasuresInNonAggregateQuery() && !(scope instanceof AggregatingScope) && scope.isMeasureRef(expr)) {
            throw this.newValidationError(expr, Static.RESOURCE.measureMustBeInAggregateQuery());
        }
        if (SqlValidatorUtil.isMeasure(expr) && scope instanceof SelectScope) {
            scope = this.getMeasureScope(((SelectScope)scope).getNode());
        }
        expr.validateExpr(this, scope);
        scope.validateExpr(expr);
    }

    private void handleScalarSubQuery(SqlSelect parentSelect, SqlSelect selectItem, List<SqlNode> expandedSelectItems, Set<String> aliasList, PairList<String, RelDataType> fieldList) {
        if (1 != SqlNonNullableAccessors.getSelectList(selectItem).size()) {
            throw this.newValidationError(selectItem, Static.RESOURCE.onlyScalarSubQueryAllowed());
        }
        expandedSelectItems.add(selectItem);
        String alias = SqlValidatorUtil.alias(selectItem, aliasList.size());
        aliasList.add(alias);
        SelectScope scope = (SelectScope)this.getWhereScope(parentSelect);
        RelDataType type = this.deriveType(scope, selectItem);
        this.setValidatedNodeType(selectItem, type);
        assert (type instanceof RelRecordType);
        RelRecordType rec = (RelRecordType)type;
        RelDataType nodeType = rec.getFieldList().get(0).getType();
        nodeType = this.typeFactory.createTypeWithNullability(nodeType, true);
        fieldList.add(alias, nodeType);
    }

    protected RelDataType createTargetRowType(SqlValidatorTable table, @Nullable SqlNodeList targetColumnList, boolean append, @Nullable SqlIdentifier targetTableAlias) {
        RelDataType baseRowType = table.getRowType();
        if (targetColumnList == null) {
            return baseRowType;
        }
        List<RelDataTypeField> targetFields = baseRowType.getFieldList();
        PairList<String, RelDataType> fields = PairList.of();
        if (append) {
            for (RelDataTypeField targetField : targetFields) {
                fields.add(SqlUtil.deriveAliasFromOrdinal(fields.size()), targetField.getType());
            }
        }
        HashSet<Integer> assignedFields = new HashSet<Integer>();
        RelOptTable relOptTable = table instanceof RelOptTable ? (RelOptTable)((Object)table) : null;
        for (SqlNode node : targetColumnList) {
            SqlIdentifier prefixId;
            SqlIdentifier id = (SqlIdentifier)node;
            if (!id.isSimple() && targetTableAlias != null && !(prefixId = id.skipLast(1)).toString().equals(targetTableAlias.toString())) {
                throw this.newValidationError(prefixId, Static.RESOURCE.unknownIdentifier(prefixId.toString()));
            }
            RelDataTypeField targetField = SqlValidatorUtil.getTargetField(baseRowType, this.typeFactory, id, this.catalogReader, relOptTable);
            if (targetField == null) {
                throw this.newValidationError(id, Static.RESOURCE.unknownTargetColumn(id.toString()));
            }
            if (!assignedFields.add(targetField.getIndex())) {
                throw this.newValidationError(id, Static.RESOURCE.duplicateTargetColumn(targetField.getName()));
            }
            fields.add(targetField);
        }
        return this.typeFactory.createStructType(fields);
    }

    @Override
    public void validateInsert(SqlInsert insert) {
        SqlValidatorNamespace targetNamespace = this.getNamespaceOrThrow(insert);
        this.validateNamespace(targetNamespace, this.unknownType);
        RelOptTable relOptTable = SqlValidatorUtil.getRelOptTable(targetNamespace, this.catalogReader.unwrap(Prepare.CatalogReader.class), null, null);
        SqlValidatorTable table = relOptTable == null ? SqlNonNullableAccessors.getTable(targetNamespace) : relOptTable.unwrapOrThrow(SqlValidatorTable.class);
        RelDataType targetRowType = this.createTargetRowType(table, insert.getTargetColumnList(), false, null);
        SqlNode source = insert.getSource();
        if (source instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)source;
            this.validateSelect(sqlSelect, targetRowType);
        } else {
            SqlValidatorScope scope = this.scopes.get(source);
            Objects.requireNonNull(scope, "scope");
            this.validateQuery(source, scope, targetRowType);
        }
        RelDataType sourceRowType = this.getNamespaceOrThrow(source).getRowType();
        RelDataType logicalTargetRowType = this.getLogicalTargetRowType(targetRowType, insert);
        this.setValidatedNodeType(insert, logicalTargetRowType);
        RelDataType logicalSourceRowType = this.getLogicalSourceRowType(sourceRowType, insert);
        List<ColumnStrategy> strategies = table.unwrapOrThrow(RelOptTable.class).getColumnStrategies();
        RelDataType realTargetRowType = this.typeFactory.createStructType(logicalTargetRowType.getFieldList().stream().filter(f -> ((ColumnStrategy)((Object)((Object)strategies.get(f.getIndex())))).canInsertInto()).collect(Collectors.toList()));
        RelDataType targetRowTypeToValidate = logicalSourceRowType.getFieldCount() == logicalTargetRowType.getFieldCount() ? logicalTargetRowType : realTargetRowType;
        this.checkFieldCount(insert.getTargetTable(), table, strategies, targetRowTypeToValidate, realTargetRowType, source, logicalSourceRowType, logicalTargetRowType);
        this.checkTypeAssignment(this.scopes.get(source), table, logicalSourceRowType, targetRowTypeToValidate, insert);
        this.checkConstraint(table, source, logicalTargetRowType);
        this.validateAccess(insert.getTargetTable(), table, SqlAccessEnum.INSERT);
        this.setValidatedNodeType(insert, targetRowTypeToValidate);
    }

    private void checkConstraint(SqlValidatorTable validatorTable, SqlNode source, RelDataType targetRowType) {
        ModifiableViewTable modifiableViewTable = validatorTable.unwrap(ModifiableViewTable.class);
        if (modifiableViewTable != null && source instanceof SqlCall) {
            Table table = modifiableViewTable.getTable();
            RelDataType tableRowType = table.getRowType(this.typeFactory);
            List<RelDataTypeField> tableFields = tableRowType.getFieldList();
            ImmutableMap<Integer, RelDataTypeField> tableIndexToTargetField = SqlValidatorUtil.getIndexToFieldMap(tableFields, targetRowType);
            Map<Integer, RexNode> projectMap = RelOptUtil.getColumnConstraints(modifiableViewTable, targetRowType, this.typeFactory);
            ImmutableBitSet targetColumns = ImmutableBitSet.of(tableIndexToTargetField.keySet());
            ImmutableBitSet constrainedColumns = ImmutableBitSet.of(projectMap.keySet());
            List<@KeyFor(value={"tableIndexToTargetField", "projectMap"}) Integer> constrainedTargetColumns = targetColumns.intersect(constrainedColumns).asList();
            List<SqlNode> values = ((SqlCall)source).getOperandList();
            for (int colIndex : constrainedTargetColumns) {
                String colName = tableFields.get(colIndex).getName();
                RelDataTypeField targetField = (RelDataTypeField)Objects.requireNonNull(tableIndexToTargetField.get(colIndex));
                for (SqlNode row : values) {
                    SqlCall call = (SqlCall)row;
                    Object sourceValue = call.operand(targetField.getIndex());
                    ValidationError validationError = new ValidationError((SqlNode)sourceValue, Static.RESOURCE.viewConstraintNotSatisfied(colName, Util.last(validatorTable.getQualifiedName())));
                    RelOptUtil.validateValueAgainstConstraint(sourceValue, projectMap.get(colIndex), validationError);
                }
            }
        }
    }

    private void checkConstraint(SqlValidatorTable validatorTable, SqlUpdate update, RelDataType targetRowType) {
        ModifiableViewTable modifiableViewTable = validatorTable.unwrap(ModifiableViewTable.class);
        if (modifiableViewTable != null) {
            Table table = modifiableViewTable.getTable();
            RelDataType tableRowType = table.getRowType(this.typeFactory);
            Map<Integer, RexNode> projectMap = RelOptUtil.getColumnConstraints(modifiableViewTable, targetRowType, this.typeFactory);
            Map<String, Integer> nameToIndex = SqlValidatorUtil.mapNameToIndex(tableRowType.getFieldList());
            List<String> targetNames = SqlIdentifier.simpleNames(update.getTargetColumnList());
            SqlNodeList sources = update.getSourceExpressionList();
            Pair.forEach(targetNames, sources, (columnName, expr) -> {
                Integer columnIndex = (Integer)nameToIndex.get(columnName);
                if (projectMap.containsKey(columnIndex)) {
                    RexNode columnConstraint = (RexNode)projectMap.get(columnIndex);
                    ValidationError validationError = new ValidationError((SqlNode)expr, Static.RESOURCE.viewConstraintNotSatisfied((String)columnName, Util.last(validatorTable.getQualifiedName())));
                    RelOptUtil.validateValueAgainstConstraint(expr, columnConstraint, validationError);
                }
            });
        }
    }

    private void checkFieldCount(SqlNode node, SqlValidatorTable table, List<ColumnStrategy> strategies, RelDataType targetRowTypeToValidate, RelDataType realTargetRowType, SqlNode source, RelDataType logicalSourceRowType, RelDataType logicalTargetRowType) {
        int sourceFieldCount = logicalSourceRowType.getFieldCount();
        int targetFieldCount = logicalTargetRowType.getFieldCount();
        int targetRealFieldCount = realTargetRowType.getFieldCount();
        if (sourceFieldCount != targetFieldCount && sourceFieldCount != targetRealFieldCount) {
            throw this.newValidationError(node, Static.RESOURCE.unmatchInsertColumn(targetFieldCount, sourceFieldCount));
        }
        for (RelDataTypeField field : table.getRowType().getFieldList()) {
            RelDataTypeField targetField = targetRowTypeToValidate.getField(field.getName(), true, false);
            switch (strategies.get(field.getIndex())) {
                case NOT_NULLABLE: {
                    assert (!field.getType().isNullable());
                    if (targetField != null) break;
                    throw this.newValidationError(node, Static.RESOURCE.columnNotNullable(field.getName()));
                }
                case NULLABLE: {
                    assert (field.getType().isNullable());
                    break;
                }
                case VIRTUAL: 
                case STORED: {
                    if (targetField == null || SqlValidatorImpl.isValuesWithDefault(source, targetField.getIndex())) break;
                    throw this.newValidationError(node, Static.RESOURCE.insertIntoAlwaysGenerated(field.getName()));
                }
            }
        }
    }

    private static boolean isValuesWithDefault(SqlNode source, int column) {
        switch (source.getKind()) {
            case VALUES: {
                for (SqlNode operand : ((SqlCall)source).getOperandList()) {
                    if (SqlValidatorImpl.isRowWithDefault(operand, column)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isRowWithDefault(SqlNode operand, int column) {
        switch (operand.getKind()) {
            case ROW: {
                SqlCall row = (SqlCall)operand;
                return row.getOperandList().size() >= column && row.getOperandList().get(column).getKind() == SqlKind.DEFAULT;
            }
        }
        return false;
    }

    protected RelDataType getLogicalTargetRowType(RelDataType targetRowType, SqlInsert insert) {
        if (insert.getTargetColumnList() == null && this.config.conformance().isInsertSubsetColumnsAllowed()) {
            SqlNode source = insert.getSource();
            RelDataType sourceRowType = this.getNamespaceOrThrow(source).getRowType();
            RelDataType logicalSourceRowType = this.getLogicalSourceRowType(sourceRowType, insert);
            RelDataType implicitTargetRowType = this.typeFactory.createStructType(targetRowType.getFieldList().subList(0, logicalSourceRowType.getFieldCount()));
            SqlValidatorNamespace targetNamespace = this.getNamespaceOrThrow(insert);
            this.validateNamespace(targetNamespace, implicitTargetRowType);
            return implicitTargetRowType;
        }
        return targetRowType;
    }

    protected RelDataType getLogicalSourceRowType(RelDataType sourceRowType, SqlInsert insert) {
        return sourceRowType;
    }

    protected void checkTypeAssignment(@Nullable SqlValidatorScope sourceScope, SqlValidatorTable table, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        boolean coerced;
        boolean isUpdateModifiableViewTable = false;
        if (query instanceof SqlUpdate) {
            SqlNodeList targetColumnList = Objects.requireNonNull(((SqlUpdate)query).getTargetColumnList());
            int targetColumnCount = targetColumnList.size();
            targetRowType = SqlTypeUtil.extractLastNFields(this.typeFactory, targetRowType, targetColumnCount);
            sourceRowType = SqlTypeUtil.extractLastNFields(this.typeFactory, sourceRowType, targetColumnCount);
            boolean bl = isUpdateModifiableViewTable = table.unwrap(ModifiableViewTable.class) != null;
        }
        if (SqlTypeUtil.equalAsStructSansNullability(this.typeFactory, sourceRowType, targetRowType, null)) {
            return;
        }
        if (this.config.typeCoercionEnabled() && !isUpdateModifiableViewTable && (coerced = this.typeCoercion.querySourceCoercion(sourceScope, sourceRowType, targetRowType, query))) {
            return;
        }
        List<RelDataTypeField> sourceFields = sourceRowType.getFieldList();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            String targetTypeString;
            String sourceTypeString;
            SqlNode node;
            RelDataType sourceType = sourceFields.get(i).getType();
            RelDataType targetType = targetFields.get(i).getType();
            if (SqlTypeUtil.canAssignFrom(targetType, sourceType) || (node = SqlValidatorImpl.getNthExpr(query, i, sourceCount)) instanceof SqlDynamicParam) continue;
            if (SqlTypeUtil.areCharacterSetsMismatched(sourceType, targetType)) {
                sourceTypeString = sourceType.getFullTypeString();
                targetTypeString = targetType.getFullTypeString();
            } else {
                sourceTypeString = sourceType.toString();
                targetTypeString = targetType.toString();
            }
            throw this.newValidationError(node, Static.RESOURCE.typeNotAssignable(targetFields.get(i).getName(), targetTypeString, sourceFields.get(i).getName(), sourceTypeString));
        }
    }

    private static SqlNode getNthExpr(SqlNode query, int ordinal, int sourceCount) {
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getTargetColumnList() != null) {
                return insert.getTargetColumnList().get(ordinal);
            }
            return SqlValidatorImpl.getNthExpr(insert.getSource(), ordinal, sourceCount);
        }
        if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            if (update.getSourceExpressionList() != null) {
                return update.getSourceExpressionList().get(ordinal);
            }
            return SqlValidatorImpl.getNthExpr(SqlNonNullableAccessors.getSourceSelect(update), ordinal, sourceCount);
        }
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            SqlNodeList selectList = SqlNonNullableAccessors.getSelectList(select);
            if (selectList.size() == sourceCount) {
                return selectList.get(ordinal);
            }
            return query;
        }
        return query;
    }

    @Override
    public void validateDelete(SqlDelete call) {
        SqlSelect sqlSelect = SqlNonNullableAccessors.getSourceSelect(call);
        this.validateSelect(sqlSelect, this.unknownType);
        SqlValidatorNamespace targetNamespace = this.getNamespaceOrThrow(call);
        this.validateNamespace(targetNamespace, this.unknownType);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.DELETE);
    }

    @Override
    public void validateUpdate(SqlUpdate call) {
        SqlValidatorNamespace targetNamespace = this.getNamespaceOrThrow(call);
        this.validateNamespace(targetNamespace, this.unknownType);
        RelOptTable relOptTable = SqlValidatorUtil.getRelOptTable(targetNamespace, (Prepare.CatalogReader)Nullness.castNonNull((Object)this.catalogReader.unwrap(Prepare.CatalogReader.class)), null, null);
        SqlValidatorTable table = relOptTable == null ? SqlNonNullableAccessors.getTable(targetNamespace) : relOptTable.unwrapOrThrow(SqlValidatorTable.class);
        RelDataType targetRowType = this.createTargetRowType(table, call.getTargetColumnList(), true, call.getAlias());
        SqlSelect select = SqlNonNullableAccessors.getSourceSelect(call);
        this.validateSelect(select, targetRowType);
        RelDataType sourceRowType = this.getValidatedNodeType(select);
        this.checkTypeAssignment(this.scopes.get(select), table, sourceRowType, targetRowType, call);
        this.checkConstraint(table, call, targetRowType);
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
    }

    @Override
    public void validateMerge(SqlMerge call) {
        SqlInsert insertCallAfterValidate;
        SqlInsert insertCall;
        SqlSelect sqlSelect = SqlNonNullableAccessors.getSourceSelect(call);
        IdentifierNamespace targetNamespace = (IdentifierNamespace)this.getNamespaceOrThrow(call.getTargetTable());
        this.validateNamespace(targetNamespace, this.unknownType);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
        RelDataType targetRowType = this.unknownType;
        SqlUpdate updateCall = call.getUpdateCall();
        if (updateCall != null) {
            Objects.requireNonNull(table, () -> "ns.getTable() for " + targetNamespace);
            targetRowType = this.createTargetRowType(table, updateCall.getTargetColumnList(), true, call.getAlias());
        }
        if ((insertCall = call.getInsertCall()) != null) {
            Objects.requireNonNull(table, () -> "ns.getTable() for " + targetNamespace);
            targetRowType = this.createTargetRowType(table, insertCall.getTargetColumnList(), false, null);
        }
        this.validateSelect(sqlSelect, targetRowType);
        SqlUpdate updateCallAfterValidate = call.getUpdateCall();
        if (updateCallAfterValidate != null) {
            this.validateUpdate(updateCallAfterValidate);
        }
        if ((insertCallAfterValidate = call.getInsertCall()) != null) {
            this.validateInsert(insertCallAfterValidate);
            if (insertCallAfterValidate.getSource() instanceof SqlSelect) {
                SqlSelect sourceSelect = (SqlSelect)insertCallAfterValidate.getSource();
                SqlNodeList sourceSelectList = sourceSelect.getSelectList();
                for (int i = 0; i < sourceSelectList.size(); ++i) {
                    RelDataTypeField targetField = targetRowType.getFieldList().get(i);
                    SqlNode selectItem = sourceSelect.getSelectList().get(i);
                    if (targetField.getType().isNullable() || !SqlUtil.isNullLiteral(selectItem, true)) continue;
                    throw this.newValidationError(selectItem, Static.RESOURCE.columnNotNullable(targetField.getName()));
                }
            }
        }
    }

    private void validateAccess(SqlNode node, @Nullable SqlValidatorTable table, SqlAccessEnum requiredAccess) {
        SqlAccessType access;
        if (table != null && !(access = table.getAllowedAccess()).allowsAccess(requiredAccess)) {
            throw this.newValidationError(node, Static.RESOURCE.accessNotAllowed(requiredAccess.name(), table.getQualifiedName().toString()));
        }
    }

    private void validateSnapshot(SqlNode node, @Nullable SqlValidatorScope scope, SqlValidatorNamespace ns) {
        if (node.getKind() == SqlKind.SNAPSHOT) {
            SqlSnapshot snapshot = (SqlSnapshot)node;
            SqlNode period = snapshot.getPeriod();
            RelDataType dataType = this.deriveType(Objects.requireNonNull(scope, "scope"), period);
            if (!SqlTypeUtil.isTimestamp(dataType)) {
                throw this.newValidationError(period, Static.RESOURCE.illegalExpressionForTemporal(dataType.getSqlTypeName().getName()));
            }
            SqlValidatorTable table = SqlNonNullableAccessors.getTable(ns);
            if (!table.isTemporal()) {
                List<String> qualifiedName = table.getQualifiedName();
                String tableName = qualifiedName.get(qualifiedName.size() - 1);
                throw this.newValidationError(snapshot.getTableRef(), Static.RESOURCE.notTemporalTable(tableName));
            }
        }
    }

    protected void validateValues(SqlCall node, RelDataType targetRowType, final SqlValidatorScope scope) {
        assert (node.getKind() == SqlKind.VALUES);
        final List<SqlNode> operands = node.getOperandList();
        for (SqlNode operand : operands) {
            if (operand.getKind() != SqlKind.ROW) {
                throw Util.needToImplement("Values function where operands are scalars");
            }
            SqlCall rowConstructor = (SqlCall)operand;
            if (this.config.conformance().isInsertSubsetColumnsAllowed() && targetRowType.isStruct() && rowConstructor.operandCount() < targetRowType.getFieldCount()) {
                targetRowType = this.typeFactory.createStructType(targetRowType.getFieldList().subList(0, rowConstructor.operandCount()));
            } else if (targetRowType.isStruct() && rowConstructor.operandCount() != targetRowType.getFieldCount()) {
                return;
            }
            this.inferUnknownTypes(targetRowType, scope, rowConstructor);
            if (!targetRowType.isStruct()) continue;
            for (Pair pair : Pair.zip(rowConstructor.getOperandList(), targetRowType.getFieldList())) {
                if (((RelDataTypeField)pair.right).getType().isNullable() || !SqlUtil.isNullLiteral((SqlNode)pair.left, false)) continue;
                throw this.newValidationError(node, Static.RESOURCE.columnNotNullable(((RelDataTypeField)pair.right).getName()));
            }
        }
        for (SqlNode operand : operands) {
            operand.validate(this, scope);
        }
        int rowCount = operands.size();
        if (rowCount >= 2) {
            SqlCall firstRow = (SqlCall)operands.get(0);
            int columnCount = firstRow.operandCount();
            for (SqlNode sqlNode : operands) {
                SqlCall thisRow = (SqlCall)sqlNode;
                if (columnCount == thisRow.operandCount()) continue;
                throw this.newValidationError(node, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.VALUES.getName()));
            }
            int col = 0;
            while (col < columnCount) {
                int n;
                RelDataType type;
                if (null != (type = this.typeFactory.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(n = col++, rowCount){
                    final /* synthetic */ int val$c;
                    final /* synthetic */ int val$rowCount;
                    {
                        this.val$c = n;
                        this.val$rowCount = n2;
                    }

                    @Override
                    public RelDataType get(int row) {
                        SqlCall thisRow = (SqlCall)operands.get(row);
                        return SqlValidatorImpl.this.deriveType(scope, (SqlNode)thisRow.operand(this.val$c));
                    }

                    @Override
                    public int size() {
                        return this.val$rowCount;
                    }
                }))) continue;
                throw this.newValidationError(node, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.VALUES.getName()));
            }
        }
    }

    @Override
    public void validateDataType(SqlDataTypeSpec dataType) {
    }

    @Override
    public void validateDynamicParam(SqlDynamicParam dynamicParam) {
    }

    public ValidationErrorFunction getValidationErrorFunction() {
        return this.validationErrorFunction;
    }

    @Override
    public CalciteContextException newValidationError(SqlNode node, Resources.ExInst<SqlValidatorException> e) {
        Objects.requireNonNull(node, "node");
        SqlParserPos pos = node.getParserPosition();
        return SqlUtil.newContextException(pos, e);
    }

    protected SqlWindow getWindowByName(SqlIdentifier id, SqlValidatorScope scope) {
        SqlWindow window = null;
        if (id.isSimple()) {
            String name = id.getSimple();
            window = scope.lookupWindow(name);
        }
        if (window == null) {
            throw this.newValidationError(id, Static.RESOURCE.windowNotFound(id.toString()));
        }
        return window;
    }

    @Override
    public SqlWindow resolveWindow(SqlNode windowOrRef, SqlValidatorScope scope) {
        SqlIdentifier refId;
        SqlWindow window = windowOrRef instanceof SqlIdentifier ? this.getWindowByName((SqlIdentifier)windowOrRef, scope) : (SqlWindow)windowOrRef;
        while ((refId = window.getRefName()) != null) {
            String refName = refId.getSimple();
            SqlWindow refWindow = scope.lookupWindow(refName);
            if (refWindow == null) {
                throw this.newValidationError(refId, Static.RESOURCE.windowNotFound(refName));
            }
            window = window.overlay(refWindow, this);
        }
        return window;
    }

    public SqlNode getOriginal(SqlNode expr) {
        SqlNode original = this.originalExprs.get(expr);
        if (original == null) {
            original = expr;
        }
        return original;
    }

    public void setOriginal(SqlNode expr, SqlNode original) {
        this.originalExprs.putIfAbsent(expr, original);
    }

    @Nullable SqlValidatorNamespace lookupFieldNamespace(RelDataType rowType, String name) {
        SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
        RelDataTypeField field = nameMatcher.field(rowType, name);
        if (field == null) {
            return null;
        }
        return new FieldNamespace(this, field.getType());
    }

    @Override
    public void validateWindow(SqlNode windowOrId, SqlValidatorScope scope, @Nullable SqlCall call) {
        SqlWindow targetWindow;
        this.inWindow = true;
        switch (windowOrId.getKind()) {
            case IDENTIFIER: {
                targetWindow = this.getWindowByName((SqlIdentifier)windowOrId, scope);
                break;
            }
            case WINDOW: {
                targetWindow = (SqlWindow)windowOrId;
                break;
            }
            default: {
                throw Util.unexpected(windowOrId.getKind());
            }
        }
        Objects.requireNonNull(call, () -> "call is null when validating windowOrId " + windowOrId);
        assert (targetWindow.getWindowCall() == null);
        targetWindow.setWindowCall(call);
        targetWindow.validate(this, scope);
        targetWindow.setWindowCall(null);
        call.validate(this, scope);
        this.validateAggregateParams(call, null, null, null, scope);
        this.inWindow = false;
    }

    @Override
    public void validateLambda(SqlLambda lambdaExpr) {
        SqlLambdaScope scope = (SqlLambdaScope)this.scopes.get(lambdaExpr);
        Objects.requireNonNull(scope, "scope");
        LambdaNamespace ns = this.getNamespaceOrThrow(lambdaExpr).unwrap(LambdaNamespace.class);
        this.deriveType(scope, lambdaExpr.getExpression());
        RelDataType type = this.deriveTypeImpl(scope, lambdaExpr);
        this.setValidatedNodeType(lambdaExpr, type);
        ns.setType(type);
    }

    @Override
    public void validateMatchRecognize(SqlCall call) {
        SqlNode skipTo;
        String name2;
        RelDataType type2;
        Object identifier;
        SqlMatchRecognize matchRecognize = (SqlMatchRecognize)call;
        MatchRecognizeScope scope = (MatchRecognizeScope)this.getMatchRecognizeScope(matchRecognize);
        MatchRecognizeNamespace ns = this.getNamespaceOrThrow(call).unwrap(MatchRecognizeNamespace.class);
        assert (ns.rowType == null);
        SqlLiteral rowsPerMatch = matchRecognize.getRowsPerMatch();
        boolean allRows = rowsPerMatch != null && rowsPerMatch.getValue() == SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS;
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.typeFactory.builder();
        for (SqlNode node : matchRecognize.getPartitionList()) {
            identifier = (SqlIdentifier)node;
            ((SqlIdentifier)identifier).validate(this, scope);
            type2 = this.deriveType(scope, (SqlNode)identifier);
            name2 = (String)((SqlIdentifier)identifier).names.get(1);
            ((RelDataTypeFactory.Builder)typeBuilder).add(name2, type2);
        }
        for (SqlNode node : matchRecognize.getOrderList()) {
            node.validate(this, scope);
            identifier = node instanceof SqlBasicCall ? (SqlIdentifier)((SqlBasicCall)node).operand(0) : Objects.requireNonNull((SqlIdentifier)node, () -> "order by field is null. All fields: " + matchRecognize.getOrderList());
            if (!allRows) continue;
            type2 = this.deriveType(scope, (SqlNode)identifier);
            name2 = (String)((SqlIdentifier)identifier).names.get(1);
            if (typeBuilder.nameExists(name2)) continue;
            ((RelDataTypeFactory.Builder)typeBuilder).add(name2, type2);
        }
        if (allRows) {
            SqlValidatorNamespace sqlNs = this.getNamespaceOrThrow(matchRecognize.getTableRef());
            RelDataType inputDataType = sqlNs.getRowType();
            for (RelDataTypeField fs : inputDataType.getFieldList()) {
                if (typeBuilder.nameExists(fs.getName())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(fs);
            }
        }
        SqlNode pattern = matchRecognize.getPattern();
        PatternVarVisitor visitor = new PatternVarVisitor(scope);
        pattern.accept(visitor);
        SqlLiteral interval = matchRecognize.getInterval();
        if (interval != null) {
            interval.validate(this, scope);
            if (((SqlIntervalLiteral)interval).signum() < 0) {
                String intervalValue = interval.toValue();
                throw this.newValidationError(interval, Static.RESOURCE.intervalMustBeNonNegative(intervalValue != null ? intervalValue : interval.toString()));
            }
            if (matchRecognize.getOrderList().isEmpty()) {
                throw this.newValidationError(interval, Static.RESOURCE.cannotUseWithinWithoutOrderBy());
            }
            SqlNode firstOrderByColumn = matchRecognize.getOrderList().get(0);
            SqlIdentifier identifier2 = firstOrderByColumn instanceof SqlBasicCall ? (SqlIdentifier)((SqlBasicCall)firstOrderByColumn).operand(0) : (SqlIdentifier)Objects.requireNonNull(firstOrderByColumn, "firstOrderByColumn");
            RelDataType firstOrderByColumnType = this.deriveType(scope, identifier2);
            if (!SqlTypeUtil.isTimestamp(firstOrderByColumnType)) {
                throw this.newValidationError(interval, Static.RESOURCE.firstColumnOfOrderByMustBeTimestamp());
            }
            SqlNode expand = this.expand(interval, scope);
            RelDataType type3 = this.deriveType(scope, expand);
            this.setValidatedNodeType(interval, type3);
        }
        this.validateDefinitions(matchRecognize, scope);
        SqlNodeList subsets = matchRecognize.getSubsetList();
        if (!subsets.isEmpty()) {
            for (SqlNode node : subsets) {
                List<SqlNode> operands = ((SqlCall)node).getOperandList();
                String leftString = ((SqlIdentifier)operands.get(0)).getSimple();
                if (scope.getPatternVars().contains(leftString)) {
                    throw this.newValidationError(operands.get(0), Static.RESOURCE.patternVarAlreadyDefined(leftString));
                }
                scope.addPatternVar(leftString);
                for (SqlNode right : (SqlNodeList)operands.get(1)) {
                    SqlIdentifier id = (SqlIdentifier)right;
                    if (!scope.getPatternVars().contains(id.getSimple())) {
                        throw this.newValidationError(id, Static.RESOURCE.unknownPattern(id.getSimple()));
                    }
                    scope.addPatternVar(id.getSimple());
                }
            }
        }
        if ((skipTo = matchRecognize.getAfter()) instanceof SqlCall) {
            SqlCall skipToCall = (SqlCall)skipTo;
            SqlIdentifier id = (SqlIdentifier)skipToCall.operand(0);
            if (!scope.getPatternVars().contains(id.getSimple())) {
                throw this.newValidationError(id, Static.RESOURCE.unknownPattern(id.getSimple()));
            }
        }
        PairList<String, RelDataType> measureColumns = this.validateMeasure(matchRecognize, scope, allRows);
        measureColumns.forEach((name, type) -> {
            if (!typeBuilder.nameExists((String)name)) {
                typeBuilder.add((String)name, (RelDataType)type);
            }
        });
        RelDataType rowType = matchRecognize.getMeasureList().isEmpty() ? this.getNamespaceOrThrow(matchRecognize.getTableRef()).getRowType() : typeBuilder.build();
        ns.setType(rowType);
    }

    private PairList<String, RelDataType> validateMeasure(SqlMatchRecognize mr, MatchRecognizeScope scope, boolean allRows) {
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<SqlCall> sqlNodes = new ArrayList<SqlCall>();
        SqlNodeList measures = mr.getMeasureList();
        PairList<String, RelDataType> fields = PairList.of();
        for (SqlNode measure : measures) {
            assert (measure instanceof SqlCall);
            String alias = SqlValidatorUtil.alias(measure, aliases.size());
            aliases.add(alias);
            SqlNode expand = this.expand(measure, scope);
            expand = this.navigationInMeasure(expand, allRows);
            this.setOriginal(expand, measure);
            this.inferUnknownTypes(this.unknownType, scope, expand);
            RelDataType type = this.deriveType(scope, expand);
            this.setValidatedNodeType(measure, type);
            fields.add(alias, type);
            sqlNodes.add(SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, expand, new SqlIdentifier(alias, SqlParserPos.ZERO)));
        }
        SqlNodeList list = new SqlNodeList(sqlNodes, measures.getParserPosition());
        this.inferUnknownTypes(this.unknownType, scope, list);
        for (SqlNode node : list) {
            this.validateExpr(node, scope);
        }
        mr.setOperand(5, list);
        return fields;
    }

    private SqlNode navigationInMeasure(SqlNode node, boolean allRows) {
        Set<String> prefix = node.accept(new PatternValidator(true));
        Util.discard(prefix);
        List<SqlNode> ops = ((SqlCall)node).getOperandList();
        SqlPrefixOperator defaultOp = allRows ? SqlStdOperatorTable.RUNNING : SqlStdOperatorTable.FINAL;
        SqlNode op0 = ops.get(0);
        if (!SqlValidatorImpl.isRunningOrFinal(op0.getKind()) || !allRows && op0.getKind() == SqlKind.RUNNING) {
            SqlCall newNode = defaultOp.createCall(SqlParserPos.ZERO, op0);
            node = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, newNode, ops.get(1));
        }
        node = new NavigationExpander().go(node);
        return node;
    }

    private void validateDefinitions(SqlMatchRecognize mr, MatchRecognizeScope scope) {
        Set<String> aliases = this.catalogReader.nameMatcher().createSet();
        for (Object item : mr.getPatternDefList()) {
            String alias = SqlValidatorImpl.alias((SqlNode)item);
            if (!aliases.add(alias)) {
                throw this.newValidationError((SqlNode)item, Static.RESOURCE.patternVarAlreadyDefined(alias));
            }
            scope.addPatternVar(alias);
        }
        ArrayList<SqlCall> sqlNodes = new ArrayList<SqlCall>();
        for (SqlNode item : mr.getPatternDefList()) {
            String alias = SqlValidatorImpl.alias(item);
            SqlNode expand = this.expand(item, scope);
            expand = this.navigationInDefine(expand, alias);
            this.setOriginal(expand, item);
            this.inferUnknownTypes(this.booleanType, scope, expand);
            expand.validate(this, scope);
            sqlNodes.add(SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, expand, new SqlIdentifier(alias, SqlParserPos.ZERO)));
            RelDataType type = this.deriveType(scope, expand);
            if (!SqlTypeUtil.inBooleanFamily(type)) {
                throw this.newValidationError(expand, Static.RESOURCE.condMustBeBoolean("DEFINE"));
            }
            this.setValidatedNodeType(item, type);
        }
        SqlNodeList list = new SqlNodeList(sqlNodes, mr.getPatternDefList().getParserPosition());
        this.inferUnknownTypes(this.unknownType, scope, list);
        for (SqlNode node : list) {
            this.validateExpr(node, scope);
        }
        mr.setOperand(4, list);
    }

    private static String alias(SqlNode item) {
        assert (item instanceof SqlCall);
        assert (item.getKind() == SqlKind.AS);
        SqlIdentifier identifier = (SqlIdentifier)((SqlCall)item).operand(1);
        return identifier.getSimple();
    }

    public void validatePivot(SqlPivot pivot) {
        PivotScope scope = (PivotScope)this.getJoinScope(pivot);
        PivotNamespace ns = this.getNamespaceOrThrow(pivot).unwrap(PivotNamespace.class);
        assert (ns.rowType == null);
        PairList<@Nullable T, U> aggNames = PairList.of();
        pivot.forEachAgg((alias, call) -> {
            call.validate(this, scope);
            RelDataType type = this.deriveType(scope, (SqlNode)call);
            aggNames.add(alias, type);
            if (!(call instanceof SqlCall) || !(((SqlCall)call).getOperator() instanceof SqlAggFunction)) {
                throw this.newValidationError((SqlNode)call, Static.RESOURCE.pivotAggMalformed());
            }
        });
        ArrayList<RelDataType> axisTypes = new ArrayList<RelDataType>();
        ArrayList<SqlIdentifier> axisIdentifiers = new ArrayList<SqlIdentifier>();
        for (SqlNode axis : pivot.axisList) {
            SqlIdentifier identifier = (SqlIdentifier)axis;
            identifier.validate(this, scope);
            RelDataType type = this.deriveType(scope, identifier);
            axisTypes.add(type);
            axisIdentifiers.add(identifier);
        }
        Set<String> columnNames = pivot.usedColumnNames();
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.typeFactory.builder();
        scope.getChild().getRowType().getFieldList().forEach(field -> {
            if (!columnNames.contains(field.getName())) {
                typeBuilder.add((RelDataTypeField)field);
            }
        });
        pivot.forEachNameValues((alias, nodeList) -> {
            if (nodeList.size() != axisTypes.size()) {
                throw this.newValidationError((SqlNode)nodeList, Static.RESOURCE.pivotValueArityMismatch(nodeList.size(), axisTypes.size()));
            }
            SqlOperandTypeChecker typeChecker = OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED;
            Pair.forEach(axisIdentifiers, nodeList, (identifier, subNode) -> {
                subNode.validate(this, scope);
                typeChecker.checkOperandTypes(new SqlCallBinding(this, scope, SqlStdOperatorTable.EQUALS.createCall(subNode.getParserPosition(), (SqlNode)identifier, (SqlNode)subNode)), true);
            });
            aggNames.forEach((aggAlias, aggType) -> typeBuilder.add(aggAlias == null ? alias : alias + "_" + aggAlias, (RelDataType)aggType));
        });
        RelDataType rowType = typeBuilder.build();
        ns.setType(rowType);
    }

    public void validateUnpivot(SqlUnpivot unpivot) {
        UnpivotScope scope = (UnpivotScope)this.getJoinScope(unpivot);
        UnpivotNamespace ns = this.getNamespaceOrThrow(unpivot).unwrap(UnpivotNamespace.class);
        assert (ns.rowType == null);
        int measureCount = unpivot.measureList.size();
        int axisCount = unpivot.axisList.size();
        unpivot.forEachNameValues((nodeList, valueList) -> {
            if (nodeList.size() != measureCount) {
                throw this.newValidationError((SqlNode)nodeList, Static.RESOURCE.unpivotValueArityMismatch(nodeList.size(), measureCount));
            }
            if (valueList != null && valueList.size() != axisCount) {
                throw this.newValidationError((SqlNode)valueList, Static.RESOURCE.unpivotValueArityMismatch(valueList.size(), axisCount));
            }
            nodeList.forEach((Consumer<? super SqlNode>)((Consumer<SqlNode>)node -> this.deriveType(scope, (SqlNode)node)));
        });
        SqlValidatorNamespace inputNs = Objects.requireNonNull(this.getNamespace(unpivot.query));
        Set<String> unusedColumnNames = this.catalogReader.nameMatcher().createSet();
        unusedColumnNames.addAll(inputNs.getRowType().getFieldNames());
        unusedColumnNames.removeAll(unpivot.usedColumnNames());
        Set<String> columnNames = this.catalogReader.nameMatcher().createSet();
        columnNames.addAll(unusedColumnNames);
        PairList<String, RelDataType> measureNameTypes = PairList.of();
        Ord.forEach((Iterable)unpivot.measureList, (measure, i) -> {
            String measureName = ((SqlIdentifier)measure).getSimple();
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            ArrayList nodes = new ArrayList();
            unpivot.forEachNameValues((nodeList, valueList) -> {
                SqlNode alias = nodeList.get(i);
                nodes.add(alias);
                types.add(this.deriveType(scope, alias));
            });
            RelDataType type0 = this.typeFactory.leastRestrictive(types);
            if (type0 == null) {
                throw this.newValidationError((SqlNode)nodes.get(0), Static.RESOURCE.unpivotCannotDeriveMeasureType(measureName));
            }
            RelDataType type = this.typeFactory.createTypeWithNullability(type0, unpivot.includeNulls || unpivot.measureList.size() > 1);
            this.setValidatedNodeType((SqlNode)measure, type);
            if (!columnNames.add(measureName)) {
                throw this.newValidationError((SqlNode)measure, Static.RESOURCE.unpivotDuplicate(measureName));
            }
            measureNameTypes.add(measureName, type);
        });
        PairList<String, RelDataType> axisNameTypes = PairList.of();
        Ord.forEach((Iterable)unpivot.axisList, (axis, i) -> {
            String axisName = ((SqlIdentifier)axis).getSimple();
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            unpivot.forEachNameValues((aliasList, valueList) -> types.add(valueList == null ? this.typeFactory.createSqlType(SqlTypeName.VARCHAR, SqlUnpivot.aliasValue(aliasList).length()) : this.deriveType(scope, valueList.get(i))));
            RelDataType type = this.typeFactory.leastRestrictive(types);
            if (type == null) {
                throw this.newValidationError((SqlNode)axis, Static.RESOURCE.unpivotCannotDeriveAxisType(axisName));
            }
            this.setValidatedNodeType((SqlNode)axis, type);
            if (!columnNames.add(axisName)) {
                throw this.newValidationError((SqlNode)axis, Static.RESOURCE.unpivotDuplicate(axisName));
            }
            axisNameTypes.add(axisName, type);
        });
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.typeFactory.builder();
        scope.getChild().getRowType().getFieldList().forEach(field -> {
            if (unusedColumnNames.contains(field.getName())) {
                typeBuilder.add((RelDataTypeField)field);
            }
        });
        ((RelDataTypeFactory.Builder)typeBuilder).addAll(axisNameTypes);
        ((RelDataTypeFactory.Builder)typeBuilder).addAll(measureNameTypes);
        RelDataType rowType = typeBuilder.build();
        ns.setType(rowType);
    }

    private SqlNode navigationInDefine(SqlNode node, String alpha) {
        Set<String> prefix = node.accept(new PatternValidator(false));
        Util.discard(prefix);
        node = new NavigationExpander().go(node);
        node = new NavigationReplacer(alpha).go(node);
        return node;
    }

    @Override
    public void validateAggregateParams(SqlCall aggCall, @Nullable SqlNode filter, @Nullable SqlNodeList distinctList, @Nullable SqlNodeList orderList, SqlValidatorScope scope) {
        AggFinder a = this.inWindow ? this.overFinder : this.aggOrOverFinder;
        for (SqlNode param : aggCall.getOperandList()) {
            if (a.findAgg(param) == null) continue;
            throw this.newValidationError(aggCall, Static.RESOURCE.nestedAggIllegal());
        }
        if (filter != null && a.findAgg(filter) != null) {
            throw this.newValidationError(filter, Static.RESOURCE.aggregateInFilterIllegal());
        }
        if (distinctList != null) {
            for (SqlNode param : distinctList) {
                if (a.findAgg(param) == null) continue;
                throw this.newValidationError(aggCall, Static.RESOURCE.aggregateInWithinDistinctIllegal());
            }
        }
        if (orderList != null) {
            for (SqlNode param : orderList) {
                if (a.findAgg(param) == null) continue;
                throw this.newValidationError(aggCall, Static.RESOURCE.aggregateInWithinGroupIllegal());
            }
        }
        SqlAggFunction op = (SqlAggFunction)aggCall.getOperator();
        switch (op.requiresGroupOrder()) {
            case MANDATORY: {
                if (orderList != null && !orderList.isEmpty()) break;
                throw this.newValidationError(aggCall, Static.RESOURCE.aggregateMissingWithinGroupClause(op.getName()));
            }
            case OPTIONAL: {
                break;
            }
            case IGNORED: {
                if (orderList == null) break;
                orderList.clear();
                break;
            }
            case FORBIDDEN: {
                if (orderList == null || orderList.isEmpty()) break;
                throw this.newValidationError(aggCall, Static.RESOURCE.withinGroupClauseIllegalInAggregate(op.getName()));
            }
            default: {
                throw new AssertionError(op);
            }
        }
        if (op.isPercentile()) {
            switch (aggCall.operandCount()) {
                case 1: {
                    assert (op.requiresGroupOrder() == Optionality.MANDATORY);
                    assert (orderList != null);
                    if (orderList.size() != 1) {
                        throw this.newValidationError(orderList, Static.RESOURCE.orderByRequiresOneKey(op.getName()));
                    }
                    SqlNode node = Objects.requireNonNull(orderList.get(0));
                    RelDataType type = this.deriveType(scope, node);
                    SqlTypeFamily family = type.getSqlTypeName().getFamily();
                    if (family != null && !family.allowableDifferenceTypes().isEmpty()) break;
                    throw this.newValidationError(orderList, Static.RESOURCE.unsupportedTypeInOrderBy(type.getSqlTypeName().getName(), op.getName()));
                }
                case 2: {
                    assert (op.allowsNullTreatment());
                    assert (op.requiresOver());
                    assert (op.requiresGroupOrder() == Optionality.FORBIDDEN);
                    break;
                }
                default: {
                    throw this.newValidationError(aggCall, Static.RESOURCE.percentileFunctionsArgumentLimit());
                }
            }
        }
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        SqlOperator operator = call.getOperator();
        if (call.operandCount() == 0 && operator.getSyntax() == SqlSyntax.FUNCTION_ID && !call.isExpanded() && !this.config.conformance().allowNiladicParentheses()) {
            throw this.handleUnresolvedFunction(call, operator, (List<RelDataType>)ImmutableList.of(), null);
        }
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        if (operator instanceof SqlFunction && ((SqlFunction)operator).getFunctionType() == SqlFunctionCategory.MATCH_RECOGNIZE && !(operandScope instanceof MatchRecognizeScope)) {
            throw this.newValidationError(call, Static.RESOURCE.functionMatchRecognizeOnly(call.toString()));
        }
        operator.validateCall(call, this, scope, operandScope);
    }

    protected void validateFeature(Feature feature, SqlParserPos context) {
        assert (feature.getProperties().get("FeatureDefinition") != null);
    }

    @Override
    public SqlLiteral resolveLiteral(SqlLiteral literal) {
        switch (literal.getTypeName()) {
            case UNKNOWN: {
                SqlUnknownLiteral unknownLiteral = (SqlUnknownLiteral)literal;
                SqlIdentifier identifier = new SqlIdentifier(unknownLiteral.tag, SqlParserPos.ZERO);
                RelDataType type = this.catalogReader.getNamedType(identifier);
                SqlTypeName typeName = type != null ? type.getSqlTypeName() : SqlTypeName.lookup(unknownLiteral.tag);
                return unknownLiteral.resolve(typeName);
            }
        }
        return literal;
    }

    public SqlNode expandSelectExpr(SqlNode expr, SelectScope scope, SqlSelect select) {
        SelectExpander expander = new SelectExpander(this, scope, select);
        SqlNode newExpr = expander.go(expr);
        if (expr != newExpr) {
            this.setOriginal(newExpr, expr);
        }
        return newExpr;
    }

    @Override
    public SqlNode expand(SqlNode expr, SqlValidatorScope scope) {
        Expander expander = new Expander(this, scope);
        SqlNode newExpr = expander.go(expr);
        if (expr != newExpr) {
            this.setOriginal(newExpr, expr);
        }
        return newExpr;
    }

    private SqlNode extendedExpand(SqlNode expr, SqlValidatorScope scope, SqlSelect select, Clause clause) {
        ExtendedExpander expander = new ExtendedExpander(this, scope, select, expr, clause);
        SqlNode newExpr = expander.go(expr);
        if (expr != newExpr) {
            this.setOriginal(newExpr, expr);
        }
        return newExpr;
    }

    public SqlNode extendedExpandGroupBy(SqlNode expr, SqlValidatorScope scope, SqlSelect select) {
        return this.extendedExpand(expr, scope, select, Clause.GROUP_BY);
    }

    @Override
    public boolean isSystemField(RelDataTypeField field) {
        return false;
    }

    @Override
    public List<@Nullable List<String>> getFieldOrigins(SqlNode sqlQuery) {
        if (sqlQuery instanceof SqlExplain) {
            return Collections.emptyList();
        }
        RelDataType rowType = this.getValidatedNodeType(sqlQuery);
        int fieldCount = rowType.getFieldCount();
        if (!sqlQuery.isA(SqlKind.QUERY)) {
            return Collections.nCopies(fieldCount, null);
        }
        ArrayList<@Nullable List<String>> list = new ArrayList<List<String>>();
        for (int i = 0; i < fieldCount; ++i) {
            list.add(this.getFieldOrigin(sqlQuery, i));
        }
        return ImmutableNullableList.copyOf(list);
    }

    private @Nullable List<String> getFieldOrigin(SqlNode sqlQuery, int i) {
        if (sqlQuery instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)sqlQuery;
            SelectScope scope = this.getRawSelectScopeNonNull(sqlSelect);
            List<SqlNode> selectList = Objects.requireNonNull(scope.getExpandedSelectList(), () -> "expandedSelectList for " + scope);
            SqlNode selectItem = SqlUtil.stripAs(selectList.get(i));
            if (selectItem instanceof SqlIdentifier) {
                SqlValidatorTable table;
                SqlQualified qualified = scope.fullyQualify((SqlIdentifier)selectItem);
                SqlValidatorNamespace namespace = Objects.requireNonNull(qualified.namespace, () -> "namespace for " + qualified);
                if (namespace.isWrapperFor(AliasNamespace.class)) {
                    AliasNamespace aliasNs = namespace.unwrap(AliasNamespace.class);
                    SqlNode aliased = Objects.requireNonNull(aliasNs.getNode(), () -> "sqlNode for aliasNs " + aliasNs);
                    namespace = this.getNamespaceOrThrow(SqlUtil.stripAs(aliased));
                }
                if ((table = namespace.getTable()) == null) {
                    return null;
                }
                ArrayList<String> origin = new ArrayList<String>(table.getQualifiedName());
                for (String name : qualified.suffix()) {
                    UnnestNamespace unnestNamespace;
                    SqlQualified columnUnnestedFrom;
                    if (namespace.isWrapperFor(UnnestNamespace.class) && (columnUnnestedFrom = (unnestNamespace = namespace.unwrap(UnnestNamespace.class)).getColumnUnnestedFrom(name)) != null) {
                        origin.addAll(columnUnnestedFrom.suffix());
                    }
                    if ((namespace = namespace.lookupChild(name)) == null) {
                        return null;
                    }
                    origin.add(name);
                }
                return origin;
            }
            return null;
        }
        if (sqlQuery instanceof SqlOrderBy) {
            return this.getFieldOrigin(((SqlOrderBy)sqlQuery).query, i);
        }
        return null;
    }

    @Override
    public RelDataType getParameterRowType(SqlNode sqlQuery) {
        final ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        final HashSet alreadyVisited = new HashSet();
        sqlQuery.accept(new SqlShuttle(){

            @Override
            public SqlNode visit(SqlDynamicParam param) {
                if (alreadyVisited.add(param)) {
                    RelDataType type = SqlValidatorImpl.this.getValidatedNodeType(param);
                    types.add(type);
                }
                return param;
            }
        });
        return this.typeFactory.createStructType(types, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return "?" + index;
            }

            @Override
            public int size() {
                return types.size();
            }
        });
    }

    private static boolean isPhysicalNavigation(SqlKind kind) {
        return kind == SqlKind.PREV || kind == SqlKind.NEXT;
    }

    private static boolean isLogicalNavigation(SqlKind kind) {
        return kind == SqlKind.FIRST || kind == SqlKind.LAST;
    }

    private static boolean isAggregation(SqlKind kind) {
        return kind == SqlKind.SUM || kind == SqlKind.SUM0 || kind == SqlKind.AVG || kind == SqlKind.COUNT || kind == SqlKind.MAX || kind == SqlKind.MIN;
    }

    private static boolean isRunningOrFinal(SqlKind kind) {
        return kind == SqlKind.RUNNING || kind == SqlKind.FINAL;
    }

    private static boolean isSingleVarRequired(SqlKind kind) {
        return SqlValidatorImpl.isPhysicalNavigation(kind) || SqlValidatorImpl.isLogicalNavigation(kind) || SqlValidatorImpl.isAggregation(kind);
    }

    private static enum Clause {
        WHERE,
        GROUP_BY,
        SELECT,
        MEASURE,
        ORDER,
        CURSOR,
        HAVING,
        QUALIFY;


        boolean shouldReplaceAliases(SqlValidator.Config config) {
            switch (this) {
                case GROUP_BY: {
                    return config.conformance().isGroupByAlias();
                }
                case HAVING: {
                    return config.conformance().isHavingAlias();
                }
                case QUALIFY: {
                    return true;
                }
            }
            throw Util.unexpected(this);
        }
    }

    public static enum Status {
        UNVALIDATED,
        IN_PROGRESS,
        VALID;

    }

    private class Permute {
        final List<ImmutableIntList> sources;
        final RelDataType rowType;
        final boolean trivial;
        final int offset;

        Permute(SqlNode from, int offset) {
            this.offset = offset;
            switch (from.getKind()) {
                case JOIN: {
                    ImmutableIntList source;
                    SqlJoin join = (SqlJoin)from;
                    Permute left = new Permute(join.getLeft(), offset);
                    int fieldCount = SqlValidatorImpl.this.getValidatedNodeType(join.getLeft()).getFieldList().size();
                    Permute right = new Permute(join.getRight(), offset + fieldCount);
                    List<String> names = SqlValidatorImpl.this.usingNames(join);
                    ArrayList<ImmutableIntList> sources = new ArrayList<ImmutableIntList>();
                    HashSet<ImmutableIntList> sourceSet = new HashSet<ImmutableIntList>();
                    RelDataTypeFactory.FieldInfoBuilder b = SqlValidatorImpl.this.typeFactory.builder();
                    if (names != null) {
                        for (String name : names) {
                            RelDataTypeField f = left.field(name);
                            ImmutableIntList source2 = left.sources.get(f.getIndex());
                            sourceSet.add(source2);
                            RelDataTypeField f2 = right.field(name);
                            ImmutableIntList source22 = right.sources.get(f2.getIndex());
                            sourceSet.add(source22);
                            sources.add(source2.appendAll(source22));
                            boolean nullable = !(!f.getType().isNullable() && !join.getJoinType().generatesNullsOnLeft() || !f2.getType().isNullable() && !join.getJoinType().generatesNullsOnRight());
                            ((RelDataTypeFactory.Builder)b).add(f).nullable(nullable);
                        }
                    }
                    for (RelDataTypeField f : left.rowType.getFieldList()) {
                        source = left.sources.get(f.getIndex());
                        if (!sourceSet.add(source)) continue;
                        sources.add(source);
                        ((RelDataTypeFactory.Builder)b).add(f);
                    }
                    for (RelDataTypeField f : right.rowType.getFieldList()) {
                        source = right.sources.get(f.getIndex());
                        if (!sourceSet.add(source)) continue;
                        sources.add(source);
                        ((RelDataTypeFactory.Builder)b).add(f);
                    }
                    this.rowType = b.build();
                    this.sources = ImmutableList.copyOf(sources);
                    this.trivial = left.trivial && right.trivial && (names == null || names.isEmpty());
                    break;
                }
                default: {
                    this.rowType = SqlValidatorImpl.this.getValidatedNodeType(from);
                    this.sources = Functions.generate((int)this.rowType.getFieldCount(), i -> ImmutableIntList.of(offset + i));
                    this.trivial = true;
                }
            }
        }

        private RelDataTypeField field(String name) {
            RelDataTypeField field = SqlValidatorImpl.this.catalogReader.nameMatcher().field(this.rowType, name);
            if (field == null) {
                throw new AssertionError((Object)("field " + name + " was not found in " + this.rowType));
            }
            return field;
        }

        void permute(List<SqlNode> selectItems, PairList<String, RelDataType> fields) {
            if (this.trivial) {
                return;
            }
            ImmutableList oldSelectItems = ImmutableList.copyOf(selectItems);
            selectItems.clear();
            selectItems.addAll(oldSelectItems.subList(0, this.offset));
            ImmutablePairList<String, RelDataType> oldFields = fields.immutable();
            fields.clear();
            fields.addAll((PairList<String, RelDataType>)oldFields.subList(0, this.offset));
            for (ImmutableIntList source : this.sources) {
                int p0 = source.get(0);
                Map.Entry field = (Map.Entry)oldFields.get(p0);
                String name = (String)field.getKey();
                RelDataType type = (RelDataType)field.getValue();
                SqlNode selectItem = (SqlNode)oldSelectItems.get(p0);
                for (int p1 : Util.skip(source)) {
                    Map.Entry field1 = (Map.Entry)oldFields.get(p1);
                    SqlNode selectItem1 = (SqlNode)oldSelectItems.get(p1);
                    RelDataType type1 = (RelDataType)field1.getValue();
                    boolean nullable = type.isNullable() && type1.isNullable();
                    RelDataType currentType = type;
                    RelDataType type2 = Objects.requireNonNull(SqlTypeUtil.leastRestrictiveForComparison(SqlValidatorImpl.this.typeFactory, type, type1), () -> "leastRestrictiveForComparison for types " + currentType + " and " + type1);
                    selectItem = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.COALESCE.createCall(SqlParserPos.ZERO, SqlValidatorImpl.this.maybeCast(selectItem, type, type2), SqlValidatorImpl.this.maybeCast(selectItem1, type1, type2)), new SqlIdentifier(name, SqlParserPos.ZERO));
                    type = SqlValidatorImpl.this.typeFactory.createTypeWithNullability(type2, nullable);
                }
                fields.add(name, type);
                selectItems.add(selectItem);
            }
        }
    }

    private class PatternValidator
    extends SqlBasicVisitor<Set<String>> {
        private final boolean isMeasure;
        int firstLastCount;
        int prevNextCount;
        int aggregateCount;

        PatternValidator(boolean isMeasure) {
            this(isMeasure, 0, 0, 0);
        }

        PatternValidator(boolean isMeasure, int firstLastCount, int prevNextCount, int aggregateCount) {
            this.isMeasure = isMeasure;
            this.firstLastCount = firstLastCount;
            this.prevNextCount = prevNextCount;
            this.aggregateCount = aggregateCount;
        }

        @Override
        public Set<String> visit(SqlCall call) {
            boolean isSingle = false;
            HashSet<String> vars = new HashSet<String>();
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            if (SqlValidatorImpl.isSingleVarRequired(kind)) {
                isSingle = true;
                if (SqlValidatorImpl.isPhysicalNavigation(kind)) {
                    if (this.isMeasure) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternPrevFunctionInMeasure(call.toString()));
                    }
                    if (this.firstLastCount != 0) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternPrevFunctionOrder(call.toString()));
                    }
                    ++this.prevNextCount;
                } else if (SqlValidatorImpl.isLogicalNavigation(kind)) {
                    if (this.firstLastCount != 0) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternPrevFunctionOrder(call.toString()));
                    }
                    ++this.firstLastCount;
                } else if (SqlValidatorImpl.isAggregation(kind)) {
                    if (this.firstLastCount != 0 || this.prevNextCount != 0) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternAggregationInNavigation(call.toString()));
                    }
                    if (kind == SqlKind.COUNT && call.getOperandList().size() > 1) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternCountFunctionArg());
                    }
                    ++this.aggregateCount;
                }
            }
            if (SqlValidatorImpl.isRunningOrFinal(kind) && !this.isMeasure) {
                throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternRunningFunctionInDefine(call.toString()));
            }
            for (SqlNode node : operands) {
                if (node == null) continue;
                vars.addAll((Collection<String>)Objects.requireNonNull(node.accept(new PatternValidator(this.isMeasure, this.firstLastCount, this.prevNextCount, this.aggregateCount)), () -> "node.accept(PatternValidator) for node " + node));
            }
            if (isSingle) {
                switch (kind) {
                    case COUNT: {
                        if (vars.size() <= 1) break;
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternCountFunctionArg());
                    }
                    default: {
                        if (!operands.isEmpty() && operands.get(0) instanceof SqlCall && ((SqlCall)operands.get(0)).getOperator() == SqlStdOperatorTable.CLASSIFIER) break;
                        if (vars.isEmpty()) {
                            throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternFunctionNullCheck(call.toString()));
                        }
                        if (vars.size() == 1) break;
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternFunctionVariableCheck(call.toString()));
                    }
                }
            }
            return vars;
        }

        @Override
        public Set<String> visit(SqlIdentifier identifier) {
            boolean check = this.prevNextCount > 0 || this.firstLastCount > 0 || this.aggregateCount > 0;
            HashSet<String> vars = new HashSet<String>();
            if (identifier.names.size() > 1 && check) {
                vars.add((String)identifier.names.get(0));
            }
            return vars;
        }

        @Override
        public Set<String> visit(SqlLiteral literal) {
            return ImmutableSet.of();
        }

        @Override
        public Set<String> visit(SqlIntervalQualifier qualifier) {
            return ImmutableSet.of();
        }

        @Override
        public Set<String> visit(SqlDataTypeSpec type) {
            return ImmutableSet.of();
        }

        @Override
        public Set<String> visit(SqlDynamicParam param) {
            return ImmutableSet.of();
        }
    }

    private static class NavigationReplacer
    extends NavigationModifier {
        private final String alpha;

        NavigationReplacer(String alpha) {
            this.alpha = alpha;
        }

        @Override
        public @Nullable SqlNode visit(SqlCall call) {
            SqlKind kind = call.getKind();
            if (SqlValidatorImpl.isLogicalNavigation(kind) || SqlValidatorImpl.isAggregation(kind) || SqlValidatorImpl.isRunningOrFinal(kind)) {
                return call;
            }
            switch (kind) {
                case PREV: {
                    List<SqlNode> operands = call.getOperandList();
                    if (!(operands.get(0) instanceof SqlIdentifier)) break;
                    String name = (String)((SqlIdentifier)operands.get((int)0)).names.get(0);
                    return name.equals(this.alpha) ? call : SqlStdOperatorTable.LAST.createCall(SqlParserPos.ZERO, operands);
                }
            }
            return super.visit(call);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple()) {
                return id;
            }
            SqlMatchFunction operator = ((String)id.names.get(0)).equals(this.alpha) ? SqlStdOperatorTable.PREV : SqlStdOperatorTable.LAST;
            return operator.createCall(SqlParserPos.ZERO, id, SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO));
        }
    }

    private static class NavigationExpander
    extends NavigationModifier {
        final @Nullable SqlOperator op;
        final @Nullable SqlNode offset;

        NavigationExpander() {
            this(null, null);
        }

        NavigationExpander(@Nullable SqlOperator operator, @Nullable SqlNode offset) {
            this.offset = offset;
            this.op = operator;
        }

        @Override
        public @Nullable SqlNode visit(SqlCall call) {
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            ArrayList<@Nullable SqlNode> newOperands = new ArrayList<SqlNode>();
            if (call.getFunctionQuantifier() != null && call.getFunctionQuantifier().getValue() == SqlSelectKeyword.DISTINCT) {
                SqlParserPos pos = call.getParserPosition();
                throw SqlUtil.newContextException(pos, Static.RESOURCE.functionQuantifierNotAllowed(call.toString()));
            }
            if (SqlValidatorImpl.isLogicalNavigation(kind) || SqlValidatorImpl.isPhysicalNavigation(kind)) {
                SqlKind innerKind;
                SqlNode inner = operands.get(0);
                SqlNode offset = operands.get(1);
                if (SqlValidatorImpl.isPhysicalNavigation(kind) && SqlValidatorImpl.isPhysicalNavigation(innerKind = inner.getKind())) {
                    List<SqlNode> innerOperands = ((SqlCall)inner).getOperandList();
                    SqlNode innerOffset = innerOperands.get(1);
                    SqlBinaryOperator newOperator = innerKind == kind ? SqlStdOperatorTable.PLUS : SqlStdOperatorTable.MINUS;
                    offset = newOperator.createCall(SqlParserPos.ZERO, offset, innerOffset);
                    inner = call.getOperator().createCall(SqlParserPos.ZERO, innerOperands.get(0), offset);
                }
                SqlNode newInnerNode = inner.accept(new NavigationExpander(call.getOperator(), offset));
                if (this.op != null) {
                    newInnerNode = this.op.createCall(SqlParserPos.ZERO, newInnerNode, this.offset);
                }
                return newInnerNode;
            }
            if (!operands.isEmpty()) {
                for (SqlNode node : operands) {
                    if (node != null) {
                        SqlNode newNode = node.accept(new NavigationExpander());
                        if (this.op != null) {
                            newNode = this.op.createCall(SqlParserPos.ZERO, newNode, this.offset);
                        }
                        newOperands.add(newNode);
                        continue;
                    }
                    newOperands.add(null);
                }
                return call.getOperator().createCall(SqlParserPos.ZERO, newOperands);
            }
            if (this.op == null) {
                return call;
            }
            return this.op.createCall(SqlParserPos.ZERO, call, this.offset);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (this.op == null) {
                return id;
            }
            return this.op.createCall(SqlParserPos.ZERO, id, this.offset);
        }
    }

    private static class NavigationModifier
    extends SqlShuttle {
        private NavigationModifier() {
        }

        public SqlNode go(SqlNode node) {
            return Objects.requireNonNull(node.accept(this), () -> "NavigationModifier returned for " + node);
        }
    }

    protected static class FunctionParamInfo {
        public final Map<Integer, SqlSelect> cursorPosToSelectMap = new HashMap<Integer, SqlSelect>();
        public final Map<String, String> columnListParamToParentCursorMap = new HashMap<String, String>();
    }

    protected static class IdInfo {
        public final SqlValidatorScope scope;
        public final SqlIdentifier id;

        public IdInfo(SqlValidatorScope scope, SqlIdentifier id) {
            this.scope = scope;
            this.id = id;
        }
    }

    static class ExtendedExpander
    extends Expander {
        final SqlSelect select;
        final SqlNode root;
        final Clause clause;
        final Set<SqlNode> aliasOrdinalExpandSet = Sets.newIdentityHashSet();

        ExtendedExpander(SqlValidatorImpl validator, SqlValidatorScope scope, SqlSelect select, SqlNode root, Clause clause) {
            super(validator, scope);
            this.select = select;
            this.root = root;
            this.clause = clause;
            if (clause == Clause.GROUP_BY) {
                this.addExpandableExpressions();
            }
        }

        @Override
        public @Nullable SqlNode visit(SqlIdentifier id) {
            if (!id.isSimple()) {
                return super.visit(id);
            }
            boolean replaceAliases = this.clause.shouldReplaceAliases(this.validator.config);
            if (!replaceAliases || this.clause == Clause.GROUP_BY && !this.aliasOrdinalExpandSet.contains(id)) {
                SelectScope scope = this.validator.getRawSelectScopeNonNull(this.select);
                SqlNode node = SqlValidatorImpl.expandCommonColumn(this.select, id, scope, this.validator);
                if (node != id) {
                    return node;
                }
                return super.visit(id);
            }
            String name = id.getSimple();
            SqlNode expr = null;
            SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
            int n = 0;
            for (Object s : SqlNonNullableAccessors.getSelectList(this.select)) {
                @Nullable String alias = SqlValidatorUtil.alias((SqlNode)s);
                if (alias == null || !nameMatcher.matches(alias, name)) continue;
                expr = s;
                ++n;
            }
            if (n == 0) {
                return super.visit(id);
            }
            if (n > 1) {
                throw this.validator.newValidationError(id, Static.RESOURCE.columnAmbiguous(name));
            }
            Iterable<SqlCall> allAggList = this.validator.aggFinder.findAll((Iterable<SqlNode>)ImmutableList.of((Object)this.root));
            for (SqlCall agg : allAggList) {
                if (this.clause != Clause.HAVING || !this.containsIdentifier(agg, id)) continue;
                return super.visit(id);
            }
            if ((expr = SqlUtil.stripAs(expr)) instanceof SqlIdentifier) {
                SqlIdentifier sid = (SqlIdentifier)expr;
                SqlIdentifier fqId = this.getScope().fullyQualify((SqlIdentifier)sid).identifier;
                expr = this.expandDynamicStar(sid, fqId);
            }
            return expr;
        }

        @Override
        public @Nullable SqlNode visit(SqlLiteral literal) {
            if (this.clause != Clause.GROUP_BY || !this.validator.config().conformance().isGroupByOrdinal()) {
                return super.visit(literal);
            }
            boolean isOrdinalLiteral = this.aliasOrdinalExpandSet.contains(literal);
            if (isOrdinalLiteral) {
                switch (literal.getTypeName()) {
                    case DECIMAL: 
                    case DOUBLE: {
                        int intValue = literal.intValue(false);
                        if (intValue < 0) break;
                        if (intValue < 1 || intValue > SqlNonNullableAccessors.getSelectList(this.select).size()) {
                            throw this.validator.newValidationError(literal, Static.RESOURCE.orderByOrdinalOutOfRange());
                        }
                        int ordinal = intValue - 1;
                        return SqlUtil.stripAs(SqlNonNullableAccessors.getSelectList(this.select).get(ordinal));
                    }
                }
            }
            return super.visit(literal);
        }

        @RequiresNonNull(value={"root"})
        private void addExpandableExpressions(@UnknownInitialization ExtendedExpander this) {
            switch (this.root.getKind()) {
                case IDENTIFIER: 
                case LITERAL: {
                    this.aliasOrdinalExpandSet.add(this.root);
                    break;
                }
                case GROUPING_SETS: 
                case ROLLUP: 
                case CUBE: {
                    if (!(this.root instanceof SqlBasicCall)) break;
                    List<SqlNode> operandList = ((SqlBasicCall)this.root).getOperandList();
                    for (SqlNode sqlNode : operandList) {
                        this.addIdentifierOrdinal2ExpandSet(sqlNode);
                    }
                    break;
                }
            }
        }

        private void addIdentifierOrdinal2ExpandSet(@UnknownInitialization ExtendedExpander this, SqlNode sqlNode) {
            if (sqlNode.getKind() == SqlKind.ROW) {
                List<SqlNode> rowOperandList = ((SqlCall)sqlNode).getOperandList();
                for (SqlNode node : rowOperandList) {
                    this.addIdentifierOrdinal2ExpandSet(node);
                }
            } else if (sqlNode.getKind() == SqlKind.IDENTIFIER || sqlNode.getKind() == SqlKind.LITERAL) {
                this.aliasOrdinalExpandSet.add(sqlNode);
            }
        }

        private boolean containsIdentifier(SqlNode sqlNode, final SqlIdentifier target) {
            try {
                SqlBasicVisitor<Void> visitor = new SqlBasicVisitor<Void>(){

                    @Override
                    public Void visit(SqlIdentifier identifier) {
                        if (identifier.equalsDeep((SqlNode)target, Litmus.IGNORE)) {
                            throw new Util.FoundOne(target);
                        }
                        return (Void)super.visit(identifier);
                    }
                };
                sqlNode.accept(visitor);
                return false;
            }
            catch (Util.FoundOne e) {
                Util.swallow(e, null);
                return true;
            }
        }
    }

    static class SelectExpander
    extends Expander {
        final SqlSelect select;

        SelectExpander(SqlValidatorImpl validator, SelectScope scope, SqlSelect select) {
            super(validator, scope);
            this.select = select;
        }

        @Override
        public @Nullable SqlNode visit(SqlIdentifier id) {
            SqlNode node = SqlValidatorImpl.expandCommonColumn(this.select, id, (SelectScope)this.getScope(), this.validator);
            if (node != id) {
                return node;
            }
            return super.visit(id);
        }
    }

    class OrderExpressionExpander
    extends SqlScopedShuttle {
        private final List<String> aliasList;
        private final SqlSelect select;
        private final SqlNode root;

        OrderExpressionExpander(SqlSelect select, SqlNode root) {
            super(SqlValidatorImpl.this.getOrderScope(select));
            this.select = select;
            this.root = root;
            this.aliasList = SqlValidatorImpl.this.getNamespaceOrThrow(select).getRowType().getFieldNames();
        }

        public SqlNode go() {
            return Objects.requireNonNull(this.root.accept(this), () -> "OrderExpressionExpander returned null for " + this.root);
        }

        @Override
        public @Nullable SqlNode visit(SqlLiteral literal) {
            if (literal == this.root && SqlValidatorImpl.this.config.conformance().isSortByOrdinal()) {
                switch (literal.getTypeName()) {
                    case DECIMAL: 
                    case DOUBLE: {
                        int intValue = literal.intValue(false);
                        if (intValue < 0) break;
                        if (intValue < 1 || intValue > this.aliasList.size()) {
                            throw SqlValidatorImpl.this.newValidationError(literal, Static.RESOURCE.orderByOrdinalOutOfRange());
                        }
                        int ordinal = intValue - 1;
                        return this.nthSelectItem(ordinal, literal.getParserPosition());
                    }
                }
            }
            return super.visit(literal);
        }

        private SqlNode nthSelectItem(int ordinal, SqlParserPos pos) {
            SqlNodeList expandedSelectList = SqlValidatorImpl.this.expandStar(SqlNonNullableAccessors.getSelectList(this.select), this.select, false);
            SqlNode expr = expandedSelectList.get(ordinal);
            if ((expr = SqlUtil.stripAs(expr)) instanceof SqlIdentifier) {
                expr = this.getScope().fullyQualify((SqlIdentifier)((SqlIdentifier)expr)).identifier;
            }
            return expr.clone(pos);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple() && SqlValidatorImpl.this.config.conformance().isSortByAlias()) {
                String alias = id.getSimple();
                SqlValidatorNamespace selectNs = SqlValidatorImpl.this.getNamespaceOrThrow(this.select);
                RelDataType rowType = selectNs.getRowTypeSansSystemColumns();
                SqlNameMatcher nameMatcher = SqlValidatorImpl.this.catalogReader.nameMatcher();
                RelDataTypeField field = nameMatcher.field(rowType, alias);
                if (field != null) {
                    return this.nthSelectItem(field.getIndex(), id.getParserPosition());
                }
            }
            return this.getScope().fullyQualify((SqlIdentifier)id).identifier;
        }

        @Override
        protected @Nullable SqlNode visitScoped(SqlCall call) {
            if (call instanceof SqlSelect) {
                return call;
            }
            return super.visitScoped(call);
        }
    }

    private static class Expander
    extends SqlScopedShuttle {
        protected final SqlValidatorImpl validator;

        Expander(SqlValidatorImpl validator, SqlValidatorScope scope) {
            super(scope);
            this.validator = validator;
        }

        public SqlNode go(SqlNode root) {
            return Objects.requireNonNull(root.accept(this), () -> this + " returned null for " + root);
        }

        @Override
        public @Nullable SqlNode visit(SqlIdentifier id) {
            SqlCall call = this.validator.makeNullaryCall(id);
            if (call != null) {
                return call.accept(this);
            }
            SqlIdentifier fqId = this.getScope().fullyQualify((SqlIdentifier)id).identifier;
            SqlNode expandedExpr = this.expandDynamicStar(id, fqId);
            this.validator.setOriginal(expandedExpr, id);
            return expandedExpr;
        }

        @Override
        public @Nullable SqlNode visit(SqlLiteral literal) {
            return this.validator.resolveLiteral(literal);
        }

        @Override
        protected SqlNode visitScoped(SqlCall call) {
            switch (call.getKind()) {
                case WITH: 
                case LAMBDA: 
                case SCALAR_QUERY: 
                case CURRENT_VALUE: 
                case NEXT_VALUE: {
                    return call;
                }
            }
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, false);
            call.getOperator().acceptCall(this, call, true, argHandler);
            SqlNode result = argHandler.result();
            this.validator.setOriginal(result, call);
            return result;
        }

        protected SqlNode expandDynamicStar(SqlIdentifier id, SqlIdentifier fqId) {
            if (DynamicRecordType.isDynamicStarColName(Util.last(fqId.names)) && !DynamicRecordType.isDynamicStarColName(Util.last(id.names))) {
                return new SqlBasicCall(SqlStdOperatorTable.ITEM, (List<? extends SqlNode>)ImmutableList.of((Object)fqId, (Object)SqlLiteral.createCharString(Util.last(id.names), id.getParserPosition())), id.getParserPosition());
            }
            return fqId;
        }
    }

    private class DeriveTypeVisitor
    implements SqlVisitor<RelDataType> {
        private final SqlValidatorScope scope;

        DeriveTypeVisitor(SqlValidatorScope scope) {
            this.scope = scope;
        }

        @Override
        public RelDataType visit(SqlLiteral literal) {
            return SqlValidatorImpl.this.resolveLiteral(literal).createSqlType(SqlValidatorImpl.this.typeFactory);
        }

        @Override
        public RelDataType visit(SqlCall call) {
            SqlOperator operator = call.getOperator();
            return operator.deriveType(SqlValidatorImpl.this, this.scope, call);
        }

        @Override
        public RelDataType visit(SqlNodeList nodeList) {
            throw Util.needToImplement(nodeList);
        }

        @Override
        public RelDataType visit(SqlIdentifier id) {
            int i;
            SqlCall call = SqlValidatorImpl.this.makeNullaryCall(id);
            if (call != null) {
                return call.getOperator().validateOperands(SqlValidatorImpl.this, this.scope, call);
            }
            RelDataType type = null;
            if (!(this.scope instanceof EmptyScope)) {
                id = this.scope.fullyQualify((SqlIdentifier)id).identifier;
            }
            for (i = id.names.size() - 1; i > 0; --i) {
                SqlNameMatcher nameMatcher = SqlValidatorImpl.this.catalogReader.nameMatcher();
                SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
                this.scope.resolve((List<String>)id.names.subList(0, i), nameMatcher, false, resolved);
                if (resolved.count() != 1) continue;
                SqlValidatorScope.Resolve resolve = resolved.only();
                type = resolve.rowType();
                for (SqlValidatorScope.Step p : Util.skip(resolve.path.steps())) {
                    type = type.getFieldList().get(p.i).getType();
                }
                break;
            }
            if (type == null || id.names.size() == 1) {
                RelDataType colType = this.scope.resolveColumn((String)id.names.get(0), id);
                if (colType != null) {
                    type = colType;
                }
                ++i;
            }
            if (type == null) {
                SqlIdentifier last = id.getComponent(i - 1, i);
                throw SqlValidatorImpl.this.newValidationError(last, Static.RESOURCE.unknownIdentifier(last.toString()));
            }
            while (i < id.names.size()) {
                RelDataTypeField field;
                String name = (String)id.names.get(i);
                if (name.isEmpty()) {
                    name = "*";
                    field = null;
                } else {
                    SqlNameMatcher nameMatcher = SqlValidatorImpl.this.catalogReader.nameMatcher();
                    field = nameMatcher.field(type, name);
                }
                if (field == null) {
                    throw SqlValidatorImpl.this.newValidationError(id.getComponent(i), Static.RESOURCE.unknownField(name));
                }
                boolean recordIsNullable = type.isNullable();
                type = field.getType();
                if (recordIsNullable) {
                    type = SqlValidatorImpl.this.getTypeFactory().enforceTypeWithNullability(type, true);
                }
                ++i;
            }
            type = SqlTypeUtil.addCharsetAndCollation(type, SqlValidatorImpl.this.getTypeFactory());
            return type;
        }

        @Override
        public RelDataType visit(SqlDataTypeSpec dataType) {
            SqlValidatorImpl.this.validateDataType(dataType);
            return dataType.deriveType(SqlValidatorImpl.this);
        }

        @Override
        public RelDataType visit(SqlDynamicParam param) {
            return SqlValidatorImpl.this.unknownType;
        }

        @Override
        public RelDataType visit(SqlIntervalQualifier intervalQualifier) {
            return SqlValidatorImpl.this.typeFactory.createSqlIntervalType(intervalQualifier);
        }
    }

    private static class PatternVarVisitor
    implements SqlVisitor<Void> {
        private final MatchRecognizeScope scope;

        PatternVarVisitor(MatchRecognizeScope scope) {
            this.scope = scope;
        }

        @Override
        public Void visit(SqlLiteral literal) {
            return null;
        }

        @Override
        public Void visit(SqlCall call) {
            for (int i = 0; i < call.getOperandList().size(); ++i) {
                call.getOperandList().get(i).accept(this);
            }
            return null;
        }

        @Override
        public Void visit(SqlNodeList nodeList) {
            throw Util.needToImplement(nodeList);
        }

        @Override
        public Void visit(SqlIdentifier id) {
            Preconditions.checkArgument((boolean)id.isSimple());
            this.scope.addPatternVar(id.getSimple());
            return null;
        }

        @Override
        public Void visit(SqlDataTypeSpec type) {
            throw Util.needToImplement(type);
        }

        @Override
        public Void visit(SqlDynamicParam param) {
            throw Util.needToImplement(param);
        }

        @Override
        public Void visit(SqlIntervalQualifier intervalQualifier) {
            throw Util.needToImplement(intervalQualifier);
        }
    }

    private static class MergeNamespace
    extends DmlNamespace {
        private final SqlMerge node;

        MergeNamespace(SqlValidatorImpl validator, SqlMerge node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node, "node");
        }

        @Override
        public @Nullable SqlNode getNode() {
            return this.node;
        }
    }

    private static class DeleteNamespace
    extends DmlNamespace {
        private final SqlDelete node;

        DeleteNamespace(SqlValidatorImpl validator, SqlDelete node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node, "node");
        }

        @Override
        public @Nullable SqlNode getNode() {
            return this.node;
        }
    }

    private static class UpdateNamespace
    extends DmlNamespace {
        private final SqlUpdate node;

        UpdateNamespace(SqlValidatorImpl validator, SqlUpdate node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node, "node");
        }

        @Override
        public @Nullable SqlNode getNode() {
            return this.node;
        }
    }

    private static class InsertNamespace
    extends DmlNamespace {
        private final SqlInsert node;

        InsertNamespace(SqlValidatorImpl validator, SqlInsert node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node, "node");
        }

        @Override
        public @Nullable SqlNode getNode() {
            return this.node;
        }
    }

    public static class DmlNamespace
    extends IdentifierNamespace {
        protected DmlNamespace(SqlValidatorImpl validator, SqlNode id, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, id, enclosingNode, parentScope);
        }
    }

    class ValidationErrorFunction
    implements BiFunction<SqlNode, Resources.ExInst<SqlValidatorException>, CalciteContextException> {
        ValidationErrorFunction() {
        }

        @Override
        public CalciteContextException apply(SqlNode v0, Resources.ExInst<SqlValidatorException> v1) {
            return SqlValidatorImpl.this.newValidationError(v0, v1);
        }
    }

    private class ValidationError
    implements Supplier<CalciteContextException> {
        private final SqlNode sqlNode;
        private final Resources.ExInst<SqlValidatorException> validatorException;

        ValidationError(SqlNode sqlNode, Resources.ExInst<SqlValidatorException> validatorException) {
            this.sqlNode = sqlNode;
            this.validatorException = validatorException;
        }

        @Override
        public CalciteContextException get() {
            return SqlValidatorImpl.this.newValidationError(this.sqlNode, this.validatorException);
        }
    }

    private static class ConjunctionOfEqualities
    extends SqlShuttle {
        boolean illegal = false;

        private ConjunctionOfEqualities() {
        }

        void checkAnd(SqlCall call) {
            List<SqlNode> operands = call.getOperandList();
            for (SqlNode operand : operands) {
                if (operand.getKind() == SqlKind.AND) {
                    this.checkAnd((SqlCall)operand);
                    return;
                }
                if (operand.getKind() == SqlKind.EQUALS) continue;
                this.illegal = true;
            }
        }

        @Override
        public @Nullable SqlNode visit(SqlCall call) {
            Object operand;
            SqlKind kind = call.getKind();
            if (kind != SqlKind.AND && kind != SqlKind.EQUALS && kind != SqlKind.CAST) {
                this.illegal = true;
                return null;
            }
            if (kind == SqlKind.AND) {
                this.checkAnd(call);
            }
            if (kind == SqlKind.CAST && !((operand = call.operand(0)) instanceof SqlIdentifier)) {
                this.illegal = true;
                return null;
            }
            return super.visit(call);
        }
    }

    private class CompareFromBothSides
    extends SqlShuttle {
        final SqlValidatorScope scope;
        final SqlValidatorCatalogReader catalogReader;
        final Resources.ExInst<SqlValidatorException> exception;

        private CompareFromBothSides(SqlValidatorScope scope, SqlValidatorCatalogReader catalogReader, Resources.ExInst<SqlValidatorException> exception) {
            this.scope = scope;
            this.catalogReader = catalogReader;
            this.exception = exception;
        }

        @Override
        public @Nullable SqlNode visit(SqlCall call) {
            SqlKind kind = call.getKind();
            if (SqlKind.COMPARISON.contains((Object)kind)) {
                assert (call.getOperandList().size() == 2);
                boolean leftFound = false;
                boolean rightFound = false;
                for (SqlNode operand : call.getOperandList()) {
                    SqlBasicCall basicCall;
                    if (operand instanceof SqlBasicCall && (basicCall = (SqlBasicCall)operand).getKind() == SqlKind.CAST) {
                        operand = basicCall.operand(0);
                    }
                    if (!(operand instanceof SqlIdentifier)) {
                        throw SqlValidatorImpl.this.newValidationError(call, this.exception);
                    }
                    SqlIdentifier id = (SqlIdentifier)operand;
                    SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
                    SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
                    this.scope.resolve((List<String>)id.names.subList(0, id.names.size() - 1), nameMatcher, false, resolved);
                    SqlValidatorScope.Resolve resolve = resolved.only();
                    int index = resolve.path.steps().get((int)0).i;
                    if (index == 0) {
                        leftFound = true;
                    }
                    if (index == 1) {
                        rightFound = true;
                    }
                    if (leftFound || rightFound) continue;
                    throw SqlValidatorImpl.this.newValidationError(call, this.exception);
                }
                if (!leftFound || !rightFound) {
                    throw SqlValidatorImpl.this.newValidationError(call, this.exception);
                }
            }
            return super.visit(call);
        }
    }
}

