/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClickHouseSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.CLICKHOUSE).withIdentifierQuoteString("`").withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new ClickHouseSqlDialect(DEFAULT_CONTEXT);

    public ClickHouseSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public SqlDialect.CalendarPolicy getCalendarPolicy() {
        return SqlDialect.CalendarPolicy.SHIFT;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            SqlTypeName typeName = type.getSqlTypeName();
            switch (typeName) {
                case VARCHAR: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("String", typeName, type.isNullable());
                }
                case TINYINT: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int8", typeName, type.isNullable());
                }
                case SMALLINT: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int16", typeName, type.isNullable());
                }
                case INTEGER: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int32", typeName, type.isNullable());
                }
                case BIGINT: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Int64", typeName, type.isNullable());
                }
                case REAL: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Float32", typeName, type.isNullable());
                }
                case FLOAT: 
                case DOUBLE: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Float64", typeName, type.isNullable());
                }
                case DATE: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("Date", typeName, type.isNullable());
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return ClickHouseSqlDialect.createSqlDataTypeSpecByName("DateTime", typeName, type.isNullable());
                }
            }
        }
        return super.getCastSpec(type);
    }

    private static SqlDataTypeSpec createSqlDataTypeSpecByName(String typeAlias, SqlTypeName typeName, boolean isNullable) {
        if (isNullable) {
            typeAlias = "Nullable(" + typeAlias + ")";
        }
        final String finalTypeAlias = typeAlias;
        SqlBasicTypeNameSpec spec = new SqlBasicTypeNameSpec(typeName, SqlParserPos.ZERO){

            @Override
            public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
                writer.identifier(finalTypeAlias, true);
            }
        };
        return new SqlDataTypeSpec(spec, SqlParserPos.ZERO);
    }

    @Override
    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        String toFunc;
        if (literal instanceof SqlDateLiteral) {
            toFunc = "toDate";
        } else if (literal instanceof SqlTimestampLiteral) {
            toFunc = "toDateTime";
        } else if (literal instanceof SqlTimeLiteral) {
            toFunc = "toTime";
        } else {
            throw new RuntimeException("ClickHouse does not support DateTime literal: " + literal);
        }
        writer.literal(toFunc + "('" + literal.toFormattedString() + "')");
    }

    @Override
    public void unparseBoolLiteral(SqlWriter writer, SqlLiteral literal, int leftPrec, int rightPrec) {
        Boolean value = (Boolean)literal.getValue();
        if (value == null) {
            return;
        }
        RelToSqlConverterUtil.unparseBoolLiteralToCondition(writer, value);
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        Objects.requireNonNull(fetch, "fetch");
        writer.newlineAndIndent();
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FETCH);
        writer.keyword("LIMIT");
        if (offset != null) {
            offset.unparse(writer, -1, -1);
            writer.sep(",", true);
        }
        fetch.unparse(writer, -1, -1);
        writer.endList(frame);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.APPROX_COUNT_DISTINCT) {
            RelToSqlConverterUtil.specialOperatorByName("UNIQ").unparse(writer, call, 0, 0);
            return;
        }
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                ClickHouseSqlDialect.unparseFloor(writer, call);
                break;
            }
            case COUNT: {
                if (call.getFunctionQuantifier() != null && call.getFunctionQuantifier().toString().equals("DISTINCT")) {
                    writer.print("assumeNotNull");
                    SqlWriter.Frame frame = writer.startList("(", ")");
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    writer.endList(frame);
                    break;
                }
                super.unparseCall(writer, call, leftPrec, rightPrec);
                break;
            }
            case EXTRACT: {
                String funName;
                SqlLiteral node = (SqlLiteral)call.operand(0);
                TimeUnitRange unit = node.getValueAs(TimeUnitRange.class);
                switch (unit) {
                    case DOW: {
                        funName = "DAYOFWEEK";
                        break;
                    }
                    case DOY: {
                        funName = "DAYOFYEAR";
                        break;
                    }
                    case WEEK: {
                        funName = "toWeek";
                        break;
                    }
                    default: {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                }
                writer.print(funName);
                SqlWriter.Frame frame = writer.startList("(", ")");
                ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
                writer.endList(frame);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    private static void unparseFloor(SqlWriter writer, SqlCall call) {
        String funName;
        SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = timeUnitNode.getValueAs(TimeUnitRange.class);
        switch (unit) {
            case YEAR: {
                funName = "toStartOfYear";
                break;
            }
            case MONTH: {
                funName = "toStartOfMonth";
                break;
            }
            case WEEK: {
                funName = "toMonday";
                break;
            }
            case DAY: {
                funName = "toDate";
                break;
            }
            case HOUR: {
                funName = "toStartOfHour";
                break;
            }
            case MINUTE: {
                funName = "toStartOfMinute";
                break;
            }
            default: {
                throw new RuntimeException("ClickHouse does not support FLOOR for time unit: " + unit);
            }
        }
        writer.print(funName);
        SqlWriter.Frame frame = writer.startList("(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.endList(frame);
    }
}

