/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.smimesupport;

import javax.mail.internet.ContentType;
import javax.mail.internet.MimePart;
import net.markenwerk.utils.mail.smime.SmimeException;

public final class SmimeUtilFixed {
    public static SmimeStateFixed getStatus(MimePart mimePart) {
        try {
            return SmimeUtilFixed.getStatus(new ContentType(mimePart.getContentType()));
        }
        catch (Exception e) {
            throw SmimeUtilFixed.handledException(e);
        }
    }

    private static SmimeStateFixed getStatus(ContentType contentType) {
        if (SmimeUtilFixed.isSmimeSignatureContentType(contentType)) {
            return SmimeStateFixed.SIGNED;
        }
        if (SmimeUtilFixed.isSignatureSmimeType(contentType)) {
            return SmimeStateFixed.SIGNED_ENVELOPED;
        }
        if (SmimeUtilFixed.isSmimeEncryptionContenttype(contentType)) {
            return SmimeStateFixed.ENCRYPTED;
        }
        return SmimeStateFixed.NEITHER;
    }

    private static boolean isSmimeEncryptionContenttype(ContentType contentType) {
        String baseContentType = contentType.getBaseType();
        return baseContentType.equalsIgnoreCase("application/pkcs7-mime") || baseContentType.equalsIgnoreCase("application/x-pkcs7-mime");
    }

    private static boolean isSignatureSmimeType(ContentType contentType) {
        String baseContentType = contentType.getBaseType();
        return baseContentType.equalsIgnoreCase("application/x-pkcs7-mime") && "signed-data".equals(contentType.getParameter("smime-type"));
    }

    private static boolean isSmimeSignatureContentType(ContentType contentType) {
        String baseContentType = contentType.getBaseType();
        return baseContentType.equalsIgnoreCase("multipart/signed") && SmimeUtilFixed.isSmimeSignatureProtocoll(contentType.getParameter("protocol"));
    }

    private static boolean isSmimeSignatureProtocoll(String protocol) {
        return protocol.equalsIgnoreCase("application/pkcs7-signature") || protocol.equalsIgnoreCase("application/x-pkcs7-signature");
    }

    private static SmimeException handledException(Exception e) {
        if (e instanceof SmimeException) {
            return (SmimeException)e;
        }
        return new SmimeException(e.getMessage(), (Throwable)e);
    }

    public static enum SmimeStateFixed {
        ENCRYPTED,
        SIGNED,
        SIGNED_ENVELOPED,
        NEITHER;

    }
}

