/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.smimesupport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.markenwerk.utils.mail.smime.SmimeKey;
import net.markenwerk.utils.mail.smime.SmimeKeyStore;
import net.markenwerk.utils.mail.smime.SmimeUtil;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.internal.outlooksupport.model.OutlookMessage;
import org.simplejavamail.api.internal.outlooksupport.model.OutlookSmime;
import org.simplejavamail.api.internal.smimesupport.model.AttachmentDecryptionResult;
import org.simplejavamail.api.internal.smimesupport.model.SmimeDetails;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.internal.modules.SMIMEModule;
import org.simplejavamail.internal.smimesupport.AttachmentDecryptionResultImpl;
import org.simplejavamail.internal.smimesupport.SmimeException;
import org.simplejavamail.internal.smimesupport.SmimeRecognitionUtil;
import org.simplejavamail.internal.smimesupport.SmimeUtilFixed;
import org.simplejavamail.internal.smimesupport.builder.SmimeParseResultBuilder;
import org.simplejavamail.internal.smimesupport.model.OriginalSmimeDetailsImpl;
import org.simplejavamail.internal.smimesupport.model.SmimeDetailsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMIMESupport
implements SMIMEModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMIMESupport.class);
    private static final List<String> SMIME_MIMETYPES = Arrays.asList("application/pkcs7-mime", "application/x-pkcs7-mime", "multipart/signed");

    public SmimeParseResultBuilder decryptAttachments(@NotNull List<AttachmentResource> attachments, @NotNull OutlookMessage outlookMessage, @Nullable Pkcs12Config pkcs12Config) {
        SmimeParseResultBuilder smimeBuilder = new SmimeParseResultBuilder();
        if (outlookMessage.getSmimeMime() instanceof OutlookSmime.OutlookSmimeApplicationSmime) {
            OutlookSmime.OutlookSmimeApplicationSmime s = (OutlookSmime.OutlookSmimeApplicationSmime)outlookMessage.getSmimeMime();
            smimeBuilder.getOriginalSmimeDetails().completeWith(OriginalSmimeDetailsImpl.builder().smimeMime(s.getSmimeMime()).smimeType(s.getSmimeType()).smimeName(s.getSmimeName()).build());
        } else if (outlookMessage.getSmimeMime() instanceof OutlookSmime.OutlookSmimeMultipartSigned) {
            OutlookSmime.OutlookSmimeMultipartSigned s = (OutlookSmime.OutlookSmimeMultipartSigned)outlookMessage.getSmimeMime();
            smimeBuilder.getOriginalSmimeDetails().completeWith(OriginalSmimeDetailsImpl.builder().smimeMime(s.getSmimeMime()).smimeProtocol(s.getSmimeProtocol()).smimeMicalg(s.getSmimeMicalg()).build());
        }
        this.decryptAttachments(smimeBuilder, attachments, pkcs12Config);
        if (smimeBuilder.getOriginalSmimeDetails().getSmimeMode() == OriginalSmimeDetails.SmimeMode.SIGNED) {
            smimeBuilder.getOriginalSmimeDetails().completeWithSmimeSignatureValid(smimeBuilder.getSmimeSignedEmail() != null);
        }
        return smimeBuilder;
    }

    public SmimeParseResultBuilder decryptAttachments(@NotNull List<AttachmentResource> attachments, @NotNull MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config) {
        SmimeParseResultBuilder smimeBuilder = new SmimeParseResultBuilder();
        this.initSmimeMetadata(smimeBuilder, mimeMessage);
        this.decryptAttachments(smimeBuilder, attachments, pkcs12Config);
        this.finalizeSmimeMetadata(smimeBuilder, mimeMessage);
        return smimeBuilder;
    }

    private void initSmimeMetadata(SmimeParseResultBuilder smimeBuilder, @NotNull MimeMessage mimeMessage) {
        try {
            ContentType ct;
            if (mimeMessage.getHeader("Content-Type", null) != null && SmimeRecognitionUtil.isSmimeContentType(ct = new ContentType(mimeMessage.getHeader("Content-Type", null)))) {
                smimeBuilder.getOriginalSmimeDetails().completeWith(OriginalSmimeDetailsImpl.builder().smimeMime(ct.getBaseType()).smimeType(ct.getParameter("smime-type")).smimeName(ct.getParameter("name")).smimeProtocol(ct.getParameter("protocol")).smimeMicalg(ct.getParameter("micalg")).build());
            }
        }
        catch (MessagingException e) {
            throw new SmimeException("Error reading S/MIME Content-Type header from MimeMessage", (Exception)((Object)e));
        }
    }

    private void finalizeSmimeMetadata(SmimeParseResultBuilder smimeBuilder, @NotNull MimeMessage mimeMessage) {
        OriginalSmimeDetailsImpl originalSmimeDetails = smimeBuilder.getOriginalSmimeDetails();
        if (originalSmimeDetails.getSmimeMode() != OriginalSmimeDetails.SmimeMode.PLAIN) {
            LOGGER.debug("checking who signed this message...");
            originalSmimeDetails.completeWithSmimeSignedBy(this.getSignedByAddress((MimePart)mimeMessage));
            if (originalSmimeDetails.getSmimeMode() == OriginalSmimeDetails.SmimeMode.SIGNED) {
                originalSmimeDetails.completeWithSmimeSignatureValid(this.checkSignature(mimeMessage, originalSmimeDetails));
            }
        }
    }

    private boolean checkSignature(@NotNull MimeMessage mimeMessage, @Nullable OriginalSmimeDetails messageSmimeDetails) {
        if (messageSmimeDetails != null) {
            LOGGER.debug("verifying signed mimemessage...");
            boolean validSignature = this.verifyValidSignature(mimeMessage, messageSmimeDetails);
            if (!validSignature) {
                LOGGER.warn("Message contains invalid S/MIME signature! Assume this emal has been tampered with.");
            }
            return validSignature;
        }
        return false;
    }

    private void decryptAttachments(@NotNull SmimeParseResultBuilder smimeBuilder, @NotNull List<AttachmentResource> attachments, @Nullable Pkcs12Config pkcs12Config) {
        LOGGER.debug("checking for S/MIME signed / encrypted attachments...");
        List<AttachmentDecryptionResult> decryptedAttachments = this.decryptAttachments(attachments, pkcs12Config, smimeBuilder.getOriginalSmimeDetails());
        smimeBuilder.addDecryptedAttachments(decryptedAttachments);
        if (attachments.size() == 1) {
            AttachmentResource onlyAttachment = attachments.get(0);
            AttachmentDecryptionResult onlyAttachmentDecrypted = smimeBuilder.getDecryptedAttachmentResults().get(0);
            if (this.isSmimeAttachment(onlyAttachment) && this.isMimeMessageAttachment(onlyAttachmentDecrypted.getAttachmentResource())) {
                smimeBuilder.getOriginalSmimeDetails().completeWith(this.determineSmimeDetails(onlyAttachment));
                smimeBuilder.setSmimeSignedEmailToProcess(onlyAttachmentDecrypted.getAttachmentResource());
            }
        }
    }

    private boolean isMimeMessageAttachment(AttachmentResource attachment) {
        return attachment.getDataSource().getContentType().equals("message/rfc822");
    }

    @NotNull
    private OriginalSmimeDetailsImpl determineSmimeDetails(AttachmentResource attachment) {
        LOGGER.debug("Single S/MIME signed / encrypted attachment found; assuming the attachment is the message body, a record of the original S/MIME details will be stored on the Email root...");
        SmimeDetails smimeDetails = this.getSmimeDetails(attachment);
        return OriginalSmimeDetailsImpl.builder().smimeMime(smimeDetails.getSmimeMime()).smimeSignedBy(smimeDetails.getSignedBy()).build();
    }

    @NotNull
    public List<AttachmentDecryptionResult> decryptAttachments(@NotNull List<AttachmentResource> attachments, @Nullable Pkcs12Config pkcs12Config, @NotNull OriginalSmimeDetails messageSmimeDetails) {
        ArrayList<AttachmentDecryptionResult> decryptedAttachments = new ArrayList<AttachmentDecryptionResult>();
        for (AttachmentResource attachment : attachments) {
            if (this.isSmimeAttachment(attachment)) {
                try {
                    LOGGER.debug("decrypting S/MIME signed attachment '{}'...", (Object)attachment.getName());
                    decryptedAttachments.add(this.decryptAndUnsignAttachment(attachment, pkcs12Config, messageSmimeDetails));
                    continue;
                }
                catch (Exception e) {
                    throw new SmimeException(String.format("Error unwrapping S/MIME enveloped attachment: %n\t%s", attachment), e);
                }
            }
            decryptedAttachments.add(new AttachmentDecryptionResultImpl(OriginalSmimeDetails.SmimeMode.PLAIN, attachment));
        }
        return decryptedAttachments;
    }

    public boolean isSmimeAttachment(@NotNull AttachmentResource attachment) {
        return SMIME_MIMETYPES.contains(attachment.getDataSource().getContentType());
    }

    private AttachmentDecryptionResult decryptAndUnsignAttachment(@NotNull AttachmentResource attachment, @Nullable Pkcs12Config pkcs12Config, @NotNull OriginalSmimeDetails messageSmimeDetails) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart(new InternetHeaders(), attachment.readAllBytes());
            mimeBodyPart.addHeader("Content-Type", this.restoreSmimeContentType(attachment, messageSmimeDetails));
            AttachmentDecryptionResult liberatedContent = null;
            SmimeUtilFixed.SmimeStateFixed smimeState = this.determineStatus((MimePart)mimeBodyPart, messageSmimeDetails);
            if (smimeState == SmimeUtilFixed.SmimeStateFixed.ENCRYPTED) {
                liberatedContent = this.getEncryptedContent(pkcs12Config, mimeBodyPart);
            } else if (smimeState == SmimeUtilFixed.SmimeStateFixed.SIGNED) {
                liberatedContent = this.getSignedContent(mimeBodyPart);
            }
            return liberatedContent != null ? liberatedContent : new AttachmentDecryptionResultImpl(OriginalSmimeDetails.SmimeMode.PLAIN, attachment);
        }
        catch (IOException | MessagingException e) {
            throw new SmimeException(String.format("Error unwrapping S/MIME enveloped attachment: %n\t%s", attachment), (Exception)e);
        }
    }

    @Nullable
    private AttachmentDecryptionResult getEncryptedContent(@Nullable Pkcs12Config pkcs12Config, MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        if (pkcs12Config != null) {
            AttachmentDecryptionResult signedContent;
            MimeBodyPart liberatedBodyPart = SmimeUtil.decrypt((MimeBodyPart)mimeBodyPart, (SmimeKey)this.retrieveSmimeKeyFromPkcs12Keystore(pkcs12Config));
            if (SmimeUtilFixed.getStatus((MimePart)liberatedBodyPart) == SmimeUtilFixed.SmimeStateFixed.SIGNED_ENVELOPED && (signedContent = this.getSignedContent(liberatedBodyPart)) != null) {
                return new AttachmentDecryptionResultImpl(OriginalSmimeDetails.SmimeMode.SIGNED_ENCRYPTED, signedContent.getAttachmentResource());
            }
            return new AttachmentDecryptionResultImpl(OriginalSmimeDetails.SmimeMode.ENCRYPTED, this.handleLiberatedContent(liberatedBodyPart.getContent()));
        }
        LOGGER.warn("Message was encrypted, but no Pkcs12Config was given to decrypt it with, skipping attachment...");
        return null;
    }

    @Nullable
    private AttachmentDecryptionResult getSignedContent(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        if (SmimeUtil.checkSignature((MimePart)mimeBodyPart)) {
            MimeBodyPart liberatedBodyPart = SmimeUtil.getSignedContent((MimePart)mimeBodyPart);
            return new AttachmentDecryptionResultImpl(OriginalSmimeDetails.SmimeMode.SIGNED, this.handleLiberatedContent(liberatedBodyPart.getContent()));
        }
        LOGGER.warn("Content is S/MIME signed, but signature is not valid; skipping S/MIME interpeter...");
        return null;
    }

    private String restoreSmimeContentType(@NotNull AttachmentResource attachment, OriginalSmimeDetails originalSmimeDetails) {
        String contentType = attachment.getDataSource().getContentType();
        if (contentType.contains("multipart/signed") && !contentType.contains("protocol") && originalSmimeDetails.getSmimeProtocol() != null) {
            contentType = String.format("multipart/signed;protocol=\"%s\";micalg=%s", originalSmimeDetails.getSmimeProtocol(), originalSmimeDetails.getSmimeMicalg());
        }
        return contentType;
    }

    @Nullable
    private AttachmentResource handleLiberatedContent(Object content) throws MessagingException, IOException {
        if (content instanceof MimeMultipart) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            MimeMessage decryptedMessage = new MimeMessage(null){

                protected void updateMessageID() throws MessagingException {
                    this.setHeader("Message-ID", "<generated-for-smime-signed-attachment@simple-java-mail>");
                }
            };
            decryptedMessage.setContent((Multipart)content);
            decryptedMessage.writeTo((OutputStream)os);
            return new AttachmentResource("signed-email.eml", (DataSource)new ByteArrayDataSource(os.toByteArray(), "message/rfc822"));
        }
        LOGGER.warn("S/MIME signed content type not recognized, please raise an issue for " + content.getClass());
        return null;
    }

    private SmimeUtilFixed.SmimeStateFixed determineStatus(@NotNull MimePart mimeBodyPart, @NotNull OriginalSmimeDetails messageSmimeDetails) {
        boolean trustStatus;
        SmimeUtilFixed.SmimeStateFixed status = SmimeUtilFixed.getStatus(mimeBodyPart);
        boolean bl = trustStatus = status != SmimeUtilFixed.SmimeStateFixed.ENCRYPTED || messageSmimeDetails.getSmimeMode() == OriginalSmimeDetails.SmimeMode.PLAIN;
        if (trustStatus) {
            return status;
        }
        return "signed-data".equals(messageSmimeDetails.getSmimeType()) ? SmimeUtilFixed.SmimeStateFixed.SIGNED : SmimeUtilFixed.SmimeStateFixed.ENCRYPTED;
    }

    @NotNull
    public SmimeDetails getSmimeDetails(@NotNull AttachmentResource attachment) {
        String contentType = attachment.getDataSource().getContentType();
        String signedByAddress = this.getSignedByAddress(attachment);
        return new SmimeDetailsImpl(contentType, signedByAddress);
    }

    @Nullable
    public String getSignedByAddress(@NotNull AttachmentResource smimeAttachment) {
        try {
            InternetHeaders internetHeaders = new InternetHeaders();
            internetHeaders.addHeader("Content-Type", smimeAttachment.getDataSource().getContentType());
            return this.getSignedByAddress((MimePart)new MimeBodyPart(internetHeaders, smimeAttachment.readAllBytes()));
        }
        catch (IOException | MessagingException e) {
            throw new SmimeException(String.format("Error extracting signed-by address from S/MIME signed attachment: %n\t%s", smimeAttachment), (Exception)e);
        }
    }

    @Nullable
    public String getSignedByAddress(@NotNull MimePart mimePart) {
        try {
            return SMIMESupport.getSignedByAddress(SMIMESupport.determineSMIMESigned(mimePart));
        }
        catch (SmimeException e) {
            return null;
        }
    }

    public boolean verifyValidSignature(@NotNull MimeMessage mimeMessage, @NotNull OriginalSmimeDetails messageSmimeDetails) {
        return this.determineStatus((MimePart)mimeMessage, messageSmimeDetails) != SmimeUtilFixed.SmimeStateFixed.SIGNED || SmimeUtil.checkSignature((MimePart)mimeMessage);
    }

    @NotNull
    private static SMIMESigned determineSMIMESigned(MimePart mimePart) {
        try {
            if (mimePart.isMimeType("multipart/signed")) {
                return new SMIMESigned((MimeMultipart)mimePart.getContent());
            }
            if (mimePart.isMimeType("application/pkcs7-mime") || mimePart.isMimeType("application/x-pkcs7-mime")) {
                return new SMIMESigned((Part)mimePart);
            }
            throw new SmimeException(String.format("MimePart that was assumed to be S/MIME signed / encrypted actually wasn't: %n\t%s", mimePart.toString()));
        }
        catch (IOException | MessagingException | CMSException | SMIMEException e) {
            throw new SmimeException("Error determining who signed the S/MIME attachment", (Exception)e);
        }
    }

    private static String getSignedByAddress(SMIMESigned smimeSigned) {
        try {
            Store certificates = smimeSigned.getCertificates();
            SignerInformation signerInformation = (SignerInformation)smimeSigned.getSignerInfos().getSigners().iterator().next();
            X509Certificate certificate = SMIMESupport.getCertificate(certificates, signerInformation.getSID());
            SignerInformationVerifier verifier = SMIMESupport.getVerifier(certificate);
            X500Name x500name = verifier.getAssociatedCertificate().getSubject();
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        }
        catch (Exception e) {
            throw new SmimeException("Error extracting subject from certificate to which it was issued", e);
        }
    }

    @Deprecated
    private static X509Certificate getCertificate(Store certificates, SignerId signerId) throws CertificateException {
        X509CertificateHolder certificateHolder = (X509CertificateHolder)certificates.getMatches((Selector)signerId).iterator().next();
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
        certificateConverter.setProvider("BC");
        return certificateConverter.getCertificate(certificateHolder);
    }

    @Deprecated
    private static SignerInformationVerifier getVerifier(X509Certificate certificate) throws OperatorCreationException {
        JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder();
        builder.setProvider("BC");
        return builder.build(certificate);
    }

    @NotNull
    public MimeMessage signAndOrEncryptEmail(@Nullable Session session, @NotNull MimeMessage messageToProtect, @NotNull Email emailContainingSmimeDetails) {
        MimeMessage result = messageToProtect;
        if (emailContainingSmimeDetails.getPkcs12ConfigForSmimeSigning() != null) {
            result = this.signMessage(session, result, emailContainingSmimeDetails.getPkcs12ConfigForSmimeSigning());
        }
        if (emailContainingSmimeDetails.getX509CertificateForSmimeEncryption() != null) {
            result = this.encryptMessage(session, result, emailContainingSmimeDetails.getX509CertificateForSmimeEncryption());
        }
        return result;
    }

    @NotNull
    public MimeMessage signMessage(@Nullable Session session, @NotNull MimeMessage message, @NotNull Pkcs12Config pkcs12Config) {
        SmimeKey smimeKey = this.retrieveSmimeKeyFromPkcs12Keystore(pkcs12Config);
        return SmimeUtil.sign((Session)session, (MimeMessage)message, (SmimeKey)smimeKey);
    }

    @NotNull
    public MimeMessage encryptMessage(@Nullable Session session, @NotNull MimeMessage message, @NotNull X509Certificate certificate) {
        return SmimeUtil.encrypt((Session)session, (MimeMessage)message, (X509Certificate)certificate);
    }

    private SmimeKey retrieveSmimeKeyFromPkcs12Keystore(@NotNull Pkcs12Config pkcs12) {
        SmimeKeyStore store = new SmimeKeyStore((InputStream)new ByteArrayInputStream(pkcs12.getPkcs12StoreData()), pkcs12.getStorePassword());
        return store.getPrivateKey(pkcs12.getKeyAlias(), pkcs12.getKeyPassword());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

