/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.taskrouter.StatisticsQueryBuilder;
import com.twilio.sdk.resource.instance.taskrouter.TaskQueueStatistics;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TaskQueue
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public TaskQueue(TwilioTaskRouterClient client) {
        super(client);
    }

    public TaskQueue(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public TaskQueue(TwilioTaskRouterClient client, String workspaceSid, String queueSid) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a TaskQueue cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)queueSid)) {
            throw new IllegalArgumentException("The queueSid for a TaskQueue cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", queueSid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getAssignmentActivitySid() {
        return this.getProperty("assignment_activity_sid");
    }

    public Date getDateCreated() {
        return this.parseIsoDate(this.getProperty("date_created"));
    }

    public Date getDateUpdated() {
        return this.parseIsoDate(this.getProperty("date_updated"));
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getReservationActivityName() {
        return this.getProperty("reservation_activity_name");
    }

    public String getReservationActivitySid() {
        return this.getProperty("reservation_activity_sid");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getTargetWorkers() {
        return this.getProperty("target_workers");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    public TaskQueueStatistics getStatistics() {
        return this.getStatistics(new HashMap<String, String>());
    }

    public TaskQueueStatistics getStatistics(StatisticsQueryBuilder queryBuilder) {
        HashMap<String, String> filters = new HashMap<String, String>();
        Calendar startDate = queryBuilder.getStartDate();
        Calendar endDate = queryBuilder.getEndDate();
        Integer minutes = queryBuilder.getMinutes();
        if (startDate != null) {
            filters.put("StartDate", this.formatCalendar(startDate));
        }
        if (endDate != null) {
            filters.put("EndDate", this.formatCalendar(endDate));
        }
        if (minutes != null) {
            filters.put("Minutes", minutes.toString());
        }
        return this.getStatistics(filters);
    }

    public TaskQueueStatistics getStatistics(Map<String, String> filters) {
        String startDate = filters.get("StartDate");
        String endDate = filters.get("EndDate");
        String minutes = filters.get("Minutes");
        if ((startDate != null || endDate != null) && minutes != null) {
            throw new IllegalArgumentException("Cannot provide Minutes in combination with StartDate or EndDate");
        }
        TaskQueueStatistics statistics = new TaskQueueStatistics((TwilioTaskRouterClient)this.getClient(), this.getWorkspaceSid(), this.getSid(), filters);
        return statistics;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/TaskQueues/" + this.getSid();
    }
}

