/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.ipmessaging;

import com.twilio.sdk.TwilioIPMessagingClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.ipmessaging.Member;
import com.twilio.sdk.resource.instance.ipmessaging.Message;
import com.twilio.sdk.resource.list.ipmessaging.MemberList;
import com.twilio.sdk.resource.list.ipmessaging.MessageList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class Channel
extends NextGenInstanceResource<TwilioIPMessagingClient> {
    private static final String SERVICE_SID_PROPERTY = "service_sid";
    private static final String UNIQUE_NAME_PROPERTY = "unique_name";

    public Channel(TwilioIPMessagingClient client, String serviceSid, String sid) {
        super(client);
        if (StringUtils.isEmpty((CharSequence)serviceSid)) {
            throw new IllegalArgumentException("serviceSid cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)sid)) {
            throw new IllegalArgumentException("sid cannot be null");
        }
        this.setProperty(SERVICE_SID_PROPERTY, serviceSid);
        this.setProperty("sid", sid);
    }

    public Channel(TwilioIPMessagingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getServiceSid() {
        return this.getProperty(SERVICE_SID_PROPERTY);
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getUniqueName() {
        return this.getProperty(UNIQUE_NAME_PROPERTY);
    }

    public String getCreatedBy() {
        return this.getProperty("created_by");
    }

    public String getAttributes() {
        return this.getProperty("attributes");
    }

    public String getType() {
        return this.getProperty("type");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    public MemberList getMembers() {
        return this.getMembers(null);
    }

    public Member getMember(String sid) {
        return new Member((TwilioIPMessagingClient)this.getClient(), this.getServiceSid(), this.getSid(), sid);
    }

    public Member createMember(Map<String, String> params) throws TwilioRestException {
        return this.getMembers().create((Map)params);
    }

    public MemberList getMembers(Map<String, String> filters) {
        return new MemberList((TwilioIPMessagingClient)this.getClient(), this.getServiceSid(), this.getSid(), filters);
    }

    public MessageList getMessages() {
        return this.getMessages(null);
    }

    public MessageList getMessages(Map<String, String> filters) {
        return new MessageList((TwilioIPMessagingClient)this.getClient(), this.getServiceSid(), this.getSid(), filters);
    }

    public Message getMessage(String sid) {
        return new Message((TwilioIPMessagingClient)this.getClient(), this.getServiceSid(), this.getSid(), sid);
    }

    public Message createMessage(Map<String, String> params) throws TwilioRestException {
        return this.getMessages().create((Map)params);
    }

    public Message createMessage(List<NameValuePair> params) throws TwilioRestException {
        return this.getMessages().create((List)params);
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioIPMessagingClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Services/" + this.getServiceSid() + "/Channels/" + this.getSid();
    }
}

