/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.resource.factory.AccountFactory;
import com.twilio.sdk.resource.instance.Account;
import com.twilio.sdk.resource.list.AccountList;
import java.util.HashMap;
import java.util.Map;

public class TwilioRestClient
extends TwilioClient {
    private Account authAccount = new Account(this);

    public TwilioRestClient(String username, String password) {
        this(username, password, "https://api.twilio.com");
    }

    public TwilioRestClient(String username, String password, String endpoint) {
        super(username, password, endpoint);
        this.authAccount.setSid(username);
        this.authAccount.setAuthToken(password);
    }

    public AccountList getAccounts(Map<String, String> params) {
        return new AccountList(this, params);
    }

    public AccountList getAccounts() {
        return this.getAccounts(new HashMap<String, String>());
    }

    public AccountFactory getAccountFactory() {
        return this.getAccounts();
    }

    public Account getAccount() {
        return this.authAccount;
    }

    public Account getAccount(String sid) {
        Account account = new Account(this);
        account.setSid(sid);
        account.setRequestAccountSid(sid);
        return account;
    }

    @Override
    public void setRequestAccountSid(String sid) {
        this.authAccount = new Account(this);
        this.authAccount.setSid(sid);
        this.authAccount.setAuthToken(this.getPassword());
    }
}

