/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool.expirypolicies;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;

public abstract class TimeoutExpirationPolicy<T>
implements ExpirationPolicy<T> {
    private final long expiryAgeMs;

    /*
     * WARNING - void declaration
     */
    TimeoutExpirationPolicy(long expiryAge, TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/genericobjectpool/expirypolicies/TimeoutExpirationPolicy.<init> must not be null");
        }
        if (expiryAge < 1L) {
            throw new IllegalArgumentException("Max permitted age cannot be less than 1");
        }
        this.expiryAgeMs = unit.toMillis(expiryAge);
    }

    @Override
    public final boolean hasExpired(@NotNull PoolableObject<T> poolableObject) {
        if (poolableObject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/expirypolicies/TimeoutExpirationPolicy.hasExpired must not be null");
        }
        Map<ExpirationPolicy, Long> expiriesMs = poolableObject.getExpiriesMs();
        if (!expiriesMs.containsKey(this)) {
            expiriesMs.put(this, this.expiryAgeMs);
        }
        return this._hasExpired(poolableObject);
    }

    abstract boolean _hasExpired(@NotNull PoolableObject<T> var1);

    public long getExpiryAgeMs() {
        return this.expiryAgeMs;
    }

    public boolean equals(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/expirypolicies/TimeoutExpirationPolicy.equals must not be null");
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeoutExpirationPolicy)) {
            return false;
        }
        TimeoutExpirationPolicy other = (TimeoutExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getExpiryAgeMs() == other.getExpiryAgeMs();
    }

    protected boolean canEqual(Object other) {
        if (other == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/genericobjectpool/expirypolicies/TimeoutExpirationPolicy.canEqual must not be null");
        }
        return other instanceof TimeoutExpirationPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expiryAgeMs = this.getExpiryAgeMs();
        result = result * 59 + (int)($expiryAgeMs >>> 32 ^ $expiryAgeMs);
        return result;
    }

    public String toString() {
        String string = "TimeoutExpirationPolicy(expiryAgeMs=" + this.getExpiryAgeMs() + ")";
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/genericobjectpool/expirypolicies/TimeoutExpirationPolicy.toString must not return null");
        }
        return string;
    }
}

