/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.clusteredobjectpool.cyclingstrategies;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bbottema.clusteredobjectpool.core.api.LoadBalancingStrategy;
import org.jetbrains.annotations.NotNull;

public class RandomAccessLoadBalancing<T>
implements LoadBalancingStrategy<T, List<T>> {
    @Override
    @NotNull
    public List<T> createCollectionForCycling() {
        LinkedList linkedList = new LinkedList();
        if (linkedList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/cyclingstrategies/RandomAccessLoadBalancing.createCollectionForCycling must not return null");
        }
        return linkedList;
    }

    @Override
    @NotNull
    public T cycle(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/cyclingstrategies/RandomAccessLoadBalancing.cycle must not be null");
        }
        T t = items.get(ThreadLocalRandom.current().nextInt(items.size()) % items.size());
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/cyclingstrategies/RandomAccessLoadBalancing.cycle must not return null");
        }
        return t;
    }
}

